/*
 * DynamicSinkStore.h
 *
 *  Created on: Mar 28, 2019
 *      Author: WMA5KOR
 */

#ifndef DYNAMICSINKSTORE_H_
#define DYNAMICSINKSTORE_H_

#include "Types.h"

#include<map>
#include <iterator>
#include <string>

namespace VolumeManager
{

typedef std::map<std::string, std::pair<tenResource, tU16> > Maptype;

class DynamicSinkStore
{
    public:
        static DynamicSinkStore& getInstance()
        {
            static DynamicSinkStore    instance; // Guaranteed to be destroyed.
                                  // Instantiated on first use.
            return instance;
        }

        std::string getSinkName(const tU16& sink);
        std::string getSinkName(const tenResource& enResource);
        tenResource getenResource(const tU16& sink);
        tenResource getenResource(const std::string& name);
        tU16 getSinkID(const tenResource& enResource);
        tU16 getSinkID(const std::string& name);
        void updateDynamicSinkStore(const std::string& name, tU16 sink);

    private:
        Maptype resource;
        DynamicSinkStore();                   // Constructor? (the {} brackets) are needed here.

    public:
        DynamicSinkStore(DynamicSinkStore const&) = delete;
        void operator=(DynamicSinkStore const&)  = delete;

};

}

#endif /* DYNAMICSINKSTORE_H_ */
