/*
 * AttenuationState.h
 *
 *  Created on: Sep 23, 2019
 *      Author: wma5kor
 */

#pragma once
#include<map>
#include<tuple>
#include<string>
#include<vector>

namespace VolumeManager {


struct CurrentEentertainmentSources{
    std::string sink;
    std::string source;
    int volStep;
    int db;
};

class AttenuationState {
    public:

        AttenuationState();
        virtual ~AttenuationState();
        void setCurrentEntSource(const std::string &source, const std::string &sink);
        void updateEntVol(std::string sink, int vol, int db);
        std::tuple<std::string, int, int> getSourceDetailOnSink(const std::string &sink);

    private:
        std::map<std::string /*Attenuation Type */, int /*db*/> attenuation_active;
        //std::map<std::string, std::tuple<std::string, int, int>> current_entertainment_sources;
        CurrentEentertainmentSources AMP_A_Details, AMP_B_Details;
        std::map<std::string, std::string> current_entertainment_sources1;


};

} /* namespace VolumeManager */


