/*
 * Attenuation.h
 *
 *  Created on: Sep 23, 2019
 *      Author: wma5kor
 */
#pragma once

#include "Volume/Utilities/Uncopyable.h"
#include "InternalCommunicationAdapter.h"
#include "Volume/PropertyStore.h"
#include "Types.h"
#include "Volume/Configuration/ConfigDetails.hpp"
#include "Volume/Configuration/Configuration.h"
#include "Volume/Attenuation/AttenuationEnumDefine.h"
#include "AttenuationCompute.h"
#include "AttenuationState.h"
#include <map>

namespace VolumeManager {

class Attenuation :private Uncopyable, public IF_MessageObserver<PO_MessageConfig::enID> {
    public:
        Attenuation(PropertyStore& store, const Configuration& config);
        virtual ~Attenuation();
        bool isAttenuationActive();
        void apply(const std::string &sink, int step, int db);
        virtual void MessageNotification(PO_MessageConfig::enID MsgId);
        void updateEntVolume(std::string source, std::string sink, int step, int db);
        void InitializeVolStore(std::map<std::string, std::pair<std::string, std::pair<int, int> > > &volStore);

    private:
        PropertyStore&  _properties;
        const Configuration&  _config;
        std::map<std::string, std::pair<std::string, std::pair<int , int >>> volStore;

        AttenuationCompute attenuationCompute;
       // AttenuationState* attenuationState;

        PostOffice<PO_MessageConfig::enID>* pPO;
};

} /* namespace VolumeManager */


