/*
 * Attenuation.cpp
 *
 *  Created on: Sep 23, 2019
 *      Author: wma5kor
 */

#include "Attenuation.h"
#include "Messages/Volume/VolumeManager/ID_CCA_Start_Volume.h"
#include "Messages/Volume/VolumeManager/ID_Attenuation.h"
#include "Messages/Volume/ID_Amp_SetVolume.h"
#include "Messages/Source/IDIntSource.h"
#include "Volume/DynamicSinkStore.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include <etrace_if.h> // implicitly links <osal_if.h>

#include "controllerplugin_Trace.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/Attenuation.cpp.trc.h"

namespace VolumeManager {

Attenuation::Attenuation(PropertyStore& store, const Configuration& config)
:IF_MessageObserver<PO_MessageConfig::enID>("Attenuation")
 ,_properties(store)
 ,_config(config)
 //,attenuationState(new AttenuationState())
// ,attenuationCompute(new AttenuationCompute())
{
    InternalCommunicationAdapter::getInstance();
    pPO = InternalCommunicationAdapter::POMessages;
    if (pPO)
    {
       pPO->AddObserver(this, PO_MessageConfig::ID_CCA_Start_Volume);
       pPO->AddObserver(this, PO_MessageConfig::IDIntSource);
       pPO->AddObserver(this, PO_MessageConfig::ID_Attenuation);

    }

    InitializeVolStore(volStore);

}

Attenuation::~Attenuation()
{
    if (pPO)
       try
       {
           InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
           pPO = NULL;

       }
       catch(...)  {}
      // delete attenuationState;
      // delete attenuationCompute;
}

void Attenuation::InitializeVolStore(std::map<std::string, std::pair<std::string, std::pair<int, int> > > &volStore)
{
    const StreamSetConfig* s = NULL;
    for(size_t i = 0; i < _config.getStreamSetCount(); ++i)
    {
         s = _config.pGetStreamSetConfig(i);
         if(s && s->name)
         {
             std::string sinkname(s->name);
             volStore.insert({sinkname, {"NONE",{0,0}}});
         }
    }

}

void Attenuation::MessageNotification(PO_MessageConfig::enID MsgId)
{

    if(pPO == NULL) return;
    switch (MsgId)
    {
    case PO_MessageConfig::IDIntSource:
    {

        const VolumeSourceData& pMsg = pPO->QueryMessage<IDIntSource>(MsgId)->value;

        if(_config.pGetSourceConfig(pMsg.m_SourceName))
        {
            std::string group(_config.pGetSourceConfig(pMsg.m_SourceName)->getGroupName());
            if(group == "Entertain" ){
                auto it = volStore.find(pMsg.m_ResourceName);
                if(it != volStore.end())
                {
                    it->second.first = pMsg.m_SourceName;
                }
            }
               // attenuationState->setCurrentEntSource(pMsg.m_SourceName,pMsg.m_ResourceName);
        }

    }
        break;
    case PO_MessageConfig::ID_Attenuation:
    {

        const auto &x= pPO->QueryMessage<ID_Attenuation>(MsgId)->value;

       // auto pMsg= const_cast<std::map<std::string, std::string>>(pMsg1);
        std::map<std::string, std::string> pMsg(x);

        if((pMsg["attenuationType"] == "MIX_SOURCE_ATTENUATION") && (pMsg["action"] == "enable"))
        {
            //int db, step;
            //std::tie(std::ignore, step, db ) =  attenuationState->getSourceDetailOnSink(pMsg["sink"]);
            auto it = volStore.find(pMsg["sink"]);
            if(it != volStore.end()){
                int resultdb = attenuationCompute.computeMixSourceAttenuation(it->second.second.second, std::stoi(pMsg["db"]));
                ETG_TRACE_USR4(("computeMixSourceAttenuation %d, %d, result %d",it->second.second.second,std::stoi(pMsg["db"]),resultdb));
                apply(pMsg["sink"], it->second.second.first, resultdb);
            }
        }

        if((pMsg["attenuationType"] == "MIX_SOURCE_ATTENUATION") && (pMsg["action"] == "disable"))
        {

            std::string source;
           // std::tie(source, std::ignore, std::ignore ) =  attenuationState->getSourceDetailOnSink(pMsg["sink"]);

            auto it = volStore.find(pMsg["sink"]);
            if(it != volStore.end()){
                source = it->second.first;
            }

            VolumeSourceData DataSet;

            DataSet.m_Channel = (midw_fi_tcl_e8_AudioChannel::tenType)1;
            DataSet.m_SourceName = source;
            DataSet.m_ResourceName = pMsg["sink"];

            IDIntSource VolumeSourcePOMessage(DataSet);
            InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&VolumeSourcePOMessage);

        }

    }
        break;
    default:
    	break;

    }

}

void Attenuation::apply(const std::string& sink, int step, int db)
{
    AmpVolumeData ampData;
    //ampData.m_enStream = 1;
    ampData.m_VolStep = static_cast<unsigned char>(step);
    ampData.m_VoldB = static_cast<short>(db);

    ampData.m_Sink = DynamicSinkStore::getInstance().getSinkID(sink);
    ampData.m_SinkName = sink;
    auto it = volStore.find(sink);
    if(it != volStore.end()){
        ampData.m_Source =  it->second.first;
    }
    ETG_TRACE_USR2(("VolumeManager - Main:"
            " - launched amplifier volume command for stream = %u, Step = %d"
            " , dB = %d, Ramp (lin/log) = %d/%d  Sink =  %d"
            , ampData.m_enStream, ampData.m_VolStep
            , ampData.m_VoldB, ampData.m_RampLin, ampData.m_RampdB, ampData.m_Sink ))
    ampData.m_Group = "Entertain";
    ampData.m_status = false;

    ID_Amp_SetVolume outMsg(ampData);
    if(InternalCommunicationAdapter::POMessages != NULL)
    {
        InternalCommunicationAdapter::POMessages->DeliverMsg(&outMsg);
        ETG_TRACE_USR2(("Attenuation::apply:"
           " - launched amplifier volume command for stream = %u, Step = %d"
           " , dB = %d, Ramp (lin/log) = %d/%d  Sink =  %d"
           , ampData.m_enStream, ampData.m_VolStep
           , ampData.m_VoldB, ampData.m_RampLin, ampData.m_RampdB, ampData.m_Sink ));
    }

}

void Attenuation::updateEntVolume( std::string /* source */,  std::string sink, int step, int db)
{
    auto it = volStore.find(sink);
    if(it != volStore.end())
    {
        it->second.second.first = step;
        it->second.second.second = db;
    }
}


} /* namespace VolumeManager */


