/*
 * ADR3SourceType.h
 *
 *  Created on: 11.08.2012
 *      Author: mor2hi
 */

#ifndef ADR3SOURCETYPE_H_
#define ADR3SOURCETYPE_H_

enum tenSourceType
{
   // Source types recognized by ADR3.
   //
   //   Values must match Enum SourceType as defined in ADR3_Audio.html,
   //   available at https://inside-ilm.bosch.com/irj/go/nui/sid/download/c0635682-3a46-3210-bb92-bb6c4805c90f)
   //   and in ClearCase folder /ai_aars_delivery/<prj>/<subprj>/_doc
   //
   EN_AUDIO_SOURCE_SOURCETYPE_NOSOURCE = 0x00,
   EN_AUDIO_SOURCE_SOURCETYPE_FM = 0x01,
   EN_AUDIO_SOURCE_SOURCETYPE_AM = 0x02,
   EN_AUDIO_SOURCE_SOURCETYPE_MEDIA = 0x03,
   EN_AUDIO_SOURCE_SOURCETYPE_CDA = 0x04,
   EN_AUDIO_SOURCE_SOURCETYPE_AUX = 0x05,
   EN_AUDIO_SOURCE_SOURCETYPE_DAB = 0x06,
   EN_AUDIO_SOURCE_SOURCETYPE_PHONENARROWBAND = 0x07,
   EN_AUDIO_SOURCE_SOURCETYPE_PHONEBROADBAND = 0x08,
   EN_AUDIO_SOURCE_SOURCETYPE_AUX2 = 0x09,
   EN_AUDIO_SOURCE_SOURCETYPE_XM = 0x0A,
   EN_AUDIO_SOURCE_SOURCETYPE_HD = 0x0C,
   EN_AUDIO_SOURCE_SOURCETYPE_AUX3 = 0x0D,
   EN_AUDIO_SOURCE_SOURCETYPE_FM_TA = 0x0E,
   EN_AUDIO_SOURCE_SOURCETYPE_DAB_TA = 0x0F,
   EN_AUDIO_SOURCE_SOURCETYPE_NAVI = 0x10,
   EN_AUDIO_SOURCE_SOURCETYPE_CUE = 0x11,
   EN_AUDIO_SOURCE_SOURCETYPE_CUE2 = 0x12,
   EN_AUDIO_SOURCE_SOURCETYPE_CUE3 = 0x13,
   EN_AUDIO_SOURCE_SOURCETYPE_CUE4 = 0x14,
   EN_AUDIO_SOURCE_SOURCETYPE_IPA1 = 0x15,
   EN_AUDIO_SOURCE_SOURCETYPE_SOUNDGENERATOR1 = 0x20,
   EN_AUDIO_SOURCE_SOURCETYPE_SOUNDGENERATOR2 = 0x21,
   EN_AUDIO_SOURCE_SOURCETYPE_SOUNDSAMPLEPLAYER = 0x22,
   EN_AUDIO_SOURCE_SOURCETYPE_SOUNDNOISE = 0x23,
   EN_AUDIO_SOURCE_SOURCETYPE_BT_AUDIO = 0x32,
   EN_AUDIO_SOURCE_SOURCETYPE_PHONE3 = 0x33,
   EN_AUDIO_SOURCE_SOURCETYPE_PHONE4 = 0x34,
   EN_AUDIO_SOURCE_SOURCETYPE_TV = 0x40,
   EN_AUDIO_SOURCE_SOURCETYPE_DVD = 0x41,
   EN_AUDIO_SOURCE_SOURCETYPE_EXT_MEDIA1 = 0x42,
   EN_AUDIO_SOURCE_SOURCETYPE_MIC1 = 0x50,
   EN_AUDIO_SOURCE_SOURCETYPE_MIC2 = 0x51,
   EN_AUDIO_SOURCE_SOURCETYPE_REARSEATAUDIO_IN1 = 0x60
};



#endif /* ADR3SOURCETYPE_H_ */
