/*
 * VolumeSPIMixData.cpp
 *
 *  Created on: Apr 30, 2014
 *      Author: rej1kor
 */

#include "VolumeSPIMixData.h"
#include "util/Macro.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "controllerplugin_Trace.h"
//#include "fc_audiomanager_trace_macros.h"

#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/VolumeSPIMixData.cpp.trc.h"

VolumeSPIMixData::VolumeSPIMixData()
{
   vSetToDefault();
}

VolumeSPIMixData::VolumeSPIMixData(const VolumeSPIMixData& DataToBeCopied)
{
   copyData(DataToBeCopied);
}

VolumeSPIMixData::~VolumeSPIMixData()
{
   // TODO Auto-generated destructor stub
}

tVoid VolumeSPIMixData::vSetToDefault()
{
    m_VolumeDbLevel = 0;
  m_SPIMixMode = EN_INT_SPI_UNDUCK;
  m_RampTime = 0;
}

tVoid VolumeSPIMixData::printData() const
{
   ETG_TRACE_USR4(("VolumeSPIMixData: Data: m_VolumeDbLevel: %d, m_SPIMixMode: %d, m_RampTime: %d",
       m_VolumeDbLevel,
       ETG_CENUM(tenSPIMixMode, m_SPIMixMode),
               m_RampTime
         ));
}

VolumeSPIMixData& VolumeSPIMixData::operator=(const VolumeSPIMixData& data)
{
   // protection again copy on itself
   if( &data == this)
   {
      ETG_TRACE_USR4(("VolumeSPIMixData: self compare!"));
      NORMAL_M_ASSERT_ALWAYS();
   }

   copyData(data);
   return (*this);
}

tVoid VolumeSPIMixData::copyData(const VolumeSPIMixData& data)
{
    m_VolumeDbLevel = data.m_VolumeDbLevel;
  m_SPIMixMode = data.m_SPIMixMode;
  m_RampTime = data.m_RampTime;
}




