/**
 * VolumeModeData.cpp
 *
 *  Created on: Jul 21, 2012
 *      Author: mor2hi
 */

#include "VolumeModeData.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "controllerplugin_Trace.h"

//#include "fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CONTROLLER_VOLUME
#include "trcGenProj/Header/VolumeModeData.cpp.trc.h"
#endif

VolumeModeData::VolumeModeData()
{
  VolumeModeData::vSetToDefault();
}

VolumeModeData::VolumeModeData(const VolumeModeData& DataToBeCopied)
{
   copyData(DataToBeCopied);
}

VolumeModeData::~VolumeModeData()
{
   // TODO Auto-generated destructor stub
}

tVoid VolumeModeData::vSetToDefault()
{
   m_Resource = midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_NOT_DEF;
   m_VolumeModeType = EN_INT_VOLMODE_NOT_DEF;
   m_Channel = midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_NOT_DEF;
}

tVoid VolumeModeData::printData () const
{
   ETG_TRACE_USR4(("VolumeData: Data: Resource: %d, Channel: %d, Mode: %d\n",
               ETG_CENUM(midw_fi_tcl_e8_ResourceNo::tenType, m_Resource),
               ETG_CENUM(midw_fi_tcl_e8_AudioChannel::tenType, m_Channel),
               ETG_CENUM(tenVolumeMode, m_VolumeModeType)
         ));

}

VolumeModeData& VolumeModeData::operator=(const VolumeModeData& rhs)
{
   // protection again copy on itself
   if( &rhs == this)
   {
      ETG_TRACE_USR4(("VolumeModeData: self compare!"));
      NORMAL_M_ASSERT_ALWAYS();
   }


   copyData(rhs);
   return (*this);
}

tVoid VolumeModeData::copyData(const VolumeModeData& data)
{
   m_VolumeModeType = data.m_VolumeModeType;
   m_Resource = data.m_Resource;
   m_Channel = data.m_Channel;
}
