/*
 * clGeniviAudioCtrlAdapter.cpp
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */
#include "include/audiomanagertypes.h"

#include "AudioStack/InterfaceAudioStack.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"

#include "AudioStack/AudioSources/clAudioSourceController.h"
#include "amcontrol_clienthandler_fc_audiomanager.h"
#include "amcontrol_clienthandler_fc_audioroutemanager.h"
#include "AudioStack/AudioSources/clAudioSourceFactory.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
#include "AudioStack/clInputHelper.h"
//#include "AudioStack/clXMLLoader.h".
#include "CAmControlSenderBase.h"
#include <sstream>
//use for XML Ruleset loading
//#include <string.h>
#include <algorithm>

//#define DP_DATAPOOL_ID =0xE880
#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_if.h"

#ifndef VARIANT_S_FTR_ENABLE_AUDIO_STACK_UTEST
#include "dp_e880_if.h"
#else
#include "dp_e880_mock_if.h"
#endif

#include <stdio.h>
//#include <malloc.h>


#ifndef USE_DLT_TRACE
   #define ETG_I_TTFIS_CMD_PREFIX "AudioStack_"
   #define ETG_I_TRACE_CHANNEL TR_TTFIS_AUDIOSTACK
   #define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
   #include "trcGenProj/Header/clGeniviAudioCtrlAdapter.cpp.trc.h"
#endif


#define G3G_NUMBER_SOURCE_SND_PROPERTY 2
#define G3G_DEFAULT_SND_PROPERTY_VALUE 0
uint8_t g_u8SrcSoundPropertiesId[G3G_NUMBER_SOURCE_SND_PROPERTY]={
                               MSP_MIC_STATUS_CONNECTION,MSP_MIC_STATUS_LEVEL
                            };

namespace AudioStack
{

using namespace SourceStateMachine;
using namespace AudioSource;
using namespace am;

std::map<am_sourceID_t, SourceID >            clGeniviAudioCtrlAdapter::m_registeredSources;
std::map<am_sinkID_t, am_Sink_s>         clGeniviAudioCtrlAdapter::m_registeredSinks;
IAmControlReceive*                            clGeniviAudioCtrlAdapter::m_geniviControlIF            = NULL;
amcontrol_clienthandler_fc_audiomanager* clGeniviAudioCtrlAdapter::m_clientHandlerFcAudioMgr         = NULL;
amcontrol_clienthandler_fc_audioroutemanager* clGeniviAudioCtrlAdapter::m_clientHandlerAudioRouteMgr = NULL;
am_domainID_t                                 clGeniviAudioCtrlAdapter::m_domainID                   = 0;
CAmControlSenderBase*              clGeniviAudioCtrlAdapter::m_ControlSenderBase       = NULL;
tBool clGeniviAudioCtrlAdapter::m_bEnableAutoPlay = TRUE;

tVoid clGeniviAudioCtrlAdapter::SetRunLevel(tU8 u8Level)
{
  clAudioSMEngine::SetRunlevel(u8Level);
}

tVoid clGeniviAudioCtrlAdapter::Invalidate()
{
   clAudioSMEngine::Invalidate();
   m_registeredSources.clear();
   m_registeredSinks.clear();
   m_geniviControlIF = NULL;
   m_geniviControlIF = NULL;
   m_ControlSenderBase = NULL;
   m_domainID = 0;
}


am::am_Error_e clGeniviAudioCtrlAdapter::Init(CAmControlSenderBase* pSenderBase, IAmControlReceive * pGeniviCtrlIF,
    amcontrol_clienthandler_fc_audiomanager* clientHandlerFcAudioMgr,
      amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr)
{
#ifndef USE_DLT_TRACE
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   //ET_TRACE_OPEN;
   ETG_I_REGISTER_FILE();

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_ON %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SRC_ON)
            , tU16
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_OFF %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SRC_OFF)
            , tU16
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_SET_AVAILABLE %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE)
            , tU16
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_SET_NOT_AVAILABLE %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_SRC_NOT_AVAILABLE)
            , tU16
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SRC_SET_AVAILABLE_UNKNOWN %d %d"
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE_UNKOWN)
            , tU16
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "SET_RUNLVL %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SET_RUNLEVEL)
            , tU16))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "GET_RUNLVL "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_GET_RUNLEVEL) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "RESET "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_RESET) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_PRINT) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LIST_SRCs "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_SRC_LIST) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "KILL_SRC %d %d "
            , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_KILL_SRC)
            , tU16
            , tU16))
   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT_XML "
               , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_PRINTXML) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "LOAD_XML "
                  , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_LOADXML) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT_RULES "
                     , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_PRINTRULES) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "CMD_REMOTE_START "
                     , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_REMOTESTART) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "CMD_REMOTE_END "
                     , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_REMOTEEND) ))

   ETG_I_CMD_DEFINE((AudioStack::clGeniviAudioCtrlAdapter::TTFisInput, "PRINT_BACKUP "
                     , ETG_I_CONST_ARG(AudioStack::clGeniviAudioCtrlAdapter::CMD_PRINT_BACKUP) ))

   ETG_I_REGISTER_CHN(vTraceRxDefault);
#endif
#endif

   if(pSenderBase == NULL)
   {
     ETG_TRACE_FATAL(("AUDIOSTACK INIT FAILED: pSenderBase == NULL"));
     return E_NOT_POSSIBLE;
   }
   //g_u8SrcSoundPropertiesId
   m_ControlSenderBase = pSenderBase;

   ETG_TRACE_USR1(("clGeniviAudioCtrlAdapter::Init: domainID %d", m_domainID));
   if(pGeniviCtrlIF == NULL)
   {
      ETG_TRACE_FATAL(("AUDIOSTACK INIT FAILED: pGeniviCtrlIF == NULL"));
      return E_NOT_POSSIBLE;
   }
   AddGeniviCtrlIF(pGeniviCtrlIF);

   if(clientHandlerAudioRouteMgr == NULL)
   {
      ETG_TRACE_FATAL(("AUDIOSTACK INIT FAILED: clientHandlerAudioRouteMgr == NULL"));
      return E_NOT_POSSIBLE;
   }
   AddAudioRouteMgrIF(clientHandlerAudioRouteMgr);

   if(clientHandlerFcAudioMgr == NULL)
   {
     ETG_TRACE_FATAL(("AUDIOSTACK INIT FAILED: clientHandlerFcAudioMgr == NULL"));
     return E_NOT_POSSIBLE;
   }
   AddFcAudioMgrIF(clientHandlerFcAudioMgr);
   //am_Error_e eCode;

   if(m_domainID)
   {
      //initializeSourceClasses(m_domainID);
      am_Error_e eCode =initializeSinks(m_domainID);
      if( eCode != E_OK)
      {
         ETG_TRACE_FATAL(("AUDIOSTACK SINK INITIALIZATION FAILED: ErrorCode %d", eCode));
         return E_NOT_POSSIBLE;
      }

     if(clAudioSMEngine::SetRunlevel(3,TRUE) != clAudioSMEngine::AUDIOSM_OK)
     {
       ETG_TRACE_FATAL(("AUDIOSTACK FAILED TO SET RUNLEVEL !"));
         return E_NOT_POSSIBLE;
     }


   }else{
      ETG_TRACE_FATAL(("No Domain ID available: use clGeniviAudioCtrlAdapter::AddDomainID(...)"));
      return E_NOT_POSSIBLE;
   }

   return E_OK;
}

tVoid clGeniviAudioCtrlAdapter::vTraceRxDefault(tPCUChar pcu8Data){
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
   ETG_TRACE_FATAL(("vTraceRx() unknown trace command= %x" ,
       ETG_LIST_LEN((tU8)pcu8Data[0]), ETG_LIST_PTR_T8(&pcu8Data[1]) ));
#endif
}

tVoid clGeniviAudioCtrlAdapter::TTFisInput(tU8 cmd,tU16 value1,tU16 value2)
{
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::TTFisInput cmd %d value1 %d, value2 %d", cmd, value1, value2));
   clGeniviAudioCtrlAdapter::enCommand enCmd = static_cast<clGeniviAudioCtrlAdapter::enCommand>(cmd);
   (void) enCmd;
   switch(cmd)
   {
      case clGeniviAudioCtrlAdapter::CMD_SRC_ON:
         clAudioSMEngine::Source_On(SourceID(static_cast<sourceClassID>(value1),value2));
         break;
      case clGeniviAudioCtrlAdapter::CMD_SRC_OFF:
         clAudioSMEngine::Source_Off(SourceID(static_cast<sourceClassID>(value1),value2));
         break;
      case clGeniviAudioCtrlAdapter::CMD_RESET:
         clAudioSMEngine::ResetStack();
         break;
      case clGeniviAudioCtrlAdapter::CMD_PRINT:
         clAudioSMEngine::TraceStack();
         break;
      case clGeniviAudioCtrlAdapter::CMD_PRINT_BACKUP:
         clAudioSMEngine::TraceBackupStack();
         break;

      case clGeniviAudioCtrlAdapter::CMD_SET_RUNLEVEL:
         if(value1>3)
         {
            ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::TTFisInput : Runlevel must be 0-3"));
            return;
         }
         //vSwitchThreadContext(clAudioSMEngine, )
         clInputHelper::setValues(value1,0);
         vSwitchThreadContext<clInputHelper>(clInputHelper::getInstance(), &clInputHelper::setRunlevel);
         break;
      case clGeniviAudioCtrlAdapter::CMD_GET_RUNLEVEL:
         ETG_TRACE_ERR(("Runlevel: %d", clAudioSMEngine::GetRunlevel()));
         break;
      case clGeniviAudioCtrlAdapter::CMD_KILL_SRC:
         clAudioSMEngine::vHandleSrcActError(SourceID(static_cast<sourceClassID>(value1),value2));
         break;
      case clGeniviAudioCtrlAdapter::CMD_SRC_LIST:
         clAudioSMEngine::ListSources();
         break;
      case clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE:
      {
         const clSourceClass* srcClass =
               clFactory_AudioSourceClass::GetSourceClass_extID(static_cast<clSourceClass::externalID>(value1));
         if(srcClass != NULL)
         {
            ETG_TRACE_ERR(("given CCA SOURCE CLASS %d maps internal SourceClass %d"
                  , value1
                  , srcClass->SourceClassID));
            clInputHelper::setValues(srcClass->SourceClassID,value2);
            vSwitchThreadContext<clInputHelper>(clInputHelper::getInstance(), &clInputHelper::sourceAvailable);
         }else{
            ETG_TRACE_ERR(("COULD NOT MAP TO INTERNAL SOURCE CLASS"));
         }
      }
      break;
      case clGeniviAudioCtrlAdapter::CMD_SET_SRC_NOT_AVAILABLE:
      {
         const clSourceClass* srcClass =
               clFactory_AudioSourceClass::GetSourceClass_extID(static_cast<clSourceClass::externalID>(value1));

         if(srcClass != NULL)
         {
            ETG_TRACE_ERR(("given CCA SOURCE CLASS %d maps internal SourceClass %d"
                  , value1
                  , srcClass->SourceClassID));

            clAudioSMEngine::Source_AvailabilityChange(SourceID(srcClass->SourceClassID,value2),
                  clAudioSource::not_available,
                  clAudioSource::nomedia);
         }else{
            ETG_TRACE_ERR(("COULD NOT MAP TO INTERNAL SOURCE CLASS"));
         }
      }
      break;
      case clGeniviAudioCtrlAdapter::CMD_SET_SRC_AVAILABLE_UNKOWN:
      {
         const clSourceClass* srcClass =
               clFactory_AudioSourceClass::GetSourceClass_extID(static_cast<clSourceClass::externalID>(value1));

         if(srcClass != NULL)
         {
            ETG_TRACE_ERR(("given CCA SOURCE CLASS %d maps internal SourceClass %d"
                  , value1
                  , srcClass->SourceClassID));
            clAudioSMEngine::Source_AvailabilityChange(SourceID(srcClass->SourceClassID,value2),
                  clAudioSource::unkonwn,
                  clAudioSource::newmedia);
         }else{
            ETG_TRACE_ERR(("COULD NOT MAP TO INTERNAL SOURCE CLASS"));
         }
      }
      break;
      case clGeniviAudioCtrlAdapter::CMD_LOADXML:
         clFactory_AudioSourceClass::Ruleset_Load();
         break;
      case clGeniviAudioCtrlAdapter::CMD_PRINTXML:
         clFactory_AudioSourceClass::ReadXML();
         break;
      case clGeniviAudioCtrlAdapter::CMD_PRINTRULES:
         clFactory_AudioSourceClass::Ruleset_Print();
         break;
// daw2hi: new
      case clGeniviAudioCtrlAdapter::CMD_REMOTESTART:
      {
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::TTFisInput REMOTE_START"));
        clAudioSourceController::vRemoteCtrlStart();
         break;
      }
      case clGeniviAudioCtrlAdapter::CMD_REMOTEEND:
      {
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::TTFisInput REMOTE_END"));
        clAudioSourceController::vRemoteCtrlEnd();
         break;
      }
// end

      default:
         ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::TTFisInput Command not handled"));
         break;
   }
}

tVoid clGeniviAudioCtrlAdapter::vRemoteControlStart()
{
  if(E_OK == clAudioSourceController::vRemoteCtrlStart())
  {
  ETG_TRACE_USR4(("vRemoteControlStart, remote control started successfully"));
  }
  else
  {
    ETG_TRACE_ERR(("vRemoteControlStart, failed to start remote control session!!"));
  }
}
//Fix for PSARCCB-3229 - paj5kor
tVoid clGeniviAudioCtrlAdapter::vRemoteControlUpdateDB(int16_t i16Type)
{
  ETG_TRACE_USR4(("vRemoteControlUpdateDB, remote control status updated successfully, updaing DB"));
  if(NULL != m_ControlSenderBase)
  m_ControlSenderBase->vUpdateSystemPropertyDB(SYP_DIAG_REMOTE_CONTROL, i16Type);
}

tVoid clGeniviAudioCtrlAdapter::vRemoteControlEnd()
{
  if(E_OK == clAudioSourceController::vRemoteCtrlEnd())
  {
    ETG_TRACE_USR4(("vRemoteControlEnd, remote control Ended successfully, updaing DB"));
  vRemoteControlUpdateDB(SYP_DIAG_REMOTE_CONTROL_OFF);
  }
  else
  {
    ETG_TRACE_ERR(("vRemoteControlEnd, failed to End remote control session!!"));
  }
}
#if 1
void clGeniviAudioCtrlAdapter::initializeSinkRSE(am_domainID_t domainID)
{
  am_Error_e eCode;

  //create sink
  am_Sink_s sink;
  sink.domainID     = domainID; //we cannot know this when the table is created !
  sink.name         = "RSE_MAINFIELD";
  sink.sinkID       = 2; //take fixed ids to make thins easy
  sink.sinkClassID  = 1;
  sink.volume       = 0;
  sink.available.availability       = A_AVAILABLE;
  sink.available.availabilityReason = AR_UNKNOWN;
  //sink.listSoundProperties.push_back(sp);

  std::vector<am_MainSoundProperty_s> listMainSoundProperties;
  am_MainSoundProperty_s msp;
  msp.value = G3G_DEFAULT_SND_PROPERTY_VALUE;

  for (uint16_t i16Src = 0; i16Src < MSP_MAX; i16Src++)
  {
    //msp.type = (am_MainSoundPropertyType_e)g_u8SinkSoundPropertiesId[i16Src];
    msp.type = (am_CustomMainSoundPropertyType_t)i16Src;
    listMainSoundProperties.push_back(msp);
  }

  sink.listMainSoundProperties = listMainSoundProperties;

  sink.visible = true;
  sink.listConnectionFormats.push_back(CF_GENIVI_STEREO);
  sink.muteState = MS_MUTED;
  sink.mainVolume = 0;

  //sinks
  //am_sinkID_t sinkID;
  //set the correct domainID
  //sinkIter->domainID = mListDomains[0].domainID;

  //27.07.2016 daw2hi just make the class known
  am_SinkClass_s sinkClassRSE; //, am_sinkClass_t & sinkClassID
  am_sinkClass_t sinkClassIDRSE;
  eCode = m_geniviControlIF->enterSinkClassDB(sinkClassRSE, sinkClassIDRSE);
  ETG_TRACE_USR4(("Initialize RSE sink %d err=%d",sink.sinkID,eCode));
}
#endif

am::am_Error_e clGeniviAudioCtrlAdapter::initializeSinks(am_domainID_t domainID)
{
   am_Error_e eCode;
   iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_NOT_POSSIBLE);
   iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_ControlSenderBase,E_NOT_POSSIBLE);

   //create sink
   am_Sink_s sink;
   sink.domainID     = domainID; //we cannot know this when the table is created !
   sink.name         = "AMPLIFIER_MAINFIELD";
   sink.sinkID       = 1; //take fixed ids to make thins easy
   sink.sinkClassID  = 1;
   sink.volume       = 0;
   sink.available.availability       = A_AVAILABLE;
   sink.available.availabilityReason = AR_UNKNOWN;
   //sink.listSoundProperties.push_back(sp);

  MapMainSoundProperty_t mapMainSoundProperty;
  std::vector<am_MainSoundProperty_s> listMainSoundProperties;
  am_MainSoundProperty_s msp;
  msp.value = G3G_DEFAULT_SND_PROPERTY_VALUE;

  for (am_CustomMainSoundPropertyType_t i16Src = 0; i16Src < MSP_MAX; i16Src++)
  {
   /*
    * Add the properties which are not used and not required to register
    */
   switch(i16Src)
   {
      case MSP_MIC_STATUS_CONNECTION :
      case MSP_MIC_STATUS_LEVEL :
    continue;
    case MSP_AUDIO_OFF_MUTE :
             msp.value = AM_MSP_AUDIO_OFF_MUTE_UNDEF;

      default :
        break;
   }
     msp.type = i16Src;
     listMainSoundProperties.push_back(msp);

     mapMainSoundProperty[msp.type] = msp.value;
     //ETG_TRACE_USR4(("initializeSinks, registered sound property with %d", i16Src));
   msp.value = G3G_DEFAULT_SND_PROPERTY_VALUE;
  }

  sink.listMainSoundProperties = listMainSoundProperties;

   sink.visible = true;
   sink.listConnectionFormats.push_back(CF_GENIVI_STEREO);
   sink.muteState = MS_MUTED;
   sink.mainVolume = 0;

   //sinks
   am_sinkID_t sinkID;
   //set the correct domainID
   //sinkIter->domainID = mListDomains[0].domainID;

   //27.07.2016 daw2hi could treat this as a static sink (always there)
   am_SinkClass_s sinkClass; //, am_sinkClass_t & sinkClassID
   am_sinkClass_t sinkClassID = 1;

   sinkClass.sinkClassID = sinkClassID;
   sinkClass.name = "Sink_Class_1";
   eCode = m_geniviControlIF->enterSinkClassDB(sinkClass, sinkClassID);
   if(eCode != E_OK)
   {
      ETG_TRACE_ERR(("failed to enter SinkClass in DB, result of enterSinkClassDB %d",eCode));
   }
   else
   {
      ETG_TRACE_USR4(("enterSinkClassDB OK")); //daw2hi: ToDo: do error print if not E_OK
   }

   if ((eCode = m_geniviControlIF->enterSinkDB(sink, sinkID)) != E_OK)
   {
      ETG_TRACE_FATAL(("syncRegisterWorker::start2work error on registering domain, failed with %d", eCode));
   }
   else
   {
      m_registeredSinks[sinkID] = sink;
      m_ControlSenderBase->m_MapMainSinkSoundProperty[sinkID] = mapMainSoundProperty;
   }
   ETG_TRACE_USR3(("Initialize sink %d",sinkID));
   //initializeSinkRSE(domainID);
   return eCode;
}

am_Error_e clGeniviAudioCtrlAdapter::isValidSourceID(am_sourceID_t sourceID)
{
  //get the AudioStack SourceID of given GAM SourceID
  std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);

  if(iter != m_registeredSources.end()){
    return E_OK;
  }else{
    ETG_TRACE_ERR(("isValidSourceID: SourceID: %d is not registered at clGeniviAudioCtrlAdapter" , sourceID));
    return E_NON_EXISTENT;
  }
}
am_Error_e clGeniviAudioCtrlAdapter::isValidSinkID(am_sinkID_t sinkID)
{
  std::map<am_sinkID_t, am_Sink_s >::const_iterator iter = m_registeredSinks.find(sinkID);
  if(iter != m_registeredSinks.end()){
    return E_OK;
  }else{
    ETG_TRACE_ERR(("isValidSinkID: sinkID: %d is not registered at clGeniviAudioCtrlAdapter" , sinkID));
    return E_NON_EXISTENT;
  }
}

am_Error_e clGeniviAudioCtrlAdapter::addSourceClass( am_SourceClass_s& srcClass, am_sourceClass_t& srcClassID)
{
      return m_geniviControlIF->enterSourceClassDB(srcClassID, srcClass);
}

tVoid clGeniviAudioCtrlAdapter::initializeSourceClasses(am_domainID_t)
{
   am_Error_e eCode;
   am_SourceClass_s srcClass;
   am_sourceClass_t srcClassID;
   stSourceType t;
   const std::vector<stSourceType>& typeList = clFactory_AudioSourceClass::GetSourceTypeList();
   //std::vector<stSourceType>::const_iterator it = typeList.begin();

   for(std::vector<stSourceType>::const_iterator it = typeList.begin();
         it != typeList.end();
         ++it)
   {
      srcClass.sourceClassID = static_cast<am_sourceClass_t>((*it).id);
      srcClass.name = (*it).name;
      if ((eCode =
            m_geniviControlIF->enterSourceClassDB(srcClassID, srcClass) ) != E_OK)
      {
         //This may fail because we already registered same source class previously
         ETG_TRACE_USR4(("register source class failed with error code %d", eCode));
      }
      ETG_TRACE_USR4(("Register SourceClass GeniviID %d, ID %d, Name: %s"
            , srcClassID
            , srcClass.sourceClassID
            , srcClass.name.c_str()));
   }

}

tVoid clGeniviAudioCtrlAdapter::initializeSources(am_domainID_t domainID)
{
   vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF);
   vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_ControlSenderBase);

   am_Error_e eCode;
   //
   // CREATE DB SOURCE ITEM FOR EACH RULE OF THE STACKRULES
   // BUT EXCEPT GROUP IS INTERNAL
   //
   const std::vector<clSourceClass>& srcList = clFactory_AudioSourceClass::GetSourceClassList();
   for(std::vector<clSourceClass>::const_iterator it = srcList.begin();
         it !=srcList.end();
         ++it)
   {
      const AudioStack::clSourceClass & srcClass = clFactory_AudioSourceClass::GetSourceClass((*it).SourceClassID);
      if(srcClass.getRegistrationMode() == clSourceClass::registerStatic)
      {
         //create a bunch full of sources
         am_Source_s item;
         am_sourceID_t sourceID = 0;
         item.domainID = domainID; //assign the default domain we created
         item.name = srcClass.SrcClassName;
         item.sourceState = SS_OFF;
         item.sourceID = static_cast<am_sourceID_t>(srcClass.getClassID()); //take fixed ids to make thins easy
         //don't know Class ID
         item.sourceClassID = static_cast<am_sourceClass_t>(srcClass.getTypeID());
         item.volume = 0;
         item.visible = true;
         item.available.availability = A_AVAILABLE;
         item.available.availabilityReason = AR_UNKNOWN;

         am_MainSoundProperty_s msp;
         std::vector<am_MainSoundProperty_s> listMainSoundProperties;
         MapMainSoundProperty_t mapMainSoundProperty;

         msp.value = G3G_DEFAULT_SND_PROPERTY_VALUE;

         for (uint16_t i16Src = 0; i16Src < G3G_NUMBER_SOURCE_SND_PROPERTY; i16Src++)
         {
          msp.type = (uint16_t)g_u8SrcSoundPropertiesId[i16Src];
            listMainSoundProperties.push_back(msp);
            mapMainSoundProperty[msp.type] = G3G_DEFAULT_SND_PROPERTY_VALUE;
         }
         item.listMainSoundProperties = listMainSoundProperties;
         item.listConnectionFormats.push_back(CF_GENIVI_STEREO);

         if ((eCode =
               m_geniviControlIF->enterSourceDB(item,sourceID)) != E_OK)
         {
            ETG_TRACE_ERR(("ERROR on registering source, failed with ErrorCode: %d", eCode));
         }
     else
     {
      m_ControlSenderBase->m_MapMainSourceSoundProperty[sourceID] = mapMainSoundProperty;
     }
      }
   }
}

tVoid clGeniviAudioCtrlAdapter::Reset()
{
   m_geniviControlIF = NULL;
   //m_registeredSources.clear();
}

clAudioSource::enSourceActivity clGeniviAudioCtrlAdapter::Ext2Int_Activity(midw_fi_tcl_e8_SrcActivity::tenType extActivity)
{
   switch(extActivity)
   {
      case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
         return clGeniviAudioSource::On;

      case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
         return clGeniviAudioSource::Pause;

      case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
         return clGeniviAudioSource::Off;

      default:
         ETG_TRACE_FATAL(("Ext2Int_Activity INVALID PARAMETER"));
         break;
   }
   return clGeniviAudioSource::Off;
}

clAudioSource::enSourceAvailability clGeniviAudioCtrlAdapter::Ext2Int_Availability(midw_fi_tcl_e8_SrcAvailability::tenType extAvailability)
{
   switch(extAvailability)
   {
      case midw_fi_tcl_e8_SrcAvailability::FI_EN_NOT_AVAILABLE:
         return clAudioSource::not_available;
      case midw_fi_tcl_e8_SrcAvailability::FI_EN_PLAYABLE:
         return clAudioSource::available;
      case midw_fi_tcl_e8_SrcAvailability::FI_EN_PLAYABLE_UNKNOWN:
         return clAudioSource::unkonwn;
      case midw_fi_tcl_e8_SrcAvailability::FI_EN_NOT_PLAYABLE:
         return clAudioSource::not_available;
      default:
         ETG_TRACE_FATAL(("Ext2Int_Availability INVALID PARAMETER"));
         break;
   }
   return clAudioSource::not_available;
}

clAudioSource::enSourceAvailabilityReason clGeniviAudioCtrlAdapter::Ext2Int_AvailabilityReason(
      midw_fi_tcl_e8_SrcAvailabilityReason::tenType extAvailabilityReason)
{
   switch(extAvailabilityReason)
   {
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_ERROR:
         return clAudioSource::error;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NEWMEDIA:
         return clAudioSource::newmedia;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NOMEDIA:
         return clAudioSource::nomedia;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_NO_CONTENT:
         return clAudioSource::no_content;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_SAMEMEDIA:
         return clAudioSource::samemedia;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_TEMPERATURE:
         return clAudioSource::temperature;
      case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_VOLTAGE:
         return clAudioSource::voltage;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_OVERCURRENT:
         return clAudioSource::overcurrent;
    case midw_fi_tcl_e8_SrcAvailabilityReason::FI_EN_INTERNALDISCONNECT:
         return clAudioSource::internaldisconnect;
      default:
         ETG_TRACE_FATAL(("Ext2Int_AvailabilityReason INVALID PARAMETER"));
         break;
   }
   return clAudioSource::error;
}


am_sourceID_t clGeniviAudioCtrlAdapter::AddSource(SourceID srcID, am_Source_s& gam_source_s)
{
   ETG_TRACE_USR4(("AddSource: SourceClass: %d subID %d, GeniviID %d "
            , srcID.enSourceClass
            , (tU16)srcID.u16SubSource
            , gam_source_s.sourceID));
   if(m_geniviControlIF == NULL)
   {
      ETG_TRACE_ERR(("Error: Genivi Receive Interface not available! SourceClass: %d subID %d "
            , srcID.enSourceClass
            , (tU16)srcID.u16SubSource));
      return 0;
   }
   am_sourceID_t gam_sourceID = gam_source_s.sourceID;
   am_Error_e retVal = m_geniviControlIF->enterSourceDB(gam_source_s,gam_sourceID);
   if(retVal == E_OK)
   {
      m_registeredSources[gam_sourceID] = srcID;
      ETG_TRACE_USR4(("AddSource: SourceClass: %d subID %d assigned GeniviSourceID %d "
           , srcID.enSourceClass
           , (tU16)srcID.u16SubSource
           , (tU16)static_cast<tU16>(gam_sourceID)));
      return gam_sourceID;
   }
   ETG_TRACE_ERR(("Error: enterSourceDB returned error %d for SourceClass: %d subID %d "
               ,(tU16)retVal
               , srcID.enSourceClass
               , (tU16)srcID.u16SubSource));
   return 0;
}



tVoid clGeniviAudioCtrlAdapter::RemoveSource(am_sourceID_t gam_sourceID)
{
   ETG_TRACE_USR4(("RemoveSource: amSourceID: %d", gam_sourceID));
   am_Error_e retVal = m_geniviControlIF->removeSourceDB(gam_sourceID);
   m_registeredSources.erase(gam_sourceID);
   if(retVal != E_OK)
   {
      ETG_TRACE_ERR(("RemoveSource: ERROR could not remove source from DB %d", gam_sourceID));
   }
}

tVoid clGeniviAudioCtrlAdapter::SourceAvailabilityChange(midw_fi_tcl_e8_AudSource::tenType Source,
                                                        tU16 SubSource,
                                                        midw_fi_tcl_e8_SrcAvailability::tenType Availability,
                                                        midw_fi_tcl_e8_SrcAvailabilityReason::tenType Reason)
{
   ETG_TRACE_USR4(("SourceAvailabilityChange: SourceClass: %d, subID %#x(%d), Availability %d, Reason %d"
            ,ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType,Source)
            , SubSource
            , SubSource
            , ETG_CENUM(midw_fi_tcl_e8_SrcAvailability::tenType, Availability)
            , ETG_CENUM(midw_fi_tcl_e8_SrcAvailabilityReason::tenType, Reason)
            ));
#if 0 // there should be no more need to do this. It is clear why reset happened.
   const std::vector<clSourceClass>& srcList = clFactory_AudioSourceClass::GetSourceClassList();
   for(std::vector<clSourceClass>::const_iterator it = srcList.begin();
         it !=srcList.end();
         ++it)
   {
    const AudioStack::clSourceClass & srcClass = clFactory_AudioSourceClass::GetSourceClass((*it).SourceClassID);
    if(Ext2Int_SrcClass(Source) == srcClass.getClassID())
    {
      if(srcClass.getRegistrationMode() == clSourceClass::registerDynamic)
      {
         ETG_TRACE_USR3(("SourceAvailabilityChange: SourceAvailability change requested for dynamic source: Accepted"));
         clAudioSMEngine::Source_AvailabilityChange(
           SourceID( Ext2Int_SrcClass(Source) ,SubSource),
           Ext2Int_Availability(Availability),
           Ext2Int_AvailabilityReason(Reason));
      }
      else
      {
        ETG_TRACE_USR4(("SourceAvailabilityChange: SourceAvailability change requested for static or none source: Ignored"));
      }
      break;
    }
   }
#endif
  const AudioStack::clSourceClass & srcClass = clFactory_AudioSourceClass::GetSourceClass(Ext2Int_SrcClass(Source));
  if(srcClass.getRegistrationMode() == clSourceClass::registerDynamic)
  {
  ETG_TRACE_USR3(("SourceAvailabilityChange: SourceAvailability change requested for dynamic source: Accepted"));
  clAudioSMEngine::Source_AvailabilityChange(
  SourceID( Ext2Int_SrcClass(Source) ,SubSource),
  Ext2Int_Availability(Availability),
  Ext2Int_AvailabilityReason(Reason));
  }
  else
  {
  ETG_TRACE_USR4(("SourceAvailabilityChange: SourceAvailability change requested for static or none source: Ignored"));
  }
}

// Sink handling

am_sinkID_t clGeniviAudioCtrlAdapter::AddSink(const am_Sink_s& gam_sink_s)
{
   ETG_TRACE_USR4(("AddSink: gam_sink_s.sinkID: %d", gam_sink_s.sinkID));
   am_Sink_s tmp_sink_s;

   tmp_sink_s = gam_sink_s;
   tmp_sink_s.sinkID = 0;

   if(m_geniviControlIF == NULL)
   {
      ETG_TRACE_ERR(("Error: Genivi Receive Interface not available! SinkClassID: %d SinkID: %d, name %s"
            , tmp_sink_s.sinkClassID
            , tmp_sink_s.sinkID
            , tmp_sink_s.name.c_str()));
      return 0;
   }
   am_Error_e retVal = m_geniviControlIF->enterSinkDB(gam_sink_s,tmp_sink_s.sinkID);
   if(retVal == E_OK)
   {
      m_registeredSinks[gam_sink_s.sinkID] = gam_sink_s;
      return gam_sink_s.sinkID;  //daw2hi 9.8.2016 added forgotten return value
   }

   ETG_TRACE_ERR(("Error: enterSinkDB returned error %d for SinkClassID: %d SinkID %d"
         , retVal
         , (tU16)tmp_sink_s.sinkClassID
         , tmp_sink_s.sinkID));
   return 0;
}
tVoid clGeniviAudioCtrlAdapter::RemoveSink(am_sinkID_t gam_sinkID)
{
   ETG_TRACE_USR4(("RemoveSink: gam_sinkID: %d", gam_sinkID));
   am_Error_e retVal = m_geniviControlIF->removeSinkDB(gam_sinkID);
   m_registeredSinks.erase(gam_sinkID);
   //ToDo should check for the corresponding Stack and clean it
   clAudioSMEngine::vResetStack(gam_sinkID);
   if(retVal != E_OK)
   {
      ETG_TRACE_ERR(("RemoveSink: ERROR could not remove sinkID from DB %d", gam_sinkID));
   }
}

//tVoid clGeniviAudioCtrlAdapter::SinkAvailabilityChange()
// end
tVoid clGeniviAudioCtrlAdapter::AddAudioRouteMgrIF(amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr)
{
   m_clientHandlerAudioRouteMgr = clientHandlerAudioRouteMgr;
}

tVoid clGeniviAudioCtrlAdapter::RemoveAudioRouteMgrIF()
{
   m_clientHandlerAudioRouteMgr = NULL;
}

tVoid clGeniviAudioCtrlAdapter::AddFcAudioMgrIF(amcontrol_clienthandler_fc_audiomanager* clientHandlerFcAudiMgr)
{
  m_clientHandlerFcAudioMgr = clientHandlerFcAudiMgr;
}

tVoid clGeniviAudioCtrlAdapter::RemoveFcAudioMgrIF()
{
  m_clientHandlerFcAudioMgr = NULL;
}

tVoid clGeniviAudioCtrlAdapter::AddGeniviCtrlIF(IAmControlReceive* pGeniviCtrlIF)
{
   m_geniviControlIF = pGeniviCtrlIF;
}

tVoid clGeniviAudioCtrlAdapter::RemoveGeniviCtrlIF()
{
   m_geniviControlIF = NULL;
}

IAmControlReceive* clGeniviAudioCtrlAdapter::GetGeniviCtrlIF()
{
   return m_geniviControlIF;
}

tVoid clGeniviAudioCtrlAdapter::AddDomainID(am_domainID_t domainID)
{
  // ETG_TRACE_USR1(("AddDomainID: m_domainID: %d", domainID));
   m_domainID = domainID;
}

am_Error_e clGeniviAudioCtrlAdapter::hookUserDisconnectionRequest(const am_mainConnectionID_t connectionID)
{

   if(m_geniviControlIF==NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }
   clAudioSMEngine::enErrorCode retVal = clAudioSMEngine::AUDIOSM_ERROR;
   am_MainConnection_s mainConnectionData;
   if(E_OK == m_geniviControlIF->getMainConnectionInfoDB(connectionID, mainConnectionData))
   {
      //get the AudioStack SourceID of given GAM SourceID
      std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(mainConnectionData.sourceID);
      if(iter != m_registeredSources.begin())
      {
       //retVal =  clAudioSMEngine::Source_Off((*iter).second);
        retVal =  clAudioSMEngine::Source_Off((*iter).second,mainConnectionData.sinkID,0);
      }else{
         //There is no mapping to AudioStack SourceID
         ETG_TRACE_ERR(("hookUserDisconnectionRequest: No registered SourceID found for GAM Source ID %d", mainConnectionData.sourceID))
      }
      //Check if AudioStack was able to remove
      if(retVal != clAudioSMEngine::AUDIOSM_OK)
      {
         return E_NOT_POSSIBLE;
      }else{
         return E_OK;
      }
   }
   //Connection was not found in Genivi DB
   return E_NON_EXISTENT;
}

am_Error_e clGeniviAudioCtrlAdapter::bSourceConnect(am_sourceID_t SourceId,clAudioSMEngine::enErrorCode & retval)
{
  ETG_TRACE_ERR(("bSourceConnect use sink 1"));
  return bSourceConnect(SourceId,1,retval);
}

am_Error_e clGeniviAudioCtrlAdapter::bSourceConnect(am_sourceID_t SourceId, am_sinkID_t SinkID, clAudioSMEngine::enErrorCode & retval)
{
   //get the AudioStack SourceID of given GAM SourceID
   std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(SourceId);

   // ToDo: we should also chekc if the sink is registered and reject if it is not

   if(iter != m_registeredSources.end())
   {
      if(clAudioSourceController::bIsSourceOnStack((*iter).second,SinkID))
      {
        /*
         * accept src change always (applying stack rules is blocked if project want to
         * accept/deny src change request depending on configuration parameter) (SUZUKI-30143)
        */

        ETG_TRACE_ERR(("bSourceConnect, connection exists, source already on stack, ACCEPTING SRC CHANGE REQUEST"));
      }
      retval = clAudioSMEngine::Source_On((*iter).second,SinkID,0); //no defaults anymore
   }
   else
   {
      ETG_TRACE_ERR(("hookUserConnectionRequest: SourceID: %d is not registered at clGeniviAudioCtrlAdapter" , SourceId));
      return E_NOT_POSSIBLE;
   }
   return E_OK;
}

tVoid clGeniviAudioCtrlAdapter::vUpdateMultiUsrDataPool(bool bUserProfileChanged)
{
   dp_tclAudioStackUsrDPAudioStack_Usr_PersistentMuteAudioOff   oPersMute;
   tU8 u8PersMute = 0;
   tS32 ret = oPersMute.s32GetData(u8PersMute);
   ETG_TRACE_USR4(("vUpdateMultiUsrDataPool is %d (ret=%x)",(tU16)u8PersMute,ret));

   clAudioSMEngine::vRestoreEntertainmentsource(bUserProfileChanged);

   (void)oPersMute.s32SetData(u8PersMute);
   ETG_TRACE_USR4(("vUpdateMultiUsrDataPool is %d (ret=%x)",(tU16)u8PersMute,ret));

   clAudioSMEngine::vRestorePersistentMuteState();

}

am_Error_e clGeniviAudioCtrlAdapter::hookUserConnectionRequest(const am_sourceID_t sourceID,
                                                                      const am_sinkID_t sinkID,
                                                                      am_mainConnectionID_t& mainConnectionID)
{
    //check if sinkID is valid
  if(E_OK != clGeniviAudioCtrlAdapter::isValidSinkID(sinkID))
  {
    ETG_TRACE_ERR(("hookUserConnectionRequest: sinkID: %d is not registered at clGeniviAudioCtrlAdapter" , sinkID));
      return E_NOT_POSSIBLE;
  }
  clAudioSMEngine::enErrorCode retVal = clAudioSMEngine::AUDIOSM_ERROR;
  //am_Error_e erFlag = bSourceConnect(sourceID,retVal);
  am_Error_e erFlag = bSourceConnect(sourceID,sinkID,retVal);
  if(E_OK == erFlag)
   {
   if(retVal == clAudioSMEngine::AUDIOSM_OK)
   {
     if(E_OK == getMainConnectionOfSource(sourceID, mainConnectionID))
     {
       return E_OK;
     }
     else
     {
      ETG_TRACE_ERR(("connection exists"));
      return addMainConnection(sourceID,sinkID, mainConnectionID);
     }
  }
   else
   {
      ETG_TRACE_ERR(("hookUserConnectionRequest: AudioStack returns Error %d for connection request of SourceID: %d" , sourceID, retVal));
      return E_UNKNOWN;
  }
     return E_UNKNOWN; //to fix lint
  }
  return erFlag;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(midw_fi_tcl_e8_AudSource::tenType , tU16 )
{
   return E_OK;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID srcID)
{
  // use default Sink 1 if not provided by request
  return RequestSourceOff(srcID,(tU16)1);
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(SourceID srcID, tU16 sinkID)
{
   const stSourceType& srcType = clFactory_AudioSourceClass::GetType(srcID);
   if((srcType.exclusive) && (!srcType.stackable))
   {
      // we are not allowing source off for Entertainment (previously only blocked in SMEngine,
      // but now conflicting with CRQ CMG3G-10573, (related bug NCG3D-23032)
      ETG_TRACE_USR4(("This is Entertainment. Would block it for calls via ARL here"));
      return E_NOT_POSSIBLE;
   }
   if( clAudioSMEngine::Source_Off(srcID, sinkID) == clAudioSMEngine::AUDIOSM_OK)
   {
      return E_OK;
   }
   return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOff(const am_sourceID_t sourceID)
{
   std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);
   if(iter != m_registeredSources.end())
   {
      return RequestSourceOff((*iter).second);
   }
   return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourcePause(SourceID srcID)
{
   (void) srcID;
   ETG_TRACE_ERR(("ERROR: RequestSourcePause actually not supported"));
   return E_NOT_USED;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID srcID)
{
  return RequestSourceOn(srcID, (tU16)1);
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOn(SourceID srcID, tU16 sinkID)
{
   // we could check for the sinks here and reject if sink not found
   if(E_OK != isValidSinkID(sinkID))
   {
      //Sink not found, reject
      return E_NOT_POSSIBLE;
   }

   if( clAudioSMEngine::Source_On(srcID, sinkID, 0) == clAudioSMEngine::AUDIOSM_OK)
   {
      return E_OK;
   }
   return E_NOT_POSSIBLE;
}

am_Error_e clGeniviAudioCtrlAdapter::RequestSourceOn(const am_sourceID_t sourceID)
{
   std::map<am_sourceID_t, SourceID >::const_iterator iter = m_registeredSources.find(sourceID);
   if(iter != m_registeredSources.end())
   {
      return RequestSourceOn((*iter).second);
   }
   return E_NOT_POSSIBLE;
}

#if 1
am_Error_e clGeniviAudioCtrlAdapter::SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source
                                             , tU16 subSource
                                             , midw_fi_tcl_e8_AudSource::tenType possibleNextSource
                                             , midw_fi_tcl_e8_SrcActivity::tenType activity
                                             , midw_fi_tcl_e8_ResourceNo::tenType sink)
{
     am_Error_e retVal = E_OK;
     if(m_clientHandlerAudioRouteMgr != NULL)
     {
        m_clientHandlerAudioRouteMgr->vSourceRouteActivity_Set(
              static_cast<uint8_t>(source)
            , static_cast<uint16_t>(subSource)
            , static_cast<uint8_t>(possibleNextSource)
            , static_cast<uint8_t>(sink)
            , static_cast<uint8_t>(activity));
     }
     return retVal;
}
#endif
am_Error_e clGeniviAudioCtrlAdapter::SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source
                                                           , tU16 subSource
                                                           , midw_fi_tcl_e8_AudSource::tenType possibleNextSource
                                                           , midw_fi_tcl_e8_SrcActivity::tenType activity)
{

   ETG_TRACE_ERR(("SourceActivityRequest called without sink"));
   am_Error_e retVal = E_OK;
   if(m_clientHandlerAudioRouteMgr != NULL)
   {
      m_clientHandlerAudioRouteMgr->vSourceRouteActivity_Set(
            static_cast<uint8_t>(source)
          , static_cast<uint16_t>(subSource)
          , static_cast<uint8_t>(possibleNextSource)
          , static_cast<uint8_t>(midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS)
          , static_cast<uint8_t>(activity));
   }
   return retVal;
}

am_Error_e clGeniviAudioCtrlAdapter::disconnect(am_Handle_s& handle, am_connectionID_t connectionID)
{
   am_Error_e retVal = E_UNKNOWN;
   if(m_geniviControlIF==NULL)
   {
      return retVal;
   }
   ETG_TRACE_USR4(("disconnect: request at GAM HandleType: %d Handle %d, connectionID: %d", handle.handleType, handle.handle, connectionID));
   //bAckdisconnect is called before returning from method call
   m_geniviControlIF->disconnect(handle, connectionID);

   ETG_TRACE_USR4(("disconnect: executed at GAM HandleType: %d Handle %d, connectionID: %d", handle.handleType, handle.handle, connectionID));
   return retVal;
}

am_Error_e clGeniviAudioCtrlAdapter::connect(am_Handle_s& handle,
                                                 am_connectionID_t& connectionID,
                                                 am_CustomConnectionFormat_t format,
                                                 am_sourceID_t sourceID,
                                                 am_sinkID_t sinkID)
{
   if(m_geniviControlIF==NULL)
   {
      return E_UNKNOWN;
   }
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::connect"));
   return m_geniviControlIF->connect(handle, connectionID, format, sourceID, sinkID);
}



tVoid clGeniviAudioCtrlAdapter::cbAckDisconnect(const am_Handle_s handle, const am_Error_e errorID)
{
   ETG_TRACE_USR4(("cbAckDisconnect: Handletype: 0x%x Handlevalue: 0x%x Error: %d", handle.handleType, handle.handle, errorID));
}

tVoid clGeniviAudioCtrlAdapter::cbAckConnect(const am_Handle_s handle, const am_Error_e errorID)
{
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::cbAckConnect: Handletype: 0x%x Handlevalue: 0x%x Error: %d", handle.handleType, handle.handle, errorID));
}

am_Error_e clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB(am_sourceID_t sourceID,  std::vector<am_connectionID_t>& listConnectionID)
{
   if(m_geniviControlIF==NULL)
   {
      return E_UNKNOWN;
   }
   am_mainConnectionID_t mainconnectionID;
   am_Error_e ret = getMainConnectionOfSource(sourceID, mainconnectionID);
   if(E_OK != ret)
   {
      return ret;
   }
   return m_geniviControlIF->changeMainConnectionRouteDB(mainconnectionID, listConnectionID);
}

am_Error_e clGeniviAudioCtrlAdapter::removeMainConnection(am_sourceID_t sourceID)
{
   ETG_TRACE_USR4(("removeMainConnection for sourceID %d connected to any sink",sourceID));

   // ToDo daw2hi: need to find all connections of this sourceID.  serach and take all sinks from m_registeredSinks
   am_Error_e ret = E_OK;
   for (std::map<am_sinkID_t, am_Sink_s>::iterator it=m_registeredSinks.begin(); it!=m_registeredSinks.end(); ++it)
   {
      am_mainConnectionID_t mainConnectionID;
      ret = getMainConnectionOfSource(sourceID, it->first, mainConnectionID);
      if(E_OK == ret)
      {
         ret = removeMainConnectionDB(mainConnectionID);
         ETG_TRACE_USR4(("removeMainConnection %d for sourceID %d -- sinkID %d with result %d",mainConnectionID, sourceID, it->first, ret));
      }
      else
      {
         ETG_TRACE_USR4(("sourceID %d not connected to sinkID %d,  skipping, map size is %d",sourceID, it->first, m_registeredSinks.size()));
      }
   }

   return ret; //daw2hi: check how to handle ret. NOK if any error occured and else OK ??

  //ETG_TRACE_USR4(("removeMainConnectionDB: GAM SourceID: %d, SinkID hard coded to 1",sourceID));
  //return removeMainConnection(sourceID, GAM_AUDIO_SINK_ID);
}
am_Error_e clGeniviAudioCtrlAdapter::removeMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID)
{
   ETG_TRACE_USR4(("removeMainConnectionDB: GAM SourceID: %d, SinkID: %d", sourceID, sinkID));
   //Check active main connections
   am_mainConnectionID_t mainConnectionID;
   am_Error_e ret = getMainConnectionOfSource(sourceID, sinkID, mainConnectionID);
   if(E_OK != ret)
   {
      return ret;
   }
   ret = removeMainConnectionDB(mainConnectionID);
   if(ret != E_OK)
   {
      ETG_TRACE_ERR(("removeMainConnectionDB: Failed with: %d ", ret));
   }
   return ret;
}

am_Error_e clGeniviAudioCtrlAdapter::removeMainConnectionDB(const am_mainConnectionID_t mainConnectionID)
{
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::removeMainConnectionDB: mainConnectionID: %d ", mainConnectionID));
   if(m_geniviControlIF==NULL)
   {
      return E_UNKNOWN;
   }
   return m_geniviControlIF->removeMainConnectionDB( mainConnectionID);
}

am_Error_e clGeniviAudioCtrlAdapter::addMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID)
{
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::addMainConnection_1 hard codeded sink 1"));
   am_mainConnectionID_t mainConnectionID;
   return addMainConnection(sourceID, sinkID, mainConnectionID);
}
am_Error_e clGeniviAudioCtrlAdapter::addMainConnection(am_sourceID_t sourceID)
{
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::addMainConnection_2 hard codeded sink 1"));
   am_mainConnectionID_t mainConnectionID;
   return addMainConnection(sourceID, GAM_AUDIO_SINK_ID, mainConnectionID);
}


am_Error_e clGeniviAudioCtrlAdapter::addMainConnection(const am_sourceID_t sourceID,
                                                              const am_sinkID_t sinkID,
                                                              am_mainConnectionID_t& mainConnectionID)
{
   ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::addMainConnection SinkID %d",sinkID));
   if(m_geniviControlIF==NULL)
   {
      return E_NOT_POSSIBLE;
   }

   if(E_OK == getMainConnectionOfSource(sourceID, sinkID, mainConnectionID))
   {
      return E_ALREADY_EXISTS;
   }

   //TODO delete these Object somewhere
//   stGACA_mainConnectionItem* GACAconnItem = new stGACA_mainConnectionItem();
   //TODO delete these Object somewhere
   am_MainConnection_s mainConnectionData;// = new am_MainConnection_s();

   mainConnectionData.mainConnectionID = 0;
   mainConnectionData.sinkID = sinkID;
   mainConnectionData.sourceID = sourceID;
   mainConnectionData.connectionState = CS_CONNECTING;
   mainConnectionData.delay = 0;

//   GACAconnItem->mainConnection = mainConnectionData;
//   GACAconnItem->handle = NULL;
//   m_mainConnectionList.push_back(GACAconnItem);
   am_Error_e ret;
   ETG_TRACE_USR2(("addMainConnection: enterMainConnectionDB: ID %d, MainConnID %d, Src %d, Snk %d, size %d", mainConnectionID,
         mainConnectionData.mainConnectionID,
         mainConnectionData.sourceID,
         mainConnectionData.sinkID,
         mainConnectionData.listConnectionID.size()));
   ret = m_geniviControlIF->enterMainConnectionDB(mainConnectionData, mainConnectionID);
   ETG_TRACE_USR2(("addMainConnection: new MainConnection: ID %d, Src %d, Snk %d", mainConnectionID, sourceID, sinkID));
   mainConnectionData.mainConnectionID = mainConnectionID;
   return ret;
}

am_Error_e clGeniviAudioCtrlAdapter::getMainConnectionOfSource(am_sourceID_t sourceID, am_mainConnectionID_t& mainConnectionID)
{
  ETG_TRACE_USR4(("getMainConnectionOfSource use hard coded SinkID 1"));
  // Leave this for the time being to stay backward compatible
  return getMainConnectionOfSource(sourceID, GAM_AUDIO_SINK_ID, mainConnectionID);
}

am_Error_e clGeniviAudioCtrlAdapter::getMainConnectionOfSource(am_sourceID_t sourceID, am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID)
{
   ETG_TRACE_USR4(("getMainConnectionOfSource: Search MainConnection for Source %d, SinkID %d"
               , sourceID, sinkID));

   if(m_geniviControlIF==NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }

   std::vector<am_MainConnection_s> listMainConnections;
   m_geniviControlIF->getListMainConnections(listMainConnections);
   std::vector<am_MainConnection_s>::iterator iter = listMainConnections.begin();
   //Check for equal MainConnections
   while(iter != listMainConnections.end())
   {
      if( ((*iter).sourceID == sourceID) && ((*iter).sinkID == sinkID) )
      {
         ETG_TRACE_USR4(("getMainConnectionOfSource: Found MainConnection: ID %d, Src %d, Snk %d"
               ,(*iter).mainConnectionID
               ,(*iter).sourceID
               ,(*iter).sinkID));
         mainConnectionID = (*iter).mainConnectionID;
         return E_OK;
      }
      ++iter;
   }
   ETG_TRACE_USR4(("getMainConnectionOfSource: No MainConnection for Source %d and Sink %d", sourceID, sinkID));
   return E_NON_EXISTENT;
}

am_Error_e clGeniviAudioCtrlAdapter::getConnectionOfSource(clGeniviAudioSource* pSrc, am_connectionID_t& connectionID)
{
   if(pSrc == NULL)
   {
      ETG_TRACE_ERR(("getConnectionOfSource: SOURCE POINTER == NULL"))
      return E_UNKNOWN;
   }

   ETG_TRACE_USR4(("getConnectionOfSource: Search Connection for SourceClass %d SubID %d "
               , pSrc->sGetId().enSourceClass
               , pSrc->sGetId().u16SubSource));

   if(m_geniviControlIF==NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }

   std::vector<am_Connection_s> listConnections;
   m_geniviControlIF->getListConnections(listConnections);
   std::vector<am_Connection_s>::iterator iter = listConnections.begin();
   //Check for equal MainConnections
   while(iter != listConnections.end())
   {
      if((*iter).sourceID == pSrc->u16GetGeniviSourceID())
      {
         ETG_TRACE_USR4(("getMainConnectionOfSource: Found Connection: ID %d, Src %d, Snk %d"
               ,(*iter).connectionID
               ,(*iter).sourceID
               ,(*iter).sinkID));
         connectionID = (*iter).connectionID;
         return E_OK;
      }
      ++iter;
   }
   ETG_TRACE_USR4(("getConnectionOfSource: No Connection for SourceClass %d SubID %d "
               , pSrc->sGetId().enSourceClass
               , pSrc->sGetId().u16SubSource));
   return E_NON_EXISTENT;
}

am_Error_e clGeniviAudioCtrlAdapter::changeSourceAvailabilityDB(am_Availability_s& availability, am_sourceID_t sourceID)
{
    am_Error_e GamDBErr;
   ETG_TRACE_USR3(("changeSourceAvailabilityDB: GeniviSourceID %d, availability-state: 0x%x availability-reason: 0x%x "
               , sourceID
               , availability.availability
               , availability.availabilityReason));
   if(m_geniviControlIF == NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }
   //return m_geniviControlIF->changeSourceAvailabilityDB(availability, sourceID);
   GamDBErr = m_geniviControlIF->changeSourceAvailabilityDB(availability, sourceID);

  return GamDBErr;
}

am_Error_e clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(const am_sourceID_t sourceID,
                                                                        const am_sinkID_t sinkID,
                                                                        const am_ConnectionState_e connectionState)
{
   ETG_TRACE_USR3(("changeMainConnectionStateDB: source %d, connectionState %d"
               , sourceID
               , ETG_CENUM(am_ConnectionState_e, connectionState)));

   if(m_geniviControlIF==NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }

   am_mainConnectionID_t mainConnectionID;
   am_Error_e ret = getMainConnectionOfSource(sourceID, sinkID, mainConnectionID);
   if(E_OK != ret)
   {
      return ret;
   }
   return m_geniviControlIF->changeMainConnectionStateDB(mainConnectionID, connectionState);
}

am_Error_e clGeniviAudioCtrlAdapter::changeSinkMuteStateDB(const am_MuteState_e muteState,
                                                           const am_sinkID_t sinkId)
{
   ETG_TRACE_USR3(("changeSinkMuteStateDB: sinkId: %d, muteState: %d"
               , sinkId
               , ETG_CENUM(am_MuteState_e, muteState)));

   if(m_geniviControlIF==NULL)
   {
      ETG_TRACE_ERR(("m_geniviControlIF==NULL"));
      return E_UNKNOWN;
   }

   am_Sink_s sinkData;
   m_geniviControlIF->getSinkInfoDB(sinkId,sinkData);

   if(sinkData.muteState == muteState){
     ETG_TRACE_USR4(("changeSinkMuteStateDB::muteState is not changed, No need to send update !!"));
     return E_NO_CHANGE;
   }

   return m_geniviControlIF->changeSinkMuteStateDB(muteState, sinkId);
}

/**
  * update system property
  */
void clGeniviAudioCtrlAdapter::updateSystemPropertyDB(am_CustomSystemPropertyType_t etype,int16_t ivalue)
{
   ETG_TRACE_USR3(("updateSystemPropertyDB: property type: %d, value: %d"
       , ETG_CENUM(am_CustomSystemPropertyType_t, etype),ivalue));
   if(m_ControlSenderBase==NULL)
   {
     ETG_TRACE_ERR(("m_ControlSenderBase==NULL"));
     return;
   }
   m_ControlSenderBase->vUpdateSystemPropertyDB(etype,ivalue);
   return;
 }

/**
  * update system property
  */
void clGeniviAudioCtrlAdapter::updateSoundPropertyDB(am_CustomMainSoundPropertyType_t etype,int16_t ivalue)
{
   ETG_TRACE_USR3(("updateSoundPropertyDB: property type: %d, value: %d"
       , ETG_CENUM(am_CustomMainSoundPropertyType_t, etype),ivalue));
   if(m_ControlSenderBase==NULL)
   {
     ETG_TRACE_ERR(("m_ControlSenderBase==NULL"));
     return;
   }
   m_ControlSenderBase->vUpdateSinkSoundPropertyDB(etype,ivalue);
   return;
 }

am_Error_e clGeniviAudioCtrlAdapter::setSourceState(am_Handle_s& handle,
      const am_sourceID_t sourceID, am_SourceState_e state)
{
   ETG_TRACE_USR3(("setSourceState: GAM source %d, state %d"
            , sourceID
            , ETG_CENUM(am_SourceState_e, state)));
   return m_geniviControlIF->setSourceState(handle, sourceID, state);
}

void clGeniviAudioCtrlAdapter::cbAckSourceState(const am_Handle_s handle, const am_Error_e error)
{
   ETG_TRACE_USR4(("cbAckSourceState: handle %d, handleType %d, errorID: %d"
               , handle.handle
               , handle.handleType
               , error));
}

sourceClassID clGeniviAudioCtrlAdapter::Ext2Int_SrcClass(midw_fi_tcl_e8_AudSource::tenType enSrcExt)
{
   //sourceClassID enSrcInternal = clFactory_AudioSourceClass::GetInvalidSourceClass();
   ETG_TRACE_USR4(("ExternalSrcClass_2_InternalSrcClass: External/midw_fi source id %d",
         ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, enSrcExt)));

   const clSourceClass* srcClass = clFactory_AudioSourceClass::GetSourceClass_extID(static_cast<midw_fi_tcl_e8_AudSource::tenType>(enSrcExt));
   //midw_fi_tcl_e8_AudSource::tenType extSrcID = static_cast<midw_fi_tcl_e8_AudSource::tenType>(clStackRules::rules[i].externalID);
   if(srcClass != NULL)
   {
      sourceClassID intID = srcClass->getClassID();
      ETG_TRACE_USR4(("Ext2Int_SrcClass: clStackRules=>ExtSrcID : %d, Mapped to IntSrcID : %d",
            ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType,enSrcExt),
            intID));
      return intID;
   }else{
      ETG_TRACE_ERR(("Ext2Int_SrcClass: ERROR could not map ExternalID %d to internal SourceClass"
            , static_cast<tU16>(enSrcExt)));
      return clFactory_AudioSourceClass::GetInvalidSourceClass();
   }
}

clAudioSource* clGeniviAudioCtrlAdapter::pcoGetTopOfStack()
{
  return clAudioSourceController::getInstance().pcoGetTopOfStack();
}
tBool clGeniviAudioCtrlAdapter::bIsCurrentActiveAudiosource(SourceID srcID)
{
  tBool retVal = clAudioSourceController::getInstance().bIsCurrentActiveAudiosource(srcID);
  ETG_TRACE_USR4(("bIsCurrentActiveAudiosource: SourceClass: %d subID %d: %d"
      , srcID.enSourceClass
      , srcID.u16SubSource
      , retVal));
  return retVal;
}

//rjk2kor : fix for Fix for SUZUKI-16966
clAudioSource* clGeniviAudioCtrlAdapter::pcoGetTopOfStackMixsource()
{
  return clAudioSourceController::pcoGetTopOfStackMixsource();
}

void clGeniviAudioCtrlAdapter::vHandleSourceError(midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc, tU16 ErrorCode)
{
   // daw2hi: we have now sufficient information via modified status message
   ETG_TRACE_ERR(("vHandleSourceError: Src=%d, SubSrc=%d, Error=%d",
       source,subSrc,ErrorCode));
   // need to get sourceClassID  enSourceClass from receive source
   SourceID srcID(Ext2Int_SrcClass(source), subSrc);
   clAudioSMEngine::vHandleSrcActError(srcID);
}
// no more supported
//void clGeniviAudioCtrlAdapter::vHandleSourceError(midw_fi_tcl_e8_AudSource::tenType errSrc)
//{
   //TODO: Open Point identified:
   //received Information insufficient, need additional SubSource Information
   //which is actually not transmitted
   //Send Mail 11.11.2013 4pm
//   ETG_TRACE_ERR(("vHandleSourceError: CANNOT HANDLE ERROR CORRECTLY, ABORTING ERROR HANDLING FOR SOURCE CLASS %d",
//           ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, errSrc)));
//}

tBool clGeniviAudioCtrlAdapter::bIsCurrentSourceStackable(midw_fi_tcl_e8_AudSource::tenType source,tU8 subID)
{
  bool bIsStackable = false;
  if(source == midw_fi_tcl_e8_AudSource::FI_EN_NONE)
  {
    ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::bIsCurrentSourceStackable(),Ignoring source(0)/midw_fi_tcl_e8_AudSource::FI_EN_NONE"));
    return true;
  }

  sourceClassID srcClassID = clGeniviAudioCtrlAdapter::Ext2Int_SrcClass(source);
  const AudioStack::clSourceClass & srcClass = clFactory_AudioSourceClass::GetSourceClass(srcClassID);
  clAudioSource* pSrc = clAudioSourceFactory::getAudioSource(srcClass.SourceClassID,subID);

  if(pSrc != NULL){
    if(pSrc->getSourceType().stackable){
      bIsStackable = true;
      ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::bIsCurrentSourceStackable(),new source is mix/announcement source"));
    }
    else{
      ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::bIsCurrentSourceStackable(),new source is not mix/announcement source"));
    }
    }
  return bIsStackable;
}

// daw2hi: keep for backward compatibility
void clGeniviAudioCtrlAdapter::handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity, midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc)
{
  midw_fi_tcl_e8_ResourceNo::tenType sinkID = (midw_fi_tcl_e8_ResourceNo::tenType)1;
  handleSourceStatus(activity, source, subSrc, sinkID);
}


void clGeniviAudioCtrlAdapter::handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity,
    midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc, midw_fi_tcl_e8_ResourceNo::tenType sinkID)
{
     ETG_TRACE_USR3(("handleSourceStatus: external sourceID %d, subID %d, activity %d, sinkID = %d"
           , ETG_CENUM(midw_fi_tcl_e8_AudSource::tenType, source)
           , subSrc
           , ETG_CENUM(midw_fi_tcl_e8_SrcActivity::tenType, activity)
           , sinkID));


   // We go to all registered source
   // and notify all with the corresponding SourceClass
   // because there might be more than one that matches
   std::map<am_sourceID_t, SourceID >::iterator iter = m_registeredSources.begin();
   while(iter != m_registeredSources.end())
   {
      clAudioSource* pSrc = clAudioSourceFactory::getAudioSource((*iter).second);
      ++iter;
      if((pSrc != NULL )
         && (clFactory_AudioSourceClass::GetExternalID(pSrc->sGetId()) == static_cast<tU32>(source))
         && (pSrc->sGetId().u16SubSource == subSrc))
      {
         ETG_TRACE_USR4(("handleSourceStatus: Inform internal sourceClass %d, subID %d, activity %d"
               , pSrc->sGetId().enSourceClass
               , pSrc->sGetId().u16SubSource
               , ETG_CENUM(clGeniviAudioSource::enSourceActivity,activity)));

           pSrc->vMW_CCAResponse(static_cast<tS32>(source), subSrc, Ext2Int_Activity(activity), static_cast<tU16>(sinkID));
       break; //Solve blocking of Genivi Main loop (NCG3D-78107)
      }

   }
}

clGeniviAudioSource* clGeniviAudioCtrlAdapter::getAudioSource(SourceID srcID)
{
   std::map<am_sourceID_t, SourceID >::iterator iter = m_registeredSources.begin();
   while(iter != m_registeredSources.end())
   {
      if((*iter).second == srcID)
      {
         return static_cast<clGeniviAudioSource* >(clAudioSourceFactory::getAudioSource((*iter).second));
      }
      ++iter;
   }
   ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::getAudioSource: No Source found with SrcClass %d SubID %d"
         , srcID.enSourceClass
         , srcID.u16SubSource));
   return NULL;
}



void clGeniviAudioCtrlAdapter::SetAudioState(tS16 audioState)
{
  if(audioState == AM_MSP_AUDIO_OFF_MUTE_OFF)
  {
    clAudioSMEngine::vResetTime_Init();
  }
}

am_Error_e clGeniviAudioCtrlAdapter::vSetAmplifierMute(tU16 u16MuteValue)
{
  am_Error_e ret = E_UNKNOWN;
  const clSourceClass* pSrcClass_AmplifierMute = clFactory_AudioSourceClass::GetSourceClass("MUTE_NO_AUD_DEV");

  if(pSrcClass_AmplifierMute == NULL)
  {
    ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::vSetAmplifierMute MUTE_NO_AUD_DEV not found !!!"));
    return E_NON_EXISTENT;
  }

  switch(u16MuteValue)
  {
    case MUTE_NO_AUD_DEV_OFF :
    {
      ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetAmplifierMute, Removing MUTE_NO_AUD_DEV"));
      ret = RequestSourceOff(SourceID(pSrcClass_AmplifierMute->getClassID(),0));
      break;
    }
    case MUTE_NO_AUD_DEV_ON :
    {
      ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetAmplifierMute, Adding MUTE_NO_AUD_DEV"));
      ret = RequestSourceOn(SourceID(pSrcClass_AmplifierMute->getClassID(),0));
      break;
    }
    default :
    {
      ret = E_NON_EXISTENT;
      ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::vSetAmplifierMute, called for Non Existent value of MUTE_NO_AUD_DEV"));
      break;
    }
  }
  return ret;
}
/************************************************************************
 *FUNCTION     : vSetMuteOnStartUp
 *DESCRIPTION  : Apply "MUTE_HMISTARTUP" on stack on startup to mute the system on startup
             HMI should remove "MUTE_HMISTARTUP" once it is ready by calling setSystemSoundProperty()
 *PARAMETER    : tU16 uiValue
 *RETURN VALUE : am_Error_e
 *HISTORY      :
 *01.06.2015   Rev 1.0     RBEI/ECV2 - Vyankatesh VD  Initial Revision
 ************************************************************************/
am_Error_e clGeniviAudioCtrlAdapter::vSetMuteOnStartUp(tU16 uiValue, bool bStartup)
{
  am_Error_e ret = E_UNKNOWN;
  const clSourceClass* pSrcClass_HmiStartupMute = clFactory_AudioSourceClass::GetSourceClass("MUTE_HMISTARTUP");

  if(pSrcClass_HmiStartupMute == NULL)
  {
    ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp MUTE_HMISTARTUP not found !!!"));
    return E_NON_EXISTENT;
  }

  iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_geniviControlIF,E_UNKNOWN);

  am_SystemProperty_s systemproperty = {SYP_HMISTARTUP_MUTE,SYP_HMISTARTUP_MUTE_OFF};

  switch(uiValue)
  {
    case SYP_HMISTARTUP_MUTE_OFF :
    {
      ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp, setting SYP_HMISTARTUP_MUTE_OFF"));
      ret = RequestSourceOff(SourceID(pSrcClass_HmiStartupMute->getClassID(),0));
      m_geniviControlIF->changeSystemPropertyDB(systemproperty);

      break;
    }
    case SYP_HMISTARTUP_MUTE_ON :
    {
      if(bStartup) {
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp, setting SYP_HMISTARTUP_MUTE_ON"));
        ret = RequestSourceOn(SourceID(pSrcClass_HmiStartupMute->getClassID(),0));

        systemproperty.value = SYP_HMISTARTUP_MUTE_ON;
        m_geniviControlIF->changeSystemPropertyDB(systemproperty);
      }
      else{
        ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp,Not possible to set SYP_HMISTARTUP_MUTE_ON"));
        return E_NOT_POSSIBLE;
      }
      break;
    }
    default :
    {
      ret = E_NON_EXISTENT;
      ETG_TRACE_ERR(("clGeniviAudioCtrlAdapter::vSetMuteOnStartUp, called for Non Existent value of SYP_HMISTARTUP_MUTE"));
      break;
    }
  }
  return ret;
}
am_Error_e clGeniviAudioCtrlAdapter::vSetWelcomeMuteOnStartUp(bool bStartup)
{
  ETG_TRACE_USR4(("vSetWelcomeMuteOnStartUp Entered with bStartUp %d",bStartup));
  am_Error_e ret = E_UNKNOWN;

#if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_RN_AIVI)
  tU8 u8VariantInfo = 0;
  if((DP_S32_NO_ERR == DP_s32GetConfigItem("CMVariantCoding", "OEMType", &u8VariantInfo,1)))
  {
      if(0x08 == u8VariantInfo)  //check if OEM type is Renault
      {
       ETG_TRACE_USR4(("After Pushing welcome sound on startup"));
       const clSourceClass* pSrcClass_welcomesoundMute = clFactory_AudioSourceClass::GetSourceClass("MUTE_WELCOMESOUND_STARTUP");

      if(pSrcClass_welcomesoundMute){
          SourceID Src = SourceID(pSrcClass_welcomesoundMute->getClassID(),0);
      ret = RequestSourceOn(Src);
      if(clAudioSourceFactory::isSourceInstantiated(Src) != NULL){
        clAudioSource* pAudSrc = clAudioSourceFactory::getAudioSource(Src);
        if(pAudSrc)
             pAudSrc->vWelcomeSoundTimerStart();
        }
      }
      }
  }
#endif
  return ret;
}
am_Error_e clGeniviAudioCtrlAdapter::vSetPersistentMute()
{
  am_MuteState_e muteState = MS_MUTED;
  m_geniviControlIF->changeSinkMuteStateDB(muteState, 1);
  return E_OK;
}

/************************************************************************
 *FUNCTION     : vAudioStateLCMStatus
 *DESCRIPTION  : Set auto play parameter to TURE or FALSE based on
 *         audio state received from LCM.
 *PARAMETER    : spm_corefi_tclMsgAudioStateStatus&
 *RETURN VALUE : tVoid
 *HISTORY      :
 *08.10.2015   Rev 1.0     RBEI/ECV2 - Parusharam J  Initial Revision
 ************************************************************************/
tVoid clGeniviAudioCtrlAdapter::vAudioStateLCMStatus(am_SystemAudioState_e oAudioSate)
{
  ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vAudioStateLCMStatus() entered"));
  ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vAudioStateLCMStatus() audiostate=%d", oAudioSate));
  switch(oAudioSate)
  {

  case SYP_AM_SRV_STS_AUDIOSTATE_EMERGENCY:
  {
    vSetWelcomeMuteOnStartUp(1);
    m_bEnableAutoPlay = FALSE;
  }
  break;
  case SYP_AM_SRV_STS_AUDIOSTATE_OFF:
  case SYP_AM_SRV_STS_AUDIOSTATE_LIMITED:
    {
      m_bEnableAutoPlay = FALSE;
    }
    break;
  case SYP_AM_SRV_STS_AUDIOSTATE_NORMAL:
    {
      m_bEnableAutoPlay = TRUE;
    }
    break;
  default:
    {
      m_bEnableAutoPlay = TRUE;
    }
    break;
  }
  ETG_TRACE_USR4(("clGeniviAudioCtrlAdapter::vAudioStateLCMStatus() m_bEnableAutoPlay=%d", m_bEnableAutoPlay));
}

/************************************************************************
 *FUNCTION     : LoadVolContext
 *DESCRIPTION  : function to load correct volume context in volume manager
 *PARAMETER    : clAudioSource*, clAudioSource*
 *RETURN VALUE : Void
 *HISTORY      :
 *30.06.2016   Rev 1.0     RBEI/ECO12 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid clGeniviAudioCtrlAdapter::vLoadVolumeContext(clAudioSource* pSrcRemoved)
{
  vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_clientHandlerAudioRouteMgr);
  vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(pSrcRemoved);

  ETG_TRACE_USR4(("vLoadVolumeContext: Entered"));

  clAudioSource* pNextPossibleSource  = clAudioSourceController::getInstance().pcoGetFirstNonMuteSrcFromStack();
  clAudioSource* pCurrActiveSource = clAudioSourceController::getInstance().pcoGetCurrentActiveAudiosource();

  if((NULL != pNextPossibleSource) && (NULL != pCurrActiveSource))
  {
    ETG_TRACE_USR4(("vLoadVolumeContext: pNextPossibleSource: %d,pCurrActiveSource: %d",
            pNextPossibleSource->getSourceClass().getClassID(),pCurrActiveSource->getSourceClass().getClassID()));
       /*
      *  AST:  --------TOP--------
      *  AST:      TUNER_TA_FM : on
      *  AST:   MUTE_ENTERTAIN : pause
      *  AST:         MEDIA : pause
      *  AST:  ------BOTTOM-------
      *
      *  Case1: Media Removed : pSrcRemoved->Media, pNextPossibleSource->TUNER_TA_FM, pCurrActiveSource->TUNER_TA_FM
      */
    if(pCurrActiveSource->getSourceClass().getClassID() == pNextPossibleSource->getSourceClass().getClassID())
    {
      ETG_TRACE_USR4(("vLoadVolumeContext: No Need to Load Volume Context, as it is Active source : %d",
          pNextPossibleSource->getSourceClass().getClassID()));
    }
    else if(clSrcStateFactory::pclCreateOn() != pNextPossibleSource->pclGetState() && clSrcStateFactory::pclCreateRampDownToOff() != pNextPossibleSource->pclGetState())
    {
      ETG_TRACE_USR3(("vLoadVolumeContext: Loading Volume Context For SrcID: %d",
      pNextPossibleSource->getSourceClass().getClassID()));
    m_clientHandlerAudioRouteMgr->vSetAudioSource((uint8_t)clFactory_AudioSourceClass::GetExternalID(pNextPossibleSource->sGetId()),0,(uint8_t)clFactory_AudioSourceClass::GetExternalID(pNextPossibleSource->sGetId()),(uint8_t)midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC,(uint8_t)1);
    }
    else
    {
       /*
      *  AST:  --------TOP--------
      *  AST:      NAVI_SPEECH :  on
      *  AST:      TUNER_TA_FM :  on
      *  AST:  SDS_SPEECHRECOGNITION :pause
      *  AST:   MEDIA_PLAYER#1 :pause
      *  AST:  ------BOTTOM-------
      *
      *  If Media is removed then pSrcRemoved->Media, pNextPossibleSource->NAVI_SPEECH, pCurrActiveSource->TUNER_TA_FM
      */
      ETG_TRACE_USR4(("vLoadVolumeContext: No Need to Load Volume Context, as possible Next source is already ON"));
    }
  }
  else
  {
    /*
     * Use case when source report error for SrcActOn() request
     * In this case when error is reported, src is removed from stack and stack became empty.
     * If volume operation is performed when stack is empty,it should be applied to default source
     */
    ETG_TRACE_USR4(("vLoadVolumeContext: pNextPossibleSource is NULL, May be STACK is EMPTY !!"));
    SourceID lastSource (clFactory_AudioSourceClass::GetDefaultSourceClass(),0);

    if (clAudioSMEngine::bIsSourceAvailable(lastSource)){
      ETG_TRACE_USR4(("vLoadVolumeContext: Loading Volume Context For Default Source: %d",lastSource.enSourceClass));
      m_clientHandlerFcAudioMgr->vSetAudioSource((uint8_t)midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,(uint8_t)clFactory_AudioSourceClass::GetExternalID(lastSource),(uint8_t)midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC);
     }
    else{
      ETG_TRACE_USR4(("vLoadVolumeContext: Default Source: %d is not Available !!",lastSource.enSourceClass));
    }

  }
}
/************************************************************************
 *FUNCTION     : bIsAutoplayEnabled
 *DESCRIPTION  : returns TRUE if auto play is enabled otherwise FALSE
 *PARAMETER    : void
 *RETURN VALUE : tBool
 *HISTORY      :
 *08.10.2015  Rev 1.0     RBEI/ECV2 - Parusharam J  Initial Revision
 ************************************************************************/
tBool clGeniviAudioCtrlAdapter::bIsAutoplayEnabled()
{
  //No autoplay if we are in Diag Session
  if(true == clAudioSourceController::getInstance().bIsTopOfBackUpStackMuteAndOn())
  {
    ETG_TRACE_USR4(("DiagMode is active, autoplay is disabled for all sources"));
    return false;
  }

  ETG_TRACE_USR3(("clGeniviAudioCtrlAdapter::bIsAutoplayEnabled() m_bEnableAutoPlay=%d", m_bEnableAutoPlay));
  return m_bEnableAutoPlay;
}

tBool clGeniviAudioCtrlAdapter::bAudioDeviceAvailability()
{
  iGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_clientHandlerFcAudioMgr,false);
  return(m_clientHandlerFcAudioMgr->bGetbAudioDeviceAvailability());
}

/************************************************************************
 *FUNCTION     : vSetEntertainmentMute
 *DESCRIPTION  : method to inform fc_audiMgr about Entertainment Mute/DeMute
 *PARAMETER    : void
 *RETURN VALUE : tBool
 *HISTORY      :
 *21.08.2017  Rev 1.0     RBEI/ECO1 - Vyankatesh VD  Initial Revision
 ************************************************************************/
tVoid clGeniviAudioCtrlAdapter::vSetEntertainmentMute(const am_MuteState_e muteState)
{
    ETG_TRACE_USR4(("CAmControlSenderBase::vSetEntertainmentMute called with muteState= %d",muteState));
    vGAM_CTRL_PLUGIN_NULL_POINTER_CHECK(m_clientHandlerFcAudioMgr);

    switch (muteState)
    {
        case MS_MUTED:
        {
            ETG_TRACE_USR4(("CAmControlSenderBase::vSetEntertainmentMute, Calling vSetEntertainmentMute(MUTE) to mute all main streams"));
            m_clientHandlerFcAudioMgr->vSetEntertainmentMute(
                    midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                    midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                    midw_fi_tcl_e8MuteAction::FI_EN_MUTE,
                    midw_fi_tcl_b32MuteReason::FI_C_U32_BIT_MUTE_REAS_OTHER);

            break;
        }
        case MS_UNMUTED:
        {
            ETG_TRACE_USR4(("CAmControlSenderBase::vSetEntertainmentMute, Calling vSetEntertainmentMute(DEMUTE) to mute all main streams"));
            m_clientHandlerFcAudioMgr->vSetEntertainmentMute(
                    midw_fi_tcl_e8_MuteRequester::FI_EN_GENIVIAUDIOMANAGER,
                    midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_RESOURCE_LS,
                    midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE,
                    midw_fi_tcl_b32MuteReason::FI_C_U32_BIT_MUTE_REAS_OTHER);

            break;
        }
        default:
            ETG_TRACE_USR4(("CAmControlSenderBase::vSetEntertainmentMute, default"));
    }
}


} //namespace
