#include "AudioStack/SMT/clSrcState_WaitFor.h"
#include "AudioStack/AudioSources/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack { namespace SourceStateMachine
{

using namespace AudioSource;

//******************************************************************
//************************ WAIT FOR ********************************
//******************************************************************


void clSrcState_WaitFor::vEnter(clAudioSource* , tU32 , tU8 )
{
}

void clSrcState_WaitFor::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // simple transition from waitFor to off
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateOff(), u32UserData, ENTRYCONDITION_NONE);
}

void clSrcState_WaitFor::vMsg_On(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // should be called when the source that we'll waited for is gone
   // cause we'll init now as same as we do from Off state
   // sequence is:
   // 1) init() -> init_done()
   // 2) on() -> requesConfirmed() -> on_done()
   // as long as request is not confirmed from FC-Audio, an incoming off-request
   // is not delegated to FC-Audio. It has to be confirmed manually.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData);
}

void clSrcState_WaitFor::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   if (NULL != pclAudioSource)
   {
      pclAudioSource->vMW_Pause(pclAudioSource->u8GetNextSource());
   }
   // simple transition from off to pause is just used to differentiate background and foreground-states
   // of sources in MW. No intermediate state required.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_Pause(), u32UserData);
}

}}//namespace

