/*
 * clXMLLoader.cpp
 *
 *  Created on: Jan 9, 2014
 *      Author: vo84hi
 *
 */
#include "include/audiomanagertypes.h"
#include "AudioStack/AudioSources/clAudioSourceController.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"
#include <sstream>
#include <algorithm>
#include <stdio.h>
#include <time.h>
#include <sys/time.h>
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
   #include "xmlKeeper.h"
#endif

#ifndef USE_DLT_TRACE
   #define ETRACE_S_IMPORT_INTERFACE_GENERIC
   #include "etrace_if.h"
   #define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
   #include "trcGenProj/Header/clFactory_AudioSourceClass.cpp.trc.h"
#endif

namespace AudioStack
{
namespace AudioSource
{
//**********************
//MEMBER INIT
std::string                clFactory_AudioSourceClass::m_configFile("/var/opt/bosch/static/audio/audiomanager/source_priorities.xml");
std::string                clFactory_AudioSourceClass::m_configBoseFile("/var/opt/bosch/static/audio/audiomanager/source_priorities_bose.xml");

stSourceSetting             clFactory_AudioSourceClass::m_source_settings;
std::vector<stSourceType>  clFactory_AudioSourceClass::m_source_types;
std::vector<std::string>   clFactory_AudioSourceClass::m_source_groups;
std::vector<clSourceClass> clFactory_AudioSourceClass::m_source_class;
clAudioSourceController* clFactory_AudioSourceClass::m_pAudioSourceController = NULL;

std::vector<tU16>          clFactory_AudioSourceClass::m_sinks;

sourceClassID              clFactory_AudioSourceClass::m_default_sourceClassId = clFactory_AudioSourceClass::GetInvalidSourceClass();
long                       clFactory_AudioSourceClass::m_timeXmlLoad_overallTime = 0;
long                       clFactory_AudioSourceClass::m_timeXmlLoad_cpuTime = 0;
//ans5kor - fix for SUZUKI-22310, SUZUKI-22275
clSourceClass           m_invalidsourceclass(clFactory_AudioSourceClass::GetInvalidSourceClass(),"INVALID");

//**********************

tVoid clFactory_AudioSourceClass::Invalidate()
{
   m_configFile = "/var/opt/bosch/static/audio/audiomanager/source_priorities.xml";
   m_source_types.clear();
   m_source_groups.clear();
   m_source_class.clear();
   m_source_settings.AllowSrcAlreadyonStack = true;
   m_source_settings.BackGroundSourceExchange = true;

   m_sinks.clear();
   m_default_sourceClassId = clFactory_AudioSourceClass::GetInvalidSourceClass();
   m_timeXmlLoad_overallTime = 0;
   m_timeXmlLoad_cpuTime = 0;
}

tVoid clFactory_AudioSourceClass::ReadXML()
{
   ETG_TRACE_ERR(("ReadXML"));
   /*
    * this initialize the library and check potential ABI mismatches
    * between the version it was compiled for and the actual shared
    * library used.
    */
   LIBXML_TEST_VERSION
   Ruleset_Parse();
   /*
    * Cleanup function for the XML library.
    */
   xmlCleanupParser();
   /*
    * this is to debug memory for regression tests
    */
   xmlMemoryDump();
}



tBool clFactory_AudioSourceClass::Ruleset_LoadTypes(xmlNode * a_node)
{
   //TODO doublette check
   m_source_types.clear();
   stSourceType invalidType;
   invalidType.exclusive = TRUE;
   invalidType.stackable = TRUE;
   invalidType.name = std::string("INVALID");

   xmlNode *cur_node = NULL;
   //xmlNodePtr Node = NULL;
   for (cur_node = a_node; cur_node; cur_node = cur_node->next) {
      if (cur_node->type == XML_ELEMENT_NODE) {
         if(xmlStrEqual(cur_node->name,(const xmlChar *)"type" ))
         {
            xmlChar* type_name = xmlGetProp(cur_node, (const xmlChar *)"name");
            xmlChar* stackable = xmlGetProp(cur_node, (const xmlChar *)"stackable");
            xmlChar* exclusive = xmlGetProp(cur_node, (const xmlChar *)"exclusive");
            xmlChar* restore   = xmlGetProp(cur_node, (const xmlChar *)"restore");
            xmlChar* previous  = xmlGetProp(cur_node, (const xmlChar *)"previous"); //New parameter to set previous history(CMG3G-7590)

      stSourceType type;
            if(type_name == NULL)
            {
               ETG_TRACE_ERR(("Ruleset_LoadTypes: TYPE NODE HAS NO NAME ATTRIBUTE" ));
               return FALSE;
            }
            if(stackable == NULL)
            {
               ETG_TRACE_ERR(("Ruleset_LoadTypes: NO stackable ATTRIBUTE AT TYPE NODE: %s"
                     , (const char*)type_name));
               return FALSE;
            }
            if(exclusive == NULL)
            {
               ETG_TRACE_ERR(("Ruleset_LoadTypes: NO exclusive ATTRIBUTE AT TYPE NODE: %s"
                     , (const char*)type_name));
               return FALSE;
            }
            if(restore == NULL)
            {
               ETG_TRACE_ERR(("Ruleset_LoadTypes: NO restore ATTRIBUTE AT TYPE NODE: %s"
                     , (const char*)type_name));
               return FALSE;
            }
      if(previous == NULL)
            {
               ETG_TRACE_ERR(("Ruleset_LoadTypes: NO previous ATTRIBUTE AT TYPE NODE: %s"
                     , (const char*)type_name));
         // Setting previous to TRUE if previous parameter is not available in source_priorities.xml file.
         // Behavior should be same as earlier for other G3g projects(PSA specific requirement).
               type.previous = TRUE;
            }

            type.name = std::string((const char*)type_name);

            //check for correct value "yes" or "no" of RESTORE attribute
            if(strcmp("yes", (const char*)restore) == 0)
            {
               type.restorable = TRUE;
            }else
            if(strcmp("no", (const char*)restore) == 0)
            {
               type.restorable = FALSE;
            }else{
               ETG_TRACE_ERR(("Ruleset_LoadTypes: ONLY yes OR no ARE ALLOWED VALUES FOR ATTRIBUTE stackable OF NODE %s"
                     , (const char*)type_name));
               return FALSE;
            }

            //check for correct value "yes" or "no" of STACKABLE attribute
            if(strcmp("yes", (const char*)stackable) == 0)
            {
               type.stackable = TRUE;
            }else
            if(strcmp("no", (const char*)stackable) == 0)
            {
               type.stackable = FALSE;
            }else{
               ETG_TRACE_ERR(("Ruleset_LoadTypes: ONLY yes OR no ARE ALLOWED VALUES FOR ATTRIBUTE stackable OF NODE %s"
                     , (const char*)type_name));
               return FALSE;
            }

            //check for correct value "yes" or "no" of EXCLUSIV attribute
            if(strcmp("yes", (const char*)exclusive) == 0)
            {
               type.exclusive = TRUE;
            }else
            if(strcmp("no", (const char*)exclusive) == 0)
            {
               type.exclusive = FALSE;
            }else{
               ETG_TRACE_ERR(("Ruleset_LoadTypes: ONLY yes OR no ARE ALLOWED VALUES FOR ATTRIBUTE exclusive OF NODE %s"
                     , (const char*)type_name));
               return FALSE;
            }

      if(NULL != previous)
      {
        //check for correct value "yes" or "no" of previous attribute
        if(strcmp("yes", (const char*)previous) == 0)
        {
           type.previous = TRUE;
        }else
        if(strcmp("no", (const char*)previous) == 0)
        {
           type.previous = FALSE;
        }else{
           ETG_TRACE_ERR(("Ruleset_LoadTypes: ONLY yes OR no ARE ALLOWED VALUES FOR ATTRIBUTE previous OF NODE %s"
             , (const char*)type_name));
           return FALSE;
        }
      }

            type.id = (tU8)m_source_types.size();
            m_source_types.push_back(type);
            ETG_TRACE_USR4(("TYPE LOADED: ID: %d, Stackable %d, Exclusive %d, Name %s, "
                  , type.id
                  , type.stackable
                  , type.exclusive
                  , type.name.c_str()));
         }
      }
   }
   return TRUE;
}



tBool clFactory_AudioSourceClass::Ruleset_LoadGroups(xmlNode * a_node)
{
   xmlNode *cur_node = NULL;
   //xmlNodePtr Node = NULL;
   for (cur_node = a_node; cur_node; cur_node = cur_node->next) {
      if (cur_node->type == XML_ELEMENT_NODE) {
         if(xmlStrEqual(cur_node->name,(const xmlChar *)"group" ))
         {
            xmlChar* uri = xmlGetProp(cur_node, (const xmlChar *)"name");
            if(uri!= NULL)
            {
               m_source_groups.push_back(std::string((const char*)uri));
               ETG_TRACE_USR4(("GROUP LOADED: %s", (const char*)uri ));
            }else{
               ETG_TRACE_ERR(("GROUP NODE HAS NO NAME ATTRIBUTE" ));
               return FALSE;
            }
         }
      }
   }
   return TRUE;
}
tBool clFactory_AudioSourceClass::Ruleset_LoadSettings(xmlNode * a_node)
{
  ETG_TRACE_USR4(("Ruleset_LoadSettings: entered"));
  xmlNode *cur_node = NULL;
  //xmlNodePtr Node = NULL;
  for (cur_node = a_node; cur_node; cur_node = cur_node->next) {
    if (cur_node->type == XML_ELEMENT_NODE) {
      if(xmlStrEqual(cur_node->name,(const xmlChar *)"setting" ))
      {
        ETG_TRACE_USR4(("Ruleset_LoadSettings: found setting"));
        xmlChar* allow_src_request = xmlGetProp(cur_node, (const xmlChar *)"AllowSrcAlreadyonStack");

        if(NULL != allow_src_request)
        {
          m_source_settings.AllowSrcAlreadyonStack = true;

          //check for correct value "yes" or "no" of previous attribute
          if(strcmp("yes", (const char*)allow_src_request) == 0)
          {
            ETG_TRACE_USR4(("Ruleset_LoadSettings: AllowSrcAlreadyonStack=yes"));
            m_source_settings.AllowSrcAlreadyonStack = true;
          }else if(strcmp("no", (const char*)allow_src_request) == 0){
            ETG_TRACE_USR4(("Ruleset_LoadSettings: AllowSrcAlreadyonStack=no"));
            m_source_settings.AllowSrcAlreadyonStack = false;
          }else{
            ETG_TRACE_ERR(("Ruleset_LoadSettings: ONLY yes OR no ARE ALLOWED VALUES FOR ATTRIBUTE AllowSrcAlreadyonStack OF NODE %s"
                , (const char*)allow_src_request));
            //return FALSE;
          }
        }else{
          ETG_TRACE_ERR(("Ruleset_LoadSettings:setting NODE HAS NO 'AllowSrcAlreadyonStack' ATTRIBUTE" ));
          //return FALSE;
        }

        //Read parameter 'BackGroundSourceExchange'
        xmlChar* background_src_exchange = xmlGetProp(cur_node, (const xmlChar *)"BackGroundSourceExchange");
        if(NULL != background_src_exchange)
        {
          m_source_settings.BackGroundSourceExchange = true;

          //check for correct value "yes" or "no"
          if(strcmp("yes", (const char*)background_src_exchange) == 0)
          {
            ETG_TRACE_USR4(("Ruleset_LoadSettings: BackGroundSourceExchange=yes"));
            m_source_settings.BackGroundSourceExchange = true;
          }else if(strcmp("no", (const char*)background_src_exchange) == 0){
            ETG_TRACE_USR4(("Ruleset_LoadSettings: BackGroundSourceExchange=no"));
            m_source_settings.BackGroundSourceExchange = false;
          }else{
            ETG_TRACE_ERR(("Ruleset_LoadSettings: ONLY yes OR no ARE ALLOWED VALUES FOR ATTRIBUTE BackGroundSourceExchange OF NODE %s"
                , (const char*)background_src_exchange));
            //return FALSE;
          }
        }else{
          ETG_TRACE_ERR(("Ruleset_LoadSettings:setting NODE HAS NO 'BackGroundSourceExchange' ATTRIBUTE" ));
          //return FALSE;
        }

      }else
      {
        ETG_TRACE_ERR(("Ruleset_LoadSettings:setting NODE not found" ));
      }
    }
  }
  return TRUE;
}

//Read in the possible sinks in the system
tBool clFactory_AudioSourceClass::Ruleset_LoadSinks(xmlNode * a_node)
{
  xmlNode *cur_node = NULL;
  for (cur_node = a_node; cur_node; cur_node = cur_node->next)
  {
    if(cur_node->type == XML_ELEMENT_NODE)
    {
      if(xmlStrEqual(cur_node->name,(const xmlChar *)"sink"))
      {
        xmlChar* uri = xmlGetProp(cur_node, (const xmlChar *)"name");
        xmlChar* idStr = xmlGetProp(cur_node, (const xmlChar *)"id");
        if(uri!= NULL)
        {
          ETG_TRACE_USR4(("Found Sink: %s", (const char*)uri ));

        }else{
          ETG_TRACE_ERR(("SINK NODE HAS NO NAME SINK" ));
          return FALSE;
        }

        if(idStr!= NULL)
        {
          ETG_TRACE_USR4(("Found Sink: id=%s", (const char*)idStr ));
               m_sinks.push_back(tU16(atoi((const char*)idStr)));
          ETG_TRACE_USR4(("SINK LOADED id=%d name=%s",atoi((const char*)idStr), (const char*)uri));

          //ToDo: daw2hi 27.07.2016 we could create Genivi Sink Class
          am_Sink_s gam_sink_s;
               gam_sink_s.sinkClassID = (uint16_t)atoi((const char*)idStr);
               gam_sink_s.sinkID = (uint16_t)atoi((const char*)idStr); // sinkID and sinkClassID same value
          gam_sink_s.name = std::string((const char*)uri);
          gam_sink_s.domainID = 1;
          gam_sink_s.volume = 0;
          gam_sink_s.visible = true;
          gam_sink_s.available.availability = A_AVAILABLE;
          gam_sink_s.available.availabilityReason = AR_UNKNOWN;
          gam_sink_s.muteState = MS_MUTED;
          gam_sink_s.mainVolume = 0;
          gam_sink_s.listConnectionFormats.push_back(CF_GENIVI_STEREO);


          std::map<am_CustomMainSoundPropertyType_t, int16_t> mapMainSoundProperty;
          std::vector<am_MainSoundProperty_s> listMainSoundProperties;
          am_MainSoundProperty_s msp;
          msp.value = 0;

          for (am_CustomMainSoundPropertyType_t i16Src = 0; i16Src < MSP_MAX; i16Src++)
          {
            /*
             * Add the properties which are not used and not required to register
             */
             switch(i16Src)
             {
             case MSP_MIC_STATUS_CONNECTION :
             case MSP_MIC_STATUS_LEVEL :
               continue;
             default :
               break;
             }
             msp.type = i16Src;
             listMainSoundProperties.push_back(msp);

             mapMainSoundProperty[msp.type] = msp.value;
             //ETG_TRACE_USR4(("Ruleset_LoadSinks, registered sound property with %d", i16Src));
          }

          gam_sink_s.listMainSoundProperties = listMainSoundProperties;


          if(m_pAudioSourceController == NULL)
          {
            ETG_TRACE_USR4(("clAudioSourceController not yet created -> do it now."));
            //(void)clAudioSourceController::getInstance();
          }
          if(m_pAudioSourceController == NULL)
          {
            ETG_TRACE_USR4(("m_pAudioSourceController still NULL"));
          }
          else
          {
            ETG_TRACE_USR4(("announce sink"));
            m_pAudioSourceController->vAddSinkClass(gam_sink_s);
          }

        }else{
          ETG_TRACE_ERR(("SINK NODE HAS NO NAME SINK" ));
          return FALSE;
        }
      }
    }
  }
  return TRUE;
}


tBool clFactory_AudioSourceClass::isValidSourceClass(sourceClassID srcClass)
{
   if((srcClass < m_source_class.size())&&(srcClass != GetInvalidSourceClass()))
         return TRUE;
   return FALSE;
}

tU16  clFactory_AudioSourceClass::GetAvailabilityTimeout(SourceID& srcID)
{
   if(isValidSourceClass(srcID.enSourceClass))
   {
      return m_source_class[srcID.enSourceClass].AvailabilityTimeout;
   }else{
      ETG_TRACE_FATAL(("GetAvailabilityTimeout: ClassID %d subID %d is not valid"
            , srcID.enSourceClass
            , srcID.u16SubSource));
      return 0;
   }
}

const clSourceClass* clFactory_AudioSourceClass::GetSourceClass_extID(clSourceClass::externalID extID)
{
   ETG_TRACE_USR4(("GetSourceClass_extID: search SourceClass by extID: %d"
         , extID));
   std::vector<clSourceClass>::const_iterator it = m_source_class.begin();
   while(it != m_source_class.end())
   {
      const clSourceClass& srcClass = (*it);
      if(srcClass.ExtID == extID)
      {
        // ETG_TRACE_USR4(("GetSourceClass: found SourceClass ID: %d"
        //       , srcClass.SourceClassID));
         return &srcClass;
      }
      ++it;
   }
   return NULL;
}

const clSourceClass* clFactory_AudioSourceClass::GetSourceClass(const char * srcClassName)
{
   ETG_TRACE_USR4(("GetSourceClass: search SourceClass by name: %s"
         , srcClassName));
   std::vector<clSourceClass>::const_iterator it = m_source_class.begin();
   while(it != m_source_class.end())
   {
      const clSourceClass& srcClass = (*it);
      if(strcmp(srcClass.SrcClassName.c_str(),srcClassName) == 0)
      {
         ETG_TRACE_USR4(("GetSourceClass: found SourceClass ID: %d"
                  , srcClass.SourceClassID));
         return &srcClass;
      }
      ++it;
   }
   return NULL;
}

const clSourceClass& clFactory_AudioSourceClass::GetSourceClass(sourceClassID srcClass)
{
   if(isValidSourceClass(srcClass))
   {
      return m_source_class[srcClass];
   }else{
    //ans5kor - fix for SUZUKI-22310, SUZUKI-22275
      ETG_TRACE_USR3(("GetSourceClass %d is not valid", srcClass));
      return m_invalidsourceclass;
      //return m_source_class[GetInvalidSourceClass()];

   }
}

sourceClassID clFactory_AudioSourceClass::GetInvalidSourceClass()
{
   //TODO extend XML and Load procedure for getting a default source
   return 0;
}

sourceClassID clFactory_AudioSourceClass::GetDefaultSourceClass()
{
   ETG_TRACE_USR4(("clFactory_AudioSourceClass::GetDefaultSourceClass: %d"
         , m_default_sourceClassId));
   return m_default_sourceClassId;
}

clSourceClass::autoplay_t clFactory_AudioSourceClass::GetAutoPlayMode(SourceID srcID)
{
   if(m_source_class.size() <= srcID.enSourceClass)
      {
         ETG_TRACE_FATAL(("clFactory_AudioSourceClass::GetAutoPlayMode: OUT OF BOUNDS m_source_class.size():%d  SourceClassID: %d"
               , m_source_class.size()
               , srcID.enSourceClass));
         return clSourceClass::autoplay_none;
      }
      //ETG_TRACE_USR4(("GetTypeID: %d"));
      return m_source_class[srcID.enSourceClass].AutoPlay;
}

tU32 clFactory_AudioSourceClass::GetExternalID(SourceID srcID)
{
   if(m_source_class.size() <= srcID.enSourceClass)
      {
         ETG_TRACE_FATAL(("clFactory_AudioSourceClass::GetTypeID: OUT OF BOUNDS m_source_class.size():%d  SourceClassID: %d"
               , m_source_class.size()
               , srcID.enSourceClass));
         return 0;
      }
      //ETG_TRACE_USR4(("GetTypeID: %d"));
      return m_source_class[srcID.enSourceClass].ExtID;
}

clSourceClass::registration_t clFactory_AudioSourceClass::GetRegistrationMode(SourceID srcID)
{
   if(m_source_class.size() <= srcID.enSourceClass)
      {
         ETG_TRACE_FATAL(("clFactory_AudioSourceClass::GetTypeID: OUT OF BOUNDS m_source_class.size():%d  SourceClassID: %d"
               , m_source_class.size()
               , srcID.enSourceClass));
         return clSourceClass::registerNone;
      }
      //ETG_TRACE_USR4(("GetTypeID: %d"));
      return m_source_class[srcID.enSourceClass].SourceRegistration;
}

clSourceClass::sourceTypeID clFactory_AudioSourceClass::GetTypeID(SourceID srcID)
{
   if(m_source_class.size() <= srcID.enSourceClass)
   {
      ETG_TRACE_FATAL(("clFactory_AudioSourceClass::GetTypeID: OUT OF BOUNDS m_source_class.size():%d  SourceClassID: %d"
            , m_source_class.size()
            , srcID.enSourceClass));
      return 0;
   }
   //ETG_TRACE_USR4(("GetTypeID: %d"));
   return m_source_class[srcID.enSourceClass].SourceTypeID;
}

const stSourceType& clFactory_AudioSourceClass::GetType(SourceID srcID)
{
   sourceTypeID typeID = GetTypeID(srcID);
//   if(typeID == 0)
//   {
//      ETG_TRACE_FATAL(("clFactory_AudioSourceClass::GetType: ERROR: return INVALID type for SourceClassID: %d"
//                  , srcID.enSourceClass));
//   }
   if(m_source_types.size() <= typeID)
   {
      ETG_TRACE_FATAL(("clFactory_AudioSourceClass::GetType: OUT OF BOUNDS m_source_types.size():%d  SourceClassID: %d"
            , m_source_types.size()
            , srcID.enSourceClass));
   }
   return m_source_types[typeID];
}

clSourceClass::sourceGroupID clFactory_AudioSourceClass::GetGroupID(SourceID srcID)
{
   if(m_source_class.size() <= srcID.enSourceClass)
   {
      ETG_TRACE_FATAL(("clFactory_AudioSourceClass::GetGroupID: OUT OF BOUNDS m_source_class.size():%d  SourceClassID: %d"
            , m_source_class.size()
            , srcID.enSourceClass));
      return 0;
   }
   return m_source_class[srcID.enSourceClass].SourceGroupID;
}

tBool clFactory_AudioSourceClass::Ruleset_LoadSource(xmlNode * sourceNode)
{
   xmlChar* uri = xmlGetProp(sourceNode, (const xmlChar *)"name");
   if(uri== NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource: SOURCE NODE IS MISSING NAME ATTRIBUTE"));
      return FALSE;
   }
//   ETG_TRACE_USR4(("Load SourceClass    Name: %s",(const char*)uri));
   clSourceClass srcClass((tU8)m_source_class.size(),(const char*)uri);
   //these are the minimum attributes
   xmlChar* type     = xmlGetProp(sourceNode, (const xmlChar *)"type");
   xmlChar* group    = xmlGetProp(sourceNode, (const xmlChar *)"group");
   xmlChar* reg      = xmlGetProp(sourceNode, (const xmlChar *)"registration");
   xmlChar* externID = xmlGetProp(sourceNode, (const xmlChar *)"cca_value");
   xmlChar* autoplay = xmlGetProp(sourceNode, (const xmlChar *)"autoplay");
   xmlChar* timeout = xmlGetProp(sourceNode, (const xmlChar *)"timeout");
   xmlChar* supress_subsource = xmlGetProp(sourceNode, (const xmlChar *)"supress_subsource");
   xmlChar* defaultSourceClass = xmlGetProp(sourceNode, (const xmlChar *)"default");
   xmlChar* restore = xmlGetProp(sourceNode, (const xmlChar *)"restore");
   xmlChar* previous = xmlGetProp(sourceNode, (const xmlChar *)"previous");


   //********************
   // ATTRIBUTE REGISTRATION
   //********************
   if(reg == NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource: SOURCE NODE MISSING MANDATORY ATTRIBUTE: REGISTRATION"))
           return FALSE;
   }else if(xmlStrEqual(reg, (const xmlChar *)"none"))
   {
      srcClass.SourceRegistration = clSourceClass::registerNone;
   }else if(xmlStrEqual(reg, (const xmlChar *)"static"))
   {
      srcClass.SourceRegistration = clSourceClass::registerStatic;
   }else if(xmlStrEqual(reg, (const xmlChar *)"dynamic"))
   {
      srcClass.SourceRegistration = clSourceClass::registerDynamic;
   }else{
      ETG_TRACE_ERR(("Ruleset_LoadSource: SOURCE NODE REGISTRATION TYPE IS UNKOWN: %s",(const char*)reg))
      return FALSE;
   }

   //********************
   // ATTRIBUTE GROUP
   //********************
   if(group == NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource: SOURCE NODE MISSING MANDATORY ATTRIBUTE: GROUP"))
      return FALSE;
   }
   std::vector<std::string>::iterator it;
   it=std::find(m_source_groups.begin(), m_source_groups.end(),std::string((const char*)group));
   if(it == m_source_groups.end())
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource: SOURCE NODE GROUP IS NOT PART OF GROUP DEFINITIONS"));
      return FALSE;
   }
   clSourceClass::sourceGroupID indexSrcGroupID = static_cast<clSourceClass::sourceGroupID>(it - m_source_groups.begin());
   //ETG_TRACE_USR4(("    Group: ID %d, Name: %s", static_cast<tU8>(indexSrcGroupID), m_source_groups[static_cast<tU8>(indexSrcGroupID)].c_str()));
   srcClass.SourceGroupID = indexSrcGroupID;

   //********************
   // ATTRIBUTE TYPE
   //********************
   if(type == NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource: SOURCE NODE MISSING MANDATORY ATTRIBUTE: TYPE"))
      return FALSE;
   }

   std::vector<stSourceType>::iterator it_type;
   for( it_type=m_source_types.begin();
       (it_type!=m_source_types.end())
         && ((*it_type).name != std::string((const char*)type));
         ++it_type)
   { }

   if(it_type == m_source_types.end())
   {
      ETG_TRACE_FATAL(("Ruleset_LoadSource: SOURCE NODE TYPE IS NOT PART OF TYPE DEFINITIONS"));
      ETG_TRACE_ERRMEM(("Ruleset_LoadSource: SOURCE NODE TYPE IS NOT PART OF TYPE DEFINITIONS"));
      return FALSE;
   }

   clSourceClass::sourceTypeID index_type = static_cast<sourceTypeID>((*it_type).id);
   //ETG_TRACE_USR4(("    Type:  ID %d, Name: %s"
   //      , static_cast<tU8>(index_type)
   //      , m_source_types[static_cast<tU8>(index_type)].name.c_str()));
   srcClass.SourceTypeID = index_type;
   //********************
   // ATTRIBUTE EXT-ID
   //********************
   if(srcClass.SourceRegistration != clSourceClass::registerNone)
   {
      // If registration is done, an external ID is mandatory
      if(externID == NULL)
      {
         ETG_TRACE_ERR(("Ruleset_LoadSource: SOURCE NODE MISSING MANDATORY EXTERN ID (Except register == none"));
         return FALSE;
      }
      srcClass.ExtID = (tU16)atoi((const char*)externID);
      //ETG_TRACE_USR4(("    EXT-ID: %d", srcClass.ExtID));
   }

   //********************
   // ATTRIBUTE AUTOPLAY
   //********************
   if(autoplay != NULL)
   {
      if(!strcmp((const char*)autoplay,"none"))
      {
         srcClass.AutoPlay = clSourceClass::autoplay_none;
      }else{
         srcClass.AutoPlay = clSourceClass::autoplay_avail;
      }
   }else{
      //By default do autoplay
      srcClass.AutoPlay = clSourceClass::autoplay_avail;
   }

   /*
    * Introduced as WEB source are not LSM restorable in IVI
    */
   //*************************
   // ATTRIBUTE RESTORE AS LSM
   //*************************
   if(restore != NULL)
   {
      if(!strcmp((const char*)restore,"false"))
      {
         srcClass.Restore = false;
      }else{
       srcClass.Restore = true;
      }
   }else{
      //By default restore LSM is true
    srcClass.Restore = true;
   }

   //ETG_TRACE_USR4(("    Restore: %d", srcClass.Restore));

/*
* Introduced as USB_VIDEO source are not LSM restorable in IVI
*/
   //*************************
   // ATTRIBUTE PREVIOUS
   //*************************
   if(previous != NULL)
   {
      if(!strcmp((const char*)previous,"no"))
      {
         srcClass.Previous = false;
      }else{
       srcClass.Previous = true;
      }
   }else{
      //By default fall back to previous is true
    srcClass.Previous = true;
   }

   //ETG_TRACE_USR4(("    Previous: %d", srcClass.Previous));

   //********************
   // ATTRIBUTE TIMEOUT
   //********************
   if(timeout != NULL)
   {
    srcClass.AvailabilityTimeout = (tU16)atoi((const char*)timeout);
    //ETG_TRACE_USR4(("Setting timeout to %d",srcClass.AvailabilityTimeout));
   }else{
      //By default no timeout
      srcClass.AvailabilityTimeout = 0;
   }
   //********************
   // ATTRIBUTE supress_subsource
   //********************

   // This is default if not used in xml file
   srcClass.bSupressSubSource = false;

   if(supress_subsource != NULL)
   {
     if(!strcmp((const char*)supress_subsource,"true"))
     {
       // this should supress the subsource #Tag for dynamic sources
       srcClass.bSupressSubSource = true;
     }
   }
   //ETG_TRACE_USR4(("    supress_subsource: %u",(tU8)srcClass.bSupressSubSource));
   // ATTRIBUTE DEFAULT SOURCE CLASS
   //********************
   if(defaultSourceClass != NULL)
   {
      //ETG_TRACE_USR4(("    Default SourceClass"));
      if(m_default_sourceClassId != GetInvalidSourceClass())
      {
         ETG_TRACE_ERR(("Ruleset_LoadSource: ERROR default SrcClass reassign: already assigned SrcClass %10s, wanted default %s "
               , m_source_class[m_default_sourceClassId].SrcClassName.c_str()
               , (const char*)uri));
         return FALSE;
      }
      m_default_sourceClassId = (tU8)m_source_class.size();
   }

   ETG_TRACE_USR4(("    SourceClass added: ID: %d Name: %s"
         ,m_source_class.size()
         ,srcClass.SrcClassName.c_str()));
   m_source_class.push_back(srcClass);
   return TRUE;
}

tVoid clFactory_AudioSourceClass::Ruleset_Print() {
   ETG_TRACE_ERR(("Ruleset_Print: Actual Ruleset"));
   //std::vector<clGeniviAudioCtrlAdapter::SourceClassRule>::iterator it;
   //for(it=m_source_class.begin(); it!=m_source_class.end();++it)
   for(tU8 i = 0; i<m_source_class.size(); ++i)
   {
      ETG_TRACE_ERR(("%s", m_source_class[i].SrcClassName.c_str()));
      ETG_TRACE_ERR(("   ID      : %d", i));
      ETG_TRACE_ERR(("   ExtID   : %d", m_source_class[i].ExtID));
      ETG_TRACE_ERR(("   Type    : %d, %s", m_source_class[i].getTypeID(), m_source_types[m_source_class[i].getTypeID()].name.c_str() ));
                      // m_source_types[m_source_class[i].type].c_str()
                      // m_source_types[static_cast<tU8>(index)].c_str()
      ETG_TRACE_ERR(("   Group   : %d, %s", m_source_class[i].getGroupID(), m_source_groups[m_source_class[i].getGroupID()].c_str()));
      ETG_TRACE_ERR(("   RegMode : %d", (tU8)m_source_class[i].getRegistrationMode()));
      ETG_TRACE_ERR(("   Timeout : %d", (tU16)m_source_class[i].AvailabilityTimeout));
      ETG_TRACE_ERR(("   Autoplay: %d", m_source_class[i].AutoPlay));
      ETG_TRACE_ERR(("   Restore : %d", m_source_class[i].Restore));
      ETG_TRACE_ERR(("   Supress_SubSource: %d", (tU8)m_source_class[i].bSupressSubSource));
      ETG_TRACE_ERR(("   Rules: %d", m_source_class[i].Rules.size()));
      for(tU8 j = 0; j<m_source_class[i].Rules.size(); ++j)
      {

         //TODO remove the magic numbers
         switch(RuleQualifier::GetQualifier(m_source_class[i].Rules[j]))
         {
            case RuleQualifier::ALLOW_GROUP:
               {
               clSourceClass::sourceGroupID groupID = RuleQualifier::GetGroupID(m_source_class[i].Rules[j]);
               ETG_TRACE_ERR(("        Rule %d: Allow Group (ID %d): %s"
                     , j
                     , groupID
                     , m_source_groups[groupID].c_str() ));
               }
               break;
            case RuleQualifier::NOT_SRC:
               {
               sourceClassID classID = RuleQualifier::GetSourceClass(m_source_class[i].Rules[j]);
               ETG_TRACE_ERR(("        Rule %d: Deny Source:  ID: %d Name: %s"
                     , j
                     , classID
                     , (m_source_class[classID].SrcClassName.c_str()) ));
               }
               break;
            case RuleQualifier::ALL_SOURCES:
               {
               ETG_TRACE_ERR(("        Rule %d: Allow All Sources"
                     , j ));
               }
               break;
            default:
               {
               ETG_TRACE_ERR(("        Rule %d: Allow Source: ID: %d Name: %s"
                     , j
                     , m_source_class[i].Rules[j]
                     , (m_source_class[m_source_class[i].Rules[j]].SrcClassName.c_str()) ));
               }
               break;
         }
      }
   }
}

tBool clFactory_AudioSourceClass::Ruleset_LoadSource_SinkRuleAndAction(xmlNode * sinkNode)
{
  //********************
  //One ruleset: sinks, rules and actions
  //********************
  for (xmlNode *sinkSubNode = sinkNode->children; sinkSubNode; sinkSubNode = sinkSubNode->next)
  {
    if (sinkSubNode->type == XML_ELEMENT_NODE)
    {
      if(xmlStrEqual(sinkSubNode->name,(const xmlChar *)"sink" ))
      {
        if(!Ruleset_LoadSource_Sink(sinkSubNode))
        {
          ETG_TRACE_ERR(("LOAD SINK FAILED"));
          return FALSE;
        }
      }
      else if(xmlStrEqual(sinkSubNode->name,(const xmlChar *)"rules" ))
      {
        if(!Ruleset_LoadSource_Rules(sinkSubNode))
        {
          ETG_TRACE_ERR(("LOAD RULES FAILED"));
          return FALSE;
        }
      }
      else if(xmlStrEqual(sinkSubNode->name,(const xmlChar *)"actions" ))
      {
        if(!Ruleset_LoadSource_Actions(sinkSubNode))
        {
          ETG_TRACE_ERR(("LOAD ACTIONS FAILED"));
          return FALSE;
        }
      }
    }
  }
  return TRUE;
}

tBool clFactory_AudioSourceClass::Ruleset_LoadSource_RuleAndAction(xmlNode * sourceNode)
{
   //********************
   // RULES
   //********************
   tBool bAllowedSinksFound = false;
   for (xmlNode *sourceSubNode = sourceNode->children; sourceSubNode; sourceSubNode = sourceSubNode->next)
   {
      if (sourceSubNode->type == XML_ELEMENT_NODE)
      {
         if(xmlStrEqual(sourceSubNode->name,(const xmlChar *)"rules" ))
         {
            if(!Ruleset_LoadSource_Rules(sourceSubNode))
            {
               ETG_TRACE_ERR(("LOAD RULES FAILED"));
               return FALSE;
            }
         }
         else if(xmlStrEqual(sourceSubNode->name,(const xmlChar *)"actions" ))
         {
            if(!Ruleset_LoadSource_Actions(sourceSubNode))
            {
               ETG_TRACE_ERR(("LOAD ACTIONS FAILED"));
               return FALSE;
            }
         }
         else if(xmlStrEqual(sourceSubNode->name,(const xmlChar *)"allowed_sinks" ))
         {
            bAllowedSinksFound = true; //new xml format
            if(!Ruleset_LoadSource_AllowedSinks(sourceSubNode))
            {
               ETG_TRACE_ERR(("LOAD ALLOWED SINKS FAILED"));
               return FALSE;
            }
         }
      }
   }
   if(bAllowedSinksFound == false)
   {
      xmlChar* source_name = xmlGetProp(sourceNode, (const xmlChar *)"name");

      if(source_name == NULL)
      {
         ETG_TRACE_ERR(("sourceNode->parent name is NULL"));
         //return FALSE;
      }
      else {
         tU8 index_sinkOwner = 0;
         if(!Ruleset_GetSourceClassID(index_sinkOwner,(const char*)source_name))
         {
            ETG_TRACE_ERR(("can not get number from source class %s",source_name));
            return FALSE;
         }
        // ETG_TRACE_USR4(("found  index_sinkOwner%d from source class %s",index_sinkOwner,source_name));
         // old XML Format. Set sink 1 as default and as the only allowed sink
         m_source_class[index_sinkOwner].defaultSink = 1; //default sink
         m_source_class[index_sinkOwner].Sinks.push_back(1); //allowed sink
      }

   }
   return TRUE;
}

tBool clFactory_AudioSourceClass::Ruleset_LoadSource_Sink(xmlNode * sinkGrouNode)
{
   if(sinkGrouNode->parent==NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_Sink: NO PARENT NODE"));
      return FALSE;
   }
   xmlChar* source_name = xmlGetProp(sinkGrouNode->parent, (const xmlChar *)"name");
   if(source_name == NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_Sink: GIVEN NODE IS NOT A CHILD OF SOURCE NODE"));
      return FALSE;
   }

   for (xmlNode *sinkNode = sinkGrouNode->children; sinkNode; sinkNode = sinkNode->next)
   {
      if(sinkNode->type == XML_ELEMENT_NODE)
      {
         //***************
         // ALLOW SINK RULES
         //***************
         if(xmlStrEqual(sinkNode->name,(const xmlChar *)"allow"))
         {
             //TODO Clean this if/else/if... -> make it more readable ;)
             xmlChar* sink = xmlGetProp(sinkNode, (const xmlChar *)"number");
             if(sink != NULL)
             {
                int s16Sink = atoi((const char*)sink);
                (void)s16Sink;
                // need to put it somehwere
               // ETG_TRACE_USR4(("allow Sink %d",s16Sink));
             }
         }
         else if(xmlStrEqual(sinkNode->name,(const xmlChar *)"default"))
         {
             //TODO Clean this if/else/if... -> make it more readable ;)
              xmlChar* defSink = xmlGetProp(sinkNode, (const xmlChar *)"number");
              if(defSink != NULL)
              {
                 int s16defSink = atoi((const char*)defSink);
                 (void)s16defSink;
                 // need to put it somewhere
                // ETG_TRACE_USR4(("default Sink %d",s16defSink));
              }
         }
      }
   } // for loop


//   if(!strcmp((const char*)number,"1"))
//   {
//     ETG_TRACE_USR4(("supported for Sink 1"));
//   }
//   else if(!strcmp((const char*)number,"2"))
//   {
//     ETG_TRACE_USR4(("supported for Sink 2"));
//   }

   return TRUE;
}
tBool clFactory_AudioSourceClass::Ruleset_LoadSource_Rules(xmlNode * rulesGroupNode)
{
   if(rulesGroupNode->parent==NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_Rules: NO PARENT NODE"));
      return FALSE;
   }

   xmlChar* source_name = xmlGetProp(rulesGroupNode->parent, (const xmlChar *)"name");
   if(source_name == NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_Rules: GIVEN NODE IS NOT A CHILD OF SOURCE NODE"));
      return FALSE;
   }

   tU8 index_ruleOwner = 0;
   if(!Ruleset_GetSourceClassID(index_ruleOwner,(const char*)source_name))
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_Rules: COULD NOT ASSIGN RULES TO SOURCE %s. IT IS NO FOUND IN SOURCECLASS LISTING", (const char*)source_name));
      return FALSE;
   }
   //ETG_TRACE_USR4(("LOAD RULES for SourceClass ID: %d, Name %s", index_ruleOwner, source_name));

   for (xmlNode *ruleNode = rulesGroupNode->children; ruleNode; ruleNode = ruleNode->next)
   {
      if(ruleNode->type == XML_ELEMENT_NODE)
      {
         //***************
         // ALLOW RULES
         //***************
         if(xmlStrEqual(ruleNode->name,(const xmlChar *)"allow" ))
         {
            //TODO Clean this if/else/if... -> make it more readable ;)
            xmlChar* attribute = xmlGetProp(ruleNode, (const xmlChar *)"group");
            if(attribute != NULL)
            {
               //use U16 with flags in upper byte
               //0x2000 => GroupFlag, so logical or with Src and find its group
               tU8 index_targetSrc = 0;
               if(!Ruleset_GetSourceClassID(index_targetSrc,(const char*)attribute))
               {
                  ETG_TRACE_ERR(("Ruleset_LoadSource_Rules: SOURCE %s OF RULE IS NOT FOUND IN SOURCECLASS LISTING", (const char*)source_name));
                  return FALSE;
               }
               clSourceClass allowGroup = GetSourceClass(index_targetSrc);
               if(allowGroup.getClassID() != GetInvalidSourceClass())
               {
                  //ETG_TRACE_USR4(("    Allow Group: %s"
                  //      , m_source_groups[allowGroup.getGroupID()].c_str()));
                  sourceRule ruleValue = RuleQualifier::Apply(allowGroup.getClassID(), RuleQualifier::ALLOW_GROUP);
                  m_source_class[index_ruleOwner].Rules.push_back(ruleValue);
               }else{
                  ETG_TRACE_ERR(("Ruleset_LoadSource_Rules: RULE ALLOWS INVALID GROUP"));
                  return FALSE;
               }
            }else{
               attribute = xmlGetProp(ruleNode, (const xmlChar *)"source");
               if(attribute != NULL)
               {
                  tU8 index_targetSrc = 0;
                  if(!Ruleset_GetSourceClassID(index_targetSrc,(const char*)attribute))
                  {
                     ETG_TRACE_ERR(("Ruleset_LoadSource_Rules: SOURCE %s OF RULE IS NOT FOUND IN SOURCECLASS LISTING", (const char*)source_name));
                     return FALSE;
                  }
                  //ETG_TRACE_USR4(("    Allow Source: %s", (const char*)attribute));
                  tU16 ruleValue = index_targetSrc;
                  m_source_class[index_ruleOwner].Rules.push_back(ruleValue);
               }
            }
         }
         //***************
         // DENY RULES
         //***************
         if(xmlStrEqual(ruleNode->name,(const xmlChar *)"deny" ))
         {
            //VVD lint fix
       xmlChar* str_source_name     = xmlGetProp(ruleNode, (const xmlChar *)"source");
            //Find the source
            sourceClassID classID = 0;
            if(!Ruleset_GetSourceClassID(classID,(const char*)str_source_name))
            {
               ETG_TRACE_ERR(("COULD NOT ASSIGN RULE BECAUSE TARGET SOURCE %s NOT FOUND", (const char*)str_source_name));
               return FALSE;
            }
            sourceRule ruleValue = RuleQualifier::Apply(classID, RuleQualifier::NOT_SRC);
            m_source_class[index_ruleOwner].Rules.push_back(ruleValue);
            //ETG_TRACE_USR4(("    Deny Source: ID %d, Name %s", classID, str_source_name));
         }
         //***************
         // SPECIAL RULES
         //***************
         if(xmlStrEqual(ruleNode->name,(const xmlChar *)"allow_all" ))
         {
            //TODO see above, use class for rule
            //This is according SRC_ALL define in clStackRules.h
            //ETG_TRACE_USR4(("    Allow All"));
            sourceRule ruleValue = RuleQualifier::Apply(GetInvalidSourceClass(),RuleQualifier::ALL_SOURCES);
            m_source_class[index_ruleOwner].Rules.push_back(ruleValue);
         }
      }
   }
   return TRUE;
}

tBool clFactory_AudioSourceClass::Ruleset_LoadSource_Actions(xmlNode * actionsGroupNode)
{
   if(actionsGroupNode->parent==NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_Actions: NO PARENT NODE"));
      return FALSE;
   }

   xmlChar* source_name = xmlGetProp(actionsGroupNode->parent, (const xmlChar *)"name");
   if(source_name == NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_Actions: PARENT NODE HAS NO NAME ATTRIBUTE"));
      return FALSE;
   }

   tU8 index_ruleOwner = 0;
   if(!Ruleset_GetSourceClassID(index_ruleOwner,(const char*)source_name))
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_Actions: COULD NOT ASSIGN RULES TO SOURCE %s. IT IS NO FOUND IN SOURCECLASS LISTING"
            , (const char*)source_name));
      return FALSE;
   }
   //ETG_TRACE_USR4(("LOAD ACTIONS for SourceClass ID: %d, Name %s", index_ruleOwner, source_name));

   for (xmlNode *ruleNode = actionsGroupNode->children; ruleNode; ruleNode = ruleNode->next)
   {
      if(ruleNode->type == XML_ELEMENT_NODE)
      {
         //***************
         // PUSH ACTIONS
         //***************
         if(xmlStrEqual(ruleNode->name,(const xmlChar *)"push" ))
         {
            //TODO Clean this if/else/if... -> make it more readable ;)
            xmlChar* action        = xmlGetProp(ruleNode, (const xmlChar *)"action");
            xmlChar* action_source = xmlGetProp(ruleNode, (const xmlChar *)"source");
            if(action != NULL)
            {
               if(action_source == NULL)
               {
                  ETG_TRACE_ERR(("Push Action:%s: MISSING SOURCE ATTRIBUTE", (const char*)action));
                  return FALSE;
               }
               tU8 srcClassId = 0;
               Ruleset_GetSourceClassID(srcClassId,(const char*)action_source);
               //ETG_TRACE_USR2(("    Add Push Action:%10s Source:%s", (const char*)action, (const char*)action_source));
               if(strcmp((const char*)action, "abort")==0)
               {
                 m_source_class[index_ruleOwner].PushActions.push_back(static_cast<clSourceClass::actions_t>(clSourceClass::action_abort | srcClassId));
               }
               if(strcmp((const char*)action, "wait_off")==0)
               {
                 m_source_class[index_ruleOwner].PushActions.push_back(static_cast<clSourceClass::actions_t>(clSourceClass::action_waitFor| srcClassId));
               }
               if(strcmp((const char*)action, "pause")==0)
               {
                 m_source_class[index_ruleOwner].PushActions.push_back(static_cast<clSourceClass::actions_t>(clSourceClass::action_pause| srcClassId));
               }

            }else{
               ETG_TRACE_ERR(("Push : MISSING ACTION ATTRIBUTE"));
               return FALSE;
            }
         }
         //***************
         // POP RULES
         //***************
         if(xmlStrEqual(ruleNode->name,(const xmlChar *)"pop" ))
         {
            //TODO Clean this if/else/if... -> make it more readable ;)
            xmlChar* action        = xmlGetProp(ruleNode, (const xmlChar *)"action");
            xmlChar* action_source = xmlGetProp(ruleNode, (const xmlChar *)"source");
            if(action != NULL)
            {
               if(action_source == NULL)
               {
                  ETG_TRACE_ERR(("Pop Action:%s: MISSING SOURCE ATTRIBUTE", (const char*)action));
                  return FALSE;
               }
               tU8 srcClassId = 0;
               Ruleset_GetSourceClassID(srcClassId,(const char*)action_source);
               //ETG_TRACE_USR2(("    Add Pop Action:%10s Source:%s", (const char*)action, (const char*)action_source));
               if(strcmp((const char*)action, "abort")==0)
               {
                  m_source_class[index_ruleOwner].PopActions.push_back(static_cast<clSourceClass::actions_t>(clSourceClass::action_abort | srcClassId));
               }
               if(strcmp((const char*)action, "wait_off")==0)
               {
                  m_source_class[index_ruleOwner].PopActions.push_back(static_cast<clSourceClass::actions_t>(clSourceClass::action_waitFor| srcClassId));
               }
               if(strcmp((const char*)action, "restart")==0)
               {
                  m_source_class[index_ruleOwner].PopActions.push_back(static_cast<clSourceClass::actions_t>(clSourceClass::action_restart| srcClassId));
               }

            }else{
               ETG_TRACE_ERR(("Push : MISSING ACTION ATTRIBUTE"));
               return FALSE;
            }
         }
      }
   }
   return TRUE;
}


tBool clFactory_AudioSourceClass::Ruleset_LoadSource_AllowedSinks(xmlNode * sinkGroupNode)
{
   if(sinkGroupNode->parent==NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_AllowedSinks: NO PARENT NODE"));
      return FALSE;
   }

   xmlChar* source_name = xmlGetProp(sinkGroupNode->parent, (const xmlChar *)"name");
   if(source_name == NULL)
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_AllowedSinks: PARENT NODE HAS NO NAME ATTRIBUTE"));
      return FALSE;
   }

   tU8 index_sinkOwner = 0;
   if(!Ruleset_GetSourceClassID(index_sinkOwner,(const char*)source_name))
   {
      ETG_TRACE_ERR(("Ruleset_LoadSource_Actions: COULD NOT ASSIGN SINKS TO SOURCE %s. IT IS NOT FOUND IN SOURCECLASS LISTING"
            , (const char*)source_name));
      return FALSE;
   }


   //ETG_TRACE_USR4(("NOW LOAD ALLOWED SINKS for SourceClass ID: %d, Name %s", index_sinkOwner, source_name));
   //this is the default if it is not set
   m_source_class[index_sinkOwner].defaultSink = 1;

   for (xmlNode *ruleNode = sinkGroupNode->children; ruleNode; ruleNode = ruleNode->next)
   {
      if(ruleNode->type == XML_ELEMENT_NODE)
      {
         //***************
         // default sink
         //***************
         if(xmlStrEqual(ruleNode->name,(const xmlChar *)"default" ))
         {
            xmlChar* id = xmlGetProp(ruleNode, (const xmlChar *)"id");
            if(id != NULL)
            {
               //read the number
               int defSinkID = atoi((const char*)id);
               //ETG_TRACE_USR4(("default sink %d",defSinkID));

               //set default Sink
               m_source_class[index_sinkOwner].defaultSink = (tU16)defSinkID;
            }
         }
         //***************
         // sink
         //***************
         else if(xmlStrEqual(ruleNode->name,(const xmlChar *)"sink" ))
         {
            xmlChar* id = xmlGetProp(ruleNode, (const xmlChar *)"id");

            if(id != NULL)
            {
               if(strcmp((const char*)id, "all")==0)
               {
                 // ETG_TRACE_USR4(("allowed for all sinks"));
                  m_source_class[index_sinkOwner].Sinks.push_back(0xFF);
               }
               else
               {
                  //read the number
                  int sinkID = atoi((const char*)id);
                  //ETG_TRACE_USR4(("allowed for sink %d",sinkID));

                  //put them in Sourceclass Sinks
                  m_source_class[index_sinkOwner].Sinks.push_back((tU16)sinkID);
                  //ToDo: handle also a default sink
               }
            }
            else
            {
               ETG_TRACE_ERR(("Push : MISSING id ATTRIBUTE"));
               return FALSE;
            }
         }

      }
   }
   return TRUE;
}


tBool clFactory_AudioSourceClass::Ruleset_GetSourceClassID(sourceClassID &id, const char * sourceClassName)
{
   std::vector<clSourceClass>::iterator it;
   it=std::find(m_source_class.begin(),
         m_source_class.end(),(const char*)sourceClassName);
   //it=std::find(m_source_types.begin(), m_source_types.end(),std::string((const char*)type));
   if(it == m_source_class.end())
   {
      ETG_TRACE_ERR(("COULD NOT GET ID OF SOURCECLASS %s (Not in List)", (const char*)sourceClassName));
               return FALSE;
   }
   id = static_cast<sourceClassID>(it - m_source_class.begin());
   return TRUE;
}

tBool clFactory_AudioSourceClass::Ruleset_LoadSources(xmlNode * a_node)
{
   //clear source list
   m_source_class.clear();
   m_default_sourceClassId = GetInvalidSourceClass();
   //initialize invalid source
   clSourceClass srcClass(clFactory_AudioSourceClass::GetInvalidSourceClass(),"INVALID");
   m_source_class.push_back(srcClass);

   xmlNode *cur_node = NULL;
   //xmlNodePtr Node = NULL;
   for (cur_node = a_node; cur_node; cur_node = cur_node->next)
   {
      if (cur_node->type == XML_ELEMENT_NODE)
      {
        // ETG_TRACE_USR4(("source node name %s",cur_node->name));
         if(xmlStrEqual(cur_node->name,(const xmlChar *)"source" ))
         {
            //This will load the source line, e.g.
            //<source name="TUNER_FM" type="entertain" group="tuner"registration="static"  cca_value="1" default="true" >
            if(!Ruleset_LoadSource(cur_node))
            {
               ETG_TRACE_ERR(("LOADING SOURCECLASSES FAILED"));
               return FALSE;
            }
         }
      }
   }
   // load sinks
   for (cur_node = a_node; cur_node; cur_node = cur_node->next)
   {
      if (cur_node->type == XML_ELEMENT_NODE)
      {
         //ETG_TRACE_USR4(("sinks: node name %s",cur_node->name));
         // could have several sets. sinks could be named as ruleset
         if(xmlStrEqual(cur_node->name,(const xmlChar *)"sinks" ))
         {
            if(!Ruleset_LoadSource_SinkRuleAndAction(cur_node))
            {
               ETG_TRACE_ERR(("LOADING RULES FAILED"));
               return FALSE;
            }
         }
      }
   }

#if 1
   ETG_TRACE_USR4(("LOADING SOURCECLASSES COMPLETE"));
   for (cur_node = a_node; cur_node; cur_node = cur_node->next)
   {
      if (cur_node->type == XML_ELEMENT_NODE)
      {
         //ETG_TRACE_USR4(("???: node name %s",cur_node->name));
         if(xmlStrEqual(cur_node->name,(const xmlChar *)"source" ))
         {
            if(!Ruleset_LoadSource_RuleAndAction(cur_node))
            {
               ETG_TRACE_ERR(("LOADING RULES FAILED"));
               return FALSE;
            }
         }
      }
   }
#endif
   ETG_TRACE_USR4(("LOADING RULES COMPLETE"));
   return TRUE;
}

tVoid clFactory_AudioSourceClass::SetRulesetFile(const char *filename)
{
   m_configFile = std::string(filename);
}

/*
 * Function to check if External MCAN Bose Amplifier is connected
 * Reads KDS parameter to check if BOSE amplifier is connected
 */
bool clFactory_AudioSourceClass::bIsMCanBoseAmplifierConnected()
{
  ETG_TRACE_USR4(("clFactory_AudioSourceClass::bMCanBoseAmplifierConnected"));


  //read item from the KDS key's bytes- stream
 #if defined(VARIANT_S_FTR_ENABLE_CONTROLLERPLUGIN_RN_AIVI)
  tU8 u8Amplifier = 0;
  if ((DP_S32_NO_ERR == DP_s32GetConfigItem("SystemConfiguration1", "OutputInformation",&u8Amplifier, 1)))
  {
    ETG_TRACE_USR4(("bMCanBoseAmplifierConnected,Amplifier value  : %d", u8Amplifier));

    switch (u8Amplifier) {
    case EXTERNALAMP_BOSE2CH_MCAN:
    case EXTERNALAMP_BOSE_5_1CH_MCAN:
      return true;
    default:
      break;
    }
  } else {
    ETG_TRACE_ERR(("Error in diagnosis read "));
    return false;
  }
#endif
  return false;
}

tBool clFactory_AudioSourceClass::Ruleset_Load()
{
   /*
    check if MCAN Bose Amplifier is connected by reading KDS data then source priority
    for specific to MCAN  Amplifier should be loaded on start up
   */
   if(true == bIsMCanBoseAmplifierConnected())
   {
     ETG_TRACE_USR1(("MCAN BOSE Amplifier connected, Loading : %s",m_configBoseFile.c_str()));
     return Ruleset_Load(m_configBoseFile,1);
   }

   return Ruleset_Load(m_configFile,1); // for sink 1 just same as before

#if 0 //daw2hi first trial to load additional xml for additional sinks
   //Search for all source_priorities with source_priorities_sink*.xml
   const char *filename = m_configFile.c_str();

   const char ending[] = ".xml";

   int posInsert = strlen(filename) -4;

   std::string xmlFile = m_configFile;
   int i;
   for(i=2;i<10;i++)
   {
      std::string sink("_sink");
      //char* cSinkNr = itoa(i);
      char buf[10];
      memset(buf,0,sizeof(buf));
      sprintf(buf,"%d",i);
      std::string cSinkNr = std::string(buf);
      //std::string xml("_xml");

      std::string sink_insert = sink + std::string(cSinkNr);

      xmlFile.insert(posInsert,sink_insert);
      Ruleset_Load(xmlFile, i);
   }
#endif
}

tBool clFactory_AudioSourceClass::Ruleset_Load(std::string xmlFile, int sinkNr)
{
   //const char *filename = m_configFile.c_str();
   const char *filename = xmlFile.c_str();
   timeval  time_start;
   timeval  time_end;
   clock_t clock_start;
   clock_t clock_end;

   gettimeofday(&time_start,0);
   clock_start = clock();

   LIBXML_TEST_VERSION

   ETG_TRACE_USR2(("Ruleset_Load: Try to parse %s", filename));
   xmlDocPtr doc; /* the resulting document tree */
   xmlNode *root_element = NULL;
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
   XMLKeeper xmlKeeper;
   xmlKeeper.init();
   doc = xmlReadMemory(
         xmlKeeper.XMLSrcPrioCollection[m_configFile.c_str()].c_str()
         , strlen(xmlKeeper.XMLSrcPrioCollection[m_configFile.c_str()].c_str())
         , "source_priorities.xml"
         , NULL
         , 0);
#else
   doc = xmlReadFile(filename, NULL, 0);
#endif
   if (doc == NULL) {
      ETG_TRACE_ERR(("Ruleset_Load: FAILED TO PARSE %s", filename));
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      //ETG_TRACE_ERR(("XML Content: %s", xmlKeeper.XMLSrcPrioCollection[m_configFile].c_str()));
#endif
      xmlCleanupParser();
      xmlMemoryDump();
      return FALSE;
   }
   /*Get the root element node */
   root_element = xmlDocGetRootElement(doc);
   ETG_TRACE_USR4(("Ruleset_Parse: Parsing successful"));
   if(root_element == NULL)
   {
      ETG_TRACE_ERR(("COULD NOT FIND ROOT ELEMENT IN %s", filename));
      xmlFreeDoc(doc);
      xmlCleanupParser();
      xmlMemoryDump();
      return FALSE;
   }

   if(sinkNr == 1) // this should be done only for sink 1
   {
      ETG_TRACE_USR4(("Ruleset_Load: Delete old Ruleset (only for Sink 1"));
      m_source_groups.clear();
      m_source_types.clear();
      m_source_class.clear();

      m_sinks.clear();
   }

   xmlNode * a_node  = root_element->children;
   xmlNode *cur_node = NULL;

   if(sinkNr == 1) // this should be done only for sink 1
   {
      for (cur_node = a_node; cur_node != NULL; cur_node = cur_node->next) {
         if (cur_node->type == XML_ELEMENT_NODE) {

            if(xmlStrEqual(cur_node->name,(const xmlChar *)"types" ))
            {

               if(!Ruleset_LoadTypes(cur_node->children))
               {
                  ETG_TRACE_ERR(("LOAD TYPES FAILED"));
                  return FALSE;
               }
               break; //daw2hi: 24.08.2016 no need to continue
            }
         }
      }

   //by default 'AllowSrcAlreadyonStack' is true (accept src request even if src already on stack)
   m_source_settings.AllowSrcAlreadyonStack = true;
   //by default 'BackGroundSourceExchange' is true
   m_source_settings.BackGroundSourceExchange = true;


   for (cur_node = a_node; cur_node != NULL; cur_node = cur_node->next) {
      if (cur_node->type == XML_ELEMENT_NODE) {

         if(xmlStrEqual(cur_node->name,(const xmlChar *)"settings" ))
         {
            if(!Ruleset_LoadSettings(cur_node->children))
            {
               ETG_TRACE_ERR(("LOAD SETTINGS FAILED"));
               //by default 'AllowSrcAlreadyonStack' is true (accept src request even if src already on stack)
               m_source_settings.AllowSrcAlreadyonStack = true;
                        /*
                * by default 'BackGroundSourceExchange' is true
                 * if source which is removed is in pause state then new source will also be in pause state)
                 * Ex : Precondition : MUTE_ENT(ON)
                 *                        ------------
                 *                        MEDIA_PLAYER(PAUSE)
                 *      Operation    : If USB source is removed, then MediaPlayer will be replaced by last/default source
                 *      Result       : MUTE_ENT(ON)
                 *                         ------------
                 *                         FM(PAUSE)
                */

               m_source_settings.BackGroundSourceExchange = true;

            }
         }
      }
   }

      for (cur_node = a_node; cur_node != NULL; cur_node = cur_node->next) {
         if (cur_node->type == XML_ELEMENT_NODE) {

            if(xmlStrEqual(cur_node->name,(const xmlChar *)"groups" ))
            {
               if(!Ruleset_LoadGroups(cur_node->children))
               {
                  ETG_TRACE_ERR(("LOAD GROUPS FAILED"));
                  return FALSE;
               }
               break; //daw2hi: 24.08.2016 no need to continue
            }
         }
      }

      //ToDo: Try to handle also old xml where no sinks are defined -> set sink1 as present.
      tBool bSinksFound = false;
      for (cur_node = a_node; cur_node != NULL; cur_node = cur_node->next) {
         if (cur_node->type == XML_ELEMENT_NODE) {

            if(xmlStrEqual(cur_node->name,(const xmlChar *)"sinks" ))
            {
               bSinksFound = true;
               if(!Ruleset_LoadSinks(cur_node->children))
               {
                  ETG_TRACE_ERR(("LOAD SINKS FAILED"));
                  return FALSE;
               }
               break; //daw2hi: 24.08.2016 no need to continue
            }
         }
      }
      if(bSinksFound==false)
      {
         //no sinks found, assume old xml, set default sink 1
         m_sinks.push_back(1);
      }
   }  // if(sinkNr == 1)

   // this is for all additional xml files (currently not used). Each additional xml should give own rules for a source e.g. FM rules for sink1, other rules for sink2,
   // but it should no more contain groups types and sinks.
   for (cur_node = a_node; cur_node != NULL; cur_node = cur_node->next) {
      if (cur_node->type == XML_ELEMENT_NODE) {

         if(xmlStrEqual(cur_node->name,(const xmlChar *)"sources" ))
         {
            if(!Ruleset_LoadSources(cur_node->children))
            {
               ETG_TRACE_ERR(("LOAD SOURCES FAILED"));
               return FALSE;
            }
         }
      }
   }
   xmlFreeDoc(doc);
   xmlCleanupParser();
   xmlMemoryDump();
   //TODO validate loaded rules
   if( m_default_sourceClassId == GetInvalidSourceClass())
   {
      ETG_TRACE_ERR(("Ruleset_Load: VALIDATION ERROR: MISSING DEFAULT SOURCE CLASS"));
      m_source_groups.clear();
      m_source_types.clear();
      m_source_class.clear();
      m_default_sourceClassId = GetInvalidSourceClass();
      return FALSE;
   }
   clock_end = clock();
   gettimeofday(&time_end,0);
   m_timeXmlLoad_cpuTime = (clock_end - clock_start)/ (CLOCKS_PER_SEC/1000);
   ETG_TRACE_USR2(("XML Load timing: Time Overall Start: %ds %dms End: %ds %dms"
         , time_start.tv_sec
         , time_start.tv_usec
         , time_end.tv_sec
         , time_end.tv_usec
   ));

   m_timeXmlLoad_overallTime = (time_end.tv_sec - time_start.tv_sec)*1000 +(( time_end.tv_usec - time_start.tv_usec) / 1000);
   ETG_TRACE_USR4(("XML Load timing: CPU %dms Overall %dms"
         , m_timeXmlLoad_cpuTime
         , m_timeXmlLoad_overallTime));
   return TRUE;
}

tVoid clFactory_AudioSourceClass::Ruleset_Parse_Print(xmlNode * a_node, int depth)
{
   xmlNode *cur_node = NULL;
   //xmlNodePtr Node = NULL;


   if(a_node != NULL)
   {
      depth += 2;
   }

   std::string output(depth,' ');

   for (cur_node = a_node; cur_node; cur_node = cur_node->next) {

      if (cur_node->type == XML_ELEMENT_NODE) {
         //Print Element name
         output.append((const char*)cur_node->name);
         output.append(" ");
         //ETG_TRACE_ERR(("Element %s", (const char*)cur_node->name));
         //Iterate through all attributes of the Element
         for(xmlAttrPtr attr = cur_node->properties; NULL != attr; attr = attr->next)
         {
            //add attribute name
            output.append((const char*)attr->name);
            //ETG_TRACE_ERR(("Attr Name: %s",(const char*)attr->name));
            output.append(": ");
            //add attribute value
            output.append((const char*)xmlNodeListGetString(cur_node->doc, attr->children, 1));
            output.append(" ");
            //ETG_TRACE_ERR(("Attr Value: %s",(const char*)xmlNodeListGetString(cur_node->doc, attr->children, 1)));
         }
         ETG_TRACE_ERR(("%s", output.c_str()));
         output.clear();
         output.assign(depth, ' ');
      }
      Ruleset_Parse_Print(cur_node->children, depth);
   }
}

tVoid clFactory_AudioSourceClass::Ruleset_Parse() {
   const char *filename = m_configFile.c_str();
   ETG_TRACE_ERR(("Ruleset_Parse: Try to parse %s", filename));
   xmlDocPtr doc; /* the resulting document tree */
   xmlNode *root_element = NULL;
   doc = xmlReadFile(filename, NULL, 0);
   if (doc == NULL) {
      ETG_TRACE_ERR(("Failed to parse %s", filename));
      return;
   }
   /*Get the root element node */
   root_element = xmlDocGetRootElement(doc);
   Ruleset_Parse_Print(root_element,0);
   xmlFreeDoc(doc);
}

}}//namespace
