/*
 * @file aud_diag_defset_adaptor_IF.h
 * This file provides the declaration of the classes which handle asynchronous communication with dbus.
 * If asynchronous communication is required, then libdbus requires you to implement dbus_watch and dbus_timer
 *  Created on: Mar 9, 2016
 *
 * @author rjk2kor
 *
 * \copyright RBEI
 */


#ifndef DIAGDEFSET_AUD_DIAG_DEFSET_ADAPTOR_IF_IF_H_
#define DIAGDEFSET_AUD_DIAG_DEFSET_ADAPTOR_IF_IF_H_

#include <dbus/dbus.h>
#include "aud_diag_defset_adaptor_IF_types.h"
#include <map>


class aud_dbus_error
{
private:
  bool bSend;
  DBusConnection* pConnection;
  DBusMessage* pMethodCall;
private:
  //Explicit Privates
  aud_dbus_error();
  aud_dbus_error(const aud_dbus_error&);
public:
  std::string sErrorName;
  std::string sErrorMessage;

  aud_dbus_error(DBusConnection* x, DBusMessage* y)
  :bSend(true)
    ,pConnection(x)
  ,pMethodCall(y)
    ,sErrorName(DBUS_ERROR_FAILED)
    ,sErrorMessage("Failed")
  {
  }
  ~aud_dbus_error()
  {
    if(pConnection && pMethodCall && bSend)
    {
      dbus_uint32_t serial = dbus_message_get_serial(pMethodCall);
      DBusMessage* pErr = dbus_message_new_error(pMethodCall,sErrorName.c_str(),sErrorMessage.c_str());
    if(pErr)
    {
     (void)dbus_connection_send(pConnection,pErr,&serial);
     dbus_message_unref(pErr);
    }
    }
  }
  void disable()
  {
    bSend = false;
  }
};

class aud_diag_defset_adaptor_IF;

typedef void (aud_diag_defset_adaptor_IF::*aud_dbus_DispatchFunc)(DBusMessage*);
/**
 * This class is the interface class, which provides easy to use interfaces to implement the diag defset sequence
 */
//class aud_diag_defset_adaptor_IF:public aud_dbus_msg_dispatch_func
class aud_diag_defset_adaptor_IF
{
private:
  //Explicit privates
  aud_diag_defset_adaptor_IF();
  aud_diag_defset_adaptor_IF(const aud_diag_defset_adaptor_IF&);

public:
  ///Constructor
  aud_diag_defset_adaptor_IF(DBusConnection*);
  ///Destructor
  virtual ~aud_diag_defset_adaptor_IF();
  //Function to be called to acknowledge systemsetting
  void vAckPrepareSystemSetting();

private:
  //Validation functions
  bool bValidateMethodCall(DBusMessage* pmsg,const char* signature);

  ///Helper function to Extract data from the DBusMessage and fill into the parameters
  bool bUnMarshallDefsetData ( DBusMessage* pmsg,
                   std::string& rfsyssetid,
                 std::string& rfsyssettype,
                 std::vector<defset_ext_data>& rfextdatalist,
                 uint32_t& rfU32cookie);

  ///Helper function to Marshal the data from the parameters and add to DBusMessage pointer provided
  bool bMarshallDefsetData   (DBusMessage* pmsg,
                  std::string& rfsyssetid,
                 std::string& rfsyssettype,
                 std::vector<defset_ext_data>& rfextdatalist,
                 uint32_t& rfu32ReturnCode,
                 uint32_t& rfU32cookie);

  ///Processor functions
  void _vOnPrepareSystemSetting(DBusMessage* pMsg);
  void _vOnExecuteSystemSetting(DBusMessage* pMsg);
  void _vOnFinalizeSystemSetting(DBusMessage* pMsg);

  static DBusHandlerResult eDispatchMsg(DBusConnection *conn, DBusMessage *msg, void *ptrx);

protected:
  ///Interface functions to be overridden by users
  virtual uint32_t u32OnPrepareSystemSetting(std::string& rfSysSetId, std::string& rfSyssetType) = 0;//Function should return the result of the operation
  virtual uint32_t u32OnExecuteSystemSetting(std::string& rfSysSetId, std::string& rfSyssetType) = 0;//Function should return the result of the operation
  virtual uint32_t u32OnFinalizeSystemSetting(std::string& rfSysSetId, std::string& rfSyssetType)= 0;//Function should return the result of the operation
private:
  ///Members
  DBusConnection* m_ptrconnection;
  std::map<std::string,aud_dbus_DispatchFunc> m_dispatchtable;
};



#endif /* DIAGDEFSET_AUD_DIAG_DEFSET_ADAPTOR_IF_IF_H_ */
