
#if !defined(AUDIOMANAGERTYPES_H)
#define AUDIOMANAGERTYPES_H

#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
#include "mock_audiomanagertypes.h"
#else
#include "audiomanager/audiomanagertypes.h"
#endif

using namespace am;

namespace am
{
/**
 * This type gives the information about reason for reason for Source/Sink change
*/

/** the availability changed because of no media content */
static const am_CustomAvailabilityReason_t AR_GENIVI_MEDIA_NOCONTENT = 7;
/** the availability changed because of over current */
static const am_CustomAvailabilityReason_t AR_GENIVI_OVER_CURRENT = 8;
/** the availability changed because of internal disconnect */
static const am_CustomAvailabilityReason_t AR_GENIVI_INTERNAL_DISCONNECT = 9;
/** the availability MAX */
static const am_CustomAvailabilityReason_t AR_MAX = 10;


/**
 * Here are all SoundProperties that can be set via the CommandInterface.
 * This type is product specific and can be changed or extended.
 */
typedef uint16_t am_CustomMainSoundPropertyType_t;

/** Bass setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_BASS = 1;
/** Bass setting with relative steps. Modifies property MSP_SOUND_BASS */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_BASS_RELATIVE = 2;
/** Middle setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_MIDDLE = 3;
/** Middle setting with relative steps. Modifies property MSP_SOUND_MIDDLE */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_MIDDLE_RELATIVE = 4;
/** Treble setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_TREBLE = 5;
/** Treble setting with relative steps. Modifies property MSP_SOUND_TREBLE */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_TREBLE_RELATIVE = 6;
/** Loudness setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_LOUDNESS = 7;
/** Loudness setting with relative steps. Modifies property MSP_SOUND_LOUDNESS */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_LOUDNESS_RELATIVE = 8;
/** Balance setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_BALANCE = 9;
/** Balance setting with relative steps. Modifies property MSP_SOUND_BALANCE */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_BALANCE_RELATIVE = 10;
/** Fader setting to absolute value */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_FADER = 11;
/** Fader setting with relative steps. Modifies property MSP_SOUND_FADER */
static const am_CustomMainSoundPropertyType_t MSP_SOUND_FADER_RELATIVE = 12;
/** Dynamic compression. Possible values defined as AM_MSP_DYN_COMPRESSION_**/
static const am_CustomMainSoundPropertyType_t MSP_SOUND_DYN_COMPRESSION = 13;
/** Equalizer Presets. Possible values defined as AM_MSP_EQU_PRESET_*
 ** ADR3 configuration matches number to name in DpInit_PreMix.h,
 ** generated by ADR3_ParaConfig.xls **/
static const am_CustomMainSoundPropertyType_t MSP_EQUALIZER_PRESET = 14;
/** Speed dependent volume: Possible values defined as AM_MSP_SDV_ **/
static const am_CustomMainSoundPropertyType_t MSP_SPEED_DEPENDENT_VOLUME = 15;
/** Microphone connection status. Possible values defined as */
static const am_CustomMainSoundPropertyType_t MSP_MIC_STATUS_CONNECTION = 16;
/** Microphone level. Possible values defined as */
static const am_CustomMainSoundPropertyType_t MSP_MIC_STATUS_LEVEL = 17;
/** Sound optimization. Possible values defined as AM_MSP_SND_OPTI_ **/
static const am_CustomMainSoundPropertyType_t MSP_SOUND_OPTIMIZATION = 18;
/** Room effect. Possible values defined as AM_MSP_SND_ROOM_EFFECT_ **/
static const am_CustomMainSoundPropertyType_t MSP_SOUND_ROOM_EFFECT = 19;
/** Aux In level. Possible values defined as AM_MSP_LVL_AUX_IN_ **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_AUX_IN = 20;
/** Beep level. Possible values defined as AM_MSP_LVL_BEEP_ **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_BEEP = 21;
/** Center speaker level. Possible values defined as **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_CENTER = 22;
/** Subwoofer level. Possible values defined as **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_SUBWOOFER = 23;
/** Surround Setting. Possible values defined as **/
static const am_CustomMainSoundPropertyType_t MSP_SETTING_SURROUND = 24;
/** Audio Mode **/
static const am_CustomMainSoundPropertyType_t MSP_MODE_AUDIO = 25;
/** Volume for entertainment sources **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_ENTERTAINMENT = 26;
/** Volume for Phone source **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE = 27;
/** Volume for ONVOL **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_ONVOL = 28;
/** Volume for TA sources **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_TA = 29;
/** Volume for Beep tone **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_BEEP = 30;
/** PDC Attenuation level. Possible values defined as AM_MSP_PDC_ATTENUATION_ **/
static const am_CustomMainSoundPropertyType_t MSP_PDC_ATTENUATION_LEVEL = 31;
/** BTAudio In level. Possible values defined as AM_MSP_LVL_BTAUDIO_IN_ **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_BTAUDIO_IN = 32;
/** Gala Gain status **/
static const am_CustomMainSoundPropertyType_t MSP_GALA_GAIN = 33;
/** PDC status. Possible values defined as AM_MSP_PDC_COMMAND_ **/
static const am_CustomMainSoundPropertyType_t MSP_PDC_ACTIVE = 34;
/** Volume lock status **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_LOCK = 35;
/** System Mute status. Possible values defined as AM_MSP_SYSTEM_MUTE_ **/
static const am_CustomMainSoundPropertyType_t MSP_SYSTEM_MUTE = 36;
/** Volume for Navigation **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_NAVIGATION = 37;
/** Volume for SDS **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_SDS = 38;
/** Volume for Ringtone **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_RINGTONE = 39;
/** System Property for ACC Off/On **/
static const am_CustomMainSoundPropertyType_t MSP_AUDIO_OFF_MUTE = 40;
/** Sound Property to report the source for which the volume will be valid **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_SOURCE = 41;
/** Center speaker level with relative steps. Modifies property MSP_LEVEL_CENTER **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_CENTER_RELATIVE = 42;
/** SubWoofer level with relative steps. Modifies property MSP_LEVEL_SUBWOOFER **/
static const am_CustomMainSoundPropertyType_t MSP_LEVEL_SUBWOOFER_RELATIVE = 43;
/** Children sleep mode **/
static const am_CustomMainSoundPropertyType_t MSP_CHILDREN_SLEEP_MODE = 44;
/** FM Enhancer **/
static const am_CustomMainSoundPropertyType_t  MSP_FM_ENHANCER = 45;
/** ESE Sound Type **/
static const am_CustomMainSoundPropertyType_t  MSP_ESE_SOUND_TYPE = 46;
/** ESE Volume **/
static const am_CustomMainSoundPropertyType_t MSP_ESE_VOLUME = 47;
/** RSoundOnOff **/
static const am_CustomMainSoundPropertyType_t   MSP_R_SOUND_ON_OFF = 48;
/** RSoundSoundType **/
static const am_CustomMainSoundPropertyType_t   MSP_R_SOUND_SOUND_TYPE = 49;
/** RSoundSoundVolume **/
static const am_CustomMainSoundPropertyType_t   MSP_R_SOUND_VOLUME = 50;
/** Property for setting the audio mode in HMI based on Arkamys Library **/
static const am_CustomMainSoundPropertyType_t   MSP_ARKAMYS_AUDIO_MODE = 51;
/** This property can be used to set/get the user volume of UPA **/
static const am_CustomMainSoundPropertyType_t   MSP_ADAS_PARK_ASSISTANT_VOLUME = 52;
/** This property can be used to set/get the UPA Temporary Mute State **/
static const am_CustomMainSoundPropertyType_t   MSP_ADAS_UPA_MUTE = 53;
/** Property for setting the Geometry mode in HMI **/
static const am_CustomMainSoundPropertyType_t   MSP_GEOMETRY_MODE = 54;
/**  Property for setting the automatic gain control in HMI based on Arkamys Library **/
static const am_CustomMainSoundPropertyType_t MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL = 55;
/** Property that can be used to set/get the user volume of LDW/LKA **/
static const am_CustomMainSoundPropertyType_t   MSP_ADAS_LDW_USER_VOLUME = 56;
/** Property to update status of Amplifier Availability Function status **/
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAILABILITY_FUNCTION_STATUS = 57;
/** RSoundActivation **/
static const am_CustomMainSoundPropertyType_t MSP_R_SOUND_ACTIVATE = 58;
static const am_CustomMainSoundPropertyType_t MSP_ENTSTARTUPVOLUME=59;
static const am_CustomMainSoundPropertyType_t MSP_ENTSTARTUPVOLUME_RELATIVE=60;

/** MCAN BOSE Amplifier properties **/
static const am_CustomMainSoundPropertyType_t MSP_BOSE_AUDIO_PILOT=61;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_CENTER_POINT=62;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_SURROUND_VOLUME=63;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_DRIVER_AUDIO_STAGE=64;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_REARSEAT_AUDIO_STAGE=65;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_ANC_ASC_ACTIVETEST=66;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_ANC_SETTING=67;
static const am_CustomMainSoundPropertyType_t MSP_BOSE_ASC_SETTING=68;
/** SCENE Recorder Sound Notification **/
static const am_CustomMainSoundPropertyType_t MSP_SR_SOUND_NOTIFICATION=69;
static const am_CustomMainSoundPropertyType_t MSP_ESE_SETTING=70;
static const am_CustomMainSoundPropertyType_t MSP_AUDIO_PILOT_INTENSITY=71;
 /*Extension of ampavail */
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_BASS                = 72;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_MIDDLE              = 73;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_TREBLE              = 74;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_BALANCE             = 75;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_FADER               = 76;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_AUDIO_PILOT         = 77;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_GALA                = 78;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_SURROUNDMODE        = 79;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_SUBWOOFER           = 80;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_STAGING             = 81;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_ROOMEFFECT          = 82;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_LOUDNESS            = 83;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_AGC                 = 84;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_AMPDOWNMIX          = 85;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_SURROUND_VOLUME     = 86;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_DRIVER_AUDIO_STAGE  = 87;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_REARSEAT_AUDIO_STAGE= 88;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_ANC                 = 89;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_ASC                 = 90;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_SOUNDAMBIANCE       = 91;
static const am_CustomMainSoundPropertyType_t MSP_AMP_AVAIL_ESE                 = 92;
static const am_CustomMainSoundPropertyType_t MSP_ENTSTARTUPMINVOLUME           = 93;
static const am_CustomMainSoundPropertyType_t MSP_ENTSTARTUPMINVOLUME_RELATIVE  = 94;

static const am_CustomMainSoundPropertyType_t MSP_PRIVATE_MODE_MIX_VOLUME  = 95;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_SDS_BARGEIN  = 96;

/** Extension of Phone Volume for Phone1 to Phone10 sources **/
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_1 = 97;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_2 = 98;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_3 = 99;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_4 = 100;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_5 = 101;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_6 = 102;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_7 = 103;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_8 = 104;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_9 = 105;
static const am_CustomMainSoundPropertyType_t MSP_VOLUME_PHONE_10 = 106;
/** User Mute status **/
static const am_CustomMainSoundPropertyType_t   MSP_USER_MUTE_STATUS = 107;
static const am_CustomMainSoundPropertyType_t MSP_MAX = 108;


static const am_CustomMainSoundPropertyType_t MSP_AVB_MIC1_GAIN   = 0x4714; // 18196
static const am_CustomMainSoundPropertyType_t MSP_AVB_FILTER_FREQ = 0x4715; // 18197
static const am_CustomMainSoundPropertyType_t MSP_AVB_MIC_VOLUME  = 0x4716; // 18198

static const am_CustomMainSoundPropertyType_t MSP_AVB_MIX_TREBLE  = 0x4717; // 18199
static const am_CustomMainSoundPropertyType_t MSP_AVB_MIX_BASS    = 0x4718; // 18200


#define MSP_MIC1_GAIN_LEVEL_OFF 0
#define MSP_MIC1_GAIN_LEVEL_ON 20

#define MSP_GAIN_LEVEL_OFF 0
#define MSP_AVB_SOURCE_GAIN_LEVEL_ON 250	// -6dB

/*custom define for RAMP handling*/
static const am_CustomRampType_t RAMP_VERY_FAST=1;
static const am_CustomRampType_t RAMP_FAST=2;
static const am_CustomRampType_t RAMP_SLOW=3;
static const am_CustomRampType_t RAMP_MID=4;
static const am_CustomRampType_t RAMP_VERY_SLOW=5;
static const am_CustomRampType_t RAMP_MAX=6;


/* VVD MSP VALUES */
/**
 * Value for MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL
 * @author Vyankatesh VD
 * @created 17-Sep-2016
 */
#define MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_OFF  ((int16_t) 0)
#define MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_ON   ((int16_t) 1)

/* VVD MSP VALUES */
/**
 * Value for MSP_AUDIO_PILOT_INTENSITY
 * @author Swati N
 * @created 17-Feb-2018
 */
#define MSP_AUDIO_PILOT_INTENSITY_LOW      ((int16_t) 1)
#define MSP_AUDIO_PILOT_INTENSITY_MEDIUM   ((int16_t) 2)
#define MSP_AUDIO_PILOT_INTENSITY_HIGH     ((int16_t) 3)

/* VVD MSP_ESE_SETTING VALUES */
/**
 * Value for MSP_ESE_SETTING
 * @author Swati N
 * @created 16-Feb-2018
 */
#define MSP_ESE_SETTING_ON                 ((int16_t) 1)
#define MSP_ESE_SETTING_OFF                ((int16_t) 0)
/* VVD MSP_BOSE_ANC_SETTING VALUES */
/**
 * Value for MSP_BOSE_ANC_SETTING
 * @author Swati N
 * @created 16-Feb-2018
 */
#define MSP_BOSE_ANC_SETTING_ON                 ((int16_t) 1)
#define MSP_BOSE_ANC_SETTING_OFF                ((int16_t) 0)
/*
 * Values for System property 'SYP_ESE_DRIVE_MODE'
 */
#define AM_SYP_ESE_DRIVE_MODE_ECO      ((int16_t) 0)
#define AM_SYP_ESE_DRIVE_MODE_COMFORT    ((int16_t) 1)
#define AM_SYP_ESE_DRIVE_MODE_NORMAL    ((int16_t) 2)
#define AM_SYP_ESE_DRIVE_MODE_DYNAMIC    ((int16_t) 3)
#define AM_SYP_ESE_DRIVE_MODE_PERSO    ((int16_t) 4)

/*
 * Values for Sink property 'MSP_ESE_SOUND_TYPE'
 * Below values are defined only for RN-IVI project
 * which can vary for other projects
 */
#define AM_MSP_ESE_SOUND_TYPE_NEUTRAL      ((int16_t) 1)
#define AM_MSP_ESE_SOUND_TYPE_SOUND_1      ((int16_t) 2)
#define AM_MSP_ESE_SOUND_TYPE_SOUND_2      ((int16_t) 3)

/*
 * Values for Sink property 'MSP_ESE_SOUND_VOLUME'
 * Below values are defined only for RN-IVI project
 * which can vary for other projects
 */
#define AM_MSP_ESE_VOLUME_OFF      ((int16_t) 1)
#define AM_MSP_ESE_VOLUME_LOW      ((int16_t) 2)
#define AM_MSP_ESE_VOLUME_HIGH    ((int16_t) 3)

/*
 * Values for Sink property 'MSP_R_SOUND_ON_OFF'
 */
#define AM_MSP_R_SOUND_OFF      ((int16_t) 0)
#define AM_MSP_R_SOUND_ON          ((int16_t) 1)

/*
 * Values for Sink property 'MSP_R_SOUND_ACTIVATE'
 */
#define MSP_R_SOUND_ACTIVATE_OFF  ((int16_t) 0)
#define MSP_R_SOUND_ACTIVATE_ON    ((int16_t) 1)
/*
 * Values for Sink property 'MSP_R_SOUND_SOUND_TYPE'
 */
#define AM_MSP_R_SOUND_SOUND_TYPE_1      ((int16_t) 1)
#define AM_MSP_R_SOUND_SOUND_TYPE_2      ((int16_t) 2)
#define AM_MSP_R_SOUND_SOUND_TYPE_3      ((int16_t) 3)
#define AM_MSP_R_SOUND_SOUND_TYPE_4      ((int16_t) 4)
#define AM_MSP_R_SOUND_SOUND_TYPE_5      ((int16_t) 5)
#define AM_MSP_R_SOUND_SOUND_TYPE_6      ((int16_t) 6)

/*
 * Values for Sink property 'MSP_R_SOUND_VOLUME'
 */
#define MSP_R_SOUND_VOLUME_0    ((int16_t) 0)
#define MSP_R_SOUND_VOLUME_1    ((int16_t) 1)
#define MSP_R_SOUND_VOLUME_2    ((int16_t) 2)
#define MSP_R_SOUND_VOLUME_3    ((int16_t) 3)
#define MSP_R_SOUND_VOLUME_4    ((int16_t) 4)
#define MSP_R_SOUND_VOLUME_5    ((int16_t) 5)
#define MSP_R_SOUND_VOLUME_6    ((int16_t) 6)
#define MSP_R_SOUND_VOLUME_7    ((int16_t) 7)
#define MSP_R_SOUND_VOLUME_8    ((int16_t) 8)
#define MSP_R_SOUND_VOLUME_9    ((int16_t) 9)
#define MSP_R_SOUND_VOLUME_10    ((int16_t) 10)
#define MSP_R_SOUND_VOLUME_11    ((int16_t) 11)
#define MSP_R_SOUND_VOLUME_12    ((int16_t) 12)
#define MSP_R_SOUND_VOLUME_13    ((int16_t) 13)
#define MSP_R_SOUND_VOLUME_14    ((int16_t) 14)
#define MSP_R_SOUND_VOLUME_15    ((int16_t) 15)

/**
 * MSP_SOUND_DYN_COMPRESSION values
 */
#define AM_MSP_DYN_COMPRESSION_OFF  ((int16_t) 0)
#define AM_MSP_DYN_COMPRESSION_ON   ((int16_t) 1)


/**
 * MSP_EQUALIZER_PRESET values
 * ADR3 configuration matches number to name in DpInit_PreMix.h,
 * generated by ADR3_ParaConfig.xls
 */
#define AM_MSP_EQU_PRESET_0      ((int16_t) 0)
#define AM_MSP_EQU_PRESET_1      ((int16_t) 1)
#define AM_MSP_EQU_PRESET_2      ((int16_t) 2)
#define AM_MSP_EQU_PRESET_3      ((int16_t) 3)
#define AM_MSP_EQU_PRESET_4      ((int16_t) 4)
#define AM_MSP_EQU_PRESET_5      ((int16_t) 5)
#define AM_MSP_EQU_PRESET_NOT_DEF  ((int16_t) 255)
/**
 * MSP_SPEED_DEPENDENT_VOLUME values
 */
#define AM_MSP_SDV_OFF      ((int16_t) 0)
#define AM_MSP_SDV_LEVEL_1  ((int16_t) 1)
#define AM_MSP_SDV_LEVEL_2  ((int16_t) 2)
#define AM_MSP_SDV_LEVEL_3  ((int16_t) 3)
#define AM_MSP_SDV_LEVEL_4  ((int16_t) 4)
#define AM_MSP_SDV_LEVEL_5  ((int16_t) 5)
#define AM_MSP_SDV_LEVEL_6  ((int16_t) 6)
#define AM_MSP_SDV_LEVEL_7  ((int16_t) 7)
#define AM_MSP_SDV_NOT_DEF  ((int16_t) 255)

/**
 * MSP_MIC_STATUS_CONNECTION values
 */
/* Values yet to be defined */


/**
 * MSP_MIC_STATUS_LEVEL values
 */
/* Values yet to be defined */


/**
 * MSP_SOUND_OPTIMIZATION values
 */
#define AM_MSP_SND_OPTI_OFF      ((int16_t) 0)
#define AM_MSP_SND_OPTI_LEFT     ((int16_t) 1)
#define AM_MSP_SND_OPTI_RIGHT    ((int16_t) 2)
#define AM_MSP_SND_OPTI_ALL      ((int16_t) 3)
#define AM_MSP_SND_OPTI_DRIVER   ((int16_t) 4)
#define AM_MSP_SND_OPTI_FRONT    ((int16_t) 5)
#define AM_MSP_SND_OPTI_NOT_DEF  ((int16_t) 255)


/**
 * MSP_SOUND_ROOM_EFFECT values
 */
#define AM_MSP_SND_ROOM_EFFECT_LEVEL0  ((int16_t) 0)
#define AM_MSP_SND_ROOM_EFFECT_LEVEL1  ((int16_t) 1)
#define AM_MSP_SND_ROOM_EFFECT_LEVEL2  ((int16_t) 2)
#define AM_MSP_SND_ROOM_EFFECT_LEVEL3  ((int16_t) 3)
#define AM_MSP_SND_ROOM_EFFECT_LEVEL4  ((int16_t) 4)

/**
 * MSP_LEVEL_AUX_IN values
 */
#define AM_MSP_LVL_AUX_IN_LEVEL1      ((int16_t) 1)
#define AM_MSP_LVL_AUX_IN_LEVEL2      ((int16_t) 2)
#define AM_MSP_LVL_AUX_IN_LEVEL3      ((int16_t) 3)
#define AM_MSP_LVL_AUX_IN_LEVEL_NOT_DEF    ((int16_t) 255)
/**
* MSP_LEVEL_BEEP values
*/
#define AM_MSP_LVL_BEEP_LEVEL1      ((int16_t) 1)
#define AM_MSP_LVL_BEEP_LEVEL2      ((int16_t) 2)
#define AM_MSP_LVL_BEEP_LEVEL3      ((int16_t) 3)


/**
 * MSP_LEVEL_CENTER values
 */
/* Values yet to be defined */


/**
 * MSP_LEVEL_SUBWOOFER values
 */


/**
 * MSP_SETTING_SURROUND values
 */
/* Values yet to be defined */


/**
 * MSP_MODE_AUDIO values
 */
#define AM_MSP_MODE_AUDIO_NORMAL      ((int16_t) 0)
#define AM_MSP_MODE_AUDIO_LINEAR      ((int16_t) 1)

/**
 * MSP_PDC_ATTENUATION_LEVEL values
 */
#define AM_MSP_PDC_ATTENUATION_OFF       ((int16_t) 0)
#define AM_MSP_PDC_ATTENUATION_LIGHTER   ((int16_t) 1)
#define AM_MSP_PDC_ATTENUATION_LIGHT     ((int16_t) 2)
#define AM_MSP_PDC_ATTENUATION_MEDIUM    ((int16_t) 3)
#define AM_MSP_PDC_ATTENUATION_STRONG    ((int16_t) 4)
#define AM_MSP_PDC_ATTENUATION_STRONGER  ((int16_t) 5)
#define AM_MSP_PDC_ATTENUATION_MAX       ((int16_t) 6)

/**
 * MSP_LEVEL_BTAUDIO_IN values
 */
#define AM_MSP_LVL_BTAUDIO_IN_LEVEL1   ((int16_t) 0)
#define AM_MSP_LVL_BTAUDIO_IN_LEVEL2   ((int16_t) 1)
#define AM_MSP_LVL_BTAUDIO_IN_LEVEL3   ((int16_t) 2)

/**
 * MSP_PDC_ACTIVE values
 */
#define AM_MSP_PDC_COMMAND_START   ((int16_t) 1)
#define AM_MSP_PDC_COMMAND_STOP    ((int16_t) 2)
#define AM_MSP_PDC_COMMAND_BREAK   ((int16_t) 3)
#define AM_MSP_PDC_COMMAND_NOT_DEF ((int16_t) 255)


/**
 * MSP_SYSTEM_MUTE values
 */
#define AM_MSP_SYSTEM_MUTE_OFF  ((int16_t) 0)
#define AM_MSP_SYSTEM_MUTE_ON   ((int16_t) 1)

/**
MSP_CLILDREN_SLEEP_MODE
**/
#define MSP_CHILDREN_SLEEP_MODE_OFF  ((int16_t) 0)
#define MSP_CHILDREN_SLEEP_MODE_ON   ((int16_t) 1)

/**
 * MSP_AUDIO_OFF_MUTE values
 */
#define AM_MSP_AUDIO_OFF_MUTE_UNDEF  ((int16_t) -1)
#define AM_MSP_AUDIO_OFF_MUTE_OFF  ((int16_t) 0)
#define AM_MSP_AUDIO_OFF_MUTE_ON   ((int16_t) 1)

/**
 * MSP_USER_MUTE_STATUS values
 */
#define MSP_USER_MUTE_STATUS_OFF  ((int16_t) 0)
#define MSP_USER_MUTE_STATUS_ON   ((int16_t) 1)
/*
 * MSP_ARKAMYS_AUDIO_MODE values (Property for setting the audio mode in HMI based on Arkamys Library.)
 */
#define AM_MSP_ARKAMYS_AUDIO_MODE_BYPASS      ((int16_t) 1)
#define AM_MSP_ARKAMYS_AUDIO_MODE_CLASSIC      ((int16_t) 2)
#define AM_MSP_ARKAMYS_AUDIO_MODE_AUDITORIUM    ((int16_t) 3)
#define AM_MSP_ARKAMYS_AUDIO_MODE_PREMIUM_1    ((int16_t) 4)
#define AM_MSP_ARKAMYS_AUDIO_MODE_PREMIUM_2    ((int16_t) 5)
#define AM_MSP_ARKAMYS_AUDIO_MODE_NOT_DEF      ((int16_t) 255)

/*
 * Values for Sink property 'MSP_ADAS_PARK_ASSISTANT_VOLUME'
 */
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_NO_SOUND    ((int16_t) 0)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_1      ((int16_t) 1)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_2      ((int16_t) 2)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_3      ((int16_t) 3)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_4      ((int16_t) 4)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_5      ((int16_t) 5)
#define  MSP_ADAS_PARK_ASSISTANT_VOLUME_LEVEL_NOT_DEF   ((int16_t) 255)

/*
 * Values for Sink property 'MSP_ADAS_UPA_MUTE'
 */
#define  MSP_ADAS_UPA_MUTE_OFF      ((int16_t) 0)
#define  MSP_ADAS_UPA_MUTE_ON      ((int16_t) 1)
#define  MSP_ADAS_UPA_MUTE_NOT_DEF    ((int16_t) 255)

/*
 * Values for Sink property 'MSP_ADAS_LDW_USER_VOLUME'
 */
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_INVALID     ((int16_t) 0)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_1      ((int16_t) 1)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_2      ((int16_t) 2)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_3      ((int16_t) 3)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_4      ((int16_t) 4)
#define  MSP_ADAS_LDW_USER_VOLUME_LEVEL_5      ((int16_t) 5)

/*
 * Values for Sink property 'MSP_GEOMETRY_MODE'
 */
#define  AM_MSP_GEOMETRY_MODE_MANUAL      ((int16_t) 0)
#define  AM_MSP_GEOMETRY_MODE_CHILDREN_SLEEP    ((int16_t) 1)
#define  AM_MSP_GEOMETRY_MODE_ALL_CAR      ((int16_t) 2)
#define  AM_MSP_GEOMETRY_MODE_NOT_DEF      ((int16_t) 255)

/**
 * Value for MSP_FM_ENHANCER
 * @author Vyankatesh VD
 * @created 15-Dec-2015 04:44:00 pm
 */
#define AM_MSP_FM_ENHANCER_OFF  ((int16_t) 0)
#define AM_MSP_FM_ENHANCER_ON   ((int16_t) 1)
/**
 * Value for MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL
 * @author Vyankatesh VD
 * @created 17-Sep-2016
 */
#define MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_OFF  ((int16_t) 0)
#define MSP_ARKAMYS_AUTOMATIC_GAIN_CONTROL_ON   ((int16_t) 1)

/*
 * Values for property MSP_BOSE_AUDIO_PILOT
 */
#define MSP_BOSE_AUDIO_PILOT_OFF  ((int16_t) 0)
#define MSP_BOSE_AUDIO_PILOT_ON    ((int16_t) 1)

/*
 * Values for property MSP_BOSE_ANC_ASC_ACTIVETEST
 */
#define MSP_BOSE_ANC_ASC_ACTIVETEST_OFF  ((int16_t) 0)
#define MSP_BOSE_ANC_ASC_ACTIVETEST_ON    ((int16_t) 1)

/*
 * Values for property MSP_BOSE_ANC_ASC_SETTING
 */
#define MSP_BOSE_ANC_ASC_SETTING_UNAVAILABLE  ((int16_t) 15)
#define MSP_BOSE_ANC_ASC_SETTING_ENABLE    ((int16_t) 1)
#define MSP_BOSE_ANC_ASC_SETTING_DISABLE    ((int16_t) 0)

/*
 * Values for property MSP_BOSE_CENTER_POINT
 */
#define MSP_BOSE_CENTER_POINT_OFF  ((int16_t) 0)
#define MSP_BOSE_CENTER_POINT_ON  ((int16_t) 1)

/*
 * Values for property MSP_BOSE_SURROUND_VOLUME
 */
#define MSP_BOSE_SURROUND_VOLUME_1  ((int16_t) 1)
#define MSP_BOSE_SURROUND_VOLUME_2  ((int16_t) 2)
#define MSP_BOSE_SURROUND_VOLUME_3  ((int16_t) 3)
#define MSP_BOSE_SURROUND_VOLUME_4  ((int16_t) 4)
#define MSP_BOSE_SURROUND_VOLUME_5  ((int16_t) 5)
#define MSP_BOSE_SURROUND_VOLUME_6  ((int16_t) 6)

/*
 * Values for property MSP_BOSE_DRIVER_AUDIO_STAGE
 */
#define MSP_BOSE_DRIVER_AUDIO_STAGE_OFF  ((int16_t) 0)
#define MSP_BOSE_DRIVER_AUDIO_STAGE_ON  ((int16_t) 1)

/*
 * Values for property MSP_BOSE_REARSEAT_AUDIO_STAGE
 */
#define MSP_BOSE_REARSEAT_AUDIO_STAGE_OFF  ((int16_t) 0)
#define MSP_BOSE_REARSEAT_AUDIO_STAGE_ON  ((int16_t) 1)

/*
 * Values for property MSP_SR_SOUND_NOTIFICATION
 */
#define MSP_SR_SOUND_NOTIFICATION_OFF   ((int16_t) 0)
#define MSP_SR_SOUND_NOTIFICATION_ON    ((int16_t) 1)


/*
 * Property to update status of Amplifier Availability status
 */
//MSP_AMP_AVAILABILITY_STATUS = 56,
enum am_AmpAvailabilityFunctionStatus_e
{
 /* Valid set , but since update to HMI is int16_t type need to check*/

  MSP_AMP_AVAILABILITY_AUDIO_PILOT         = 0x00001,
  MSP_AMP_AVAILABILITY_BALANCE             = 0x00002,
  MSP_AMP_AVAILABILITY_BASS                = 0x00004,
  MSP_AMP_AVAILABILITY_FADER               = 0x00008,
  MSP_AMP_AVAILABILITY_GALA                = 0x00010,
  MSP_AMP_AVAILABILITY_MIDDLE              = 0x00020,
  MSP_AMP_AVAILABILITY_SURROUNDMODE        = 0x00040,
  MSP_AMP_AVAILABILITY_TREBLE              = 0x00080,
  MSP_AMP_AVAILABILITY_AMPDOWNMIX          = 0x00100,
  MSP_AMP_AVAILABILITY_SURROUND_VOLUME     = 0x00200,
  MSP_AMP_AVAILABILITY_DRIVER_AUDIO_STAGE  = 0x00400,
  MSP_AMP_AVAILABILITY_REARSEAT_AUDIO_STAGE    = 0x00800,
  MSP_AMP_AVAILABILITY_ANC                     = 0x01000,
  MSP_AMP_AVAILABILITY_ASC                     = 0x02000,
  MSP_AMP_AVAILABILITY_ROOMEFFECT              = 0x04000,
  MSP_AMP_AVAILABILITY_SOUNDAMBIANCE           = 0x08000
};
/**
 * Describes the different system properties which are project specific.
 */
typedef uint16_t am_CustomSystemPropertyType_t;
/** Different beeps can be started with this */
static const am_CustomSystemPropertyType_t   SYP_BEEP = 1;
/** Fader status active */
static const am_CustomSystemPropertyType_t   SYP_FADER_STATUS_ACTIVE = 2;
/** Volume mode for main1 stream */
static const am_CustomSystemPropertyType_t   SYP_VOLMODE_STREAM_MAIN_1 = 3;
/** Volume mode for Mix1 stream */
static const am_CustomSystemPropertyType_t   SYP_VOLMODE_STREAM_MIX_1 = 4;
/** Diagnosis remote control */
static const am_CustomSystemPropertyType_t   SYP_DIAG_REMOTE_CONTROL = 5;
/** System property for service availability status of GAM */
static const am_CustomSystemPropertyType_t   SYP_AM_SRV_STS = 6;
/** System Property to report that HMI is ready and remove MUTE_HMISTARTUP */
static const am_CustomSystemPropertyType_t   SYP_HMISTARTUP_MUTE = 7;
/** System Property to set drive mode for ESE feature */
static const am_CustomSystemPropertyType_t   SYP_ESE_DRIVE_MODE = 8;
/** System Property to update User Mute/DeMute Status */
static const am_CustomSystemPropertyType_t   SYP_USER_MUTE_STATUS = 9;
/** Property to set/get the collection of sound files to be used for UPA/HFP */
static const am_CustomSystemPropertyType_t   SYP_ADAS_UPA_SOUND_COLLECTION = 10;
/** This property can be used to set/get setting Sound */
static const am_CustomSystemPropertyType_t   SYP_ADAS_SETTING_SOUND = 11;
/** This property used to update last tuner entertainment source playing */
static const am_CustomSystemPropertyType_t   SYP_LAST_TUNER_SOURCE = 12;

static const am_CustomSystemPropertyType_t   SYP_PRIVATE_MODE  = 13;
//static const am_CustomSystemPropertyType_t   SYP_UNREGISTER_SINK17  = 14;
static const am_CustomSystemPropertyType_t   SYP_MODIFY_SINK17    = 14;
static const am_CustomSystemPropertyType_t   SYP_MAX = 15;

enum am_Sink17TestModification_e
{
	Sink17Unregister = -1,
	Sink17RegisterInvisible = 0,
	Sink17RegisterVisible = 1
};
/*
* System propert values
*/
/**
 * Value for SYP_DIAG_REMOTE_CONTROL
 * @author Vyankatesh VD
 * @created 30-June-2015 04:44:00 pm
 */
#define SYP_DIAG_REMOTE_CONTROL_OFF  ((int16_t) 0)
#define SYP_DIAG_REMOTE_CONTROL_ON   ((int16_t) 1)

/**
 * Value for SYP_USER_MUTE_STATUS
 * @author Vyankatesh VD
 * @created 23-Augus-2016
 */
#define SYP_USER_MUTE_STATUS_OFF  ((int16_t) 0)
#define SYP_USER_MUTE_STATUS_ON   ((int16_t) 1)

/**
 * gives availability status of HMI
 * @author Vyankatesh VD
 * @created 29-May-2015 12:10:00 pm
 */
#define SYP_HMISTARTUP_MUTE_OFF  ((int16_t) 0)
#define SYP_HMISTARTUP_MUTE_ON   ((int16_t) 1)

/*
 * Values for System property 'SYP_ESE_DRIVE_MODE'
 */
#define AM_SYP_ESE_DRIVE_MODE_ECO      ((int16_t) 0)
#define AM_SYP_ESE_DRIVE_MODE_COMFORT    ((int16_t) 1)
#define AM_SYP_ESE_DRIVE_MODE_NORMAL    ((int16_t) 2)
#define AM_SYP_ESE_DRIVE_MODE_DYNAMIC    ((int16_t) 3)
#define AM_SYP_ESE_DRIVE_MODE_PERSO    ((int16_t) 4)

/**
 * SYP_BEEP values
 */
#define AM_SYP_BEEP_ERROR      ((int16_t) 1)
#define AM_SYP_BEEP_ROGER      ((int16_t) 2)
#define AM_SYP_BEEP_WARN      ((int16_t) 3)
#define AM_SYP_BEEP_CLICK      ((int16_t) 4)
#define AM_SYP_BEEP_POI        ((int16_t) 5)
#define AM_SYP_BEEP_SDS_END      ((int16_t) 6)
#define AM_SYP_BEEP_SMS_INCOMING  ((int16_t) 7)
#define AM_SYP_BEEP_SMS_SEND    ((int16_t) 8)
#define AM_SYP_BEEP_URGENT      ((int16_t) 9)
#define AM_SYP_BEEP_SPEED_WARN    ((int16_t) 10)
#define AM_SYP_BEEP_CURVE_WARN    ((int16_t) 11)
#define AM_SYP_BEEP_AVM_OPERATION  ((int16_t) 12)
#define AM_SYP_BEEP_AVM_ERROR    ((int16_t) 13)
#define AM_SYP_BEEP_SPEED_HINT    ((int16_t) 14)
#define AM_SYP_BEEP_CURVE_HINT    ((int16_t) 15)
#define AM_SYP_BEEP_IPA_NOSOUND    ((int16_t) 16)
#define AM_SYP_BEEP_IPA_3      ((int16_t) 17)
#define AM_SYP_BEEP_IPA_7      ((int16_t) 18)
#define AM_SYP_BEEP_IPA_8      ((int16_t) 19)
#define AM_SYP_BEEP_IPA_9      ((int16_t) 20)
#define AM_SYP_BEEP_IPA_10      ((int16_t) 21)
#define AM_SYP_BEEP_IPA_11      ((int16_t) 22)
#define AM_SYP_BEEP_IPA_STOP_SOUND  ((int16_t) 23)
#define AM_SYP_BEEP_SDS_START    ((int16_t) 24)
#define AM_SYP_BEEP_IPA_4      ((int16_t) 25)
#define AM_SYP_BEEP_IPA_5      ((int16_t) 26)
#define AM_SYP_BEEP_IPA_6      ((int16_t) 27)
#define AM_SYP_BEEP_GST_01    ((int16_t) 65)
#define AM_SYP_BEEP_GST_02    ((int16_t) 66)
#define AM_SYP_BEEP_GST_03     ((int16_t) 67)
#define AM_SYP_BEEP_GST_04     ((int16_t) 68)
#define AM_SYP_BEEP_GST_05     ((int16_t) 69)
#define AM_SYP_BEEP_GST_06     ((int16_t) 70)
#define AM_SYP_BEEP_GST_07     ((int16_t) 71)
#define AM_SYP_BEEP_GST_08     ((int16_t) 72)
#define AM_SYP_BEEP_GST_09     ((int16_t) 73)
#define AM_SYP_BEEP_GST_10     ((int16_t) 74)
#define AM_SYP_BEEP_GST_11     ((int16_t) 75)
#define AM_SYP_BEEP_GST_12     ((int16_t) 76)
#define AM_SYP_BEEP_GST_13     ((int16_t) 77)
#define AM_SYP_BEEP_GST_14     ((int16_t) 78)
#define AM_SYP_BEEP_WARN_NOT_DEF  ((int16_t) 255)

/**
 * SYP_FADER_STATUS_ACTIVE values
 */
#define AM_SYP_FADER_STATUS_INACTIVE  ((int16_t) 0)
#define AM_SYP_FADER_STATUS_ACTIVE    ((int16_t) 1)
#define AM_SYP_FADER_STATUS_NOT_DEF    ((int16_t) 255)

/**
 * SYP_VOLMODE_STREAM_MAIN_1 values
 * and
 * SYP_VOLMODE_STREAM_MIX_1 values
 */
#define AM_SYP_VOLMODE_NORMAL                      ((int16_t) 0)
#define AM_SYP_VOLMODE_SETUP_ONVOL                 ((int16_t) 1)
#define AM_SYP_VOLMODE_SETUP_PHONE                 ((int16_t) 2)
#define AM_SYP_VOLMODE_SETUP_TIM                   ((int16_t) 3)
#define AM_SYP_VOLMODE_SETUP_TA                    ((int16_t) 4)
#define AM_SYP_VOLMODE_BEEPVOL                     ((int16_t) 5)
#define AM_SYP_VOLMODE_DIAGVOL                     ((int16_t) 6)
#define AM_SYP_VOLMODE_NAV_ANNOUNCEMENT            ((int16_t) 7)
#define AM_SYP_VOLMODE_SETUP_NAV_VOL               ((int16_t) 8)
#define AM_SYP_VOLMODE_SETUP_NAV_ANNOUNCEMENT_VOL  ((int16_t) 9)
#define AM_SYP_VOLMODE_PDC_ATTENUATION_SETUP       ((int16_t) 10)
#define AM_SYP_VOLMODE_SETUP_SDS           ((int16_t) 11)
#define AM_SYP_VOLMODE_NOT_DEF             ((int16_t) 255)


#define AM_SYP_PRIVATE_MODE_1      ((int16_t) 1)
#define AM_SYP_PRIVATE_MODE_2      ((int16_t) 2)
#define AM_SYP_PRIVATE_MODE_3      ((int16_t) 3)

/**
 * gives service availability status of GAM
 * @author Vyankatesh VD
 * @created 17-Jan-2014 03:00:00 pm
 */
enum am_ServiceAvailability_e
{
  SYP_AM_SRV_STS_UNKNOWN = 0,
  SYP_AM_SRV_STS_UNAVAILABLE = 1,
  SYP_AM_SRV_STS_AVAILABLE = 2,
  SYP_AM_SRV_STS_MAX
};

enum am_SystemAudioState_e
{
  SYP_AM_SRV_STS_AUDIOSTATE_OFF = 0,
  SYP_AM_SRV_STS_AUDIOSTATE_EMERGENCY = 1,
  SYP_AM_SRV_STS_AUDIOSTATE_NORMAL = 2,
  SYP_AM_SRV_STS_AUDIOSTATE_LIMITED = 3
};
}

#endif
