/******************************************************************************

  FILE:           trc_stdtext.h
 
  PROJECT:        VASCO

  SW-COMPONENT:   general library

  DESCRIPTION:    default trace text
  
  AUTHOR:         CM-DI/ESA2 Frank Wiedemann

  COPYRIGHT:      (c) 2003 Blaupunkt Werke GmbH

  HISTORY:
  $Log:   //hi230124/projects/Vasco/swnavi/archives/components/trace/trc_stdtext.cpp-arc  $
 * 
 *    Rev 1.7   Jul 11 2003 13:34:18   Zombetzki
 * Bugfix: include protection and extern declaration
 * 
 *    Rev 1.6   Jul 01 2003 10:03:18   Stuebner
 * more strings
 * 
 *    Rev 1.5   Jun 24 2003 15:39:46   Pirklbauer
 * more string constants
 * 
 *    Rev 1.4   Jun 17 2003 14:10:46   Pirklbauer
 * 'Speech' and 'RouteGuidance' added
 * 
 *    Rev 1.3   Jun 17 2003 11:03:10   Pirklbauer
 * fcvd_voice added; beautified
 * 
 *    Rev 1.2   Jun 17 2003 09:42:36   Pirklbauer
 * some new trace textes
 * 
 *    Rev 1.1   Jun 16 2003 09:07:24   Wiedemann
 * made text constants extern
 * 
 *    Rev 1.0   Jun 13 2003 09:23:12   Wiedemann
 * Initial revision.

  Date     | Rev. | Author                | Modification
  ----------------------------------------------------------------------------
  12.06.03 | 1.0  | CM-DI/ESA2-Wiedmann   | Initial revision

******************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "trc_stdtext.h"

// general
const tChar trc_txtEnter[]            = "enter "; // e.g. enter 'FunctionName'
const tChar trc_txtLeave[]            = "leave "; // e.g. leave 'FunctionName'
const tChar trc_txtStarted[]          = "started "; 
const tChar trc_txtFinished[]         = "finished "; 
const tChar trc_txtFailed[]           = "failed "; 
const tChar trc_txtStopped[]          = "stopped "; 
const tChar trc_txtExceeded[]         = "exceeded "; 
const tChar trc_txtInit[]             = "init "; // e.g. init 'DatabaseName'
const tChar trc_txtFree[]             = "free ";
const tChar trc_txtDelete[]           = "delete ";
const tChar trc_txtShutDown[]         = "shut down ";
const tChar trc_txtProcess[]          = "process ";
const tChar trc_txtDatasetID[]        = "datasetID ";
const tChar trc_txtParanthesis[]      = "() ";
const tChar trc_txtCreate[]           = "create ";
const tChar trc_txtFCVD_Voice[]       = "FCVD_Voice ";
const tChar trc_txtSpeech[]           = "Speech ";
const tChar trc_txtRouteGuidance[]    = "RouteGuidance ";
const tChar trc_txtGenerating[]       = "generating ";
const tChar trc_txtForwardingOf[]     = "forwarding of ";
const tChar trc_txtSpace[]            = " ";
const tChar trc_txtOn[]               = "on ";
const tChar trc_txtOf[]               = "of ";
const tChar trc_txtFrom[]             = "from ";
const tChar trc_txtTo[]               = "to ";
const tChar trc_txtEqualSign[]        = "= ";
const tChar trc_txtNo[]               = "no ";
const tChar trc_txtPushBack[]         = "push_back ";
const tChar trc_txtMemoryAllocation[] = "memory allocation ";
const tChar trc_txtInvalid[]          = "invalid ";
const tChar trc_txtTripHandle[]       = "TripHandle ";
const tChar trc_txtTripSegment[]      = "TripSegment ";
const tChar trc_txtTripDefinition[]   = "Tripdefinition ";
const tChar trc_txtDestination[]      = "destination ";
const tChar trc_txtDescription[]      = "description ";
const tChar trc_txtVehicle[]          = "vehicle ";
const tChar trc_txtPosition[]         = "position ";
const tChar trc_txtRoute[]            = "route ";
const tChar trc_txtOption[]           = "option ";
const tChar trc_txtAvailable[]        = "available ";
const tChar trc_txtLocation[]         = "location ";
const tChar trc_txtChannel[]          = "channel ";


// message-handling, service register 
const tChar trc_txtOpenFailed[]         = "open failed "; // e.g. open failed 'ChannelName'
const tChar trc_txtCloseFailed[]        = "close failed "; // e.g. close failed 'ChannelName'
const tChar trc_txtOpened[]             = "opened "; // e.g. opened 'ChannelName'
const tChar trc_txtClosed[]             = "closed "; // e.g. closed 'ChannelName'
const tChar trc_txtServiceAvailable[]   = "service available "; // e.g. service available 'ServiceName/ID'
const tChar trc_txtServiceUnavailable[] = "service unavailable "; // e.g. service unavailable 'ServiceName/ID'
const tChar trc_txtMsgSendFailed[]      = "msg send failed "; // e.g. msg send failed 'functionID/OpCode'
const tChar trc_txtMsgSent[]            = "msg sent "; // e.g. msg sent 'functionID/OpCode'
const tChar trc_txtSend[]               = "send ";
const tChar trc_txtMsgReceived[]        = "received "; // e.g. msg received 'functionID/OpCode'
const tChar trc_txtPropRegistered[]     = "prop. registered "; // e.g. property registered 'PropertyName'
const tChar trc_txtPropUnRegistered[]   = "prop. unregistered "; // e.g. property registered 'PropertyName'
const tChar trc_txtUpReg[]              = "UpReg ";
const tChar trc_txtRelUpReg[]           = "RelUpReg ";
const tChar trc_txtMethodStart[]        = "MethodStart ";
const tChar trc_txtMethodAbort[]        = "MethodAbort ";
const tChar trc_txtMethodResult[]       = "MethodResult ";
const tChar trc_txtSet[]                = "Set ";
const tChar trc_txtGet[]                = "Get ";
const tChar trc_txtStatus[]             = "Status ";
const tChar trc_txtError[]              = "Error ";
const tChar trc_txtAbort[]              = "Abort ";
const tChar trc_txtServiceDataMsg[]     = "amt_tclServiceDataMsg ";
const tChar trc_txtVisitorMsg[]         = "fi_tclVisitorMsg ";
const tChar trc_txtProperty[]           = "property ";

// State-Machines
const tChar trc_txtStateChart[] = "state chart "; //e.g. state chart 'NameOfStateChart'
const tChar trc_txtState[]      = "state "; //e.g. state 'NameOfCurrentState'
const tChar trc_txtTransition[] = "transition "; //e.g. transition 'NameOfTransition'
const tChar trc_txtGuard[]      = "guard "; //e.g. guard 'NameOfGuard'
const tChar trc_txtEvent[]      = "event "; //e.g. event 'NameOfEvent'
const tChar trc_txtSignal[]     = "signal "; // e.g. signal 'EventName'

// errors
const tChar trc_txtInvalidValue[]       = "invalid value ";
const tChar trc_txtInvalidHandle[]      = "invalid handle ";
const tChar trc_txtAccessFailed[]       = "access failed ";
const tChar trc_txtMsgAccessFailed[]    = "msg access failed ";
const tChar trc_txtNullPointer[]        = "null pointer ";
const tChar trc_txtExceptionCaught[]    = "exception caught "; // e.g. exception caught 'ExceptionName'
const tChar trc_txtUnhandledException[] = "unhandled exception ";
const tChar trc_txtNotInitialized[]     = "not initialized ";
const tChar trc_txtAllocationFailed[]   = "allocation failed ";
const tChar trc_txtCreationFailed[]     = "creation failed";
const tChar trc_txtTimeout[]            = "timeout ";
const tChar trc_txtDeleteFailed[]       = "delete failed ";
const tChar trc_txtOutOfMemory[]        = "out of memory ";
const tChar trc_txtOutOfRange[]         = "out of range ";

#include "trc_cl.h"
#include "trc_macro.h"
/* This function determines the name of the file, given by path and filename. */
tCString trc_szGetFileName(tCString szFilePathName)
{
   tCString szFileName = OSAL_ps8StringRSearchChar(szFilePathName, '/');
   if (szFileName == OSAL_NULL)
      szFileName = OSAL_ps8StringRSearchChar(szFilePathName, '\\');
   return (tCString)((szFileName != OSAL_NULL) ? (szFileName + 1) : (szFilePathName));
}


