#ifndef TRC_CL_HEADER
#define TRC_CL_HEADER
/******************************************************************************

  FILE:           trc_cl.h

  PROJECT:        VASCO

  SW-COMPONENT:   general library

  DESCRIPTION:    trace class definition

  AUTHOR:         CM-DI/ESA2 Mathias Schubert

  COPYRIGHT:      (c) 2002 Blaupunkt Werke GmbH

  HISTORY:
  $Log:   //hi230124/projects/Vasco/swnavi/archives/components/trace/trc_cl.h-arc  $
 * 
 *    Rev 1.10   Jul 11 2003 13:29:16   Zombetzki
 * - destructors virtual
 * - format string const
 * - add new trace methods for each level
 * 
 *    Rev 1.9   May 22 2003 10:57:20   Wiedemann
 * adding class hierarchy for trace objects and added global trace class
 * 
 *    Rev 1.8   03 Jun 2002 17:15:40   UNM2HI
 * parameter tU16 -> tU32, swap class and level in parameter list (bugfix)
 * 
 *    Rev 1.7   03 Jun 2002 11:03:38   UNM2HI
 * new macros
 * 
 *    Rev 1.6   27 May 2002 14:52:18   SUM2HI
 * vTrace fuer Streaming Objekte implementiert
 * 
 *    Rev 1.5   27 May 2002 14:30:34   SUM2HI
 * vTrace fuer dinokonforme Traces entfernt
 * Input Channel Faehigkeit entfernt
 *
 *    Rev 1.4   24 May 2002 15:41:22   SUM2HI
 * same little changes
 * LineNumber and FileName at  vTrace added.
 *
 *    Rev 1.3   07 May 2002 15:14:22   SUM2HI
 * vTripTrace added
 *
 *    Rev 1.2   26 Apr 2002 15:29:02   SUM2HI
 * Bugfix Ueberladen vTrace
 *
 *    Rev 1.1   24 Apr 2002 09:45:22   SUM2HI
 * Anpassung an Gesamtsystemkonzept Debug und Trace

  Date     | Rev. | Author                | Modification
  ----------------------------------------------------------------------------
  20.02.02 | 1.0  | CM-DI/ESA2-Schubert   | Initial revision
  24-09-12 | 2.2  | CM-AI/PJ-CB36 Hessling| Adding ETG_I functions

******************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

/**************************************************************************/
/* classes                                                                */
/**************************************************************************/

class trc_tclTraceBase
{
public:
   //Default Konstruktor
   trc_tclTraceBase() {}

   //Destruktor
   virtual ~trc_tclTraceBase() {}

   //Ermittlung ob Level und Klasse aktiv
   tBool bIsTraceActive(TR_tenTraceClass enTraceClass,TR_tenTraceLevel enTraceLevel) const;

   //Ascii Ausgabe mit Klasse und Level als Parameter
   tVoid vTrace(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...) const;

   //Ascii Ausgabe fuer Stream Objekte
   tVoid vTrace(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,tPCS8 pcos8Data,tU32 u32Length) const;
   
   // allgemeine Ausgabefunktion fertiger Strings
   tVoid vBinTrace(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,tPCS8 pcos8Data,tU32 u32Length) const;

private:
   virtual OSAL_tIODescriptor hGetTraceDevice() const = 0;

protected:
   virtual tVoid vTraceOutput(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,tU32 u32Linenumber, tCString coszFilename,
                              tCString coszFormat, va_list argList) const;
};

typedef void (*trc_tpfCallback) ( tPVoid );


class trc_tclGlobalTrace : public trc_tclTraceBase
{
public:

   //Destruktor
   virtual ~trc_tclGlobalTrace() {}

   static tS32  s32Init();
   static tVoid vFree();
   static trc_tclGlobalTrace& rfoGetTraceObject()
   {
      return oTheGlobalTraceObject;
   };

   //-- trace functions for each level
   static tVoid vTraceLevel0(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vTraceLevel1(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vTraceLevel2(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vTraceLevel3(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vTraceLevel4(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vTraceLevel5(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vTraceLevel6(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vTraceLevel7(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vTraceLevel8(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);

   static tVoid vLibTraceLevel0(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vLibTraceLevel1(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vLibTraceLevel2(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vLibTraceLevel3(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vLibTraceLevel4(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vLibTraceLevel5(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vLibTraceLevel6(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vLibTraceLevel7(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);
   static tVoid vLibTraceLevel8(TR_tenTraceClass enTraceClass,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat,...);

   //-- method to call vTraceOutput of base class to prevent output of threadname
   tVoid vTracePure(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,tU32 u32Linenumber, tCString coszFilename, tCString coszFormat, va_list argList) const;
   
   // functions to support etg tracing
   static etg_tBool bIsTraceActiveEtg(etg_tU16 u16TraceClass, etg_tU16 enTraceLevel);
   static etg_tVoid vBinTraceEtg(etg_tU16 u16TraceClass, etg_tU16 enTraceLevel, const etg_tS8* pcos8Buffer, etg_tU32 u32Length) ;
   // parameter 2 is intentionally tInt because tenErrmemEntryType is define in osioctrl.h having a ringdependency
   static etg_tVoid vDoTraceErrmemEtg(etg_tU16 u16Entry, etg_tInt eEntryType, etg_tU16 u16EntryLength, const etg_tU8* pcou8Buffer);
   static etg_tS32 s32RegTraceCallbackEtg(etg_tU16 eChanId, ETG_tpfCallback pfvCb);
   static etg_tS32 s32UnregTraceCallbackEtg(etg_tU16 eChanId, ETG_tpfCallback pfvCb);

   static tS32 s32RegTraceCallback(TR_tenTraceChan eChanId, OSAL_tpfCallback pfvCb);
   static tS32 s32UnregTraceCallback(TR_tenTraceChan eChanId, OSAL_tpfCallback pfvCb);

   //function to support TTFis command input
   /**
    * u16Register
    *
    * registers a trace input channel for TTFis input commands. If failed INVALID_CLIENT_ID
    * is returned, otherwise the assigned client id.
    * Registration shall be only performed when leaving system state initialized
    *
    * @date      2 Nov 2011
    * @return    tU16   client id
    * @param     trc_tpfCallback pfCallback function for handling input commands
    * @param     const TR_tenTraceChan & Channel
    * @author    CM-AI/PJ-CF11-Andres
    **/
   static tU16 u16Register( trc_tpfCallback pfCallback, const TR_tenTraceChan& Channel );
   /**
    * vDeregister
    *
    * deregisters a client trace input channel.
    * Deregistration shall be only performed when switching to system state terminated.
    *
    * @date      2 Nov 2011
    * @return    void
    * @param     tU16 u16ClientId delivered by u16Register
    * @author    CM-AI/PJ-CF11-Andres
    **/
   static void vDeregister( tU16 u16ClientId );

   enum{ TRC_GLOBALTRACE_MAX_CLIENTS = 20,
         TRC_GLOBALTRACE_INVALID_CLIENT_ID = 0xFFFF };
   
private:
   static trc_tclGlobalTrace oTheGlobalTraceObject;
   static OSAL_tIODescriptor hTheGlobalTrace;
   virtual OSAL_tIODescriptor hGetTraceDevice() const;

   //simplest client administration, because it is not possible to
   //use stl here!
   //it is also not possible to use OSAL_trIOCtrlLaunchChannel here!!
   //!!osal_if includes trace_if!!
   struct trIOCtrlLaunchChannel
   {
      TR_tenTraceChan         enTraceChannel;
      trc_tpfCallback        pCallback;
   };

   static trIOCtrlLaunchChannel  m_ClientList[TRC_GLOBALTRACE_MAX_CLIENTS];
   static tU16                   m_u16MaxClientIdx;

   //Default Konstruktor
   trc_tclGlobalTrace() {};
protected://lint !e1704
   virtual tVoid vTraceOutput(TR_tenTraceClass enTraceClass, TR_tenTraceLevel enTraceLevel,tU32 u32Linenumber, tCString coszFilename,
                              tCString coszFormat, va_list argList) const;
};




class trc_tclTraceData : public trc_tclTraceBase
{
public:
   //Default Konstruktor
   trc_tclTraceData();

   //Destruktor
   virtual ~trc_tclTraceData();

private:
   virtual OSAL_tIODescriptor hGetTraceDevice() const {return hTraceDevice;};
   OSAL_tIODescriptor hTraceDevice; //Filehandle
};




   
#endif


