/************************************************************************
* FILE:         vd_input_INCAdapter.h
* PROJECT:      VW MIB
* SW-COMPONENT: vd_input
*----------------------------------------------------------------------
*
* DESCRIPTION: This component is responsible for inputs simulation
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 07.10.13  | Deepak Bayiri Somesha (RBEI/ECV3) | initial version
*
*************************************************************************/
#if !defined(EA_CD7F49D8_69B3_40a7_A27C_55DA81D10269__INCLUDED_)
#define EA_CD7F49D8_69B3_40a7_A27C_55DA81D10269__INCLUDED_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <sys/types.h>
#include <sys/poll.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/time.h>
#include <time.h>
#include <netinet/tcp.h>
#include "dgram_service.h"
//#include "DeviceDataProvider.h"

#define INC_MESSAGE_RECEIVER_BUFFER_SIZE 256

class vd_input_INCAdapter
{
public:
   vd_input_INCAdapter();
   virtual ~vd_input_INCAdapter();
   static void* MessageReceiver(void* Data);
   int sendMessage(/*int Socket,*/void* Data, size_t DataLength);
   
private:
   pthread_t ObserverThread;
   /**
    * Flag will be set when the Thread shall exit
    */
   static tBool terminateObserverThread;

   // socket
   static int INCSimSocket;
     
#ifdef USE_DGRAM_SERVICE
   // datagram service
   sk_dgram *dgram;
#endif
   // local and remote address
   struct hostent *local, *remote;
   struct sockaddr_in local_addr, remote_addr;

   //DeviceDataProvider oMessageProvider;

   tBool createMessageObserver();
   tBool createSocket();
   tBool createService();
   tBool connectPort();
   
 //User specific code starts
 
 //User specific code ends
};
#endif // !defined(EA_CD7F49D8_69B3_40a7_A27C_55DA81D10269__INCLUDED_)
