/************************************************************************
* FILE:         vd_input_INCAdapter.cpp
* PROJECT:      VW MIB
* SW-COMPONENT: vd_input
*----------------------------------------------------------------------
*
* DESCRIPTION: This component is responsible for inputs simulation
*              
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2005 Robert Bosch GmbH, Hildesheim
* HISTORY:      
* Date      | Author             | Modification
* 07.10.13  | Deepak Bayiri Somesha (RBEI/ECV3) | initial version
*
*************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <pthread.h>
#include "vd_input_INCAdapter.h"
#include <unistd.h>
#include "inc.h"
#include "inc_ports.h"
//#include "../../Macro.h"
//Sandeep++ Need to re-work if doesnot work
//#define vd_input_PORT 0x26



//Sandeep--
tBool vd_input_INCAdapter::terminateObserverThread = FALSE;
int vd_input_INCAdapter::INCSimSocket = -1;
/**
 * create a thread which is waiting for incoming inc messages
 */
tBool vd_input_INCAdapter::createMessageObserver()
{
   tBool threadCreatePassed = TRUE;

   if (pthread_create(&ObserverThread, NULL, &MessageReceiver, NULL) != 0)
   {
#if defined (_PRINT__)
      printf("vd_input_INCAdapter Observer Thread create failed!\n");
#endif
      exit (EXIT_FAILURE);
      threadCreatePassed = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }
   else
   {
#if defined (_PRINT__)
      printf("vd_input_INCAdapter Observer Thread create passed\n");
#endif

   }

   return (threadCreatePassed);
}

tBool vd_input_INCAdapter::createSocket()
{
   tBool CreatePassed = TRUE;
   //   non blocking socket
   INCSimSocket = socket(AF_BOSCH_INC_AUTOSAR, SOCK_STREAM, 0);

   if (-1 == INCSimSocket)
   {
#if defined (_PRINT__)
      printf("vd_input_INCAdapter::vd_input_INCAdapter(): socket for dimming create failed! Socket Id: %d\n", INCSimSocket);
#endif
      CreatePassed = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }
   else
   {
#if defined (_PRINT__)
      printf("vd_input_INCAdapter::vd_input_INCAdapter(): socket for dimming created. Socket Id: %d\n", INCSimSocket);
#endif
   }
   return (CreatePassed);
}

tBool vd_input_INCAdapter::createService()
{
   tBool CreatePassed = TRUE;
#ifdef USE_DGRAM_SERVICE
   dgram = dgram_init(INCSimSocket, DGRAM_MAX, NULL);
   if ( NULL == dgram)
   {
#if defined (_PRINT__)
      printf("vd_input_INCAdapter::vd_input_INCAdapter(): dgram for dimming create failed. dgram Id: %d\n", dgram);
#endif
      close(INCSimSocket);
      INCSimSocket = -1;
      CreatePassed = FALSE;
   }
#if defined (_PRINT__)
   printf("vd_input_INCAdapter::vd_input_INCAdapter(): dgram for dimming created. dgram Id: %d\n", dgram);
#endif

#endif
   return (CreatePassed);

}
tBool vd_input_INCAdapter::connectPort()
{
   tBool ConnectPassed = TRUE;

   if (-1 == INCSimSocket)
   {
      ConnectPassed = FALSE;
   }
   else
   {
      //get local and remote addresses and ports
      local = gethostbyname("scc-local");
      if ( NULL == local)
      {
         ConnectPassed = FALSE;
      }
      else
      {
         memcpy((char *) &local_addr.sin_addr.s_addr, (char *) local->h_addr, local->h_length);
         local_addr.sin_family = AF_INET;
         local_addr.sin_port = htons(TTFIS_PORT); /* from inc_ports.h *///To be checked This will append LUNID 0x26 for Input simulator

         // bind socket
         int bindReturn = bind(INCSimSocket, (struct sockaddr *) &local_addr, sizeof(local_addr));
         if (0 != bindReturn)
         {
#if defined (_PRINT__)
            printf("vd_input_INCAdapter::vd_input_INCAdapter(): binding failed: return value: %d\n", bindReturn);
#endif
            ConnectPassed = FALSE;

         }
         remote = gethostbyname("scc");
         if (NULL == remote)
         {
#if defined (_PRINT__)
            printf("vd_input_INCAdapter::vd_input_INCAdapter(): remote host get failed: return value: %d\n", remote);
#endif
            ConnectPassed = FALSE;

         }
         else
         {
            memcpy((char *) &remote_addr.sin_addr.s_addr, (char *) remote->h_addr, remote->h_length);
            remote_addr.sin_family = AF_INET;
            remote_addr.sin_port = htons(TTFIS_PORT); /* from inc_ports.h *////To be defined - ruth

         }

         // connect to remote adress/port
         if (0 != connect(INCSimSocket, (struct sockaddr *) &remote_addr, sizeof(remote_addr)))
         {
#if defined (_PRINT__)
            printf("vd_input_INCAdapter::vd_input_INCAdapter(): connect failed!\n");
#endif
            ConnectPassed = FALSE;

         }
         else
         {
#if defined (_PRINT__)
            printf("vd_input_INCAdapter::vd_input_INCAdapter(): connected\n");
#endif

         }
      }
      if ( FALSE == ConnectPassed)
      {
         close(INCSimSocket);
         INCSimSocket = -1;
      }
   }
   return (ConnectPassed);
}

vd_input_INCAdapter::vd_input_INCAdapter()
#ifdef USE_DGRAM_SERVICE
:dgram(NULL)
#endif
{
   //tBool SocketEstablished = FALSE; //lint warning fix
   remote = NULL;						//Coverity issue->uninitialized pointer(CID:19329)
   local = NULL;						//Coverity issue->uninitialized pointer(CID:19329)
   vd_input_INCAdapter::createMessageObserver();
   vd_input_INCAdapter::createSocket();
   vd_input_INCAdapter::createService();
   vd_input_INCAdapter::connectPort();
}

vd_input_INCAdapter::~vd_input_INCAdapter()
{
   terminateObserverThread = TRUE;

#if defined (_PRINT__)
   printf("vd_input_INCAdapter::MessageReceiver: destructor called. Waiting for exit of observer thread\n");
#endif

   // wait for end of observer thread
   pthread_join(ObserverThread, NULL);

#if defined (_PRINT__)
   printf("vd_input_INCAdapter::MessageReceiver: destructor called. observer thread left, proceed with destructor routine\n");
#endif
#ifdef USE_DGRAM_SERVICE
   dgram_exit(dgram);
#endif
   close(INCSimSocket);
   //Lint warning fix
   local = NULL;
   remote = NULL;
}

/*
 * wait for incoming INC messages */
 
void* vd_input_INCAdapter::MessageReceiver(void* Data)
{
   tU8 ReceivedBuffer[INC_MESSAGE_RECEIVER_BUFFER_SIZE];
   int NumberOfBytesReceived = 0;
   while (FALSE == terminateObserverThread)
   {
      NumberOfBytesReceived = recv(INCSimSocket, ReceivedBuffer, sizeof(ReceivedBuffer), 0);
#if defined (_PRINT__)
      printf("Here I am:INCAdapter::MessageReceiver (ThreadId: %ld): no of byte received: %d\n", pthread_self(),NumberOfBytesReceived);
#endif

      if (-1 == NumberOfBytesReceived)
      {
#if defined (_PRINT__)
         printf("Here I am:INC_Adapte::MessageReceiver: receiving failed: %d\n", NumberOfBytesReceived);
#endif
      }
      //sleep(100); //This should be removed and not used ##comment from Roccco
   }

#if defined (_PRINT__)
   printf("vd_input :INC_Adapte::MessageReceiver: leaving thread now\n");
#endif

   pthread_exit((void *) pthread_self());
   return  (tVoid*)(Data); //lintfix; //to fix lint warning
}

int vd_input_INCAdapter::sendMessage(/*int Socket,*/void* Data, size_t DataLength)
{
   int BytesSent = 0;
 
#ifdef USE_DGRAM_SERVICE
   BytesSent = dgram_send(dgram, Data, DataLength);
#else	
   BytesSent = write(INCSimSocket, Data, DataLength);
#endif

#if defined (_PRINT__)
   printf("vd_input_INCAdapter::sendMessage: no of bytes sent: %d\n", BytesSent);
#endif

   return (0);
//   return write(Socket, Data, DataLength);
}
