
/*******************************************************************************
* FILE        :  vd_inputMainGen_trace.cpp                                   
* DESCRIPTION :  Generated/Updated trace command message handler file 
*******************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "vd_inputMain.h"
#include "vd_inputMainGenTtfisCmd.h"

#include "KeyMapping/ConfigurationDataHandler.h"
#include"EvDataManager/EvObserver/EventObserver.h"
#include "vd_input_INCAdapter.h" //for creating adaptor class object
//#include "CcaClientHdl/vd_input_TestClient.h" //for testing CCA service
#include"SimulationApp/TouchSimApp.h"
#include"SimulationApp/KeySimApp.h"
#include"EvDataManager/EvObserver/EventObserver.h"
#include"EvDataManager/EvObserver/UsrActionEmu.h"
#define CONVERT_S32(f_byte,s_byte,t_byte,fo_byte)   ((((tS32)f_byte) << 24) | (((tS32)s_byte) << 16) | (((tS32)t_byte) << 8) | (tS32)fo_byte)

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/vd_inputMainGen_trace.cpp.trc.h"
#endif


tVoid vd_input_tclMain::vHandleTraceMessageGen(const tUChar* puchData) {
    tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
    
    ETG_TRACE_USR1(("vd_input_tclMain::vHandleTraceMessage(): process command: %d.", u32MsgCode));
    
    switch (u32MsgCode) {

    case VD_INPUT_CMDHELP:
        {
            // Trace out all possible trace commands for vd_input.
        	ETG_TRACE_FATAL(("ENABLE Sim using Command: VD_INPUT_ENABLE_SIMULATION"));
        	ETG_TRACE_FATAL(("HardKey Sim CMD: VD_INPUT_POSTCMDSIMULATE_HARDKEY <Status> <KeyCode>"));
        	ETG_TRACE_FATAL(("SystemKey Sim CMD: VD_INPUT_POSTCMDSIMULATE_SYSTEMKEY <Status> <KeyCode>"));
        	ETG_TRACE_FATAL(("SWCKey Sim CMD: VD_INPUT_POSTCMDSIMULATE_SWCKEY <Status> <KeyCode>"));
        	ETG_TRACE_FATAL(("Encoder Sim CMD: VD_INPUT_POSTCMDSIMULATE_ENCODER <Type> <+/-Steps>"));
        	ETG_TRACE_FATAL(("Touch Sim CMD: VD_INPUT_POSTCMDSIMULATE_TOUCH <Status> <X> <Y>"));
        	ETG_TRACE_FATAL(("Touch SLide Sim CMD: VD_INPUT_SIMULATE_TOUCH_SLIDE <StartX> <StartY> <EndX> <EndY> <Speed>"));
        	ETG_TRACE_FATAL(("Disable Sim using CMD: VD_INPUT_DISABLE_SIMULATION"));
        }
        break;

    case VD_INPUT_TRACEINFO:
        {
            // Trace out info about MAIN class.
        	ETG_TRACE_FATAL(("VD_MAIN: TR_CLASS_VD_INPUT_APPLICATION 8"));
        	ETG_TRACE_FATAL(("VD_DEVICE: TR_CLASS_VD_INPUT_DEVICE 8"));
        	ETG_TRACE_FATAL(("VD_DIAG_CLIENT: TR_CLASS_VD_INPUT_CLIENT_DIAGNOSTICS 8"));

        	_poMainAppInstance->printTouchDiagList();			//Alok only for testing
        	_poMainAppInstance->printTouchDiagList_PIVI();	//Alok only for testing
        }
        break;

    case VD_INPUT_POSTBROADCASTCMD:
        {
            // Post an internal message to all application object handler.
            tU32 param1 =(puchData[3]<<8) | puchData[4];

            Ivd_inputBase::TMsg oMsg;
            oMsg.eCmd = (Ivd_inputBase::ECmdTypes)param1;
            oMsg.strClassName[0]=0;
            oMsg.u.u32Data = 0;

            // vd_input_PostBroadcastCmd: user specific code start
            // vd_input_PostBroadcastCmd: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;

    case VD_INPUT_POSTBROADCASTCMDPARAM:
        {
            // Post an internal message to all application object handler.
            tU32 param1 =(puchData[3]<<8) | puchData[4];
            tU32 param2 = (puchData[5]<<24) | (puchData[6]<<16) | (puchData[7] << 8) | puchData[8];

            Ivd_inputBase::TMsg oMsg;
            memset(&oMsg, 0, sizeof(oMsg));
            oMsg.eCmd = (Ivd_inputBase::ECmdTypes)param1;
            memset(&oMsg.strClassName[0], 0, sizeof(oMsg.strClassName));
            oMsg.u.u32Data = param2;
            // vd_input_PostBroadcastCmdParam: user specific code start
            // vd_input_PostBroadcastCmdParam: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;

    case VD_INPUT_POSTCMDTOCLASS:
        {
            // Post an internal message to all application object handler.
            tU32 param1 =(puchData[3]<<8) | puchData[4];
            const tChar* pString2 = (const tChar*)&puchData[5];
            tU32 param3 = (puchData[55]<<24) | (puchData[56]<<16) | (puchData[57] << 8) | puchData[58];

            Ivd_inputBase::TMsg oMsg;
            oMsg.eCmd = (Ivd_inputBase::ECmdTypes)param1;
            OSAL_szStringNCopy(oMsg.strClassName, pString2, 49);
            oMsg.u.u32Data = param3;

            // vd_input_PostCmdToClass: user specific code start
            // vd_input_PostCmdToClass: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;
		case VD_INPUT_POSTCMDSIMULATE_HARDKEY:
		{
	#ifdef __INPUT_INC_TESTING__

	 			//Key Events will be routed to V850 is UInputSimulation is not enabled
	 			ETG_TRACE_USR4(("Please ENABLE Simulation First using Command: VD_INPUT_ENABLE_SIMULATION"));
	 			vd_input_tclMain::m_u8INC_msg_buff[0] = CID;//Component Id -> 0x14
				vd_input_tclMain::m_u8INC_msg_buff[1] = NULL_BYTE;//Message Id Byte1-> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[2] = NULL_BYTE;//Message Id Byte2-> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[3] = MSGID_HDC_HK; //Message Id Byte3-> 0x51, 0x57 or 0x59 for HK, SYS, SWC
				vd_input_tclMain::m_u8INC_msg_buff[4] = 0x01; //Ev.Num -> Explains no of events occur 0x01 for hardkey
				vd_input_tclMain::m_u8INC_msg_buff[5] = NULL_BYTE; //Event Type Byte1 ->0x00
				vd_input_tclMain::m_u8INC_msg_buff[6] = EV_KEY; //Event Type Byte2 -> 0x01 for Key Event type
				vd_input_tclMain::m_u8INC_msg_buff[7] = puchData[4]; //Event Code Byte1-> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[8] = puchData[5]; //Event Code Byte 2-> Key Codes 0 - 9
				vd_input_tclMain::m_u8INC_msg_buff[9] = NULL_BYTE;//Key value pressed/Released Byte 1 -> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[10] = NULL_BYTE;//Key value pressed/Released Byte 2 -> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[11] = NULL_BYTE;//Key value pressed/Released Byte 3 -> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[12] = puchData[3];//Key value pressed/Released Byte 4-> 1-Press 0- Release

				//For testing purpose ++
				ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_HDC_HARDKEY Message format start = -->["));
				for(int i = 0; i<=12; i++)
					ETG_TRACE_USR4((" Byte%x | %x, ", i, vd_input_tclMain::m_u8INC_msg_buff[i]));
				ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_HDC_HARDKEY Message format End = ]<--"));
				//For testing purpose --
				if((_poMainAppInstance->pointerToAdaptor())!=NULL)
				{
					//Send data via adaptor and store return status, ret staus can be used for validation later or removed
					int retStatus=(_poMainAppInstance->pointerToAdaptor())->sendMessage(&vd_input_tclMain::m_u8INC_msg_buff[0], 13);
					ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_HDC_HARDKEY::After Call:sendMessage(&vd_input_tclMain::m_u8INC_msg_buff[0], 13), retStatus=%d", retStatus));
				}
	//End of INC If check
	#else
	 			//Key Events will be routed to uInput driver
				tU16 Keycode = ( (puchData[4]<<8) | puchData[5] );
				tS32 Value = puchData[3];
				ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_HDC_HARDKEY::KeyCode: %d, Status: %d", Keycode, Value));
				// Call Method of Main class to simulate Key
				_poMainAppInstance->simulateKey(Keycode, Value);
	#endif
		}
		break;
		case VD_INPUT_POSTCMDSIMULATE_SYSTEMKEY:
		{
	#ifdef __INPUT_INC_TESTING__
			{	//Key Events will be routed to V850
				ETG_TRACE_USR4(("Please ENABLE Simulation First using Command: VD_INPUT_ENABLE_SIMULATION"));
				vd_input_tclMain::m_u8INC_msg_buff[0] = CID;//Component Id -> 0x14
				vd_input_tclMain::m_u8INC_msg_buff[1] = NULL_BYTE;//Message Id Byte1-> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[2] = NULL_BYTE;//Message Id Byte2-> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[3] = MSGID_SYSTEM_KEY; //Message Id Byte3-> 0x51, 0x57 or 0x59 for HK, SYS, SWC
				vd_input_tclMain::m_u8INC_msg_buff[4] = 0x01; //Ev.Num -> Explains no of events occur 0x01 for hardkey
				vd_input_tclMain::m_u8INC_msg_buff[5] = NULL_BYTE; //Event Type Byte1 ->0x00
				vd_input_tclMain::m_u8INC_msg_buff[6] = EV_KEY; //Event Type Byte2 -> 0x01 for Key Event type
				vd_input_tclMain::m_u8INC_msg_buff[7] = puchData[4]; //Event Code Byte1-> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[8] = puchData[5]; //Event Code Byte 2-> Key Codes 0 - 9
				vd_input_tclMain::m_u8INC_msg_buff[9] = NULL_BYTE;//Key value pressed/Released Byte 1 -> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[10] = NULL_BYTE;//Key value pressed/Released Byte 2 -> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[11] = NULL_BYTE;//Key value pressed/Released Byte 3 -> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[12] = puchData[3];//Key value pressed/Released Byte 4-> 1-Press 0- Release

				//For testing purpose ++
				ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_SYSTEMKEY Message format start = -->["));
				for(int i = 0; i<=12; i++)
					ETG_TRACE_USR4((" Byte%x | %x, ", i, vd_input_tclMain::m_u8INC_msg_buff[i]));
				ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_SYSTEMKEY Message format End = ]<--"));
				//For testing purpose --
				if((_poMainAppInstance->pointerToAdaptor())!=NULL)
				{
					//Send data via adaptor and store return status, ret staus can be used for validation later or removed
					int retStatus=(_poMainAppInstance->pointerToAdaptor())->sendMessage(&vd_input_tclMain::m_u8INC_msg_buff[0], 13);
					ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_SYSTEMKEY::After Call:sendMessage(&vd_input_tclMain::m_u8INC_msg_buff[0], 13), retStatus=%d", retStatus));
				}
	#else//End of If check for Flag

				//Key Events will be routed to uInput driver
				tU16 Keycode = ( (puchData[4]<<8) | puchData[5] );
				tS32 Value = puchData[3];
				ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_SYSTEM_KEY::KeyCode: %d, Status: %d", Keycode, Value));
				// Call Method of Main class to simulate Key
				_poMainAppInstance->simulateKey(Keycode, Value);
	#endif
		}
		break;
		case VD_INPUT_POSTCMDSIMULATE_SWCKEY:
		{
	#ifdef __INPUT_INC_TESTING__
			//Key Events will be routed to V850 through INC Message
				ETG_TRACE_USR4(("Please ENABLE Simulation First using Command: VD_INPUT_ENABLE_SIMULATION"));
				vd_input_tclMain::m_u8INC_msg_buff[0] = CID;//Component Id -> 0x14
				vd_input_tclMain::m_u8INC_msg_buff[1] = NULL_BYTE;//Message Id Byte1-> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[2] = NULL_BYTE;//Message Id Byte2-> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[3] = MSGID_SWC_KEY; //Message Id Byte3-> 0x51, 0x57 or 0x59 for HK, SYS, SWC
				vd_input_tclMain::m_u8INC_msg_buff[4] = 0x01; //Ev.Num -> Explains no of events occur 0x01 for hardkey
				vd_input_tclMain::m_u8INC_msg_buff[5] = NULL_BYTE; //Event Type Byte1 ->0x00
				vd_input_tclMain::m_u8INC_msg_buff[6] = EV_KEY; //Event Type Byte2 -> 0x01 for Key Event type
				vd_input_tclMain::m_u8INC_msg_buff[7] = puchData[4]; //Event Code Byte1-> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[8] = puchData[5]; //Event Code Byte 2-> Key Codes 0 - 9
				vd_input_tclMain::m_u8INC_msg_buff[9] = NULL_BYTE;//Key value pressed/Released Byte 1 -> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[10] = NULL_BYTE;//Key value pressed/Released Byte 2 -> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[11] = NULL_BYTE;//Key value pressed/Released Byte 3 -> 0x00
				vd_input_tclMain::m_u8INC_msg_buff[12] = puchData[3];//Key value pressed/Released Byte 4-> 1-Press 0- Release

				//For testing purpose ++
				ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_SWCKEY Message format start = -->["));
				for(int i = 0; i<=12; i++)
					ETG_TRACE_USR4((" Byte%x | %x, ", i, vd_input_tclMain::m_u8INC_msg_buff[i]));
				ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_SWCKEY Message format End = ]<--"));
				//For testing purpose --
				if((_poMainAppInstance->pointerToAdaptor())!=NULL)
				{
					//Send data via adaptor and store return status, ret staus can be used for validation later or removed
					int retStatus=(_poMainAppInstance->pointerToAdaptor())->sendMessage(&vd_input_tclMain::m_u8INC_msg_buff[0], 13);
					ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_SWCKEY::After Call:sendMessage(&vd_input_tclMain::m_u8INC_msg_buff[0], 13), retStatus=%d", retStatus));
				}
			}//End of if for Simulation enable check
	#else
				//Key Events will be routed to uInput driver
				tU16 Keycode = ( (puchData[4]<<8) | puchData[5] );
				tS32 Value = puchData[3];
				ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_SWC_KEY::KeyCode: %d, Status: %d", Keycode, Value));
				// Call Method of Main class to simulate Key
				_poMainAppInstance->simulateKey(Keycode, Value);
	#endif
		}
		break;
		case VD_INPUT_POSTCMDSIMULATE_JOYSTICK_KEY:
		{
			//Key Events will be routed to uInput driver
			tU16 Keycode = ( (puchData[4]<<8) | puchData[5] );
			tS32 Value = puchData[3];
			ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_JOYSTICK_KEY::KeyCode: %d, Status: %d", Keycode, Value));
			// Call Method of Main class to simulate Key
			_poMainAppInstance->simulateKey(Keycode, Value);
		}
		break;
		case VD_INPUT_POSTCMDSIMULATE_TOUCH:
		{ //Touch simulation will be routed to uInput Driver
	#ifndef __INPUT_INC_TESTING__
			tS32 X,Y,Status,SlotId=0;
			X= CONVERT_S32(puchData[4], puchData[5], puchData[6], puchData[7]);
			Y= CONVERT_S32(puchData[8], puchData[9], puchData[10], puchData[11]);
			Status = puchData[3];
			ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_TOUCH::Touch{X,Y,Status} = [%d, %d, %d]", X, Y, Status));

			_poMainAppInstance->simulateTouch(X, Y, SlotId, Status); //Pass the event to uInput for injection
	#endif
		}
		break;
		case VD_INPUT_POSTCMDSIMULATE_ENCODER:
		{
	#ifdef __INPUT_INC_TESTING__
			vd_input_tclMain::m_u8INC_msg_buff[0] = CID;//Component Id -> 0x14
			vd_input_tclMain::m_u8INC_msg_buff[1] = NULL_BYTE;//Message Id Byte1-> 0x00 
			vd_input_tclMain::m_u8INC_msg_buff[2] = NULL_BYTE;//Message Id Byte2-> 0x00
			vd_input_tclMain::m_u8INC_msg_buff[3] = MSGID_ENCODER; //Message Id Byte3-> 0x53
			vd_input_tclMain::m_u8INC_msg_buff[4] = 0x01; //Ev.Num -> Explains no of events occur 0x01 for Encoder
			vd_input_tclMain::m_u8INC_msg_buff[5] = NULL_BYTE; //Event Type Byte1 ->0x00
			vd_input_tclMain::m_u8INC_msg_buff[6] = EV_REL; //Event Type Byte2 -> 0x02 for Event type	Encoder
			vd_input_tclMain::m_u8INC_msg_buff[7] = NULL_BYTE;
			vd_input_tclMain::m_u8INC_msg_buff[8] = puchData[3]; //Value from TTFIS 0x06 for ENCODER_HWHEEL,0x08 for  ENCODER_WHEEL
			vd_input_tclMain::m_u8INC_msg_buff[9] = puchData[4]; //No of turns Byte 1->0x00
			vd_input_tclMain::m_u8INC_msg_buff[10] = puchData[5]; //No of turns Byte 1->0x00
			vd_input_tclMain::m_u8INC_msg_buff[11] = puchData[6]; //No of turns Byte 1->0x00
			vd_input_tclMain::m_u8INC_msg_buff[12] = puchData[7]; // +/- value from TTFIS indicating no of rotations clock/anti-cloc wise direction 
			
			//For testing purpose ++
			ETG_TRACE_USR4(("Message format start = -->["));
			for(int i = 0; i<=12; i++)
				ETG_TRACE_USR4((" Byte%d | %x, ", i, vd_input_tclMain::m_u8INC_msg_buff[i]));					
			ETG_TRACE_USR4(("Message format End = ]<--"));
			tS32 result=CONVERT_S32(vd_input_tclMain::m_u8INC_msg_buff[9],vd_input_tclMain::m_u8INC_msg_buff[10],vd_input_tclMain::m_u8INC_msg_buff[11],\
						vd_input_tclMain::m_u8INC_msg_buff[12]);
			ETG_TRACE_USR4(("Encoder value = %d",result));	
			//For testing purpose --
			
			if((_poMainAppInstance->pointerToAdaptor())!=NULL)
			{
				//Send data via adaptor and store return status, ret staus can be used for validation later or removed
				int retStatus=(_poMainAppInstance->pointerToAdaptor())->sendMessage(&vd_input_tclMain::m_u8INC_msg_buff[0], 13); 
				ETG_TRACE_USR4(("vd_input_POSTCMDSIMULATE_ENCODER::After Call:sendMessage(&vd_input_tclMain::m_u8INC_msg_buff[0], 13), retStatus=%d", retStatus));
			}
	#else
			//Key Events will be routed to uInput driver
			tU16 EncoderType = puchData[3];
			tS32 Steps = CONVERT_S32(puchData[4], puchData[5], puchData[6], puchData[7]);
			ETG_TRACE_USR4(("VD_INPUT_POSTCMDSIMULATE_SWC_KEY::KeyCode: %d, Status: %d", EncoderType, Steps));
			// Call Method of Main class to simulate Key
			_poMainAppInstance->simulateEncoder(EncoderType, Steps);
	#endif

		}
		break;
		case VD_INPUT_READ_KDS:
		{
			ETG_TRACE_USR4(("vd_input_tclMain::vHandleTraceMessageGen for read KDS entered."));
			_poMainAppInstance->readKDS();

		}
		break;
      case VD_INPUT_FORWARD_CONSOLE_KEY_OUTPUT_TO_TTFIS:
      {
         ETG_TRACE_USR4(("console output will be forwarded to TTFis"));
         switch ((InputEventType) puchData[3])
         {
            case INPUT_EVENT_KEY_MATRIX:
            {
               if (ACTIVATE_INPUT_EVENT==(InputEventSwitch)puchData[4])
               {
                  ETG_TRACE_USR4(("command is not yet completly available ! output don't contain the complete dump"));
                  system (" tcpdump -i inc-scc |grep --line-buffered ff14  | /opt/bosch/base/bin/stdout_to_ttfis_out.out &");
//                  system("evtest /dev/input/event0 | /opt/bosch/base/bin/stdout_to_tttfis_out.out &"); //this don't work
               }
               else
               {
                  ETG_TRACE_USR4(("deactivation is not yet available !"));
               }
               break;
            }
            case INPUT_EVENT_SYSTEM_KEY:
            {
               ETG_TRACE_USR4(("command is not yet completly available ! output don't contain the complete dump"));
               system (" tcpdump -i inc-scc |grep --line-buffered ff14  | /opt/bosch/base/bin/stdout_to_ttfis_out.out &");

               break;
            }
            case INPUT_EVENT_CAR_BUS:
            {
               ETG_TRACE_USR4(("command is not yet completly available ! output don't contain the complete dump"));
               system (" tcpdump -i inc-scc |grep --line-buffered ff14  | /opt/bosch/base/bin/stdout_to_ttfis_out.out &");
               break;
            }
            case INPUT_ALL_EVENTS:
            {
               ETG_TRACE_USR4(("command is not yet completly available ! output don't contain the complete dump"));
               system (" tcpdump -i inc-scc |grep --line-buffered ff14  | /opt/bosch/base/bin/stdout_to_ttfis_out.out &");

               break;
            }
            default:
               break;
         }

      }
         break;
      case VD_INPUT_TEST_KEYCONFIG:
      {
         ETG_TRACE_FATAL(("Command: VD_INPUT_TEST_KEYCONFIG to test Key Mapping Configuration\n"));
         _poMainAppInstance->printTargetConfiguredKeyList();

      }
      break;
      case VD_INPUT_SIMULATE_TOUCH_SLIDE:
      {
	#ifndef __INPUT_INC_TESTING__
        	  tU16 X1, Y1, X2, Y2, duration;
        	  X1=0;Y1=0;X2=0,Y2=0;duration=0;
        	  X1=(puchData[3]<<8| puchData[4]);
        	  Y1=(puchData[5]<<8| puchData[6]);
        	  X2=(puchData[7]<<8| puchData[8]);
        	  Y2=(puchData[9]<<8| puchData[10]);
        	  duration=(puchData[11]<<8| puchData[12]);
			  ETG_TRACE_USR4(("VD_INPUT_SIMULATE_TOUCH_SLIDE Start=[%d, %d] END=[%d,%d] and duration = %d",X1,Y1,X2,Y2,duration));

			  _poMainAppInstance->simulateTouchSlide(X1, Y1, X2, Y2, duration);
	#endif

      }
      break;

      case VD_INPUT_SIMULATE_PIVITOUCH_SLIDE:
            {
      	#ifndef __INPUT_INC_TESTING__
              	  tU16 X1, Y1, X2, Y2, duration;
              	  X1=0;Y1=0;X2=0,Y2=0;duration=0;
              	  X1=(puchData[3]<<8| puchData[4]);
              	  Y1=(puchData[5]<<8| puchData[6]);
              	  X2=(puchData[7]<<8| puchData[8]);
              	  Y2=(puchData[9]<<8| puchData[10]);
              	  duration=(puchData[11]<<8| puchData[12]);
      			  ETG_TRACE_USR4(("VD_INPUT_SIMULATE_TOUCH_SLIDE Start=[%d, %d] END=[%d,%d] and duration = %d",X1,Y1,X2,Y2,duration));

      			  _poMainAppInstance->simulateTouchSlide(X1, Y1, X2, Y2, duration,2);
      	#endif

            }
            break;

      case VD_INPUT_START_OBSERVER:
      {
    	  ETG_TRACE_USR4(("CMD VD_INPUT_START_OBSERVER : Enabling Event Observer "));
    	  _poMainAppInstance->EnableEventObserver();
      }
      break;
      case VD_INPUT_STOP_OBSERVER:
      {
    	  ETG_TRACE_USR4(("CMD VD_INPUT_STOP_OBSERVER : Request to Stop Event Observer "));
    	  _poMainAppInstance->DisableEventObserver();
      }
      break;
      case VD_INPUT_EV_RECORD:
      {
    	  tU8 u8StartStop = puchData[3];
    	  tChar strFileName[51]={0};
          const tChar* pString2 = (const tChar*)&puchData[5];
          OSAL_szStringNCopy(strFileName, pString2, 50);

    	  ETG_TRACE_USR4(("CMD VD_INPUT_EV_RECORD : Record Status = %d ",u8StartStop));

    	  tBool status = _poMainAppInstance->_poUsrActionEmu->record(u8StartStop, std::string(strFileName));
      	  if(FALSE==status)
      		  ETG_TRACE_FATAL(("Error In record = %d , from file %s\n",status, strFileName));

      }
      break;
      case VD_INPUT_EV_REPLAY:
      {
    	  tU8 u8StartStop = puchData[3];
    	  tChar strFileName[51]={0};	//Coverity Issue-> strncpy for size =50 CID:18583
          const tChar* pString2 = (const tChar*)&puchData[5];
          OSAL_szStringNCopy(strFileName, pString2, 50);
    	  ETG_TRACE_USR4(("CMD VD_INPUT_EV_REPLAY : REPLAY Status = %d ",u8StartStop));

    	  tBool status = _poMainAppInstance->_poUsrActionEmu->replay(u8StartStop, std::string(strFileName));
    	  if(FALSE==status)
    	  	ETG_TRACE_FATAL(("Error In replay = %d, from file %s\n",status,strFileName));

      }
      break;
      case VD_INPUT_PIVI_TOUCH:
      {
		tS32 X, Y, Status, Screen_no;
		tS32 SlotId=0;

		X= CONVERT_S32(puchData[5], puchData[6], puchData[7], puchData[8]);
		Y= CONVERT_S32(puchData[9], puchData[10], puchData[11], puchData[12]);
		Screen_no=puchData[3];
		Status = puchData[4];
		ETG_TRACE_FATAL(("VD_INPUT_PIVI_TOUCH::Simulated Touch AT : {Screen_no=%d, Status=%d, X=%d, Y=%d}",Screen_no, Status, X, Y));

		_poMainAppInstance->simulateTouch(X, Y,SlotId, Status, Screen_no); //Screen_no=1 for seat0 and 2 for Seat 1
      }
      break;
      default:
         vd_input_tclMain::vHandleTraceMessage(puchData);
         break;
   }
   // vd_input_tclMainFunction: user specific code start
   // vd_input_tclMainFunction: user specific code end

   return;
}
// vd_input_tclMainFile: user specific code start

// vd_input_tclMainFile: user specific code end
