/*******************************************************************************
 * FILE        :  vd_inputTraceIds.h
 * DESCRIPTION :  Generated trace command header file
 *******************************************************************************/

#ifndef _VD_INPUTTRACEIDS_H_
#define _VD_INPUTTRACEIDS_H_

#define VD_INPUT_CMDHELP                                   0x0064
#define VD_INPUT_TRACEINFO                                 0x0065
#define VD_INPUT_POSTBROADCASTCMD                          0x0066
#define VD_INPUT_POSTBROADCASTCMDPARAM                     0x0067
#define VD_INPUT_POSTCMDTOCLASS                            0x0068
#define VD_INPUT_POSTCMDSIMULATE_HARDKEY                   0x0069
#define VD_INPUT_POSTCMDSIMULATE_SYSTEMKEY				   0x0070
#define VD_INPUT_POSTCMDSIMULATE_SWCKEY					   0x0071

#define VD_INPUT_POSTCMDSIMULATE_TOUCH	                   0x0072
#define VD_INPUT_POSTCMDSIMULATE_ENCODER                   0x0073
#define VD_INPUT_READ_KDS                                  0x0074
#define VD_INPUT_FORWARD_CONSOLE_KEY_OUTPUT_TO_TTFIS       0x0075
#define VD_INPUT_TEST_KEYCONFIG                          0x0076
#define VD_INPUT_ENABLE_SIMULATION				   		   0x0077
#define VD_INPUT_DISABLE_SIMULATION					       0x0078
#define VD_INPUT_SIMULATE_TOUCH_SLIDE					   0x0079
#define VD_INPUT_START_OBSERVER							   0x0080
#define VD_INPUT_STOP_OBSERVER							   0x0081
#define VD_INPUT_POSTCMDSIMULATE_JOYSTICK_KEY			   0x0082
#define VD_INPUT_EV_RECORD								   0x0083
#define VD_INPUT_EV_REPLAY								   0x0084
//Alok++
#define VD_INPUT_PIVI_TOUCH								   0x0085
#define VD_INPUT_SIMULATE_PIVITOUCH_SLIDE                  0x0086
//Alok--
#define SCC_INPUT_DEVICE 0x14
#define CID SCC_INPUT_DEVICE
#define NULL_BYTE 0x00

// first parameter for VD_INPUT_FORWARD_CONSOLE_KEY_OUTPUT_TO_TTFIS
typedef enum {
   INPUT_EVENT_KEY_MATRIX = 0,
   INPUT_EVENT_SYSTEM_KEY,
   INPUT_EVENT_CAR_BUS,
   INPUT_ALL_EVENTS
} InputEventType;

// second parameter for VD_INPUT_FORWARD_CONSOLE_KEY_OUTPUT_TO_TTFIS
typedef enum {
   DEACTIVATE_INPUT_EVENT = 0,
   ACTIVATE_INPUT_EVENT
} InputEventSwitch;

/*List of Macros for Different Variant types 
 like Skoda, Seat, VW*/
typedef enum {
   E_BRAND_NONE = 0,
   E_BRAND_SKODA,
   E_BRAND_VW,
   E_BRAND_SEAT
} E_BRAND_NAME;

/*Macros for Input Device Types Information 
 like hardkey, encoder, touch*/

#define MSGID_HDC_HK				0x51
#define MSGID_ENCODER			0x53
#define MSGID_TOUCH				0x55 //to be confirmed
#define MSGID_SYSTEM_KEY      0x57
#define MSGID_SWC_KEY      0x59
// Macros to tell Event type
#define EV_KEY			0x01	//Used for Hard Key 
#define EV_REL			0x02	//Used for Encoder
#define EV_ABS			0x03	//Used for Touch
#define ABS_X			0x00	
#define ABS_Y			0x01
#define ABS_TOUCH 		0x02 //Dont care value
/* Macros to tell type of encoder */
#define ENCODER_WHEEL 0x06
#define ENCODER_HWHEEL 0x08

#endif // VD_INPUTTRACEIDS
