/*****************************************************************************
* FILE:         vd_inputMain.cpp
* PROJECT:      G3G project
* SW-COMPONENT: __COMPONENT__
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA main class based on ahl_tclBaseOneThreadApp
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) __YEAR__ Robert Bosch GmbH, Hildesheim
*****************************************************************************/


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#include "vd_inputMain.h"
#include "vd_inputMainGenTtfisCmd.h" //For Macro and Enum defination

#include "KeyMapping/ConfigurationDataHandler.h"
#include "KeyMapping/Input_DiagSystemSetListener.h"

//initializing static variable with Skoda variant
tU32 vd_input_tclMain::m_u32VariantType = E_BRAND_SKODA; 
tUChar vd_input_tclMain::m_u8INC_msg_buff[MAX_MSG_SIZE]={0};

// vd_input_tclMainIncludes: user specific code start
#include "vd_input_INCAdapter.h" //for creating adaptor class object
#include "CcaServiceHdl/vd_input_StatusServiceHandler.h"

#include"SimulationApp/TouchSimApp.h"
#include"SimulationApp/KeySimApp.h"
#include"SimulationApp/EncSimApp.h"
#include"EvDataManager/EvObserver/EventObserver.h"
#include"EvDataManager/EvObserver/UsrActionEmu.h"
// vd_input_tclMainIncludes: user specific code end

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/vd_inputMain.cpp.trc.h"
#endif


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define HANDLE_DELETE(poClass)   if(poClass) { delete poClass; poClass = NULL;}

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/

// Static self reference to be used in function callbacks.
vd_input_tclMain* vd_input_tclMain::_poMainAppInstance = NULL;

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
* FUNCTION   : vd_input_tclMain::theServer()
* DESCRIPTION: Creates new server object by using the singleton pattern.
* PARAMETER  : None.
* RETURNVALUE: Pointer to the instance of this application.
*******************************************************************************/
vd_input_tclMain* vd_input_tclMain::theServer()
{
   if ( NULL == _poMainAppInstance )
   {
      _poMainAppInstance = new vd_input_tclMain();
   }
   return _poMainAppInstance;
}
   

/*******************************************************************************
*
* FUNCTION: vd_input_tclMain::vd_input_tclMain()
*
* DESCRIPTION: Constructor.
*
*              Initialize static self reference to be used in function
*              callbacks.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_input_tclMain::vd_input_tclMain():ahl_tclBaseOneThreadApp(CCA_C_U16_APP_VD_INPUT)
{
   ETG_TRACE_USR4(("vd_input_tclMain() entered."));
   vd_input_tclMain::_poMainAppInstance   = this;

   // ------------vd_input_tclMainConstructor: user specific code start---------------------

   pCcaServiceHdl = OSAL_NEW vd_input_StatusServiceHandler(this, (tU16)VD_SERVICE_ID, VD_INPUT_FI_MAJOR_VERSION, VD_INPUT_FI_MINOR_VERSION);
   vd_input_NULL_POINTER_CHECK(pCcaServiceHdl);
   vAddObj(pCcaServiceHdl);
   _mU8BrandType = 0;
   _mU8DisplayOrientation = 2;
   //pvd_input_INCAdapter = OSAL_NEW vd_input_INCAdapter(); //Creating vd_input adaptor object

   vd_input_tclMain::clearINCBuffer(); //calling this to initialise buffer

   // ------------vd_input_tclMainConstructor: user specific code end------------------------

   _hWorkerMsgQueue                    = OSAL_C_INVALID_HANDLE;
   _bTerminate                         = FALSE;
   _tThreadID                          = 0;

   vTracePlugIn();
   _tpTouchSimApp = NULL;
   _tpTouchSimApp_Secondary = NULL;
   _tpKeySimApp = NULL;
   _tpEncSimApp = NULL;

   _poEventObserver = NULL;
   _poUsrActionEmu = NULL;

   m_poServiceDiaglib = NULL;
   m_poSystemSetListener = NULL;
}

/*******************************************************************************
*
* FUNCTION: vd_input_tclMain::~vd_input_tclMain()
*
* DESCRIPTION: Destructor.
*
*              Invalidate static self reference.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_input_tclMain::~vd_input_tclMain()
{
   ETG_TRACE_USR4(("~vd_input_tclMain() entered."));
   // --- unplug TTFIS trace ---
   vTraceUnplug();   

   // vd_input_tclMainDestructor: user specific code start
	vd_input_tclMain::_poMainAppInstance = NULL;

	vd_input_NULL_POINTER_CHECK(pCcaServiceHdl);
	vRemoveObj(pCcaServiceHdl);
	HANDLE_DELETE(pCcaServiceHdl);

	vd_input_NULL_POINTER_CHECK(_tpKeySimApp);
	vRemoveObj(_tpKeySimApp);
	HANDLE_DELETE(_tpKeySimApp);

	vd_input_NULL_POINTER_CHECK(_tpEncSimApp);
	vRemoveObj(_tpEncSimApp);
	HANDLE_DELETE(_tpEncSimApp);

	vd_input_NULL_POINTER_CHECK(_tpTouchSimApp);
	vRemoveObj(_tpTouchSimApp);
	HANDLE_DELETE(_tpTouchSimApp);
	//Alok++
	vd_input_NULL_POINTER_CHECK(_tpTouchSimApp_Secondary);
	vRemoveObj(_tpTouchSimApp_Secondary);
	HANDLE_DELETE(_tpTouchSimApp_Secondary);
	//Alok--
	vd_input_NULL_POINTER_CHECK(_poEventObserver);
	vRemoveObj(_poEventObserver);
	HANDLE_DELETE(_poEventObserver);

	vd_input_NULL_POINTER_CHECK(_poUsrActionEmu);
	vRemoveObj(_poUsrActionEmu);
	HANDLE_DELETE(_poUsrActionEmu);

	HANDLE_DELETE(m_poServiceDiaglib);
	HANDLE_DELETE(m_poSystemSetListener);
	//HANDLE_DELETE(pvd_input_INCAdapter);
   // vd_input_tclMainDestructor: user specific code end

}

/*******************************************************************************
*
* FUNCTION: tBool vd_input_tclMain::bOnInit()
*
* DESCRIPTION: This function is called by the CCA framework before starting any
*              CCA message related communication action. As default this
*              function always returns TRUE. The user has to implement all his
*              local application initialization (create client and service
*              handler, create worker threads, allocate application memory,...).
*              If returns TRUE, initialization could be successfully performed
*              and framework will register application, else, a reset of the
*              system is forced immediately.
*
*              This function is the counterpart of vOnApplicationClose().
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = Application successfully initialized.
*              FALSE = Application NOT successfully initialized.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
*******************************************************************************/
tBool vd_input_tclMain::bOnInit()
{
   tBool bSuccess = TRUE;

   ETG_TRACE_USR4(("bOnInit() entered."));

	// vd_input_tclMainbOnInit: user specific code start
	// create diaglib-service
	m_poServiceDiaglib = new diaglib::tclServiceDiaglib(this, 0x01);
	if (NULL == m_poServiceDiaglib)
	{
		bSuccess = FALSE;
		NORMAL_M_ASSERT_ALWAYS();
	}
	else
	{
		ETG_TRACE_FATAL(("bOnInit() - DIAGLib service created"));

		diaglib::tclSystemSetIF* poSystemSetIF;

		// Get SystemSet Interface (the referenced IF-object will be created within diaglib)
		// so it is no problem that the pointer is destroyed here when leaving the scope here
		poSystemSetIF = m_poServiceDiaglib->poGetSysSet();

		// create our listener object here
		m_poSystemSetListener = new Input_tclSystemSetListener(poSystemSetIF, this);

		// register our listeners at DIAGlib
		if (m_poSystemSetListener != NULL)
		{
		   poSystemSetIF->vRegisterListener(SYSSETID_INPUT, diaglib::EN_TYPE_CODING, m_poSystemSetListener );
		   poSystemSetIF->vRegisterListener(SYSSETID_INPUT, diaglib::EN_TYPE_DEFAULT_TEF, m_poSystemSetListener );
		
		   ETG_TRACE_FATAL(("bOnInit() - DIAG SystemSet Listener registered"));
		}
		else
		{
		   ETG_TRACE_FATAL(("bOnInit() - ERROR - DIAG SystemSet Listener could not be registered"));
		}
	}

	// Reading KDS and writing into PDD on Startup
	ConfigurationDataHandler oConfigurationDataHandler;
	oConfigurationDataHandler.makeKeyMappingForV850Available();
	_mU8BrandType = oConfigurationDataHandler.getBrandType();
	_mU8DisplayOrientation = oConfigurationDataHandler.getDisplayOrientationType();
	_tpKeySimApp = new KeySimApp(this);
	vd_input_NULL_POINTER_CHECK_VAL(_tpKeySimApp);
	vAddObj(_tpKeySimApp);

	_tpEncSimApp = new EncSimApp(this);
	vd_input_NULL_POINTER_CHECK_VAL(_tpEncSimApp);
	vAddObj(_tpEncSimApp);

	std::string Touch1_DeviceName("uinput-Touch1");
	_tpTouchSimApp = new TouchSimApp(this, Touch1_DeviceName);
	vd_input_NULL_POINTER_CHECK_VAL(_tpTouchSimApp);
	vAddObj(_tpTouchSimApp);
	std::string Touch2_DeviceName("uinput-Touch2");
	_tpTouchSimApp_Secondary = new TouchSimApp(this, Touch2_DeviceName);
	vd_input_NULL_POINTER_CHECK_VAL(_tpTouchSimApp_Secondary);
	vAddObj(_tpTouchSimApp_Secondary);
	//Event Observer to record input events
	_poEventObserver = new EventObserver(this);
	vd_input_NULL_POINTER_CHECK_VAL(_poEventObserver);
	vAddObj(_poEventObserver);
	//Guesture Simulator
	_poUsrActionEmu = new UsrActionEmu(this);
	vd_input_NULL_POINTER_CHECK_VAL(_poUsrActionEmu);
	vAddObj(_poUsrActionEmu);
   // vd_input_tclMainbOnInit: user specific code end

	vGetReferences();

	vCreateWorkerThread();

    vStartCommunication();

   return bSuccess;
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_input_tclMain::vOnApplicationClose()
*
* DESCRIPTION: This function is called by the CCA framework to indicate the
*              imminent shutdown of the application. The user has to implement
*              the de-initialization of all his local application data (destroy
*              client and service handler, destroy worker threads, free
*              application memory, ... ). After this function call the
*              destructor of this application will be called.
*
*              This function is the counterpart of bOnInit().
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
*******************************************************************************/
tVoid vd_input_tclMain::vOnApplicationClose()
{
   ETG_TRACE_USR4(("vOnApplicationClose() entered."));

   _bTerminate = TRUE;

   ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_input_tclMain::vCreateWorkerThread(tVoid)
*
* DESCRIPTION: Worker thread will only be supported if configured.
*
* PARAMETER: None
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_input_tclMain::vCreateWorkerThread(tVoid)
{
   ETG_TRACE_USR4(("vd_input_tclMain::vCreateWorkerThread() entered."));
   OSAL_trThreadAttribute  rThAttr;

   tU32 u32ThreadPrio = 120;
   tU32 u32ThreadStack = 2048;
   tChar szName[32] = "NOIOSC_vd_input_WORKER";
   
   // create msgbox
   if( OSAL_ERROR == OSAL_s32MessageQueueCreate(szName,
      20,
      sizeof(Ivd_inputBase::TMsg),
      OSAL_EN_READWRITE, &_hWorkerMsgQueue)
      )
   {
      _hWorkerMsgQueue=OSAL_C_INVALID_HANDLE;
   }
   
   
   // setup thread
   _bTerminate = FALSE;
   
   //get thread prio
   //todo
   rThAttr.szName       = const_cast<tString>("vd_input_WORKER");
   rThAttr.u32Priority  = u32ThreadPrio;
   rThAttr.s32StackSize = u32ThreadStack;
   rThAttr.pfEntry      = (OSAL_tpfThreadEntry)dwThreadWork; 
   rThAttr.pvArg        = (tPVoid)this;

   // create thread suspended
   _tThreadID = OSAL_ThreadSpawn( &rThAttr );
   if(_tThreadID == OSAL_ERROR)
   {
      ETG_TRACE_FATAL(("vd_input_tclMain::vCreateWorkerThread(): Failed to create worker thread."));
   }

   return;


}

/*******************************************************************************
*
* FUNCTION: tVoid vd_input_tclMain::dwThreadWork( tPVoid pvArg )
*
* DESCRIPTION: Worker thread will only be supported if configured.
*
* PARAMETER: pointer to main class object
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_input_tclMain::dwThreadWork( tPVoid pvArg )
{
   ETG_TRACE_USR4(("vd_input_tclMain::dwThreadWork() entered."));

   vd_input_tclMain*  poMain = (vd_input_tclMain*)pvArg;
   tS32      s32Ret;
   
   Ivd_inputBase::TMsg tMyMsg;
   tU32		 u32Prio;
   tU32		 u32MsgMax, u32MaxLen, u32MsgCount;

   while(!(poMain->_bTerminate))
   {
      if (OSAL_OK != OSAL_s32MessageQueueStatus(poMain->_hWorkerMsgQueue, &u32MsgMax, &u32MaxLen, &u32MsgCount)) {
      }
      if (u32MsgCount == 0) {
         //no more message in queue -> all current substate updates consumed
      }

      s32Ret = OSAL_s32MessageQueueWait(
         poMain->_hWorkerMsgQueue,
         (tU8*)&tMyMsg, /*pointer of the MsgHandle field*/
         sizeof(Ivd_inputBase::TMsg),
         &u32Prio, 
         OSAL_C_U32_INFINITE
         );

      if (!(poMain->_bTerminate) && (s32Ret != OSAL_ERROR)) {
         ETG_TRACE_USR4(("vd_input_tclMain::dwThreadWork(): New message received: %u -> data: %d.", ETG_ENUM(vd_input_INT_MSG , (tU32)tMyMsg.eCmd), tMyMsg.u.u32Data));
         poMain->vDispatchInternalMsg(&tMyMsg);
      }

   }

   OSAL_vThreadExit();
   return;


}

/*******************************************************************************
*
* FUNCTION: tVoid vd_input_tclMain::vOnTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called by the CCA framework on the expiration
*              of a previously via function bStartTimer() started timer. The
*              expired timer is forwarded to the respective service or
*              client-handler via a call of vProcessTimer().
*
*              The function is called from this applications context and
*              therefore no interthread programming rules must be considered
*              and the application methods and/or member variables can be
*              accessed without using the static self reference
*              'm_poMainAppInstance'.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tVoid vd_input_tclMain::vOnTimer(tU16 u16TimerId)
{
   ETG_TRACE_USR4(("vOnTimer() entered."));
   (tVoid)u16TimerId; //lint warning fix
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_input_tclMain::vOnLoopback
*                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called by the CCA framework if a message was
*              sent from one if this applications services or from a
*              callback-handler of this application (so called self or loopback
*              messages). The message can be forwarded to the respective service
*              via a call of vOnLoopbackService(). If there is no service
*              registered for this message then the user has the option to
*              directly evaluate the message in the default block of this.
*              methods switch-clause.
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*
*            [IN] poMessage = Message object.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
*******************************************************************************/
tVoid vd_input_tclMain::vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
   ETG_TRACE_USR4(("vOnLoopback() entered with service ID %04x.", u16ServiceID));
#if 0
   gm_tclU32Message oVisitorMsg(poMessage);

   Ivd_inputBase::TMsg oMsg = {};

   oMsg.eCmd = (Ivd_inputBase::ECmdTypes)poMessage->u16GetFunctionID();
   oMsg.u.u32Data = oVisitorMsg.u32GetDWord();

   ETG_TRACE_USR4(("vOnLoopbackService() entered. iFID = 0x%4x, u32MsgContent = %u.", (tU32)oMsg.eCmd, oMsg.u.u32Data));
   //post message
   vDispatchInternalMsg(&oMsg);
#endif

   switch(u16ServiceID)
   {
       case VD_SERVICE_ID:
       {
          ETG_TRACE_USR4(("vd_input_tclMain->VD_SERVICE_ID :: vOnLoopback() entered. vd_input service"));
           if(NULL != pCcaServiceHdl)
           {
              ETG_TRACE_USR4(("vd_input_tclMain->VD_SERVICE_ID :: vOnLoopback() entered. vd_input Service: call service"));
              pCcaServiceHdl->vOnLoopbackService(poMessage);
           }
           else
           {
              ETG_TRACE_ERR(("vd_input_tclMain :: vOnLoopback() entered. vd_input Service: NULL Pointer"));
               NORMAL_M_ASSERT_ALWAYS();
           }
       }
       break;

       default:
       {
          ETG_TRACE_USR4(("vd_input_tclMain :: vOnLoopback(): service id not supported"));
           // Evaluate your none service related loopback messages here.
       }
       break;
   }

}


tVoid vd_input_tclMain::vDispatchInternalMsg(Ivd_inputBase::TMsg* pInternalMsg)
{
   bpstl::set<Ivd_inputBase*>::iterator iter;
   for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
      // then check for specific implementation
      if (pInternalMsg->strClassName[0] != 0) 
      {
         if (0 == OSAL_s32StringCompare((*iter)->getIfName(), pInternalMsg->strClassName)) {
            (*iter)->vHandleMessage(pInternalMsg);
         }
      } else {
         (*iter)->vHandleMessage(pInternalMsg);
      }
   }

}

tVoid vd_input_tclMain::vPostInternalMessage(Ivd_inputBase::TMsg* pInternalMsg)
{
   ETG_TRACE_USR1(("vd_input_tclMain::vPostInternalMessage(): post internal message '%d'.", pInternalMsg->eCmd));

   if (_hWorkerMsgQueue == OSAL_C_INVALID_HANDLE) {
      gm_tclU32Message oExampleMsg(u16GetAppId(), u16GetAppId(), 0, 0, 0, (tU16)pInternalMsg->eCmd, AMT_C_U8_CCAMSG_OPCODE_STATUS );
      oExampleMsg.vSetDWord(pInternalMsg->u.u32Data);  
      if ( oExampleMsg.bIsValid() ) {
         if (enPostMessage(&oExampleMsg, TRUE) != AIL_EN_N_NO_ERROR) {  
            NORMAL_M_ASSERT_ALWAYS();
         }
      } else {  
         NORMAL_M_ASSERT_ALWAYS();
      }
   }
   else  
   {
      tS32	s32Ret = OSAL_s32MessageQueuePost(_hWorkerMsgQueue,
         (tCU8*)pInternalMsg,
         sizeof(Ivd_inputBase::TMsg), 
         OSAL_C_U32_MQUEUE_PRIORITY_HIGHEST);

      if(s32Ret != OSAL_OK){
         ETG_TRACE_FATAL(("vd_input_tclMain::vPostInternalMessage(): post to worker thread failed."));
      }
   }
}

/*******************************************************************************
* FUNCTION   : vd_input_tclMain::vTracePlugIn
* DESCRIPTION: Activate the TTFIS command channel for FC_PDC
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid vd_input_tclMain::vTracePlugIn(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;

   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_KEYBOARD;//Component VDKBD is  used for TTFis interface as it is not part of MIB
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)vd_input_tclMain::vHandleTraceMessageGen;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t) &MyTraceChannel);
      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TracePlugin"));
      }
      // close trace device and clear channel
      OSAL_s32IOClose(desc);	
   }
}

/*******************************************************************************
* FUNCTION   : vd_input_tclMain::vTraceUnplug
* DESCRIPTION: Deactivate the TTFIS command channel for __COMPONENT__
* PARAMETER  : None
* RETURNVALUE: None
*******************************************************************************/
tVoid vd_input_tclMain::vTraceUnplug(tVoid)
{
   OSAL_trIOCtrlLaunchChannel  MyTraceChannel;
   tS32 s32Err;

   OSAL_tIODescriptor desc = OSAL_IOOpen(OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE);
   if (desc != OSAL_ERROR) { 
      MyTraceChannel.enTraceChannel = TR_TTFIS_KEYBOARD;
      MyTraceChannel.pCallback      = (OSAL_tpfCallback)vd_input_tclMain::vHandleTraceMessage ;

      s32Err = OSAL_s32IOControl (desc, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t) &MyTraceChannel);

      if (s32Err == OSAL_OK) {
         //good
      } else {
         //bad
         ETG_TRACE_USR4(("MAIN :: Error TraceUnplug"));
      }

      // close trace device and clear channel
      OSAL_s32IOClose(desc);	
   }
}


tVoid vd_input_tclMain::clearINCBuffer()
{
	//OSAL_pvMemorySet(pvSource, u32Char, u32Bytes)
	OSAL_pvMemorySet( &vd_input_tclMain::m_u8INC_msg_buff[0], 0, MAX_MSG_SIZE);
}
tVoid vd_input_tclMain::readKDS()
{
   ETG_TRACE_USR4(("vd_input_tclMain::readKDS entered."));
   ConfigurationDataHandler oConfigurationHandler;
   oConfigurationHandler.makeKeyMappingForV850Available();
}

tVoid vd_input_tclMain::printTargetConfiguredKeyList()
{
	if(_poEventObserver != NULL)
	{
		tS32 NoOfDevices = _poEventObserver->printVariantSupportedKeyList();
		if(NoOfDevices == 0)
		{
		   ETG_TRACE_FATAL(("VD_INPUT_KEYCONFIG: NO Supported Devices Found"));
		}
	}
}

tVoid vd_input_tclMain::EnableEventObserver()
{
	if(_poEventObserver != NULL)
	{
		if( FALSE == _poEventObserver->isObsRunning() ) {
			_poEventObserver->startObserver();
		}
	}
}

tVoid vd_input_tclMain::DisableEventObserver()
{
	if(_poEventObserver != NULL)
	{
		if( TRUE == _poEventObserver->isObsRunning() ) {
			_poEventObserver->stopObserver();
		}
	}
}

tU8 vd_input_tclMain::getKeyDeviceType(tU16 Keycode)
{
	return( (tU8) (_tpKeySimApp->selectKeyDevice(Keycode)) );
}

tBool vd_input_tclMain::simulateKey(tU16 Keycode, tS32 Status)
{
	tBool bSuccess = FALSE;

	if(_tpKeySimApp != NULL)
	{
		bSuccess = _tpKeySimApp->simulateKey((E_UINPUT_EVENT_TYPE)getKeyDeviceType(Keycode), Keycode, Status);
	}
	return bSuccess;
}

tBool vd_input_tclMain::simulateEncoder(tU16 EncType, tS32 Steps)
{
	tBool bSuccess = FALSE;
	if(_tpEncSimApp != NULL)
	{
		bSuccess = _tpEncSimApp->simulateEncoderRotation(EncType, Steps);
	}
	return bSuccess;
}

tBool vd_input_tclMain::simulateTouch(tS32 X, tS32 Y, tS32 SlotId, tS32 Status,tS32 Screen_No)
{
	tBool bSuccess = FALSE;
	switch(Screen_No)
	{
		case 1:
		{
			if(_tpTouchSimApp != NULL)
				{
						_tpTouchSimApp->simulateSingleTouch(X, Y ,SlotId, Status);
						bSuccess = TRUE;
				}
		}
		break;
		case 2:
		{
			if(_tpTouchSimApp_Secondary != NULL)
				{
					_tpTouchSimApp_Secondary->simulateSingleTouch(X, Y ,SlotId, Status);
					bSuccess = TRUE;
				}

		}
		break;
		default:
		{
			//do nothing
		}
		break;
	}


	return bSuccess;
}

tBool vd_input_tclMain::simulateTouchSlide(tS32 StartX, tS32 StartY, tS32 EndX, tS32 EndY, tS32 Speed, tS32 Screen_No)
{
	tBool bSuccess = FALSE;

	switch(Screen_No)
	{
		case 1:
		{
			if(_tpTouchSimApp != NULL)
			{
				_tpTouchSimApp->_X1 = StartX;
				_tpTouchSimApp->_X2 = EndX;
				_tpTouchSimApp->_Y1 = StartY;
				_tpTouchSimApp->_Y2 = EndY;
				_tpTouchSimApp->_Duration = Speed;
		        //Simulate the Slide guesture
		        bSuccess = _tpTouchSimApp->simulateSlide();
			}
		}
		break;

		case 2:
		{
			if(_tpTouchSimApp_Secondary !=NULL)
			{

				_tpTouchSimApp_Secondary->_X1 = StartX;
				_tpTouchSimApp_Secondary->_X2 = EndX;
				_tpTouchSimApp_Secondary->_Y1 = StartY;
				_tpTouchSimApp_Secondary->_Y2 = EndY;
				_tpTouchSimApp_Secondary->_Duration = Speed;
			    //Simulate the Slide guesture
			    bSuccess = _tpTouchSimApp_Secondary->simulateSlide();
			}
		}
		break;

		default:
		{
		    // do nothing
		}
		break;

		}

	return 	bSuccess;
}
//Alok
tVoid vd_input_tclMain::printTouchDiagList()
{
	Touchlist* tTouchlist = _poEventObserver->getTouchInfoList();
	vd_input_NULL_POINTER_CHECK(tTouchlist);
	Touchlist::iterator tIterator;

	if (FALSE == tTouchlist->empty()) //If List is filled
		{
			ETG_TRACE_FATAL(("vd_inputMain::printTouchDiagList() -> _tTouchlist No Of Entries = %d",tTouchlist->size()));
			//parse the list and check Time with current time
			for (tIterator = tTouchlist->begin(); tIterator != tTouchlist->end(); /**/)
			{

					ETG_TRACE_FATAL((":vd_inputMain: Touch (Slot ID = %d) in PRESSED State at [X(%d), Y(%d)]: Status=(%d) Occurrence Time=%d", tIterator->u8SlotID,
									 tIterator->s32XCoord, tIterator->s32YCoord, tIterator->u8TouchStatus, tIterator->s64EvTime));
					tIterator++; //just move to next element
			}
		}
		else
		{
			ETG_TRACE_FATAL(("EvTouchDataHandler::delObsoleteTouchEntries() -> _tTouchlist No Of Entries = %d",tTouchlist->size()));
		}


}


tVoid vd_input_tclMain::printTouchDiagList_PIVI()
{
	if(_mU8BrandType == 0x02)
	{
		Touchlist* tTouchlist = _poEventObserver->getTouchInfoListPIVISecondary();
		vd_input_NULL_POINTER_CHECK(tTouchlist);
		Touchlist::iterator tIterator;

		if (FALSE == tTouchlist->empty()) //If List is filled
		{
			ETG_TRACE_FATAL(("vd_inputMain::getTouchInfoListPIVISecondary() -> _tTouchlist No Of Entries = %d",tTouchlist->size()));
			//parse the list and check Time with current time
			for (tIterator = tTouchlist->begin(); tIterator != tTouchlist->end(); /**/)
			{

					ETG_TRACE_FATAL((":vd_inputMain: Touch (Slot ID = %d) in PRESSED State at [X(%d), Y(%d)]: Status=(%d) Occurrence Time=%d", tIterator->u8SlotID,
									 tIterator->s32XCoord, tIterator->s32YCoord, tIterator->u8TouchStatus, tIterator->s64EvTime));
					tIterator++; //just move to next element
			}
		}
		else
		{
			ETG_TRACE_FATAL(("EvTouchDataHandler::delObsoleteTouchEntries() -> _tTouchlist No Of Entries = %d",tTouchlist->size()));
		}
	}


}


/*******************************************************************************
*                                       E O F
*******************************************************************************/
