/*
 * TouchSimApp.h
 *
 *  Created on: Aug 17, 2015
 *      Author: sgt4kor
 */

#ifndef TOUCHSIMAPP_H_
#define TOUCHSIMAPP_H_

#include"../Gateway/uInputAdaptor/uInputAdaptor.h"
#include "../vd_inputMain.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

using namespace vd_input_uInputAdaptor;

class TouchSimApp :public Ivd_inputBase{
public:
    //Constructor
	TouchSimApp(vd_input_tclMain* poMain, std::string DeviceName);
	//Destructor
	virtual ~TouchSimApp();
	//Set Of Virtual Functions to be overriden from base class
	virtual const tChar* getName() const {return const_cast<tChar*> (_DeviceName.c_str()); }
	virtual const tChar* getIfName() const {return const_cast<tChar*>(_DeviceName.c_str()); }
	virtual tVoid vHandleMessage(TMsg* pMsg) {(tVoid)pMsg; } //--Lint Prio 2 Fix
	virtual tVoid vGetReferences(){; }
	virtual tVoid vStartCommunication() {; }
	virtual tVoid vTraceInfo(){; }

	//User Specific Code Starts
private:
	uInputAdaptor _TouchInputAdapter;
	std::string _DeviceName;
public:
	int _X1, _Y1;
	int _X2, _Y2;
	int _Duration;

	//Public Methods User Defined
	tBool simulateSingleTouch(int X, int Y, int SlotId, int Status);
	tBool sendInputEvent(struct input_event Event);
	tBool simulateSlide();

	tS32 getUInputFD()
	{
		return _TouchInputAdapter.getFD();
	}
	//User Specific Code Ends
};

#endif /* TOUCHSIMAPP_H_ */
