
/*
 * TouchSimApp.cpp
 *
 *  Created on: Aug 17, 2015
 *      Author: sgt4kor
 */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "TouchSimApp.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../etg_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/TouchSimApp.cpp.trc.h"
#endif

#define STEP_CALCULATION_FACTOR 10
#define MIN_X_VALUE 0
#define MAX_X_VALUE 1280			//Alok changed to 1280 from 800 for PIVI
#define MIN_Y_VALUE 0
#define MAX_Y_VALUE 768				//Alok changed to 768 from 480 for PIVI
#define MAX_NUM_OF_STEPS ( (MAX_X_VALUE>MAX_Y_VALUE) ? (MAX_X_VALUE/STEP_CALCULATION_FACTOR) : (MAX_Y_VALUE/STEP_CALCULATION_FACTOR) )

TouchSimApp::TouchSimApp(vd_input_tclMain* poMain, std::string DeviceName):Ivd_inputBase(poMain), _TouchInputAdapter(E_UINPUT_EV_TOUCH_B, DeviceName)
{
	 _X1=0;
	 _Y1=0;
	 _X2=0,
	 _Y2=0;
	 _Duration=0;
	 _DeviceName = DeviceName;
	 vd_input_NULL_POINTER_CHECK(poMain);

	 if(0x02 == poMain->u8GetBrandType()) //Infinity or PIVI
	 {
		 _TouchInputAdapter.setTouchResolution(1280, 768);
		 if (TRUE == _TouchInputAdapter.configureDevice(E_UINPUT_EV_TOUCH_B) )
			 ETG_TRACE_USR4(("poMain->u8GetBrandType() -> PIVI : Touch Resolution = 1280x768 configured !"));
	 }
	 else if(0x01 == poMain->u8GetBrandType())
	 {
		 // Nissan
		 _TouchInputAdapter.setTouchResolution(800, 480);
		 if (TRUE == _TouchInputAdapter.configureDevice(E_UINPUT_EV_TOUCH_B) )
			 ETG_TRACE_USR4(("poMain->u8GetBrandType() -> AIVI : Brand type=(%d) Touch Resolution = 800x480 configured !",poMain->u8GetBrandType()));
	 }
	 else if(0x00 == poMain->u8GetBrandType())
	 {
		 //Renault
		if(0x00 == poMain->u8getDisplayOrientationType())
		{
			//Renault Resolution = 800 x 480  , Landscape
			_TouchInputAdapter.setTouchResolution(800, 480);
			if (TRUE == _TouchInputAdapter.configureDevice(E_UINPUT_EV_TOUCH_B) )
				ETG_TRACE_USR4(("poMain->u8getDisplayOrientationType() -> AIVI : Orientation type=(%d) Touch Resolution = 800x480 configured !",poMain->u8getDisplayOrientationType()));
		}
		else
		{
			//Renault Resolution = 820 x 1024 for new renault variant, Portrait
			_TouchInputAdapter.setTouchResolution(820, 1024);
			if (TRUE == _TouchInputAdapter.configureDevice(E_UINPUT_EV_TOUCH_B) )
				ETG_TRACE_USR4(("poMain->u8getDisplayOrientationType() -> AIVI : Orientation type=(%d) Touch Resolution = 1024x820 configured !",poMain->u8getDisplayOrientationType()));

		}
	 }
	else
	{
		_TouchInputAdapter.setTouchResolution(800, 480);
		 if (TRUE == _TouchInputAdapter.configureDevice(E_UINPUT_EV_TOUCH_B) )
			 ETG_TRACE_USR4(("poMain->u8GetBrandType() -> AIVI : Brand type=(%d) Touch Resolution = 800x480 configured !",poMain->u8GetBrandType()));
	}

}

TouchSimApp::~TouchSimApp() {
	 _X1=0;
	 _Y1=0;
	 _X2=0,
	 _Y2=0;
	 _Duration=0;
}
//Public User defined Methods

tBool TouchSimApp::simulateSingleTouch(int X, int Y, int SlotID, int Status)
{
	tBool bTouchSuccess = FALSE;
	if(TRUE == _TouchInputAdapter.bIsuInputReady)
	{
		if( 0 != _TouchInputAdapter.sendTouchBEvent(X,Y,SlotID,Status))
		{
			bTouchSuccess = TRUE;
			ETG_TRACE_USR4(("TouchSimApp::simulateSingleTouch->Simulation Success..!"));
		}
		else
		{
			ETG_TRACE_USR4(("TouchSimApp::simulateSingleTouch->Simulation Failure..!"));
		}
	}
	return bTouchSuccess;
}

tBool TouchSimApp::sendInputEvent(struct input_event Event)
{
	tBool bTouchSuccess = FALSE;
	if(TRUE == _TouchInputAdapter.bIsuInputReady)
	{
		if( 0 != _TouchInputAdapter.sendInputEvent(Event))
		{
			bTouchSuccess = TRUE;
			ETG_TRACE_USR4(("TouchSimApp::sendInputEvent->Simulation Success..!"));
		}
		else
		{
			ETG_TRACE_USR4(("TouchSimApp::sendInputEvent->Simulation Failure..!"));
		}
	}
	return bTouchSuccess;
}

tBool TouchSimApp::simulateSlide()
{
	tBool bAnimSuccess = FALSE;
	tS32 XChange = 0;
	tS32 YChange = 0;
	tS32 Move = 0;
	tS32 No_Of_Steps = 0;
	tS32 TotalTime = _Duration;

	if(_X1 < MIN_X_VALUE)
		_X1 = MIN_X_VALUE;
	if(_X1 > MAX_X_VALUE)
		_X1 = MAX_X_VALUE;

	if(_Y1 < MIN_Y_VALUE)
		_Y1 = MIN_Y_VALUE;
	if(_Y1 > MAX_Y_VALUE)
		_Y1 = MAX_Y_VALUE;

	if(_X2 < MIN_X_VALUE)
		_X2 = MIN_X_VALUE;
	if(_X2 > MAX_X_VALUE)
		_X2 = MAX_X_VALUE;

	if(_Y2 < MIN_Y_VALUE)
		_Y2 = MIN_Y_VALUE;
	if(_Y2 > MAX_Y_VALUE)
		_Y2 = MAX_Y_VALUE;

	XChange = abs(_X2 - _X1);
	YChange = abs(_Y2 - _Y1);
    Move =(XChange > YChange)? XChange:YChange;
	No_Of_Steps = (Move==0)? 0:(Move/STEP_CALCULATION_FACTOR);

    ETG_TRACE_USR4(("TouchSimApp::simulateSlide->MAX_NUM_OF_ITERATIONS=%d, XChange = %d, YChange=%d", MAX_NUM_OF_STEPS, XChange, YChange));
    ETG_TRACE_USR4(("TouchSimApp::simulateSlide->Move=%d, No_Of_Steps = %d, TotalTime=%d", Move, No_Of_Steps, TotalTime));

	tS32 eventTimeGap = 0;
    tS32 deltaX=0;
    tS32 deltaY=0;
    tS32 XCoord = _X1;
    tS32 YCoord = _Y1;

    if(TRUE == _TouchInputAdapter.bIsuInputReady)
    {
		if(No_Of_Steps != 0)
		{
			eventTimeGap = TotalTime/No_Of_Steps;
			deltaX = (_X2-_X1); // total signed XChange
			deltaY = (_Y2-_Y1); // total signed YChange
			ETG_TRACE_USR4(("TouchSimApp::simulateSlide->deltaX = %d, deltaY=%d", deltaX, deltaY));
			ETG_TRACE_USR4(("TouchSimApp::simulateSlide->Animation Start---->"));

			for(int i=0; i<No_Of_Steps; i++)  // i=0 gives first touch at Start point, i=No_Of_Steps-1 gives touch at last position before End point
			{

				XCoord = _X1 + (deltaX*i)/No_Of_Steps;
				YCoord = _Y1 + (deltaY*i)/No_Of_Steps;
				_TouchInputAdapter.sendTouchBEvent(XCoord, YCoord, 0, 1);
				usleep((eventTimeGap*1000)); //delay in ms and usleep is microseconds
			}

			//Giving press and release at X2, Y2
			_TouchInputAdapter.sendTouchBEvent(_X2, _Y2, 0, 1);
			usleep(50000); //50 Ms delay
			_TouchInputAdapter.sendTouchBEvent(_X2, _Y2, 0, 0); //Giving released event at end
			bAnimSuccess = TRUE;
			ETG_TRACE_USR4(("TouchSimApp::simulateSlide->Animation Finished---->"));

		}
		else
		{
			//No of steps 0 indicate no slide guesture just a simple touch press and release.
			//Giving press and release at X2, Y2
			_TouchInputAdapter.sendTouchBEvent(_X2, _Y2, 0, 1);
			usleep(50000); //50 Ms delay
			_TouchInputAdapter.sendTouchBEvent(_X2, _Y2, 0, 0); //Giving released event at end
			bAnimSuccess = FALSE;
		}
    }

    return bAnimSuccess;
}

