/*
 * KeySimApp.cpp
 *
 *  Created on: Aug 18, 2015
 *      Author: sgt4kor
 */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "KeySimApp.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../etg_trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/KeySimApp.cpp.trc.h"
#endif
#define RANGE_CHECK(START, END, VALUE) ( ((START)<(VALUE) && (VALUE)<(END))? 1 : 0 )


KeySimApp::KeySimApp(vd_input_tclMain* poMain):Ivd_inputBase(poMain),_KeyInputAdapter_HK(E_UINPUT_EV_HARD_KEY, std::string("uinput-HardKeys")),
_KeyInputAdapter_SWC(E_UINPUT_EV_SWC_KEY, std::string("uinput-SWCKeys")), _KeyInputAdapter_ITCOMM(E_UINPUT_EV_IT_COMMANDER_KEY, std::string("uinput-ItCommKeys")),
_KeyInputAdapter_AllKeys(E_UINPUT_EV_INJECT_KEY, std::string("uinput-ReplayKeyDevice"))
{
	//Configure Hardkey Simulation device
	if( TRUE == _KeyInputAdapter_HK.configureDevice(E_UINPUT_EV_HARD_KEY) )
	{
		ETG_TRACE_USR4(("Constructor KeySimApp::KeySimApp():_KeyInputAdapter_HK(E_UINPUT_EV_HARD_KEY) Success !!"));
	}
	//Configure SWC Simulation device
	if( TRUE == _KeyInputAdapter_SWC.configureDevice(E_UINPUT_EV_SWC_KEY) )
	{
		ETG_TRACE_USR4(("Constructor KeySimApp::KeySimApp():_KeyInputAdapter_SWC(E_UINPUT_EV_SWC_KEY) Success !!"));
	}
	//Configure IT Commander simulation device
	if( TRUE == _KeyInputAdapter_ITCOMM.configureDevice(E_UINPUT_EV_IT_COMMANDER_KEY) )
	{
		ETG_TRACE_USR4(("Constructor KeySimApp::KeySimApp():_KeyInputAdapter_ITCOMM(E_UINPUT_EV_IT_COMMANDER_KEY) Success !!"));
	}
	// Configure Guesture Replay key device and Diagnositcs Key Injection
	if( TRUE == _KeyInputAdapter_AllKeys.configureDevice(E_UINPUT_EV_INJECT_KEY) )
	{
		ETG_TRACE_USR4(("Constructor KeySimApp::KeySimApp():_KeyInputAdapter_AllKeys(E_UINPUT_EV_INJECT_KEY) Success !!"));
	}
}

KeySimApp::~KeySimApp()
{
	ETG_TRACE_USR4(("Destructor KeySimApp::~KeySimApp():_KeyInputAdapter"));
}

tBool KeySimApp::simulateKey(E_UINPUT_EVENT_TYPE eKeyDeviceType, tU16 KeyCode, tS32 Value)
{
	tBool bSimSuccess = FALSE;
	ETG_TRACE_USR4(("KeySimApp::simulateKey %d Entering",eKeyDeviceType));
	switch (eKeyDeviceType)
	{
		case E_UINPUT_EV_HARD_KEY:
		{
			if(TRUE ==_KeyInputAdapter_HK.bIsuInputReady)
			{
				if(0 != _KeyInputAdapter_HK.sendKeyEvent(KeyCode, Value))
				{
					bSimSuccess = TRUE;
					ETG_TRACE_USR4(("KeySimApp::simulateKey Hardkey->Success"));
				}
				else
				{
					ETG_TRACE_USR4(("KeySimApp::simulateKey Hardkey:ERROR simulating Key"));
				}
			}
		}
		break;
		case E_UINPUT_EV_SWC_KEY:
		{
			if(TRUE ==_KeyInputAdapter_SWC.bIsuInputReady)
			{
				if(0 != _KeyInputAdapter_SWC.sendKeyEvent(KeyCode, Value))
				{
					bSimSuccess = TRUE;
					ETG_TRACE_USR4(("KeySimApp::simulateKey SWC->Success"));
				}
				else
				{
					ETG_TRACE_USR4(("KeySimApp::simulateKey SWC:ERROR simulating Key"));
				}
			}
		}
		break;
		case E_UINPUT_EV_IT_COMMANDER_KEY:
		{
			if(TRUE ==_KeyInputAdapter_ITCOMM.bIsuInputReady)
			{
				if(0 != _KeyInputAdapter_ITCOMM.sendKeyEvent(KeyCode, Value))
				{
					bSimSuccess = TRUE;
					ETG_TRACE_USR4(("KeySimApp::simulateKey IT Commander->Success"));
				}
				else
				{
					ETG_TRACE_USR4(("KeySimApp::simulateKey IT Commander:ERROR simulating Key"));
				}
			}
		}
		break;
		case E_UINPUT_EV_INJECT_KEY:
		if(TRUE ==_KeyInputAdapter_AllKeys.bIsuInputReady)
		{
			if(0 != _KeyInputAdapter_AllKeys.sendKeyEvent(KeyCode, Value))
			{
				bSimSuccess = TRUE;
				ETG_TRACE_USR4(("KeySimApp::simulateKey _KeyInputAdapter_AllKeys->Success"));
			}
			else
			{
				ETG_TRACE_USR4(("KeySimApp::simulateKey _KeyInputAdapter_AllKeys:ERROR simulating Key"));
			}
		}
		break;
		default:
		break;
	}

	return bSimSuccess;
}

tBool KeySimApp::sendInputEvent(E_UINPUT_EVENT_TYPE eKeyDeviceType, struct input_event Event)
{
	tBool bSimSuccess = FALSE;

	switch (eKeyDeviceType)
	{
		case E_UINPUT_EV_HARD_KEY:
		{
			if(TRUE ==_KeyInputAdapter_HK.bIsuInputReady)
			{
				if(0 != _KeyInputAdapter_HK.sendInputEvent(Event))
				{
					bSimSuccess = TRUE;
					ETG_TRACE_USR4(("KeySimApp::sendInputEvent Hardkey->Success"));
				}
				else
				{
					ETG_TRACE_USR4(("KeySimApp::sendInputEvent Hardkey:ERROR simulating Key"));
				}
			}
		}
		break;
		case E_UINPUT_EV_SWC_KEY:
		{
			if(TRUE ==_KeyInputAdapter_SWC.bIsuInputReady)
			{
				if(0 != _KeyInputAdapter_SWC.sendInputEvent(Event))
				{
					bSimSuccess = TRUE;
					ETG_TRACE_USR4(("KeySimApp::sendInputEvent SWC->Success"));
				}
				else
				{
					ETG_TRACE_USR4(("KeySimApp::sendInputEvent SWC:ERROR simulating Key"));
				}
			}
		}
		break;
		case E_UINPUT_EV_IT_COMMANDER_KEY:
		{
			if(TRUE ==_KeyInputAdapter_ITCOMM.bIsuInputReady)
			{
				if(0 != _KeyInputAdapter_ITCOMM.sendInputEvent(Event))
				{
					bSimSuccess = TRUE;
					ETG_TRACE_USR4(("KeySimApp::sendInputEvent IT Commander->Success"));
				}
				else
				{
					ETG_TRACE_USR4(("KeySimApp::sendInputEvent IT Commander:ERROR simulating Key"));
				}
			}
		}
		break;
		default:
		break;
	}

	return bSimSuccess;
}


E_UINPUT_EVENT_TYPE KeySimApp::selectKeyDevice(tU16 KeyCode)
{
	E_UINPUT_EVENT_TYPE eKeyDeviceRouting = E_UINPUT_EV_INJECT_KEY;

	if( RANGE_CHECK(HK_DUMMY_START, HK_DUMMY_END, KeyCode)
		|| RANGE_CHECK((HK_VIRT_SRV_TESTMODE-1),(HK_VIRT_VOL_COMBI+1),KeyCode)
		|| RANGE_CHECK((HK_MENU_LONG-1), HK_LONG_PRESS_RESERVED, KeyCode)
	  )
	{
		//HK Routing
		eKeyDeviceRouting = E_UINPUT_EV_HARD_KEY;
		ETG_TRACE_USR4((": Routing to E_UINPUT_EV_HARD_KEY"));
	}
	else if( RANGE_CHECK(JOYSTICK_DUMMY_START, JOYSTICK_DUMMY_END, KeyCode)
			 || RANGE_CHECK((JOYSTICK_OPTION_LONGPRESS-1), JOYSTICK_LONGPRESS_RESERVED, KeyCode))
	{
		//IT Commander Routing
		eKeyDeviceRouting = E_UINPUT_EV_IT_COMMANDER_KEY;
		ETG_TRACE_USR4((": Routing to E_UINPUT_EV_IT_COMMANDER_KEY"));
	}
	else if(RANGE_CHECK(SWC_DUMMY_START, SWC_DUMMY_END, KeyCode))
	{
		//SWC Routing
		eKeyDeviceRouting = E_UINPUT_EV_SWC_KEY;
		ETG_TRACE_USR4((": Routing to E_UINPUT_EV_SWC_KEY"));
	}
	else
	{
		ETG_TRACE_USR4(("KeySimApp::selectKeyDevice:ERROR-->Key pressed does not exist"));
	}

	return eKeyDeviceRouting;
}
