/*
 * KeyMappingCodes.h
 *
 *  Created on: Apr 18, 2016
 *      Author: sgt4kor
 */

#ifndef VD_INPUT_KEYMAPPING_KEYMAPPINGCODES_H_
#define VD_INPUT_KEYMAPPING_KEYMAPPINGCODES_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//************************************************************************************************
//  HMI Key Codes Defines
//************************************************************************************************
//Fascia Keys
#define KEY_RN_FAC_PHONE            0x300
#define KEY_RN_FAC_CD               0x301
#define KEY_RN_FAC_CAMERA           0x302
#define KEY_RN_FAC_AUX              0x303
#define KEY_RN_FAC_PREV             0x304
#define KEY_RN_FAC_NEXT             0x305
#define KEY_RN_FAC_RADIO            0x306
#define KEY_RN_FAC_INFO             0x307
#define KEY_RN_FAC_SETUP            0x308
#define KEY_RN_FAC_MAP              0x309
#define KEY_RN_FAC_BACK             0x30A
#define KEY_RN_FAC_DAY_NIGHT        0x30B
#define KEY_RN_FAC_NAV              0x30C
#define KEY_RN_FAC_ENTER            0x30D
#define KEY_RN_FAC_XM               0x30E
#define KEY_RN_FAC_POWER            0x30F
#define KEY_RN_FAC_EJECT            0x310
#define KEY_RN_FAC_FMAM             0x311
#define KEY_RN_FAC_MENU             0x312
#define KEY_RN_FAC_APP              0x313
#define KEY_RN_FAC_AUDIO            0x314
#define KEY_RN_FAC_DISP             0x315
#define KEY_RN_FAC_VOLUME_UP        0x316
#define KEY_RN_FAC_VOLUME_DOWN      0x317
#define KEY_RN_FAC_VOLUME      		0x318
#define KEY_RN_FAC_HOME      		0x319
#define KEY_RN_FAC_RSC_ON_OFF      	0x31A
#define KEY_INF4CV_MCP_HOME_COCKPIT 0x03CF
#define KEY_INF4CV_MCP_SRC_COCKPIT  0x03D0
#define KEY_INF4CV_MCP_NAV          0x03D1
#define KEY_INF4CV_MCP_MAP          0x03D2
#define KEY_INF4CV_MCP_SRC_CABIN    0x03D3
#define KEY_INF4CV_MCP_HOME_CABIN   0x03D4
#define KEY_INF4CV_MCP_SET_COCKPIT  0x03D5
#define KEY_INF4CV_MCP_CAM          0x03D6
#define KEY_INF4CV_MCP_PHONE_ACCEPT 0x03D7
#define KEY_INF4CV_MCP_PHONE_REJECT 0x03D8
#define KEY_INF4CV_MCP_MON          0x03D9
#define KEY_INF4CV_MCP_SET_CABIN    0x03DA
#define Encoder_KEY_INF4CV_VolumeButton_COCKPIT  0x03DB
#define Encoder_KEY_INF4CV_VolumeButton_CABIN    0x03DC

//FOR PIVI
#define KEY_RN_FAC_EV				0x31B
#define KEY_RN_FAC_FOLDER_NEXT		0x31C
#define KEY_RN_FAC_FOLDER_PREV		0x31D
#define KEY_RN_FAC_CLIMATE			0x31F

//FOR Renault MSM key
#define KEY_RN_FAC_MUTE				0x31E
#define KEY_RN_FAC_MEX				0x320

//Fascia Long Press Needed for Renault
#define KEY_RN_FAC_MENU_LONGPRESS	0x2D0
#define KEY_RN_FAC_SETUP_LONGPRESS	0x2D1
#define KEY_RN_FAC_POWER_LONGPRESS	0x2D2
#define KEY_RN_FAC_HOME_LONGPRESS	0x2D3
#define KEY_RN_FAC_DAY_NIGHT_LONGPRESS	0x2D4
//SWC Keys
#define KEY_SWC_MODE                0x0064
#define KEY_SWC_OK                  0x0065
#define KEY_SWC_SKIP_PLUS           0x0066
#define KEY_SWC_SKIP_MINUS          0x0067
#define KEY_SWC_PTT                 0x0068
#define KEY_SWC_VOLUME_DOWN         0x006A
#define KEY_SWC_VOLUME_UP           0x006B
#define KEY_SWC_HANGUP              0x006C
#define KEY_SWC_BACK                0x006D
#define KEY_SWC_UP                  0x006F
#define KEY_SWC_DOWN                0x0070
#define KEY_SWC_MUTE                0x0071
#define KEY_SWC_AUDIO_SOURCE_UP     0x0072
#define KEY_SWC_AUDIO_SOURCE_DOWN	0x0073
#define KEY_SWC_RADIO               0x0074
#define KEY_SWC_ENTER               0x0075
#define KEY_SWC_LEFT				0x0076
#define KEY_SWC_RIGHT				0x0077
#define KEY_SWC_PHONE_MUTE_DUO		0x0078
#define KEY_SWC_PHONE_VR            0x0079

//FOR PIVI
//#define KEY_SWC_TEL_ON				0x0078  	Not required
//#define KEY_SWC_TEL_OFF				0x0079

//#define KEY_SWC_DOUBLE_LEFT       0x353
//#define KEY_SWC_DOUBLE_RIGHT      0x354
//#define KEY_SWC_PHONE             0x357
//#define KEY_SWC_OFFHOOK           0x35E
//#define KEY_SWC_HANGUP_MODE       0x35F
//#define KEY_SWC_OFFHOOK_PTT       0x361

//Virtual Keys
#define KEY_VIRT_ENG_TESTMODE       0x3A0
#define KEY_VIRT_VOL_COMBI          0x3A4
//Renault HVAC table
#define KEY_HVAC_MEX				0x3A2
#define KEY_HVAC_SEAT				0x3A3
#define KEY_VIRT_AUDIO_MODE_COMBI 	0x3A1

//Joystick Directional Keys
#define KEY_JOYSTICK_UP             0x3C0
#define KEY_JOYSTICK_DOWN           0x3C1
#define KEY_JOYSTICK_LEFT           0x3C2
#define KEY_JOYSTICK_RIGHT          0x3C3
#define KEY_JOYSTICK_UPPER_LEFT     0x3C4
#define KEY_JOYSTICK_UPPER_RIGHT	0x3C5
#define KEY_JOYSTICK_LOWER_LEFT     0x3C6
#define KEY_JOYSTICK_LOWER_RIGHT	0x3C7
#define KEY_JOYSTICK_ENTER          0x3C8
//Joystick HKs
#define KEY_JOYSTICK_MAP            0x3C9
#define KEY_JOYSTICK_OPTION         0x3CA
#define KEY_JOYSTICK_HOME           0x3CB
#define KEY_JOYSTICK_BACK           0x3CC
//For PIVI
#define KEY_JOYSTICK_DAY_NIGHT		0x3CD
#define KEY_JOYSTICK_DISP			0x3CE

//Encoder Definations
#define REL_CENTRAL_SWITCH_ROTARY           0x03
#define REL_LEFT_ENCODER           			0x06
#define REL_CAN_VOLUME_ENCODER     			0x07
#define REL_RIGHT_ENCODER          			0x08
#define REL_SWRC_ENCODER           			0x09


//Long Press Key codes Joystick for Renault
#define KEY_JOYSTICK_OPTION_LONGPRESS	0x3B0
#define KEY_JOYSTICK_HOME_LONGPRESS     0x3B1
#define KEY_JOYSTICK_BACK_LONGPRESS     0x3B2
#define KEY_JOYSTICK_ENTER_LONGPRESS	0x3B3

//************************************************************************************************
//  VD_INPUT Key Names vs HMI Key Names Macros
//************************************************************************************************
typedef enum {

//-------------------------------------------------------------------------------------------
//	SWC Keys Block START
//--------------------------------------------------------------------------------------------
	SWC_DUMMY_START         = 	(tU16) (KEY_SWC_MODE-1),           			//SWC Keys Start

	SWC_MODE				=	(tU16) (KEY_SWC_MODE),
    SWC_OK					=	(tU16) (KEY_SWC_OK),
    SWC_SEEK_UP				=	(tU16) (KEY_SWC_SKIP_PLUS),
    SWC_SEEK_DOWN			=	(tU16) (KEY_SWC_SKIP_MINUS),
    SWC_TEL_VR				=	(tU16) (KEY_SWC_PTT),
    SWC_VOL_DOWN			=	(tU16) (KEY_SWC_VOLUME_DOWN),
    SWC_VOL_UP				=	(tU16) (KEY_SWC_VOLUME_UP),
    SWC_TEL_HANG_UP			=	(tU16) (KEY_SWC_HANGUP),
    SWC_BACK				=	(tU16) (KEY_SWC_BACK),
    SWC_UP					=	(tU16) (KEY_SWC_UP),
    SWC_DOWN				=	(tU16) (KEY_SWC_DOWN),
    SWC_MUTE				=	(tU16) (KEY_SWC_MUTE),
    SWC_AUDIO_SRC_UP		=	(tU16) (KEY_SWC_AUDIO_SOURCE_UP),
    SWC_AUDIO_SRC_DOWN		=	(tU16) (KEY_SWC_AUDIO_SOURCE_DOWN),
    SWC_RADIO				=	(tU16) (KEY_SWC_RADIO),
	SWC_ENTER 				=   (tU16) (KEY_SWC_ENTER),
	SWC_LEFT				=	(tU16) (KEY_SWC_LEFT),
	SWC_RIGHT				=	(tU16) (KEY_SWC_RIGHT),
	SWC_PHONE_MUTE_DUO		=	(tU16) (KEY_SWC_PHONE_MUTE_DUO),
	SWC_PHONE_VR			=	(tU16) (KEY_SWC_PHONE_VR),

	SWC_DUMMY_END			=	(tU16) (SWC_PHONE_VR+1),                     	//SWC Keys END
//-------------------------------------------------------------------------------------------
//	SWC Keys Block END
//--------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
//	Hard Keys Block START
//--------------------------------------------------------------------------------------------
	HK_DUMMY_START			= 	(tU16) (KEY_RN_FAC_PHONE - 1),

	HK_PHONE            	=	(tU16) (KEY_RN_FAC_PHONE),					//HARDKEYS START
    HK_CD				    =	(tU16) (KEY_RN_FAC_CD),
    HK_CAMERA			    =	(tU16) (KEY_RN_FAC_CAMERA),
    HK_AUX					=	(tU16) (KEY_RN_FAC_AUX),
    HK_PREV					=	(tU16) (KEY_RN_FAC_PREV),
    HK_NEXT					=	(tU16) (KEY_RN_FAC_NEXT),
    HK_RADIO				=	(tU16) (KEY_RN_FAC_RADIO),
    HK_INFO					=	(tU16) (KEY_RN_FAC_INFO),
    HK_SETUP				=	(tU16) (KEY_RN_FAC_SETUP),
    HK_MAP					=	(tU16) (KEY_RN_FAC_MAP),
    HK_BACK					=	(tU16) (KEY_RN_FAC_BACK),
    HK_DAY_NIGHT			=	(tU16) (KEY_RN_FAC_DAY_NIGHT),
    HK_NAV					=	(tU16) (KEY_RN_FAC_NAV),
    HK_ENTER				=	(tU16) (KEY_RN_FAC_ENTER),
    HK_XM					=	(tU16) (KEY_RN_FAC_XM),
    SYS_KEY_POWER			=	(tU16) (KEY_RN_FAC_POWER),
    SYS_KEY_EJECT			=	(tU16) (KEY_RN_FAC_EJECT),
    HK_FM_AM				=	(tU16) (KEY_RN_FAC_FMAM),
    HK_MENU					=	(tU16) (KEY_RN_FAC_MENU),
    HK_APP					=	(tU16) (KEY_RN_FAC_APP),
    HK_AUDIO				=	(tU16) (KEY_RN_FAC_AUDIO),
    HK_DISP					=	(tU16) (KEY_RN_FAC_DISP),
    HK_RN_VOLUME_UP			=	(tU16) (KEY_RN_FAC_VOLUME_UP),
    HK_RN_VOLUME_DOWN		=	(tU16) (KEY_RN_FAC_VOLUME_DOWN),
	HK_RN_VOLUME		 	= 	(tU16) (KEY_RN_FAC_VOLUME),
	HK_RN_HOME			  	=   (tU16) (KEY_RN_FAC_HOME),
	SYS_KEY_RSC_ON_OFF 		=   (tU16) (KEY_RN_FAC_RSC_ON_OFF),
	HK_ELECTRO_VEHICLE		=	(tU16) (KEY_RN_FAC_EV),
	HK_FOLDER_NEXT			=	(tU16) (KEY_RN_FAC_FOLDER_NEXT),
	HK_FOLDER_PREV			=	(tU16) (KEY_RN_FAC_FOLDER_PREV),
	HK_MUTE			 	 	=   (tU16) (KEY_RN_FAC_MUTE),
	HK_PIVI_CLIMATE			=   (tU16) (KEY_RN_FAC_CLIMATE),
	HK_MEX			 	 	=   (tU16) (KEY_RN_FAC_MEX),
	HK_HOME_COCKPIT         =   (tU16) (KEY_INF4CV_MCP_HOME_COCKPIT),
	HK_SRC_COCKPIT          =   (tU16) (KEY_INF4CV_MCP_SRC_COCKPIT),
	HK_INF4CV_NAV           =   (tU16) (KEY_INF4CV_MCP_NAV),
	HK_INF4CV_MAP           =   (tU16) (KEY_INF4CV_MCP_MAP),
	HK_SRC_CABIN            =   (tU16) (KEY_INF4CV_MCP_SRC_CABIN),
	HK_HOME_CABIN           =   (tU16) (KEY_INF4CV_MCP_HOME_CABIN),
	HK_SET_COCKPIT          =   (tU16) (KEY_INF4CV_MCP_SET_COCKPIT),
	HK_INF4CV_CAM           =   (tU16) (KEY_INF4CV_MCP_CAM),
	HK_PHONE_ACCEPT         =   (tU16) (KEY_INF4CV_MCP_PHONE_ACCEPT),
	HK_PHONE_REJECT         =   (tU16) (KEY_INF4CV_MCP_PHONE_REJECT),
	HK_INF4CV_MON           =   (tU16) (KEY_INF4CV_MCP_MON),
	HK_SET_CABIN            =   (tU16) (KEY_INF4CV_MCP_SET_CABIN),
	HK_VOL_COCKPIT          =   (tU16) (Encoder_KEY_INF4CV_VolumeButton_COCKPIT),
	HK_VOL_CABIN            =   (tU16) (Encoder_KEY_INF4CV_VolumeButton_CABIN),
	
	 

	HK_DUMMY_END         	=   (tU16) (HK_VOL_CABIN+1),               			//HARDKEYS END

//Miscellaneouus Hardkeys to be added in HK device Manually
	HK_MENU_LONG				=	(tU16) (KEY_RN_FAC_MENU_LONGPRESS),			//Renault Long press Start
	HK_SETUP_LONG				=	(tU16) (KEY_RN_FAC_SETUP_LONGPRESS),
	SYS_KEY_POWER_LONG			=	(tU16) (KEY_RN_FAC_POWER_LONGPRESS),
	HK_HOME_LONG				=	(tU16) (KEY_RN_FAC_HOME_LONGPRESS),
	HK_DAY_NIGHT_LONG			= 	(tU16) (KEY_RN_FAC_DAY_NIGHT_LONGPRESS),
	HK_LONG_PRESS_RESERVED	 	=   (tU16) (HK_DAY_NIGHT_LONG+1),				//Renault Long press End
	//Virtual Key
	HK_VIRT_SRV_TESTMODE		=	(tU16) (KEY_VIRT_ENG_TESTMODE),
	HK_VIRT_AUDIO_MODE_COMBI	=	(tU16) (KEY_VIRT_AUDIO_MODE_COMBI),
	HVAC_MEX					=	(tU16) (KEY_HVAC_MEX),
	HVAC_SEAT					=	(tU16) (KEY_HVAC_SEAT),
	HK_VIRT_VOL_COMBI			=	(tU16) (KEY_VIRT_VOL_COMBI),
//-------------------------------------------------------------------------------------------
//	Hard Keys Block END
//--------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
//	IT Commander Keys Block Start
//--------------------------------------------------------------------------------------------
	JOYSTICK_DUMMY_START	=	(tU16) (KEY_JOYSTICK_UP - 1),			//Joystick Keys START

	JOYSTICK_UP				=	(tU16) (KEY_JOYSTICK_UP),
    JOYSTICK_DOWN			=	(tU16) (KEY_JOYSTICK_DOWN),
    JOYSTICK_LEFT			=	(tU16) (KEY_JOYSTICK_LEFT),
    JOYSTICK_RIGHT			=	(tU16) (KEY_JOYSTICK_RIGHT),
    JOYSTICK_UPPER_LEFT		=	(tU16) (KEY_JOYSTICK_UPPER_LEFT),
    JOYSTICK_UPPER_RIGHT	=	(tU16) (KEY_JOYSTICK_UPPER_RIGHT),
    JOYSTICK_LOWER_LEFT		=	(tU16) (KEY_JOYSTICK_LOWER_LEFT),
    JOYSTICK_LOWER_RIGHT	=	(tU16) (KEY_JOYSTICK_LOWER_RIGHT),
    JOYSTICK_ENTER			=	(tU16) (KEY_JOYSTICK_ENTER),
    JOYSTICK_MAP			=	(tU16) (KEY_JOYSTICK_MAP),
    JOYSTICK_OPTION			=	(tU16) (KEY_JOYSTICK_OPTION),
    JOYSTICK_HOME			=	(tU16) (KEY_JOYSTICK_HOME),
    JOYSTICK_BACK			=	(tU16) (KEY_JOYSTICK_BACK),
    JOYSTICK_DAY_NIGHT		=	(tU16) (KEY_JOYSTICK_DAY_NIGHT),
    JOYSTICK_DISP			=	(tU16) (KEY_JOYSTICK_DISP),

    JOYSTICK_DUMMY_END		=	(tU16) (JOYSTICK_DISP+1),       			//Joystick Keys END

    //Miscellanous IT Commander Renault Specific Keys
	JOYSTICK_OPTION_LONGPRESS   =	(tU16) (KEY_JOYSTICK_OPTION_LONGPRESS),	//Joystick LONGPRESS Keys START
	JOYSTICK_HOME_LONGPRESS     =	(tU16) (KEY_JOYSTICK_HOME_LONGPRESS),
	JOYSTICK_BACK_LONGPRESS	    =	(tU16) (KEY_JOYSTICK_BACK_LONGPRESS),
	JOYSTICK_ENTER_LONGPRESS    =	(tU16) (KEY_JOYSTICK_ENTER_LONGPRESS),
	JOYSTICK_LONGPRESS_RESERVED =	(tU16) (JOYSTICK_ENTER_LONGPRESS + 1),	//Joystick LONGPRESS Keys END

//-------------------------------------------------------------------------------------------
//	IT Commander Keys Block End
//--------------------------------------------------------------------------------------------
    KEY_MIN_VALUE			=   SWC_DUMMY_START,     //Lowest Enum value in list
	KEY_MAX_VALUE			=   JOYSTICK_DUMMY_END,  //Highest Enum Value in list
	KEY_INVALID 			= 	(tU16) (0xFFFF)		 //Invalid Keys
}eVDInput_KeyCodes;


//Function Macros to extract Lower and Higher Bytes of HMI Keycode
#define LB(Keycode) ( (tU8) (Keycode) )
#define HB(Keycode) ( (tU8) ((((tU16)Keycode) >>8)) )




#endif /* VD_INPUT_KEYMAPPING_KEYMAPPINGCODES_H_ */
