/************************************************************************
* FILE        :  Input_DiagSystemSetListener.cpp
* PROJECT     :  IVI
* SW-COMPONENT:  vd_vehicledata
*----------------------------------------------------------------------
*
* DESCRIPTION : 
*
*----------------------------------------------------------------------
* COPYRIGHT   :    (c) 2010 Robert Bosch GmbH, Hildesheim
* HISTORY     :
*
* Date      | Author             | Modification
*
*************************************************************************/
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_VD_INPUT_CLIENT_DIAGNOSTICS
#include "trcGenProj/Header/Input_DiagSystemSetListener.cpp.trc.h"
#endif

#define DIAGNOSTICS_KDS_ENTRY_IMPORT_INTERFACE
#include "fc_diagnosis_if.h"

#include "Input_DiagSystemSetListener.h"
#include "../vd_inputMain.h"

/*************************************************************************
*
* FUNCTION: Constructor
* 
* DESCRIPTION: Init Members 
*
* PARAMETER: poMainAppl Pointer to main application
*            poIF Pointer to diaglib SystemSet interface 
*
* RETURNVALUE:
*
*************************************************************************/
Input_tclSystemSetListener::Input_tclSystemSetListener(diaglib::tclSystemSetIF * poIF, vd_input_tclMain* poMainAppl)
{
  ETG_TRACE_FATAL(("CONSTRUCTOR: Input_tclSystemSetListener() entered"));

  m_poSystemSetIF = poIF;
  m_poMainAppl = poMainAppl;
}

/*************************************************************************
*
* FUNCTION: Destructor
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
Input_tclSystemSetListener::~Input_tclSystemSetListener()
{
  // +++ Free resources you might have created/used +++
  m_poSystemSetIF = OSAL_NULL;
  m_poMainAppl = OSAL_NULL;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSet
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
tU32 Input_tclSystemSetListener::vOnSystemSet( tU32 u32SystemSetID,
                                                        diaglib::tenSystemSetType u32SystemSetType,
                                                        diaglib::tContext MsgContext
                                                      )
{
  ETG_TRACE_FATAL((": SystemSetListener::vOnSystemSet() - MsgContext: %X ", MsgContext ));
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  // temp vars  
  diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
  diaglib::tclParameterVector _oErrorList;

  if (diaglib::EN_TYPE_CODING == u32SystemSetType || diaglib::EN_TYPE_DEFAULT_TEF == u32SystemSetType)
  {
     ETG_TRACE_FATAL((": SystemSetListener::vOnSystemSet() EN_TYPE_CODING or EN_TYPE_DEFAULT_TEF"));
     //++++++++++ADD COde to read KDS Here +++++++//
     vd_input_NULL_POINTER_CHECK_VAL(m_poMainAppl);
     m_poMainAppl->readKDS();
     //+++++++++++++++++++++++++++++++++++++++++++//
  }
  else
  {
    // other system type -> not supported
    // probably better NOT to return an error, since diag might trigger again and again
     ETG_TRACE_FATAL((": SystemSetListener::vOnSystemSet() EN_TYPE_UNKNWON"));
  }

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bSendSystemSetResult( _enSysSetResult, _oErrorList, MsgContext) )
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSet() - ERROR sending result"));
    }
  }
  else
  {
    ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSet() - ERROR invalid pointer"));
  } 

  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSetFinished
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
tU32 Input_tclSystemSetListener::vOnSystemSetFinished( tU32 u32SystemSetID,
                                                                diaglib::tenSystemSetType u32SystemSetType,
                                                                diaglib::tContext MsgContext
                                                              )
{
  ETG_TRACE_FATAL((": SystemSetListener::vOnSystemSetFinished() entered"));
  // +++ Reallow access to values that needed default setting, then send positive response +++
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bAcknowledgeSystemSetFinished(MsgContext))
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSetFinished() - ERROR giving acknowledge"));
    }
  }
  else
  {
    ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSetFinished()- ERROR invalid pointer"));
  }
  
  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSetPrepare
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
tU32 Input_tclSystemSetListener::vOnSystemSetPrepare( tU32 u32SystemSetID,
                                                               diaglib::tenSystemSetType u32SystemSetType,
                                                               diaglib::tContext MsgContext
                                                             )
{
  ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSetPrepare() entered"));  
  // +++ Stop access to values that need default setting, then send positive response +++
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
  diaglib::tclParameterVector _oErrorList;
  
  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bSendSystemSetPrepareResult( _enSysSetResult, _oErrorList, MsgContext ) )
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSetPrepare() - ERROR sending result"));
    }
  }
  else
  {
    ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSetPrepare() - ERROR: invalid pointer"));
  }

  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vOnSystemSetCheck
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************/
tU32 Input_tclSystemSetListener::vOnSystemSetCheck( tU32 u32SystemSetID,
                                                             diaglib::tenSystemSetType u32SystemSetType,
                                                             diaglib::tContext MsgContext
                                                           )
{
  ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSetCheck() entered"));  
  // +++ Check if all values are set to default. +++
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetID );
  OSAL_C_PARAMETER_INTENTIONALLY_UNUSED( u32SystemSetType );

  diaglib::tenSystemSetResult _enSysSetResult = diaglib::EN_SYSTEMSET_OK;
  diaglib::tclParameterVector _oErrorList;

  if (m_poSystemSetIF != OSAL_NULL)
  {
    if (TRUE == m_poSystemSetIF->bSendSystemSetCheckResult( _enSysSetResult, _oErrorList, MsgContext) )
    {
      // +++ Trace info +++
    }
    else
    {
      ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSetCheck() - ERROR sending result"));
    }
  }
  else
  {
    ETG_TRACE_FATAL(("SystemSetListener::vOnSystemSetCheck() - ERROR invalid pointer"));
  }

  return diaglib::U32_DIAGLIB_RETURN_OK;
}

/*************************************************************************
*
* FUNCTION: vStoreKdsFeatureInFfd
* 
* DESCRIPTION:  
*
* PARAMETER:  
*
* RETURNVALUE:
*
*************************************************************************
tVoid Input_tclSystemSetListener::vStoreKdsFeatureInFfd(tU8 u8Feature)
{

}  
*/
