///////////////////////////////////////////////////////////
//  PDD_Adapter.cpp
//  Implementation of the Class PDD_Adapter
//  Created on:      05-Dez-2013 12:51:03
//  Original author: mor2hi
///////////////////////////////////////////////////////////
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#include "../../Macro.h"
#include "PDD_Adapter.h"
#include "../KDS/KDSDefines.h"
#include "PDD_Defines.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/PDD_Adapter.cpp.trc.h"
#endif

PDD_Adapter::PDD_Adapter() :
      oKeyMatrixDataHandler(PDD_KEY_MATRIX_AMOUNT_OF_ENTITIES), oSystemKeyDataHandler(PDD_SYSTEM_KEY_AMOUNT_OF_ENTITIES), oCarBusDataHandler(
            PDD_CAR_BUS_AMOUNT_OF_ENTITIES),oPDDRladderDataHandler(PDD_TABLE4_AMOUNT_OF_ENTITIES)
{
	//To Do
}

PDD_Adapter::~PDD_Adapter()
{
   ETG_TRACE_USR4(("PDD_Adapter::~PDD_Adapter"));
}

tBool PDD_Adapter::storeDataSet(tU32 ElementData, tU8 Element, tU16 KDSEntityCode,tU8 LastServerElement)
{
   ETG_TRACE_USR4(("PDD_Adapter::storeDataSet: [KDSCode: 0x%x, ElementPos: %d] -> ElementData: 0x%x\n", KDSEntityCode, Element, ElementData ));

   tBool Passed = TRUE;

   tBool Passed1 = TRUE;
   tBool Passed2 = TRUE;
   tBool Passed3 = TRUE;
   tBool Passed4 = TRUE;
// ToDo: This switch is a hack. The interface should provide a callback function to give direct access
   switch (KDSEntityCode)
   {
      case KEY_MATRIX_DATA_ENTITY_CODE:
      {
    	  Passed1 = oKeyMatrixDataHandler.handleData(ElementData, Element, LastServerElement);

    	  break;
      }
      case SYSTEM_KEY_DATA_ENTITY_CODE:
      {
    	  Passed2 = oSystemKeyDataHandler.handleData(ElementData, Element, LastServerElement);

          break;
      }
      case CAR_BUS_KEY_DATA_ENTITY_CODE:
      {
    	  Passed3 = oCarBusDataHandler.handleData(ElementData, Element, LastServerElement);

          break;
      }
      case RLADDER_KEY_DATA_ENTITY_CODE:
      {
    	  Passed4 = oPDDRladderDataHandler.handleData(ElementData, Element, LastServerElement);

    	  break;
      }
      default:
      {
         break;
      }

   }

   if(Passed1 == FALSE && Passed2 == FALSE && Passed3 == FALSE && Passed4 == FALSE)
   {
	   Passed = FALSE;
   }

   return (Passed);
}

//    		         [1]       [2]             [3]               [4]
// IF(u8FirstByte = 0)
// incoming data: [hw key], [reserved key], [high Logic Key], [low logic key]
// IF(u8FirstByte = 1)
// incoming data: [hw key], [reserved key], [low Logic Key], [high logic key]
tVoid PDD_Adapter::configureByteOrder(tU16 KDSEntityCode, tU8 u8FirstByte)
{
	ETG_TRACE_USR4(("PDD_Adapter::configureByteOrder: [ KDSEntityCode: 0x%x SwappingByte: %d ]\n", KDSEntityCode, u8FirstByte));
	switch (KDSEntityCode)
	{
	  case KEY_MATRIX_DATA_ENTITY_CODE:
	  {
		  oKeyMatrixDataHandler.setLogicKeyByteOrder(u8FirstByte);
		 break;
	  }
	  case SYSTEM_KEY_DATA_ENTITY_CODE:
	  {
		  oSystemKeyDataHandler.setLogicKeyByteOrder(u8FirstByte);
		 break;
	  }
	  case CAR_BUS_KEY_DATA_ENTITY_CODE:
	  {
		  oCarBusDataHandler.setLogicKeyByteOrder(u8FirstByte);
		 break;
	  }
	  case RLADDER_KEY_DATA_ENTITY_CODE:
	  {
		  oPDDRladderDataHandler.setLogicKeyByteOrder(u8FirstByte);
		  break;
	  }
	  default:
	  {
		 break;
	  }

	}
}
