/*
 * PDDElementHandler.cpp
 *
 *  Created on: 20.12.2013
 *      Author: mor2hi
 */

#include "PDDElementHandler.h"
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_vd_input_if.h"
#include "../../Macro.h"

#include "../../Frameworks/SerialQueue.h"

#include "PDD_Defines.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/PDDElementHandler.cpp.trc.h"
#endif

PDDElementHandler::PDDElementHandler(tU32 AmountOfEntities) :
      m_AmountOfEntities(AmountOfEntities), m_LogicKeyByteOrder(0)
{
   memset(&m_PDDData, 0, sizeof(m_PDDData)); //lint fix to initialize all elements to 0
   ETG_TRACE_USR4(("PDDElementHandler::PDDElementHandler"));
}

PDDElementHandler::~PDDElementHandler()
{
   ETG_TRACE_USR4(("PDDElementHandler::~PDDElementHandler"));
}

tBool PDDElementHandler::allServerElementsRead(tU8 ActualTreatedElement, tU8 LastServerElement)
{
   tBool LastServerElementReached = FALSE;
   // check whetheractual treated element is out of range.
   if (LastServerElement <= ActualTreatedElement)
   {
      LastServerElementReached = TRUE;
   }

   // Give some feedback: actual element is out of data range. Thus it's not valid
   if (LastServerElement < ActualTreatedElement)
      ETG_TRACE_ERR(("PDDElementHandler::allServerElementsRead: Element No. 0x%x out of Server Data Range: 0x%x -> data of element invalid", ActualTreatedElement, LastServerElement));

   // Give some feedback: server  is providing more data than can be handled in the pool
   if (m_AmountOfEntities < LastServerElement)
      ETG_TRACE_ERR(
            ("PDDElementHandler::allServerElementsRead: Server Data Range: 0x%x higher than PDD data range: 0x%x -> not all Server data are going to be stored", LastServerElement, m_AmountOfEntities));

   return (LastServerElementReached);
}

tBool PDDElementHandler::DPStoreRequestGranted(tU8 ActualTreatedElement, tU8 LastServerElement)
{
   tBool RequestGranted = FALSE;
   if ((ActualTreatedElement == LastServerElement) || (ActualTreatedElement == m_AmountOfEntities))
   {
      RequestGranted = TRUE;
   }

   return (RequestGranted);
}

tVoid PDDElementHandler::fillBuffer(PDD_DATA_TYPE* pData, tU8 PositionInDataArrayOfFirstElementToBeSetToDefault)
{
   INP_POINTER_CHECK_CALL_NO_RET_VALUE(pData);
   if (PositionInDataArrayOfFirstElementToBeSetToDefault <= m_AmountOfEntities)
   {
      for (tU32 i = (tU32)PositionInDataArrayOfFirstElementToBeSetToDefault; i < m_AmountOfEntities; i++) //lint fix
      {
         pData[i] = PDD_PAYLOAD_DEFAULT_VALUE;
      }
   }
}

tVoid PDDElementHandler::fillRemainingElementsWithDefaultData(PDD_DATA_TYPE* pDataBegin, tU8 ActualTreatedElement)
{
   INP_POINTER_CHECK_CALL_NO_RET_VALUE(pDataBegin);
   if (ActualTreatedElement < m_AmountOfEntities)
   {
      fillBuffer(pDataBegin, ActualTreatedElement);
   }

}

tBool PDDElementHandler::writePassed(tS32 ErrorCode)
{
   tBool Passed = FALSE;

   if (DP_S32_NO_ERR == ErrorCode)
   {
      Passed = TRUE;
   }

   return (Passed);
}

tU32 PDDElementHandler::getSize(TPddScc_Header* pInputDpHeader)
{
   INP_POINTER_CHECK_CALL(pInputDpHeader);
   tU32 Size = pInputDpHeader->u32Size;
   ETG_TRACE_USR4(("PDDElementHandler::getSize: 0x%x", Size));
   return (Size);
}

tBool PDDElementHandler::writePDDWhenLastElementIsStored(PDD_DATA_TYPE* pDataBegin, tU8 ActualTreatedElement, tU8 LastServerElement)
{
   INP_POINTER_CHECK_CALL(pDataBegin);
   tBool Passed = FALSE;

   if ((TRUE == allServerElementsRead(ActualTreatedElement, LastServerElement)) || (m_AmountOfEntities <= ActualTreatedElement))
   {
      fillRemainingElementsWithDefaultData(pDataBegin, ActualTreatedElement);
      if (TRUE == DPStoreRequestGranted(ActualTreatedElement, LastServerElement))
      {
         Passed = storeDataPool(pDataBegin);
      }

   }
   return (Passed);
}

//
//                [1]       [2]             [3]               [4]
// incoming data: [hw key], [reserved key], [high Logic Key], [low logic key]
// PDD data:      [hw key], [reserved key], [low logic key],  [high logic Key]
tU32 PDDElementHandler::convertElement(tU32 ElementData)
{

   tU32 ConvertedValue = 0;

   SerialQueue IncomingData, ConvertedData;
   IncomingData.store((tU32) ElementData);

   if(m_LogicKeyByteOrder == 0)
   {
	   //                [1]       [2]             [3]               [4]
	   // incoming data: [hw key], [reserved key], [high Logic Key], [low logic key]
	   // PDD data:      [hw key], [reserved key], [low logic key],  [high logic Key]
	   ConvertedData.store(IncomingData.readByte(4));
	   ConvertedData.store(IncomingData.readByte(3));
	   ConvertedData.store(IncomingData.readByte(2));
	   ConvertedData.store(IncomingData.readByte(1));
   }
   else if(m_LogicKeyByteOrder == 1)
   {
	   //                [1]       [2]             [3]               [4]
	   // incoming data: [hw key], [reserved key], [low Logic Key], [high logic key]
	   // PDD data:      [hw key], [reserved key], [low logic key],  [high logic Key]
	   ConvertedData.store(IncomingData.readByte(3));
	   ConvertedData.store(IncomingData.readByte(4));
	   ConvertedData.store(IncomingData.readByte(2));
	   ConvertedData.store(IncomingData.readByte(1));
   }
   else
   {
	   //Nothing
   }
   ConvertedValue = (tU32) ConvertedData.readWord();
   return (ConvertedValue);
}

tU8 PDDElementHandler::convertElement(tU8 ElementData)
{
   return (ElementData);
}

tVoid PDDElementHandler::shareDataWithTheOtherSide(PDD_DATA_TYPE* pDataBegin, PDD_DATA_TYPE ElementData, tU8 LastElement, tU8 ActualTreatedElement,
      tU32 ArraySize)
{

   INP_POINTER_CHECK_CALL_NO_RET_VALUE(pDataBegin);

   if ((LastElement >= ActualTreatedElement) && (0 != ActualTreatedElement) && (0 != LastElement))
   {
      tU8 EntityNumberInPDDArray = ActualTreatedElement - 1;
      pDataBegin[EntityNumberInPDDArray] = convertElement(ElementData);

   }
   (tVoid)ArraySize; //lint
}
