/*
 * KDSDeviceFrontend.h
 *
 *  Created on: 06.12.2013
 *      Author: mor2hi
 */

#ifndef KDSDEVICEFRONTEND_H_
#define KDSDEVICEFRONTEND_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SYSTEM_S_IMPORT_INTERFACE_KDS_DEF
#include "system_pif.h"

#define KDS_ENTITY_CODE_DEFAULT 0
#define KDS_ENTITY_LENGTH_DEFAULT 0

class KDSDeviceFrontend {

public:

   tU16 m_KDSMapSize;
   KDSDeviceFrontend():m_KDSEntityCode(0xFFFF),DeviceDescriptor(-1),m_KDSMapSize(0)//lint fix
   {
#if defined(_PRINT__)
         printf("KDSDeviceFrontend::KDSDeviceFrontend: default constructor called: KDSEntityCode: %d\n", m_KDSEntityCode);
#endif
   }


   KDSDeviceFrontend(tU16 KDSEntityCode, tU16 KDSMapSize);
   virtual ~KDSDeviceFrontend();

   tBool readStoredData(tPU8 pStorage);

   tU16 getKdsMapSize() const
   {
      return m_KDSMapSize;
   }

protected:
   tU16 m_KDSEntityCode;

private:

   OSAL_tIODescriptor DeviceDescriptor;
#if defined(__INPUT_UNIT_TESTING__)
public:
#endif
   tBool openDevice();
   tVoid closeDevice();

};

#endif /* KDSDEVICEFRONTEND_H_ */
