/*
 * KDSDefines.h
 *
 *  Created on: 09.12.2013
 *      Author: mor2hi
 */

#ifndef KDSDEFINES_H_
#define KDSDEFINES_H_
#define KDS_MAX_AMOUNT_OF_ENTITIES 56  // one entity is about 4 bytes, thus (56X4+6)=230Bytes is max in KDS
#define BITS_PER_BYTE 8

#define KDS_VERSION_NO_LENGTH 5
#define KDS_SIZE_OF_ONE_ELEMENT 4
#define KDS_AMOUNT_OF_ENTITY_PLACEHOLDER_BYTE_LENGTH 1  // the payload contains an entity about the amount of entities
#define KDS_ENTITY_BYTE_LENGTH 1
#define KDS_AMOUNT_OF_ENTITIES_VALUE_START_POSITION_NOT_EXISTING -1
/* set this define to KDS_AMOUNT_OF_ENTITIES_VALUE_START_POSITION_NOT_EXISTING
in case entities are beginning with the first payload byte*/
#define KDS_AMOUNT_OF_ENTITIES_VALUE_START_POSITION 5
//Payload starts after 5 bytes Version + noOfElements byte
#define KDS_PAYLOAD_START_POSITION (KDS_VERSION_NO_LENGTH + KDS_AMOUNT_OF_ENTITY_PLACEHOLDER_BYTE_LENGTH)
// ToDo: real coding
#define KDS_DATA_TYPE tU32
//Address of KDS for each Entity
#define KEY_MATRIX_DATA_ENTITY_CODE 0xA080//KDS_ACCESS_KEY_MATRIX_ID
#define KEY_MATRIX_COUNT 0x20  //Decimal-32
#define SYSTEM_KEY_DATA_ENTITY_CODE 0xA081//KDS_ACCESS_SYSTEM_KEY_ID
#define SYSTEM_KEY_COUNT 0x04  //Decimal - 4
#define CAR_BUS_KEY_DATA_ENTITY_CODE 0xA082//KDS_ACCESS_CAR_BUS_KEY_ID
#define CAR_BUS_KEY_COUNT 0x20 //Decimal - 32
#define RLADDER_KEY_DATA_ENTITY_CODE 0xA083//KDS_ACCESS_CAR_BUS_KEY_ID
#define RLADDER_BUS_KEY_COUNT 0x10 //Decimal -16

//Structure defination for preparing Hardcoded Key Mappings
// PDD data:      [hw key], [reserved key], [low logic key],  [high logic Key]
typedef struct{
	tU8 v850LB;
	tU8 v850Reserved;
	tU8 hmiLB;
	tU8 hmiHB;
}sKeyEntry;


#endif /* KDSDEFINES_H_ */
