///////////////////////////////////////////////////////////
//  ConfigurationDataConverter.cpp
//  Implementation of the Class ConfigurationDataConverter
//  Created on:      10-Dez-2013 14:30:11
//  Original author: mor2hi
///////////////////////////////////////////////////////////
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#include "ConfigurationDataConverter.h"
#include "KDSDefines.h"
#include "../../Macro.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_APPLICATION
#include "trcGenProj/Header/ConfigurationDataConverter.cpp.trc.h"
#endif
ConfigurationDataConverter::~ConfigurationDataConverter()
{
   ETG_TRACE_USR4(("ConfigurationDataConverter::~ConfigurationDataConverter"));
   m_pDataMap = 0;//lint fix
}

tU8 ConfigurationDataConverter::getAmountOfEntities()
{
   tU8 Amount = 0;
   Amount = (tU8) (readByteOfMap(KDS_AMOUNT_OF_ENTITIES_VALUE_START_POSITION));
   if (KDS_MAX_AMOUNT_OF_ENTITIES < Amount) // cross check. Better than nothing if is containing wrong data.
   {
      Amount = KDS_MAX_AMOUNT_OF_ENTITIES;
      ETG_TRACE_USR4(("ConfigurationDataConverter::getAmountOfEntities: use KDS_MAX_AMOUNT_OF_ENTITIES amount: 0x%x", Amount));
   }
   //ETG_TRACE_USR4(("ConfigurationDataConverter::getAmountOfEntities: Amount: 0x%x", Amount));
   return (Amount);
}

ConfigurationDataConverter::ConfigurationDataConverter(tPU8 pDataMap, tU8 DefaultSizeInCaseItsNotInMapStored):
      m_DefaultSizeInCaseItsNotInMapStored(DefaultSizeInCaseItsNotInMapStored)
{
   //ETG_TRACE_USR4(("ConfigurationDataConverter::ConfigurationDataConverter: constructor enter: pMap: 0x%x\n", pDataMap));
   m_pDataMap = NULL;
   INP_POINTER_CHECK_CALL_NO_RET_VALUE(pDataMap);
   m_pDataMap = pDataMap;
  // ETG_TRACE_USR4(("ConfigurationDataConverter::ConfigurationDataConverter: incoming Data: 0x%*x.", ETG_LIST_LEN(64), ETG_LIST_PTR_T8(
         //pDataMap)));
}

tU8 ConfigurationDataConverter::readByteOfMap(tU8 PositionOfByteInMap)
{
   tU8 ByteValue = 0;
   INP_POINTER_CHECK_CALL(m_pDataMap);
   ByteValue = m_pDataMap[PositionOfByteInMap];
   //ETG_TRACE_USR4(("ConfigurationDataConverter::readByteOfMap: position in map to be read: 0x%x, read value of dump backup: 0x%x", PositionOfByteInMap, ByteValue));
   return (ByteValue);
}

tU32 ConfigurationDataConverter::getElementStartPositionInMap(tU8 ElementNumber)
{
   tU8 AmountOfEntities = getAmountOfEntities();

   tU8 ElementPosition = 0;

   if (ElementNumber <= AmountOfEntities)
   {
      ElementPosition = KDS_PAYLOAD_START_POSITION + ((ElementNumber - 1) * KDS_SIZE_OF_ONE_ELEMENT);
   }

   return (ElementPosition);
}

tU32 ConfigurationDataConverter::getDataOfAnElement(tU8 Element)
{
   //ETG_TRACE_USR4(("ConfigurationDataConverter::getDataOfAnElement: enter for element no: %d", Element));
   tU32 ElementData = 0;
   tU32 ElementStartPos = getElementStartPositionInMap(Element);

   tU8 PositionOfByteToBeRead = ElementStartPos;
   tU8 NextByte = readByteOfMap(PositionOfByteToBeRead);

   ElementData = (tU32) NextByte;
  // ETG_TRACE_USR4(("ConfigurationDataConverter::getDataOfAnElement: start position of element: 0x%x, byte read: 0x%x, element data: 0x%x", PositionOfByteToBeRead, NextByte, ElementData));

   for (int i = 1; i < KDS_SIZE_OF_ONE_ELEMENT; i++)
   {

      PositionOfByteToBeRead = ElementStartPos + i;
      NextByte = readByteOfMap(PositionOfByteToBeRead);

      ElementData = (ElementData << BITS_PER_BYTE) + (tU32) NextByte;
      //ETG_TRACE_USR4(("ConfigurationDataConverter::getDataOfAnElement: byte position: 0x%x, byte read: 0x%x, element data: 0x%x", PositionOfByteToBeRead, NextByte, ElementData));
   }

   return (ElementData);
}

tVoid ConfigurationDataConverter::printPayload()
{
   tU8 AmountOfEntities = getAmountOfEntities();
   tU32 Data = 0;
   for (int i = 1; i < AmountOfEntities; i++)
   {
      Data = getDataOfAnElement(i);
   }
}

