/*
 * UsrActionEmu.cpp
 *
 *  Created on: Jan 13, 2016
 *      Author: sgt4kor
 */

#include "UsrActionEmu.h"
#include "EventObserver.h"
#include"../../SimulationApp/KeySimApp.h"
#include"../../SimulationApp/EncSimApp.h"
#include"../../SimulationApp/TouchSimApp.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_EV_RECORDER
#include "trcGenProj/Header/UsrActionEmu.cpp.trc.h"
#endif

//vd_input_tclMain* UsrActionEmu::_poMain = NULL;
tS32 UsrActionEmu::_uHardKeyDeviceFD = 0;
tS32 UsrActionEmu::_uSWCKeyDeviceFD = 0;
tS32 UsrActionEmu::_uITCommKeyDeviceFD = 0;
tS32 UsrActionEmu::_uEncoderDeviceFD = 0;
tS32 UsrActionEmu::_uTouchDeviceFD = 0;
tS32 UsrActionEmu::_uTouchDevice_SecFD = 0;
//pthread_mutex_t _MutexUsrAction;
using namespace std;
//#define SYSCALL(call) while (((call) == -1) && (errno == EINTR))

UsrActionEmu::UsrActionEmu(vd_input_tclMain* poMain):Ivd_inputBase(poMain),_poEvObserverRef(0) {
	// TODO Auto-generated constructor stub
	_u8RecordStatus = 0;
	_u8ReplayStatus=0;
	_strReplayFilePath = std::string("/tmp/InputEvent.txt");
	KeySimAppRef = 0;
	EncSimAppRef = 0;
	TouchSimAppRef = 0;
	TouchSimAppRef_Secondary = 0;
	//UsrActionEmu::_poMain = poMain;

	//initialise the mutex
	pthread_mutex_init(&_MutexUsrAction, NULL);
}

UsrActionEmu::~UsrActionEmu() {
	_u8RecordStatus = 0;
	_u8ReplayStatus=0;
	KeySimAppRef = 0;
	EncSimAppRef = 0;
	TouchSimAppRef = 0;
	TouchSimAppRef_Secondary = 0;
	_strReplayFilePath.clear();
	//initialise the mutex
	pthread_mutex_init(&_MutexUsrAction, NULL);
	if(_RecordFileHandl.is_open())
		_RecordFileHandl.close();
	_oThreadHandler.waitObserverThreadEnd();
	_oThreadHandler.exitMainThread();
	_poEvObserverRef=0;
}


tVoid UsrActionEmu::vGetReferences()
{
	ETG_TRACE_USR4(("UsrActionEmu::vGetReferences() Enter"));
	vd_input_NULL_POINTER_CHECK(_cpoMain);
	_poEvObserverRef = dynamic_cast<EventObserver*>(_cpoMain->getHandler("EventObserver"));
	vd_input_NULL_POINTER_CHECK(_poEvObserverRef);

	KeySimAppRef = dynamic_cast<KeySimApp*>(_cpoMain->getHandler("KeySimApp"));
	vd_input_NULL_POINTER_CHECK(KeySimAppRef);

	EncSimAppRef = dynamic_cast<EncSimApp*>(_cpoMain->getHandler("EncSimApp"));
	vd_input_NULL_POINTER_CHECK(EncSimAppRef);

	TouchSimAppRef = dynamic_cast<TouchSimApp*>(_cpoMain->getHandler("uinput-Touch1"));
	vd_input_NULL_POINTER_CHECK(TouchSimAppRef);


	TouchSimAppRef_Secondary = dynamic_cast<TouchSimApp*>(_cpoMain->getHandler("uinput-Touch2"));
	vd_input_NULL_POINTER_CHECK(TouchSimAppRef_Secondary);

	ETG_TRACE_USR4(("UsrActionEmu::vGetReferences() Exit"));
}

tVoid UsrActionEmu::vStartCommunication()
{
	ETG_TRACE_USR4(("UsrActionEmu::vStartCommunication() -> Initialize Filedescriptors of all uInput devices"));
	vd_input_NULL_POINTER_CHECK(KeySimAppRef);
	UsrActionEmu::_uHardKeyDeviceFD = KeySimAppRef->getUInputFD("HardKey");
	vd_input_NULL_POINTER_CHECK(EncSimAppRef);
	UsrActionEmu::_uSWCKeyDeviceFD = KeySimAppRef->getUInputFD("SWCKey");
	vd_input_NULL_POINTER_CHECK(EncSimAppRef);
	UsrActionEmu::_uITCommKeyDeviceFD = KeySimAppRef->getUInputFD("ITCommKey");
	vd_input_NULL_POINTER_CHECK(EncSimAppRef);
	UsrActionEmu::_uEncoderDeviceFD = EncSimAppRef->getUInputFD();
	vd_input_NULL_POINTER_CHECK(TouchSimAppRef);
	UsrActionEmu::_uTouchDeviceFD = TouchSimAppRef->getUInputFD();
	vd_input_NULL_POINTER_CHECK(TouchSimAppRef_Secondary);
	UsrActionEmu::_uTouchDevice_SecFD = TouchSimAppRef_Secondary->getUInputFD();
}

tBool UsrActionEmu::filepathValid(std::string filepath)
{
	tBool Status = FALSE;
	int fd = -1;
	if(filepath.empty())
	{
		Status =  FALSE;
	}
	if(filepath.c_str() == NULL)
	{
		Status =  FALSE;
	}
	else
	{
		ETG_TRACE_USR4(("UsrActionEmu::filepathValid Opening File to Validate!!\n"));
		fd = open(filepath.c_str(), O_RDWR|O_CREAT,0644);
		if(fd == -1)
		{
			Status = FALSE;
		}
		else
		{
			Status = TRUE;
			ETG_TRACE_USR4(("UsrActionEmu::filepathValid Closing File!!\n"));
			close(fd);
		}
	}
	return Status;
}

tBool UsrActionEmu::record(tU8 u8StartStop, std::string path )
{
	tBool bStatus = FALSE;

	_u8RecordStatus = u8StartStop;
	vd_input_NULL_POINTER_CHECK_VAL(_poEvObserverRef);

	if(u8StartStop == 1)
	{
		//First start the Observer
		if(FALSE == _poEvObserverRef->isObsRunning())
		{
			_poEvObserverRef->startObserver();
			usleep(100000); //some delay to let observer thread start
		}
		//Now Open the file to record events
		if(!_RecordFileHandl.is_open()) {
			_RecordFileHandl.open ((tCString)path.c_str(), ios_base::out);
		}

		if(_RecordFileHandl.good())
		{
			ETG_TRACE_USR4((" UsrActionEmu::Starring RECORDING To File: \"%s\" \n", path.c_str()));
			_poEvObserverRef->StartStopRecording(1);
			bStatus = TRUE;
		}
		else
		{
			_poEvObserverRef->StartStopRecording(0);
			ETG_TRACE_USR4(("UsrActionEmu::record Unable to OPEN file \"%s\" ", path.c_str()));
		}
	}
	else
	{
		_poEvObserverRef->StartStopRecording(0);
		usleep(100000); //allow some sleep
		if(_RecordFileHandl.is_open()) {
			ETG_TRACE_USR4((" UsrActionEmu::Stopping RECORDING To File: \"%s\" \n", path.c_str()));
			_RecordFileHandl.flush(); //to flush any remaining data
			_RecordFileHandl.close();
		}

		bStatus = TRUE;
	}

	 return bStatus;
}

tBool UsrActionEmu::replay(tU8 u8StartStop, std::string path)
{
	tBool bStatus = FALSE;
	_strReplayFilePath.clear();
	_strReplayFilePath = path;

	ETG_TRACE_USR4(("replay u8StartStop status = %d", u8StartStop));

	if(u8StartStop == 1)
	{
		bStatus = replayStart();
		ETG_TRACE_USR4((": replayStart() = %s \n", (bStatus==TRUE)?"SUCCESS":"FAILED"));
	}
	else
	{
		bStatus = replayStop();
		ETG_TRACE_USR4((": replayStop() = %s \n", (bStatus==TRUE)?"SUCCESS":"FAILED"));
	}

	return bStatus;
}

tBool UsrActionEmu::replayStart()
{
	tBool bStatus = FALSE;
	if(_strReplayFilePath.empty() == FALSE)
	{
		ETG_TRACE_USR4((" :STARTING.. REPLAY from File: %s \n", _strReplayFilePath.c_str()));

		if(_u8ReplayStatus == 0)
		{
			ETG_TRACE_USR4(("\nUsrActionEmu::replay()->Creating Playback Thread\n"));
			int status = _oThreadHandler.createObserverThread(&(UsrActionEmu::ReplayCallBack), reinterpret_cast<tVoid*>(this));
			bStatus = (status != -1)?TRUE:FALSE;
			if(bStatus == FALSE)
			{
				ETG_TRACE_USR4(("UsrActionEmu: Cannot Spawn Replay Thread !! ERROR !!\n"));
			}
			else
			{
			    _u8ReplayStatus = 1;
			}
		}
		else
		{
			ETG_TRACE_USR4(("UsrActionEmu::Already Replaying first stop the replay...Thread\n"));
			bStatus = FALSE;
		}
	}
	else
	{
		ETG_TRACE_USR4(("UsrActionEmu::NULL File ...Cannot Replay Exit!!\n"));
		bStatus =  FALSE;
	}
	return bStatus;
}

tBool UsrActionEmu::replayStop()
{
	tBool bStatus = FALSE;

	ETG_TRACE_USR4(("\nTerminating Replay Thread\n"));

	if(_u8ReplayStatus == 1)
	{
		_u8ReplayStatus = 0;
		this->_oThreadHandler.terminateObserverThread = TRUE;
		bStatus = (_oThreadHandler.detachObserverThread() != -1)?TRUE:FALSE;
		usleep(300000);
	}
	else
	{
		ETG_TRACE_USR4((": Stop Replay failed: Since no Replay is Running"));
	}
	return bStatus;
}

//This function shall be called by Event Observer once it gets Input Event
tVoid UsrActionEmu::RecordInputEvent(struct input_event Event, tU16 ScreenID)
{	//Input the elements into the file
	if(_RecordFileHandl.is_open())
	{
	   pthread_mutex_lock(&_MutexUsrAction);
	   _RecordFileHandl << Event.time.tv_sec << " " << Event.time.tv_usec << " " << Event.type << " " << Event.code << " " << Event.value <<" "<< ScreenID<<endl;
	   pthread_mutex_unlock(&_MutexUsrAction);
	}
	else
	{
	   //stop the recording
	    record(0);
	}
}

tVoid* UsrActionEmu::ReplayCallBack(void* pData)
{
	UsrActionEmu* pSelf = reinterpret_cast<UsrActionEmu*>(pData); //Dereference Name of device
	struct input_event EvData;
	memset(&EvData, 0, sizeof(struct input_event ));
	struct timeval time;
	memset(&time, 0, sizeof(struct timeval ));
	unsigned long usec;
	const unsigned long ERROR_MARGIN = 150; /* µs */
	tU16 type = 0;
	tU16 code = 0;
	tS32 value = 0;
	tU16 ScreenID = 0;
	ifstream myfile;
	//To store event data for Key
	tU16 type_history = 0;
	tU16 code_history = 0;
	tU16 value_Key = 0;
	tU16 key_sync = 0;
    //To store event data for Touch
	tU16 value_X = 0;
	tU16 value_Y = 0;
	tU16 value_TouchStatus = 0;
    tU16 value_SlotID = 0;
    tU16 touch_sync = 0;
	//Based on type of event call simulate Input Event for appropriate Type
	tS32 Ret = -1;
	tCString filepath = pSelf->_strReplayFilePath.c_str();

	if(filepath == NULL)
	{
		ETG_TRACE_USR4(("REPLAY THREAD: Null File path name Exitting Thread..!"));
		pSelf->_oThreadHandler.terminateObserverThread = TRUE;
		return (tVoid*)(NULL); //to solve Lint warning
	}

	myfile.open (filepath ,ios_base::in);

	if(TRUE == myfile.is_open() && FALSE == myfile.bad())
    {
		sleep(1);
		myfile.sync();
		myfile.seekg(0, std::ios::beg);
		//Starting Loop of thread Now
		while(myfile.eof() == false)
		{
			//Read one line from file and store in separate variables
			myfile >> time.tv_sec >> time.tv_usec  >> type >> code >> value >> ScreenID;
			//myfile.sync();

			key_sync = 0;
			touch_sync = 0;

			//Update EvData Time for first time to calculate delay
			if (EvData.time.tv_sec == 0 && EvData.time.tv_usec == 0)
			{
				EvData.time = time;
			}
			//calculate delay for the current event to be posted
			usec = UsrActionEmu::time_to_long(&time) - UsrActionEmu::time_to_long(&EvData.time);
			if (usec > (ERROR_MARGIN*2))
			{
				if (usec > UsrActionEmu::sec2microsec(30))
				{
					pSelf->_u8ReplayStatus = 0;
					break;
				}
				usleep(usec);
				EvData.time = time;
			}
			//Update EvData with new data read from file for next event
			EvData.type = type;
			EvData.code = code;
			EvData.value = value;
			//Lock the Mutex to synchronise the read of event from file and then simulate using appropriate Object
			pthread_mutex_lock(&pSelf->_MutexUsrAction);
			//Based on type of event call simulate Input Event for appropriate Type
			Ret = -1;
			switch(EvData.type)
			{
				case EV_KEY:
				{
					type_history = EV_KEY;
					code_history = EvData.code;

					if(EvData.code != 330)
					{
						value_Key = EvData.value;
						do {
							if(EvData.code > HK_DUMMY_START && EvData.code < HK_DUMMY_END)
							{
								Ret = write(_uHardKeyDeviceFD, &EvData, sizeof(struct input_event));
							}
							else if(EvData.code > SWC_DUMMY_START && EvData.code < SWC_DUMMY_END)
							{
								Ret = write(_uSWCKeyDeviceFD, &EvData, sizeof(struct input_event));
							}
							else if(EvData.code > JOYSTICK_DUMMY_START && EvData.code < JOYSTICK_DUMMY_END)
							{
								Ret = write(_uITCommKeyDeviceFD, &EvData, sizeof(struct input_event));
							}
							else
							{
								Ret = write(_uHardKeyDeviceFD, &EvData, sizeof(struct input_event));
							}
						}while(Ret == -1 && errno == EINTR);
					}
					else
					{
						//This is special Key event for BTN_TOUCH
						value_TouchStatus = EvData.value;
						do {
							if(ScreenID == 2)
								Ret = write(_uTouchDevice_SecFD, &EvData, sizeof(struct input_event));
							else
								Ret = write(_uTouchDeviceFD, &EvData, sizeof(struct input_event));
						}while(Ret == -1 && errno == EINTR);
					}

				}
				break;
				case EV_REL:
				{
					type_history = EV_REL;
					do {
						Ret = write(_uEncoderDeviceFD, &EvData, sizeof(struct input_event));
					}while(Ret == -1 && errno == EINTR);
				}
				break;
				case EV_ABS:
				{
					type_history = EV_ABS;
				    code_history = EvData.code;
                    //Check Event Code and Update X, Y and Slot ID(In case multi touch)
				    value_X =  (EvData.code == ABS_X) ? EvData.value : value_X;
					value_Y = (EvData.code == ABS_Y) ? EvData.value : value_Y;
					value_SlotID = (EvData.code == ABS_MT_SLOT) ? EvData.value : value_SlotID;
					ETG_TRACE_USR4(("REPLAY THREAD:Touch At-> ScreenID=(%d) SlotID=(%d) X=(%d) Y=(%d) Status=(%d)",ScreenID,value_SlotID,value_X,value_Y,value_TouchStatus));
					do{
						if(ScreenID == 2)
							Ret = write(_uTouchDevice_SecFD, &EvData, sizeof(struct input_event));
						else
							Ret = write(_uTouchDeviceFD, &EvData, sizeof(struct input_event));

					}while(Ret == -1 && errno == EINTR);

				}
				break;
				case EV_SYN:
				{
					switch(type_history)
					{
						case EV_KEY:
						{
							if(code_history != 330)
							{
								do {
									if(code_history > HK_DUMMY_START && code_history < HK_DUMMY_END)
									{
										Ret = write(_uHardKeyDeviceFD, &EvData, sizeof(struct input_event));
									}
									else if(code_history > SWC_DUMMY_START && code_history < SWC_DUMMY_END)
									{
										Ret = write(_uSWCKeyDeviceFD, &EvData, sizeof(struct input_event));
									}
									else if(code_history > JOYSTICK_DUMMY_START && code_history < JOYSTICK_DUMMY_END)
									{
										Ret = write(_uITCommKeyDeviceFD, &EvData, sizeof(struct input_event));
									}
									else
									{
										Ret = write(_uHardKeyDeviceFD, &EvData, sizeof(struct input_event));
									}
								}while(Ret == -1 && errno == EINTR);
							}
							else
							{
								do {
									if(ScreenID == 2)
										Ret = write(_uTouchDevice_SecFD, &EvData, sizeof(struct input_event));
									else
										Ret = write(_uTouchDeviceFD, &EvData, sizeof(struct input_event));

								}while(Ret == -1 && errno == EINTR);
							}
							key_sync = 1;
						}
						break;
						case EV_REL:
						{
							do{
								Ret = write(_uEncoderDeviceFD, &EvData, sizeof(struct input_event));
							}while(Ret == -1 && errno == EINTR);
						}
						break;
						case EV_ABS:
						{
							do{
								if(ScreenID == 2)
									Ret = write(_uTouchDevice_SecFD, &EvData, sizeof(struct input_event));
								else
									Ret = write(_uTouchDeviceFD, &EvData, sizeof(struct input_event));
							}while(Ret == -1 && errno == EINTR);
							touch_sync = 1;
						}
						break;
						default:
						break;
					}


				}
				break;
				default:
				break;
			}

			pthread_mutex_unlock(&pSelf->_MutexUsrAction);

			if(pSelf->_oThreadHandler.terminateObserverThread  == TRUE)
		    {
				ETG_TRACE_USR4(("REPLAY THREAD: Attempt terminating Replay in middle!"));
                //Check Incomplete Key operation, so continue replay for some more time.
				if( (type_history == EV_KEY) && (code_history != BTN_TOUCH) )
				{
					if( (value_Key != 0) || (key_sync != 1) )
					{
						ETG_TRACE_USR4(("REPLAY THREAD: No Key is released  continue replay  ....!"));
						continue;
					}
				}
                //Check Incomplete Touch operation found so continue replay for some more time.
				if( (type_history == EV_ABS) || (code_history == BTN_TOUCH) )
				{
					if( (value_TouchStatus != 0) || (touch_sync != 1) )//Check if Touch status is Released or Not
					{
						ETG_TRACE_USR4(("REPLAY THREAD: No Touch is released  continue replay ....!"));
						continue;
					}
				}

				//break if all above checks are false
				break;
			}

	    } //End of While loop

		pthread_mutex_lock(&pSelf->_MutexUsrAction);
		//Sync and close the file
		myfile.sync();
		myfile.clear();
		myfile.seekg(0, std::ios::beg);
		myfile.close();
		pthread_mutex_unlock(&pSelf->_MutexUsrAction);

		if(myfile.fail() == TRUE)
		{
			ETG_TRACE_USR4(("REPLAY THREAD: Error Closing file"));
		}
    }
    else
    {
    	ETG_TRACE_USR4(("REPLAY THREAD: Error Opening the file or Invalid File!!\n"));
    }
	pSelf->_u8ReplayStatus = 0; //Reset Replay Flag to zero
	pSelf->_oThreadHandler.terminateObserverThread = TRUE;
	ETG_TRACE_USR4(("REPLAY THREAD: Ending Replay..!"));

	return (tVoid*)(NULL); //to solve Lint warning
}



