/*
 * EventObserver.h
 *
 *  Created on: Aug 25, 2015
 *      Author: sgt4kor
 */

#ifndef EVKEYOBSERVER_H_
#define EVKEYOBSERVER_H_

#include "EvIncludes.h"
#include "../EvDataHandler/EvKeyDataHandler.h"
#include "../EvDataHandler/EvTouchDataHandler.h"
#include "../EvDataHandler/EvEncDataHandler.h"
#include "../../CcaServiceHdl/Ivd_input_ServiceHandler.h"

#include "../../Macro.h"
#include <map>
#include <iterator>
#define VD_INPUT_S_IMPORT_INTERFACE_KEYCODES
#include "vd_input_if.h"



//Forward Declarations
class UsrActionEmu;
class CSMInterface;

#define MAX_INPUT_DEVICES 14

class EventObserver: public Ivd_inputBase{

public:
    static EventObserver* pSelf;
    //Alok
    static tBool bIsJammingCheckActive;
    //Alok
	static tBool bIsObserverActive;
	EpollInput _oEpollInput;
	//static pthread_mutex_t _MutexUsrAction;
	//Constructor
	EventObserver(vd_input_tclMain* poMain);
	//Destructor
	virtual ~EventObserver();
	//Set Of Virtual Functions to be overriden from base class
	virtual const tChar* getName() const {return "EventObserver"; }
	virtual const tChar* getIfName() const {return "EventObserver"; }
	virtual tVoid vHandleMessage(TMsg* pMsg) {(tVoid)pMsg;  } //Lintfix
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo();

    //Thread common callback function for All key Events
    static tVoid* EvObserverCallback(tVoid* pData);
    static tVoid* TouchJammingCallback(tVoid*);
    //Public Methods
    tS32 startObserver();
    //Alok
    tVoid startJammingCheckThread();
    tVoid updateDeviceActivityCounter();		//Made public to increment counter on USB,SD Card, AUX and CD
    //Alok
    tVoid stopObserver();
    inline tBool isObsRunning()
    {
    	return bIsObserverActive;
    }
    //Set of Methods to be used by CCA Service Class to provide Ev Info to Client Diagnostics
    Keylist* getKeyList();
    Encoderlist* getEncoderDirList();
    Touchlist* getTouchInfoList();
    Touchlist* getTouchInfoListPIVISecondary();
    tVoid getKeyEvInfo(tU16* Keycode, tU8* Status);
    tVoid getEncoderEvInfo(tU16* EncType, tS32* Steps);
    tVoid getTouchEvInfo(tS32* X, tS32* Y, tS32* Status);
    tVoid getEncoderStatus(input_mainfi_tclMsgEncoderStatusStatus *Encoderobj);
    tBool StartStopRecording(tU8 u8StartStop);
    inline tVoid lockKeyList()
    {
    	_tEvKeyDataHandler.lockKeyList();
    }
    inline tVoid lockEncoderList()
    {
    	_tEvEncDataHandler.lockEncoderList();
    }
    inline tVoid lockTouchList()
    {
    	_tEvTouchDataHandler.lockTouchList();
    }
    inline tVoid lockTouchList_PIVISecondary()
    {
    	_tEvTouchDataHandler_PIVI.lockTouchList();
    }
    inline tVoid unlockKeyList()
    {
    	_tEvKeyDataHandler.unlockKeyList();
    }
    inline tVoid unlockEncoderList()
    {
    	_tEvEncDataHandler.unlockEncoderList();
    }
    inline tVoid unlockTouchList()
    {
    	_tEvTouchDataHandler.unlockTouchList();
    }
    inline tVoid unlockTouchList_PIVISecondary()
	{
		_tEvTouchDataHandler_PIVI.unlockTouchList();
	}
    inline tS32 getScreenNumber_PIVI()
    {
    	return s32ScreenID;
    }
    /*Calling this function shall check all /dev/input/eventX
    devices and Print All the configured HMI key Names - Code for each device*/
    tS32 printVariantSupportedKeyList();



private:
    //Member Variables
    tBool bIsDeviceMissing;
    tS8 _s8ActivityCounter;
    tS32 _s32EventTypeHistory;
    tU8 _u8StartStopRecording;
    UsrActionEmu* _pUsrActionEmuRef;
	EvKeyDataHandler _tEvKeyDataHandler;  //For Handling and storing Key Data
    EvEncDataHandler _tEvEncDataHandler;	//For Handling and storing Encoder Data
	EvTouchDataHandler _tEvTouchDataHandler; //For Handling and storing Touch Data
	EvTouchDataHandler _tEvTouchDataHandler_PIVI;  //For Handling and storing PIVI Secondary Screen Touch Data

	//Alok
	tS32 s32ScreenID;
	EvTouchDataHandler _tEvTouchJamDataHandler;
	ThreadHandler _oThreadHandler;
	//Alok
	ThreadHandler _oJammingHandler;
	//Alok
	std::vector<std::string> _stlAllDevNameList;
	std::vector<int> _FileDescList;
	std::map <int,std::string> FileMap;
	std::map <eVDInput_KeyCodes, std::string> KeyMap; //This is Full HMI key MAP for lookup.
	tVoid initKeyMap();                               //Insert All HMI key codes and Names
	//tVoid updateDeviceActivityCounter();				//Made public to increment counter on USB,SD Card, AUX and CD
	std::string getKeyName(eVDInput_KeyCodes Keycode);
	//CSM Interface pointer to send Device Activity
	CSMInterface* _poMyCSMInterface;

	//Private Member Functions
	tS32 createDevFileList();
    tVoid addDevicesToMontior();
    tVoid removeDevicesToMontior();
    tVoid HandleInputEvent(struct input_event Event);
    //CSM_C_ASIG_TX_MMCustomerAction
    tVoid sendDeviceActivity();
    tBool isCheckDevice(int fd,const char* Device);
};

#endif /* EVKEYOBSERVER_H_ */
