/*
 * EvTouchDataHandler.h
 *
 *  Created on: Aug 26, 2015
 *      Author: sgt4kor
 */

#ifndef EVTOUCHDATAHANDLER_H_
#define EVTOUCHDATAHANDLER_H_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include <linux/input.h>
#include <vector> //using std::vector
#include <pthread.h>
#define TOUCH_LIST_MAX_SIZE 5

typedef struct
{
	tS64 s64EvTime;
	tS32 s32XCoord;
	tS32 s32YCoord;
	tU8 u8TouchStatus;
	tU8 u8SlotID;
}sTouchListElelment;

typedef std::vector<sTouchListElelment> Touchlist;

class EvTouchDataHandler {
public:
    Touchlist _tTouchlist;
    tBool bStatus;				
	EvTouchDataHandler();
	virtual ~EvTouchDataHandler();
	tVoid handleTouchEvData(struct input_event sEvent);
	Touchlist* getUpdatedTouchList(); // to get touch entires within 2 Secs
	inline tVoid lockTouchList()
	{
		pthread_mutex_lock(&_MutexTouchList);
	}
	inline tVoid unlockTouchList()
	{
		pthread_mutex_unlock(&_MutexTouchList);
	}
private:
	sTouchListElelment _sTouchData;
	pthread_mutex_t _MutexTouchList;

    tVoid storeTouchData(sTouchListElelment& TouchData);
	tVoid addNewTouchEntry(sTouchListElelment& TouchData);
	tBool changeTouchEntry(sTouchListElelment& TouchData);
	tVoid delObsoleteTouchEntries();

};

#endif /* EVTOUCHDATAHANDLER_H_ */
