/*
 * EvTouchDataHandler.cpp
 *
 *  Created on: Aug 26, 2015
 *      Author: sgt4kor
 */

#include "EvTouchDataHandler.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_CLIENT_DIAGNOSTICS
#include "trcGenProj/Header/EvTouchDataHandler.cpp.trc.h"
#endif

EvTouchDataHandler::EvTouchDataHandler()
{
	// Initialize all Member variables to 0
	_sTouchData.s64EvTime = 0;
	_sTouchData.u8TouchStatus = 0;
	_sTouchData.s32XCoord = 0;
	_sTouchData.s32YCoord = 0;
	_sTouchData.u8SlotID = 0;
	bStatus = FALSE;
    _tTouchlist.clear();
	//initialise the mutex
	pthread_mutex_init(&_MutexTouchList, NULL);

}

EvTouchDataHandler::~EvTouchDataHandler()
{
// De-Initialization or cleanup
	_sTouchData.s64EvTime = 0;
	_sTouchData.u8TouchStatus = 0;
	_sTouchData.s32XCoord = 0;
	_sTouchData.s32YCoord = 0;
	_sTouchData.u8SlotID = 0;
	bStatus = FALSE;
    _tTouchlist.clear();
    //Destroy the mutex
    pthread_mutex_destroy(&_MutexTouchList);
}

tVoid EvTouchDataHandler::handleTouchEvData(struct input_event sEvent)
{
    pthread_mutex_lock (&_MutexTouchList); //lock the mutex
    tU16 EventCode = sEvent.code;
    tS64 EventTimeStamp  = (tS64)sEvent.time.tv_sec;

	switch(EventCode)
	{
		case ABS_MT_POSITION_X:
		{
			_sTouchData.s32XCoord = sEvent.value;
			bStatus = TRUE;
		}
		break;
		case ABS_MT_POSITION_Y:
		{
			_sTouchData.s32YCoord = sEvent.value;
			bStatus = TRUE;
		}
		break;
		case BTN_TOUCH:
		{
			//bStatus = FALSE;
			_sTouchData.u8SlotID = 0;
			//simply apply value filter to make sure we fill either 1 or 0
			_sTouchData.u8TouchStatus = (sEvent.value == 1) ? 1:0;
		    //ETG_TRACE_USR4(("EvTouchDataHandler::handleTouchEvData()-> BTN_TOUCH X=%d, Y=%d, Status=%d, Time=%d",_sTouchData.s32XCoord,
		    				//_sTouchData.s32YCoord, _sTouchData.u8TouchStatus, _sTouchData.s64EvTime));
		}
		break;
		case ABS_MT_SLOT:
		{
			bStatus = FALSE;
			_sTouchData.u8SlotID = sEvent.value;
			//ETG_TRACE_USR4((": handleTouchEvData():ABS_MT_SLOT-> Slot ID= %d, X=%d, Y=%d, Status=%d, Time=%d", _sTouchData.u8SlotID, _sTouchData.s32XCoord,
					    				//_sTouchData.s32YCoord, _sTouchData.u8TouchStatus, _sTouchData.s64EvTime));
		}
		break;
		case ABS_MT_TRACKING_ID:
		{
			bStatus = FALSE;
			_sTouchData.u8TouchStatus = (sEvent.value != -1) ? 1:0;
			//ETG_TRACE_USR4((": handleTouchEvData():ABS_MT_TRACKING_ID -> Slot ID= %d, X=%d, Y=%d, Status=%d, Time=%d", _sTouchData.u8SlotID, _sTouchData.s32XCoord,
							    				//_sTouchData.s32YCoord, _sTouchData.u8TouchStatus, _sTouchData.s64EvTime));
		}
		break;
		default:
		{
			//Do Nothing
		}
		break;
	}

    if(sEvent.type == EV_SYN)
    {

    	//ETG_TRACE_USR4(("EvTouchDataHandler::handleTouchEvData()-> SYN_REPORT(%d):SlotID(%d), X=%d, Y=%d, Status=%d, Time=%d", sEvent.code, _sTouchData.u8SlotID ,_sTouchData.s32XCoord,
								//_sTouchData.s32YCoord, _sTouchData.u8TouchStatus, _sTouchData.s64EvTime));
		//Indicates one Touch operation
		_sTouchData.s64EvTime = EventTimeStamp; //Update Event Time in TouchData
		//send TouchData Structure to store in list
		storeTouchData(_sTouchData);
    }

	pthread_mutex_unlock (&_MutexTouchList);//unlock the mutex
}

Touchlist* EvTouchDataHandler::getUpdatedTouchList()
{
	pthread_mutex_lock (&_MutexTouchList); //lock the mutex
	//Do List clean up & then Send this to requesting client
	delObsoleteTouchEntries();
	pthread_mutex_unlock (&_MutexTouchList);//unlock the mutex
	return(&_tTouchlist);
}


tVoid EvTouchDataHandler::storeTouchData(sTouchListElelment& TouchData)
{
	if(FALSE == changeTouchEntry(TouchData))
	{
		//add New Touch Entry
		addNewTouchEntry(TouchData);
	}

}

tVoid EvTouchDataHandler::addNewTouchEntry(sTouchListElelment& TouchData)
{
    //If size is full then check and delete obsolete entries to create space
	if(_tTouchlist.size() > TOUCH_LIST_MAX_SIZE)
	{
		delObsoleteTouchEntries();
	}
	//If Touch list size increases beyond max then delete last element before insertion
	if(_tTouchlist.size() > TOUCH_LIST_MAX_SIZE)
	{
		_tTouchlist.pop_back();
	}

	// Now Add The element to List after size check and obsolete check
	_tTouchlist.push_back(TouchData);
}

tBool EvTouchDataHandler::changeTouchEntry(sTouchListElelment& TouchData)
{
	tBool bTouchEntryExist = FALSE;
	Touchlist::iterator tIterator;

	if(FALSE == _tTouchlist.empty())
	{
		for (tIterator = _tTouchlist.begin(); tIterator != _tTouchlist.end(); tIterator++)
		{
			//Check if Same X,Y Coord is present just update status and time
			if((tIterator->u8SlotID == TouchData.u8SlotID))
			{
				bTouchEntryExist = TRUE; //Element Exist in List
				tIterator->u8TouchStatus = TouchData.u8TouchStatus; //update Status
				tIterator->s64EvTime = TouchData.s64EvTime; //update time
				if(bStatus == TRUE)
				{
					tIterator->s32XCoord = TouchData.s32XCoord;
					tIterator->s32YCoord = TouchData.s32YCoord;
				}
			}
		}
	}

	return bTouchEntryExist;
}

tVoid EvTouchDataHandler::delObsoleteTouchEntries()
{
	Touchlist::iterator tIterator;
	struct timeval CurrTime;
	gettimeofday (&CurrTime, NULL); //get current time from system

	if (FALSE == _tTouchlist.empty()) //If List is filled
	{
		//ETG_TRACE_USR4(("EvTouchDataHandler::delObsoleteTouchEntries() -> _tTouchlist No Of Entries = %d",_tTouchlist.size()));
		//parse the list and check Time with current time
		for (tIterator = _tTouchlist.begin(); tIterator != _tTouchlist.end(); /**/)
		{
			//If time difference is greater than 2Sec than delete the element
			if((CurrTime.tv_sec - tIterator->s64EvTime) > 2)
			{
				//If touch is till pressed don't delete --fix for NCG3D-17794
				if(tIterator->u8TouchStatus == 1){
					if((CurrTime.tv_sec - tIterator->s64EvTime) > 30){
						//ETG_TRACE_USR4((":EvTouchDataHandler:WARNING!: Touch (Slot ID = %d) is PRESSED State at [X(%d), Y(%d)]: Status=(%d) more than 30 secs:Ev Occurrence Time=%d", tIterator->u8SlotID,
							//	         tIterator->s32XCoord, tIterator->s32YCoord, tIterator->u8TouchStatus, tIterator->s64EvTime));
						tIterator = _tTouchlist.erase(tIterator);
						//ETG_TRACE_USR4((":EvTouchDataHandler:INFO: ERASING.... this touch Entry from Input List!"));
					}
					else{
						//ETG_TRACE_USR4((":EvTouchDataHandler:INFO: Touch Entry Found : State Pressed < 30 secs, So No Action Taken!"));
						tIterator++; //just move to next element
					}
				}
				else {
					tIterator = _tTouchlist.erase(tIterator);
				}
			}
			else
			{
				tIterator++;
			}
		}//END of FOR
	}//END OF IF

}//End of delObsoleteTouchEntries()
