/*
 * EvKeyDataHandler.cpp
 *
 *  Created on: Aug 25, 2015
 *      Author: sgt4kor
 */

#include "EvKeyDataHandler.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_CLIENT_DIAGNOSTICS
#include "trcGenProj/Header/EvKeyDataHandler.cpp.trc.h"
#endif


EvKeyDataHandler::EvKeyDataHandler()
{
	_sKeyEventInfo.s64EvTime = 0;
	_sKeyEventInfo.u16KeyCode = 0;
	_sKeyEventInfo.u8Status = 0;
	_tKeyList.clear();
	//initialise the mutex
	pthread_mutex_init(&_MutexKeyList, NULL);
}

EvKeyDataHandler::~EvKeyDataHandler()
{
	_sKeyEventInfo.s64EvTime = 0;
	_sKeyEventInfo.u16KeyCode = 0;
	_sKeyEventInfo.u8Status = 0;
	_tKeyList.clear();
   //Destroy the mutex
	pthread_mutex_destroy(&_MutexKeyList);
}

tVoid EvKeyDataHandler::handleKeyEvData(struct input_event sEvent)
{
	ETG_TRACE_USR4(("EvKeyDataHandler::handleKeyEvData() EVENT[%d, %d, %d]",sEvent.type,sEvent.code,sEvent.value ));

	pthread_mutex_lock (&_MutexKeyList); //lock the mutex

	_sKeyEventInfo.s64EvTime = sEvent.time.tv_sec;
	_sKeyEventInfo.u16KeyCode = sEvent.code;
	_sKeyEventInfo.u8Status = sEvent.value;

	//check if element already present and if yes update
	//Else Add new Key Entry if it is not Present in List
	if(TRUE == changeExistingKeyElement(_sKeyEventInfo))
	{
		//ETG_TRACE_USR4(("EvKeyDataHandler::handleKeyEvData()->changed existing Key Data"));
	}
	else
	{
		addKeyElement(_sKeyEventInfo);
		//ETG_TRACE_USR4(("EvKeyDataHandler::handleKeyEvData()->Added New Key Data"));
	}

	pthread_mutex_unlock (&_MutexKeyList);//unlock the mutex

}


Keylist*  EvKeyDataHandler::getUpdatedKeyList()
{
	pthread_mutex_lock (&_MutexKeyList); //lock the mutex
	//Do List clean up & then Send this to requesting client
	delObsoleteEntries();
	pthread_mutex_unlock (&_MutexKeyList);//unlock the mutex

	return (&_tKeyList);
}


tVoid EvKeyDataHandler::addKeyElement(sKeyListElelment& KeyElement)
{
	//Check if List Size Has reached Threshold
	if(_tKeyList.size() > LIST_THRESHOLD_INDEX)
	{
		//Delete Obsolete Entries and do cleanup
		delObsoleteEntries();
	}
	if(_tKeyList.size() > LIST_THRESHOLD_INDEX)
	{
		//if still its more then delete one entry at end
		_tKeyList.pop_back();
	}
	//Add new entry after cleanup & size check
	_tKeyList.push_back(KeyElement);
}


tBool EvKeyDataHandler::changeExistingKeyElement(sKeyListElelment& KeyElement)
{
	tBool bElementExist = FALSE;
	Keylist::iterator tIterator;

	if (FALSE == _tKeyList.empty()) //If List is filled
	{
		//parse the list and check Time with current time
		for (tIterator = _tKeyList.begin(); tIterator != _tKeyList.end(); tIterator++)
		{
			//If key code of current matches with the one present in Vector
			if(tIterator->u16KeyCode == KeyElement.u16KeyCode)
			{
				//update time of event occurence
				tIterator->s64EvTime = KeyElement.s64EvTime;
				//Update Status of Key, if pressed then 1, if released then 2 -> indicating delayed
				tIterator->u8Status = (KeyElement.u8Status != 0)? 1:2;

				bElementExist = TRUE;
				break;
			}
		}
	}

	return bElementExist;
}


tVoid EvKeyDataHandler::delObsoleteEntries()
{
	Keylist::iterator tIterator;
	struct timeval CurrTime;
	gettimeofday (&CurrTime, NULL); //get current time from system

	if (FALSE == _tKeyList.empty()) //If List is filled
	{
		//parse the list and check Time with current time
		for (tIterator = _tKeyList.begin(); tIterator != _tKeyList.end(); /**/)
		{
			//If time difference is greater than 2Sec than delete the element
			if((CurrTime.tv_sec - tIterator->s64EvTime) > 2)
			{
				if(tIterator->u8Status == 1) {
					//If key is till pressed don't delete --fix for NCG3D-9049
					tIterator++; //just move to next element
				}
				else{
					//erase current element and update iterator to point to next element
					tIterator = _tKeyList.erase(tIterator);
				}
			}
			else
			{
				tIterator++;
			}
		} //end of For loop
	}

}

