/*
 * EvEncDataHandler.cpp
 *
 *  Created on: Aug 26, 2015
 *      Author: sgt4kor
 */

#include "EvEncDataHandler.h"
#include<limits>


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "../../etg_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_INPUT_CLIENT_DIAGNOSTICS
#include "trcGenProj/Header/EvEncDataHandler.cpp.trc.h"
#endif

EvEncDataHandler::EvEncDataHandler()
{
	_sEncListElement.s64EvTime = 0;
	_sEncListElement.s8EncSteps = 0;
	_sEncListElement.u16EncType = 0;
	_tEncoderlist.clear();
	resetEncoderStatus();
	//initialise the mutex
	pthread_mutex_init(&_MutexEncoder, NULL);
}

EvEncDataHandler::~EvEncDataHandler()
{
	_sEncListElement.s64EvTime = 0;
	_sEncListElement.s8EncSteps = 0;
	_sEncListElement.u16EncType = 0;
	_tEncoderlist.clear();
   //Destroy the mutex
	pthread_mutex_destroy(&_MutexEncoder);
}

tVoid EvEncDataHandler::handleEncEvData(struct input_event sEvent)
{
	if(sEvent.type  != EV_SYN)
	{
		ETG_TRACE_USR4(("EvEncDataHandler::handleEncEvData(): EncoderEvent(%d): (EncType)= %d, (Encoder Step) = %d",sEvent.type,sEvent.code,sEvent.value ));
	}
	else
	{
		ETG_TRACE_USR4(("EvEncDataHandler::handleEncEvData()-------------Sync Report-------------"));
	}
	pthread_mutex_lock (&_MutexEncoder); //lock the mutex

	_sEncListElement.s64EvTime = sEvent.time.tv_sec;
	_sEncListElement.u16EncType = sEvent.code;
	_sEncListElement.s8EncSteps = (tS8)sEvent.value;

	//check if element already present and if yes update
	//Else Add new Key Entry if it is not Present in List
	if(TRUE == changeExistingEncEntry(_sEncListElement))
	{
		//Also update encoder Status Record
		updateEncoderStatus(_sEncListElement);

		pthread_mutex_unlock (&_MutexEncoder); //unlock the mutex	--> Coverity: 46845
		ETG_TRACE_USR4(("EvEncDataHandler::handleEncEvData()->changed existing Encoder Data"));
	}
	else
	{
		addNewEncEntry(_sEncListElement);
		//Also update encoder Status Record
		updateEncoderStatus(_sEncListElement);

		pthread_mutex_unlock (&_MutexEncoder); //unlock the mutex	--> Coverity: 86583
		ETG_TRACE_USR4(("EvEncDataHandler::handleEncEvData()->Added New Key Data"));
	}
	//Also update encoder Status Record
	//updateEncoderStatus(_sEncListElement);

	//pthread_mutex_unlock (&_MutexEncoder); //unlock the mutex
}

tVoid EvEncDataHandler::resetEncoderStatus()
{
	_s8EncStatus_1 = 0; //For Left or Volume Encoder
	_s8EncStatus_2 = 0; //For Right or Browse Encoder
	_s8EncStatus_3 = 0;
	_s8EncStatus_4 = 0;
	_s8EncStatus_5 = 0;

}

tVoid EvEncDataHandler::updateEncoderStatus(sEncListElelment& sEncListElement)
{
	enEncoderType encType = (enEncoderType)sEncListElement.u16EncType;
	tS8 s8Steps = sEncListElement.s8EncSteps;


	switch(encType)
	{
		case ENCODER_1:
		{
			if(std::numeric_limits<tS8>::min() < (_s8EncStatus_1+s8Steps) < std::numeric_limits<tS8>::max())
				_s8EncStatus_1 += s8Steps;
			else
				_s8EncStatus_1 = 0;
		}
		break;
		case ENCODER_2:
		{
			if(std::numeric_limits<tS8>::min() < (_s8EncStatus_2+s8Steps) < std::numeric_limits<tS8>::max())
				_s8EncStatus_2 += s8Steps;
			else
				_s8EncStatus_2 = 0;
		}
		break;
		case ENCODER_3:
				{
					if(std::numeric_limits<tS8>::min() < (_s8EncStatus_3+s8Steps) < std::numeric_limits<tS8>::max())
						_s8EncStatus_3 += s8Steps;
					else
						_s8EncStatus_3 = 0;
				}
		break;
		case ENCODER_4:
				{
					if(std::numeric_limits<tS8>::min() < (_s8EncStatus_4+s8Steps) < std::numeric_limits<tS8>::max())
						_s8EncStatus_4 += s8Steps;
					else
						_s8EncStatus_4 = 0;
				}
		break;
		case ENCODER_5:
				{
					if(std::numeric_limits<tS8>::min() < (_s8EncStatus_5+s8Steps) < std::numeric_limits<tS8>::max())
						_s8EncStatus_5 += s8Steps;
					else
						_s8EncStatus_5 = 0;
				}
		break;
		default:
		break;
	}

}

Encoderlist* EvEncDataHandler::getUpdatedEncoderDirList()
{
	pthread_mutex_lock (&_MutexEncoder); //lock the mutex
	//Do List clean up & then Send this to requesting client
	delObsoleteEncEntries();
	pthread_mutex_unlock (&_MutexEncoder); //unlock the mutex
	return (&_tEncoderlist);
}

tVoid EvEncDataHandler::addNewEncEntry(sEncListElelment& sEncListElement)
{
	//Check if List Size Has reached Threshold
	if(_tEncoderlist.size() > ENC_LIST_SIZE)
	{
		//Delete Obsolete Entries and do cleanup
		delObsoleteEncEntries();
	}
	if(_tEncoderlist.size() > ENC_LIST_SIZE)
	{
		//Delete Last Entry
		_tEncoderlist.pop_back();
	}
	//Add new entry after cleanup check
	_tEncoderlist.push_back(sEncListElement);
}

tBool EvEncDataHandler::changeExistingEncEntry(sEncListElelment& sEncListElement)
{
	tBool bElementExist = FALSE;
	Encoderlist::iterator tIterator;

	if (FALSE == _tEncoderlist.empty()) //If List is filled
	{
		//parse the list and check Time with current time
		for (tIterator = _tEncoderlist.begin(); tIterator != _tEncoderlist.end(); tIterator++)
		{
			//If key code of current matches with the one present in Vector
			if(tIterator->u16EncType == sEncListElement.u16EncType)
			{
				//update time of event occurence
				tIterator->s64EvTime = sEncListElement.s64EvTime;
				//Update Status of Key, if pressed then 1, if released then 2 -> indicating delayed
				tIterator->s8EncSteps = sEncListElement.s8EncSteps;

				bElementExist = TRUE;
				break;
			}
		}
	}

	return bElementExist;
}

tVoid EvEncDataHandler::delObsoleteEncEntries()
{
	Encoderlist::iterator tIterator;
	struct timeval CurrTime;
	gettimeofday (&CurrTime, NULL); //get current time from system

	if (FALSE == _tEncoderlist.empty()) //If List is filled
	{
		//parse the list and check Time with current time
		for (tIterator = _tEncoderlist.begin(); tIterator != _tEncoderlist.end();/**/ )
		{
			//If time difference is greater than 2Sec than delete the element
			if((CurrTime.tv_sec - tIterator->s64EvTime) > 2)
			{
				tIterator = _tEncoderlist.erase(tIterator);
			}
			else
			{
				tIterator++;
			}
		}
	}
}
