/*
 * vd_input_StatusServiceHandler.h
 *
 *  Created on: Feb 5, 2014
 *      Author: sgt4kor
 */

#ifndef VD_INPUT_DEVINFOSERVICEHANDLER_H_
#define VD_INPUT_DEVINFOSERVICEHANDLER_H_

#include "Ivd_input_ServiceHandler.h"
//#include "../EvDataManager/EvObserver/EventObserver.h"

class UsrActionEmu;
class EventObserver;

class vd_input_StatusServiceHandler: public Ivd_input_tclServiceHandler
{

protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:
   vd_input_StatusServiceHandler(vd_input_tclMain* poMainAppl, tU16 u16ServiceID,
                                 tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion);
   virtual ~vd_input_StatusServiceHandler(); //Destructor

   
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   virtual tVoid vOnLoopbackService(amt_tclServiceData* poMessage);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
							  
   virtual const tChar* getName() const { return "vd_input_StatusServiceHandler"; };
   virtual tVoid vHandleMessage(Ivd_inputBase::TMsg* pMsg);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   virtual tVoid vUpdateClients(tU16 u16FunctionId, amt_tclServiceData* roOutMsg);
   //Existing Framework Base class Function
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId, amt_tclServiceData& roOutMsg,
                                       amt_tclServiceData* poIncomingMessage);

private:
   vd_input_tclMain* pvd_inputAppInstance;
   EventObserver* _pEvObserverObjRef;
   UsrActionEmu* _pUsrActionEmuRef;
   //Map to include Handlers for Get and Set Properties
   DECLARE_MSG_MAP(vd_input_StatusServiceHandler)

public:
   /**********************************************************************************************
    *  Set of virtual functions
    *********************************************************************************************/

   /****************************************************************************
   * Properties and Method Handlers to be included in MAP
   ***************************************************************************/
   //Properties
   tVoid HandlePressedKeys(amt_tclServiceData* poMessage);
   tVoid HandleEncoderDirList(amt_tclServiceData* poMessage);
   tVoid HandleEncoderStatus(amt_tclServiceData* poMessage);
   tVoid HandleTouchStatus(amt_tclServiceData* poMessage);
   tVoid HandlePIVISecondaryTouchStatus(amt_tclServiceData* poMessage);
   //Methods
   tVoid onEnableInputEvent(amt_tclServiceData* poMessage);
   tVoid onDisableInputEvent(amt_tclServiceData* poMessage);
   tVoid onSimulateKeyInjection(amt_tclServiceData* poMessage);
   tVoid onSimulateEncRotation(amt_tclServiceData* poMessage);
   tVoid onSimulateSingleTouch(amt_tclServiceData* poMessage);
   tVoid onSimulateTouchSlide(amt_tclServiceData* poMessage);
   tVoid onSimulateMultiTouch(amt_tclServiceData* poMessage);
   tVoid onGuestureRecord(amt_tclServiceData* poMessage);
   tVoid onGuestureReplay(amt_tclServiceData* poMessage);
   tVoid onSimulatePIVITouch(amt_tclServiceData* poMessage);
   tVoid onDevInputNotifyConnection(amt_tclServiceData* poMessage);
   tVoid onSimulatePIVITouchSlide(amt_tclServiceData* poMessage);
private:
   tBool vEnableEventObserver();
   tBool vDisableEventObserver();
   //Functions internally used by class
   //Common Functions:
   //This is used to send the Answer for Status
   tVoid vSendStatusAnswerVisitorMessage( const amt_tclServiceData* poMessage,
                                          fi_tclVisitorMessage* poResultMsg );
   //This is used to send the Answer for Method Result
   tVoid vSendMethodResultVisitorMessage( const amt_tclServiceData* poMessage,
                                          fi_tclVisitorMessage* poResultMsg );


};



#endif /* VD_INPUT_DEVINFOSERVICEHANDLER_H_ */
