/*****************************************************************************
* FILE:         vd_clock_ServiceClockIf.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ServiceIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ServiceClockIf__IF__H_
#define __vd_clock_ServiceClockIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_vd_clock_ServiceClockIf.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_ServiceClockCallbackIf.h"

// vd_clock_tclServiceClockIf_Include: user specific code start
#include "vd_clock_datetime.h"
#include "vd_clock_datacontainer.h"
//#include "vd_clock_Event.h"
#include "vd_clock_timezone.h"
#include "vd_clock_INCAdapter.h"

#include "I_vd_clock_ClientSensorIf.h"
class Ivd_clock_tclClientSensorIf;

// vd_clock_tclServiceClockIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivd_clock_tclServiceClock;

class vd_clock_tclServiceClockIf : public Ivd_clock_tclServiceClockIf, public vd_clock_tclServiceClockCallbackIF
{
public:

   vd_clock_tclServiceClockIf(tVoid); 
   vd_clock_tclServiceClockIf(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclServiceClockIf();

   // vd_clock_tclServiceClockIfDeclarations: user specific code start

   tVoid vGetHardwareVersion();
   tVoid vGetSoftwareVersion();

   // vd_clock_tclServiceClockIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
   virtual const tChar* getName() const { return "vd_clock_tclServiceClockIf"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendTimeZoneStatus(tU16 u16Index, clock_fi_tclString szDescription);
   virtual tVoid sendDaylightSavingTimeStatus(tBool bDST_Status, tBool bDST_AutoAdjust, clock_fi_tclDCLK_TEN_DST_Setting enDST_Status);
   virtual tVoid sendGPS_AutoSyncStatus(tBool bEnabled, tBool bPositionBased);
   virtual tVoid sendSyncModeStatus(clock_fi_tclDCLK_TEN_SyncMode enMode);
   virtual tVoid sendGPS_WeekEpochStatus(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch);
   virtual tVoid sendLocalTimeOffsetStatus(tS64 s64Offset_ScalarValue, tBool bIsOffsetPostive, tS16 s16Offset_Year, tU8 u8Offset_Month, tU8 u8Offset_Day, tU8 u8Offset_Hour, tU8 u8Offset_Minute, tU8 u8Offset_Second, tU32 u32UTCTimeDate_ScalarValue, tS16 s16UTCTimeDate_Year, tU8 u8UTCTimeDate_Month, tU8 u8UTCTimeDate_Day, tU8 u8UTCTimeDate_Hour, tU8 u8UTCTimeDate_Minute, tU8 u8UTCTimeDate_Second, tU8 u8UTCTimeDate_Weekday, clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState);
   virtual tVoid sendLocalTimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue);
   virtual tVoid sendTimeFormatStatus(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat);
   virtual tVoid sendDateFormatStatus(clock_fi_tclDCLK_TEN_DateFormat enDateFormat);
   virtual tVoid sendClockSourceStatusStatus(clock_fi_tclDCLK_TEN_ClockSourceStatus enSourcesValid);
   virtual tVoid sendFormatSourceStatusStatus(clock_fi_tclDCLK_TEN_FormatSourceStatus enFormatSourceStatus);
   virtual tVoid sendLocalTimeDate_MinuteUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue);
   virtual tVoid sendRegion_TimeZoneStatus(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status, clock_fi_tclString szDescription);
   virtual tVoid sendAuto_TimeZoneOffsetStatus(tS8 s8Offset_Hour, tS8 s8Offset_Minute);
   virtual tVoid sendNewDateFormatStatus(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat);
   virtual tVoid sendConnectionStatus(clock_fi_tcl_SWC_UnitConnectionStatus SWCUnitConnectionStatus);
   virtual tVoid sendTimeZone_DSTAvailabilityStatus(tBool bTimeZone_DSTAvailabilityForRegion);
   virtual tVoid sendHardwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arHardwareVersionList);
   virtual tVoid sendSoftwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arSoftwareVersionList);
   virtual tVoid sendDebugMode_TimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode);
   virtual tVoid sendUTC_TimeDateUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bTimeValidity);
   virtual tVoid sendHUD_ActivationStatus(tBool bHUD_Status);
   virtual tVoid sendHUD_PostitionStatus(tU8 u8Up_Position, tU8 u8Down_Position);

   virtual tBool onTimeZoneSet(tU16 u16Index, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDaylightSavingTimeSet(clock_fi_tclDCLK_TEN_DST_Setting enDST_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onGPS_AutoSyncSet(tBool bEnabled, tBool bPositionBased, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onSyncModeSet(clock_fi_tclDCLK_TEN_SyncMode enMode, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onGPS_WeekEpochSet(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onLocalTimeOffsetSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onLocalTimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onTimeFormatSet(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDateFormatSet(clock_fi_tclDCLK_TEN_DateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onLocalTimeDate_MinuteUpdateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onRegion_TimeZoneSet(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onAuto_TimeZoneOffsetSet(tS8 s8Offset_Hour, tS8 s8Offset_Minute, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onNewDateFormatSet(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDebugMode_TimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onHUD_ActivationSet(clock_fi_tclDCLK_TEN_HUD_ActivationSettings enHUD_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onHUD_PostitionSet(tU8 u8Up_Position, tU8 u8Down_Position, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid sendGetAvailableTimeZonesMResult(std::vector<clock_fi_tclString, std::allocator<clock_fi_tclString> > aszDescriptions, std::vector<tU16, std::allocator<tU16> > u16Indexes);
   virtual tVoid sendGetTimeDateFromValueMResult(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday);
   virtual tVoid sendGetDaysPerMonthMResult(tU8 u8NumberOfDays);
   virtual tVoid sendFID_S_DIAG_CONFIGURATIONMResult(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode, tBool Status);
   virtual tVoid sendResetHistoryMResult();
   virtual tVoid sendVersionInfoMResult();


   virtual tVoid onGetAvailableTimeZonesMStart();
   virtual tVoid onGetTimeDateFromValueMStart(tU32 u32TimeDateValue, tU8 u8SourceDomain, tU8 u8TargetDomain);
   virtual tVoid onGetDaysPerMonthMStart(tS16 s16Year, tU8 u8Month);
   virtual tVoid onFID_S_DIAG_CONFIGURATIONMStart(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode);
   virtual tVoid onResetHistoryMStart();
   virtual tVoid onVersionInfoMStart();

   virtual void vGetTimeZoneMsg(clock_mainfi_tclMsgTimeZoneStatus& oStatus) {if (_poServerRef) _poServerRef->vGetTimeZoneMsg(oStatus);}
   virtual void vGetDaylightSavingTimeMsg(clock_mainfi_tclMsgDaylightSavingTimeStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDaylightSavingTimeMsg(oStatus);}
   virtual void vGetGPS_AutoSyncMsg(clock_mainfi_tclMsgGPS_AutoSyncStatus& oStatus) {if (_poServerRef) _poServerRef->vGetGPS_AutoSyncMsg(oStatus);}
   virtual void vGetSyncModeMsg(clock_mainfi_tclMsgSyncModeStatus& oStatus) {if (_poServerRef) _poServerRef->vGetSyncModeMsg(oStatus);}
   virtual void vGetGPS_WeekEpochMsg(clock_mainfi_tclMsgGPS_WeekEpochStatus& oStatus) {if (_poServerRef) _poServerRef->vGetGPS_WeekEpochMsg(oStatus);}
   virtual void vGetLocalTimeOffsetMsg(clock_mainfi_tclMsgLocalTimeOffsetStatus& oStatus) {if (_poServerRef) _poServerRef->vGetLocalTimeOffsetMsg(oStatus);}
   virtual void vGetLocalTimeDateMsg(clock_mainfi_tclMsgLocalTimeDateStatus& oStatus) {if (_poServerRef) _poServerRef->vGetLocalTimeDateMsg(oStatus);}
   virtual void vGetTimeFormatMsg(clock_mainfi_tclMsgTimeFormatStatus& oStatus) {if (_poServerRef) _poServerRef->vGetTimeFormatMsg(oStatus);}
   virtual void vGetDateFormatMsg(clock_mainfi_tclMsgDateFormatStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDateFormatMsg(oStatus);}
   virtual void vGetClockSourceStatusMsg(clock_mainfi_tclMsgClockSourceStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetClockSourceStatusMsg(oStatus);}
   virtual void vGetFormatSourceStatusMsg(clock_mainfi_tclMsgFormatSourceStatusStatus& oStatus) {if (_poServerRef) _poServerRef->vGetFormatSourceStatusMsg(oStatus);}
   virtual void vGetLocalTimeDate_MinuteUpdateMsg(clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& oStatus) {if (_poServerRef) _poServerRef->vGetLocalTimeDate_MinuteUpdateMsg(oStatus);}
   virtual void vGetRegion_TimeZoneMsg(clock_mainfi_tclMsgRegion_TimeZoneStatus& oStatus) {if (_poServerRef) _poServerRef->vGetRegion_TimeZoneMsg(oStatus);}
   virtual void vGetAuto_TimeZoneOffsetMsg(clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& oStatus) {if (_poServerRef) _poServerRef->vGetAuto_TimeZoneOffsetMsg(oStatus);}
   virtual void vGetNewDateFormatMsg(clock_mainfi_tclMsgNewDateFormatStatus& oStatus) {if (_poServerRef) _poServerRef->vGetNewDateFormatMsg(oStatus);}
   virtual void vGetConnectionMsg(clock_mainfi_tclMsgConnectionStatus& oStatus) {if (_poServerRef) _poServerRef->vGetConnectionMsg(oStatus);}
   virtual void vGetTimeZone_DSTAvailabilityMsg(clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& oStatus) {if (_poServerRef) _poServerRef->vGetTimeZone_DSTAvailabilityMsg(oStatus);}
   virtual void vGetHardwareVersionMsg(clock_mainfi_tclMsgHardwareVersionStatus& oStatus) {if (_poServerRef) _poServerRef->vGetHardwareVersionMsg(oStatus);}
   virtual void vGetSoftwareVersionMsg(clock_mainfi_tclMsgSoftwareVersionStatus& oStatus) {if (_poServerRef) _poServerRef->vGetSoftwareVersionMsg(oStatus);}
   virtual void vGetDebugMode_TimeDateMsg(clock_mainfi_tclMsgDebugMode_TimeDateStatus& oStatus) {if (_poServerRef) _poServerRef->vGetDebugMode_TimeDateMsg(oStatus);}
   virtual void vGetUTC_TimeDateUpdateMsg(clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& oStatus) {if (_poServerRef) _poServerRef->vGetUTC_TimeDateUpdateMsg(oStatus);}
   virtual void vGetHUD_ActivationMsg(clock_mainfi_tclMsgHUD_ActivationStatus& oStatus) {if (_poServerRef) _poServerRef->vGetHUD_ActivationMsg(oStatus);}
   virtual void vGetHUD_PostitionMsg(clock_mainfi_tclMsgHUD_PostitionStatus& oStatus) {if (_poServerRef) _poServerRef->vGetHUD_PostitionMsg(oStatus);}

private:
   Ivd_clock_tclServiceClock* _poServerRef;

// vd_clock_tclServiceClockIfDeclarationsPart2: user specific code start
	// Handling of Internal messages
	vdclk_tclDataContainer*       _poContainer;     // data container
	vd_clock_INCAdapter*          _poINCAdapter;
	vdclk_tclUpdater* _poUpdater;

	Ivd_clock_tclClientSensorIf*   _poClientSensor;     // Client Sensor

  // static tU8 m_u8INC_msg_buff[MAX_MSG_SIZE];
  
  tS64 offset_Hour,offset_Minute;
  tBool DebugModeFlag;
  tBool _u8HUDActivateState;
   
   //tVoid SendComponentStatusActive_INC();

   tVoid vHandleMessage_LocalTimeDateUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_TimezoneUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_TimeformatUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_DateformatUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_EpochUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_GPSAutoSyncUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_LocaltimeOffsetUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_clocksourcestatusUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_FormatsourcestatusUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_DSTUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_AutoTimeZoneOffsetUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_NewDateformatUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_LocalTimeDate_MinuteUpdateUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_DebugMode_TimeDateUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_Clock_MeterSettingsUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_UTCTimeDateUpdate(vd_clock_tclBaseIf::TMsg* pMsg);
   tVoid vHandleMessage_HUDActivateStateUpdate(vd_clock_tclBaseIf::TMsg* pMsg);

// vd_clock_tclServiceClockIfDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ServiceClockIf__IF__H_


