/*****************************************************************************
* FILE:         vd_clock_ServiceClockIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// vd_clock_tclServiceClockIfIncludes: user specific code start
#define _CLASS TR_CLASS_VD_CLOCK_SERVER_CLOCK
#define MAX_MSG_SIZE_DATETIME 8
#define MAX_MSG_SIZE_TIMEMODE 2
#define MAX_MSG_SIZE_DIAG_CONNECTION 1
//tU8 vd_clock_tclServiceClockIf::m_u8INC_msg_buff[60]={0};
// vd_clock_tclServiceClockIfIncludes: user specific code end

#include "vd_clock_ServiceClockIf.h"
#include "I_vd_clock_ServiceClock.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_SERVER_CLOCK
#include "trcGenProj/Header/vd_clock_ServiceClockIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclServiceClockIf::
*             vd_clock_tclServiceClockIf(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclServiceClockIf::vd_clock_tclServiceClockIf(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclServiceClockIf(poMainAppl)
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClockIf() entered."));
   _poServerRef = OSAL_NULL;

   // vd_clock_tclServiceClockIfConstructor: user specific code start
   _poContainer = OSAL_NULL;
   _poINCAdapter = OSAL_NULL;
   //_bfirstupdate = TRUE;
   offset_Hour = 0;
   offset_Minute = 0;
   DebugModeFlag = TRUE;
	_u8HUDActivateState = TRUE;
	_poUpdater = OSAL_NULL;
   _poClientSensor = OSAL_NULL;

   // vd_clock_tclServiceClockIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclServiceClockIf::
*             ~vd_clock_tclServiceClockIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclServiceClockIf::~vd_clock_tclServiceClockIf(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclServiceClockIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // vd_clock_tclServiceClockIfDestructor: user specific code start
   _poContainer = OSAL_NULL;
   _poINCAdapter = OSAL_NULL;

   // vd_clock_tclServiceClockIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClockIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ServiceClockIf.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     CLOCK_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClockIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClockIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Ivd_clock_tclServiceClock*>(_cpoMain->getHandler("Ivd_clock_tclServiceClock"));

   VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // vd_clock_tclServiceClockIfvGetReferences: user specific code start

   _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));
   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

   _poINCAdapter = dynamic_cast<vd_clock_INCAdapter*>(_cpoMain->getHandler("vd_clock_INCAdapter"));
   VD_CLOCK_NULL_POINTER_CHECK(_poINCAdapter);

	_poUpdater = dynamic_cast<vdclk_tclUpdater*>(_cpoMain->getHandler("vdclk_tclUpdater"));
	VD_CLOCK_NULL_POINTER_CHECK(_poUpdater);

	_poClientSensor = dynamic_cast<Ivd_clock_tclClientSensorIf*>(_cpoMain->getHandler("Ivd_clock_tclClientSensorIf"));
	VD_CLOCK_NULL_POINTER_CHECK(_poClientSensor);
   // vd_clock_tclServiceClockIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClockIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClockIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClockIf::vStartCommunication() entered."));
   // vd_clock_tclServiceClockIfvStartCommunication: user specific code start
   // vd_clock_tclServiceClockIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClockIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClockIf::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClockIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // vd_clock_tclServiceClockIfvHandleMessage: user specific code start
   
   VD_CLOCK_NULL_POINTER_CHECK(pMsg);
    switch (pMsg->eCmd)
    {
    case vd_clock_tclBaseIf::LocalTimeDateUpdate:
 	   vHandleMessage_LocalTimeDateUpdate(pMsg);
 	   break;
    case vd_clock_tclBaseIf::TimezoneUpdate:
 	   vHandleMessage_TimezoneUpdate(pMsg);
 	   break;
    case vd_clock_tclBaseIf::TimeformatUpdate:
 	   vHandleMessage_TimeformatUpdate(pMsg);
 	   break;
    case vd_clock_tclBaseIf::DateformatUpdate:
 	   vHandleMessage_DateformatUpdate(pMsg);
 	   break;
    case vd_clock_tclBaseIf::EpochUpdate:
 	   vHandleMessage_EpochUpdate(pMsg);
 	   break;
    case vd_clock_tclBaseIf::GPSAutoSyncUpdate:
 	   vHandleMessage_GPSAutoSyncUpdate(pMsg);
 	   break;
    case vd_clock_tclBaseIf::LocaltimeOffsetUpdate:
 	   vHandleMessage_LocaltimeOffsetUpdate(pMsg);
 	   break;
    case vd_clock_tclBaseIf::clocksourcestatusUpdate:
 	   vHandleMessage_clocksourcestatusUpdate(pMsg);
 	   break;
    case vd_clock_tclBaseIf::FormatsourcestatusUpdate:
 	   vHandleMessage_FormatsourcestatusUpdate(pMsg);
 	   break;
    case vd_clock_tclBaseIf::DSTUpdate:
 	   vHandleMessage_DSTUpdate(pMsg);
 	   break;
	case vd_clock_tclBaseIf::AutoTimeZoneOffsetUpdate:
		vHandleMessage_AutoTimeZoneOffsetUpdate(pMsg);
    	break;

	case vd_clock_tclBaseIf::NewDateformatUpdate:
		vHandleMessage_NewDateformatUpdate(pMsg);
		break;
	case vd_clock_tclBaseIf ::LocalTimeDate_MinuteUpdateUpdate:
		vHandleMessage_LocalTimeDate_MinuteUpdateUpdate(pMsg);
		break;
	case vd_clock_tclBaseIf::DebugMode_TimeDateUpdate:
		vHandleMessage_DebugMode_TimeDateUpdate(pMsg);
		break;
	case vd_clock_tclBaseIf:: Clock_MeterSettingsUpdate:
		vHandleMessage_Clock_MeterSettingsUpdate(pMsg);
		break;
	case vd_clock_tclBaseIf::UTCTimeDateUpdate:
		vHandleMessage_UTCTimeDateUpdate(pMsg);
		break;
	case vd_clock_tclBaseIf::HUDActivateStateUpdate:
		vHandleMessage_HUDActivateStateUpdate(pMsg);
		break;
	default:
		break;
	}

   // vd_clock_tclServiceClockIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClockIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClockIf::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclServiceClockIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclServiceClockIfvHandleTraceMessage: user specific code start
   // vd_clock_tclServiceClockIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClockIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClockIf::vTraceInfo()
{
   // vd_clock_tclServiceClockIfvTraceInfo: user specific code start
   // vd_clock_tclServiceClockIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClockIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclServiceClockIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClockIf::onServiceAvailable() entered."));

   // vd_clock_tclServiceClockIfvOnServiceAvailable: user specific code start
   
   // vd_clock_tclServiceClockIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClockIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclServiceClockIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClockIf::onServiceUnavailable() entered."));

   // vd_clock_tclServiceClockIfvOnServiceUnavailable: user specific code start
   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
   _poContainer->vSaveData();

   // vd_clock_tclServiceClockIfvOnServiceUnavailable: user specific code end
}

tBool vd_clock_tclServiceClockIf::onTimeZoneSet(tU16 u16Index, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onTimeZoneSet: user specific code start

   ETG_TRACE_USR4(("property_set Timezone  TimezoneIndex = %d ",u16Index ));

   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;

	VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);
	_poContainer->vSetTimeZone(u16Index);
	_poContainer ->SendMCANNotification();

   // onTimeZoneSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onDaylightSavingTimeSet(clock_fi_tclDCLK_TEN_DST_Setting enDST_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDaylightSavingTimeSet: user specific code start

   ETG_TRACE_USR4(("property_set DaylightSaving  (enDST_Setting = %d ",enDST_Setting.enType ));

   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;

   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);
   _poContainer-> vSetDaylightSavingTime( (VDCLK_TEN_DST_Setting)enDST_Setting.enType, TRUE );


   _poContainer ->SendMCANNotification();

   // onDaylightSavingTimeSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onGPS_AutoSyncSet(tBool bEnabled, tBool bPositionBased, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onGPS_AutoSyncSet: user specific code start

   ETG_TRACE_COMP(("property:GPS_AUTOSYNC set (bEnabled = %d bPositionBased = %d)",
		   bEnabled,
		   bPositionBased));

   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;

   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);
   _poContainer->vSetGPS_AutoSync(bEnabled, bPositionBased);

   _poContainer ->SendMCANNotification();

   // onGPS_AutoSyncSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onSyncModeSet(clock_fi_tclDCLK_TEN_SyncMode enMode, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onSyncModeSet: user specific code start
   (tVoid)enMode;
   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;
   // onSyncModeSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onGPS_WeekEpochSet(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onGPS_WeekEpochSet: user specific code start
   (tVoid)GPSepoch;
   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;
   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);
      _poContainer ->enSetGPSEpoch( (VDCLK_TEN_GPS_EPOCH)GPSepoch.enType);
   ETG_TRACE_USR4(("property_set GPS Epoch"));
   // onGPS_WeekEpochSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onLocalTimeOffsetSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onLocalTimeOffsetSet: user specific code start
   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;
   // onLocalTimeOffsetSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onLocalTimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onLocalTimeDateSet: user specific code start
   ETG_TRACE_USR4(("property_set Localtime  s16Year = %d  u8Month = %d u8Day = %d u8Hours = %d u8Minutes = %d u8Seconds = %d u8Weekday = %d u8ChangeMask = %d",s16Year,u8Month,u8Day,u8Hours,u8Minutes,u8Seconds,u8Weekday,u8ChangeMask ));

   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;

   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);

   tBool bIsValid = vdclk_tclDateTime:: bIsDateTimeValid( s16Year,     u8Month,     u8Day,
                                                          u8Hours,     u8Minutes,   u8Seconds,
                                                          u8Weekday,   u8ChangeMask );
   ETG_TRACE_COMP(("SetLocalTime:bIsValid=%d", bIsValid));
   if (bIsValid)
   {

#ifdef VARIANT_S_FTR_ENABLE_SET_TIME_EXTERNALMASTER

  	 OSAL_trTimeDate  oUserTimeDate;
  	 oUserTimeDate.s32Year = (tS32)oSetMsg.s16Year;
  	 oUserTimeDate.s32Month = (tS32)oSetMsg.u8Month;
  	 oUserTimeDate.s32Day = (tS32)oSetMsg.u8Day;
  	 oUserTimeDate.s32Hour = (tS32)oSetMsg.u8Hours;
  	 oUserTimeDate.s32Minute = (tS32)oSetMsg.u8Minutes;
  	 oUserTimeDate.s32Second = (tS32)oSetMsg.u8Seconds;


  	 if(_poClientHandlerBap)
  	 {
  		 _poClientHandlerBap->vSendBAPTimeDateMessage(oUserTimeDate);
  	 }

  	 break;

#endif

      vdclk_tclDateTime  oNewDateTime;
      oNewDateTime.u8Update( s16Year,     u8Month,     u8Day,
                             u8Hours,     u8Minutes,   u8Seconds,
                             u8ChangeMask );
      _poContainer-> vSetLocalDateTime (&oNewDateTime);

		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
		vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");

   }

   // onLocalTimeDateSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onTimeFormatSet(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onTimeFormatSet: user specific code start
   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;
   ETG_TRACE_USR4(("property_set Timeformat  Timeformat = %d ",enTimeFormat.enType ));

   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);

   _poContainer->vSetTimeFormat((VDCLK_TEN_TimeFormat)enTimeFormat.enType);

   _poContainer ->SendMCANNotification();

   // onTimeFormatSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onDateFormatSet(clock_fi_tclDCLK_TEN_DateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDateFormatSet: user specific code start
   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;
   ETG_TRACE_USR4(("property_set Dateformat  Dateformat = %d ",enDateFormat.enType ));

   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);
   _poContainer->vSetDateFormat((VDCLK_TEN_DateFormat)enDateFormat.enType);

   // onDateFormatSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onLocalTimeDate_MinuteUpdateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onLocalTimeDate_MinuteUpdateSet: user specific code start

   ETG_TRACE_USR4(("property_set onLocalTimeDate_MinuteUpdateSet  s16Year = %d  u8Month = %d u8Day = %d u8Hours = %d u8Minutes = %d u8Seconds = %d u8Weekday = %d u8ChangeMask = %d",s16Year,u8Month,u8Day,u8Hours,u8Minutes,u8Seconds,u8Weekday,u8ChangeMask ));

   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;

   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);

   tBool bIsValid = vdclk_tclDateTime:: bIsDateTimeValid( s16Year,     u8Month,     u8Day,
                                                          u8Hours,     u8Minutes,   u8Seconds,
                                                          u8Weekday,   u8ChangeMask );
   ETG_TRACE_COMP(("SetLocalTime:bIsValid=%d", bIsValid));
   if (bIsValid)
   {

#ifdef VARIANT_S_FTR_ENABLE_SET_TIME_EXTERNALMASTER

  	 OSAL_trTimeDate  oUserTimeDate;
  	 oUserTimeDate.s32Year = (tS32)oSetMsg.s16Year;
  	 oUserTimeDate.s32Month = (tS32)oSetMsg.u8Month;
  	 oUserTimeDate.s32Day = (tS32)oSetMsg.u8Day;
  	 oUserTimeDate.s32Hour = (tS32)oSetMsg.u8Hours;
  	 oUserTimeDate.s32Minute = (tS32)oSetMsg.u8Minutes;
  	 oUserTimeDate.s32Second = (tS32)oSetMsg.u8Seconds;


  	 if(_poClientHandlerBap)
  	 {
  		 _poClientHandlerBap->vSendBAPTimeDateMessage(oUserTimeDate);
  	 }

  	 break;

#endif

      vdclk_tclDateTime  oNewDateTime;
      oNewDateTime.u8Update( s16Year,     u8Month,     u8Day,
                             u8Hours,     u8Minutes,   u8Seconds,
                             u8ChangeMask );
      _poContainer-> vSetLocalDateTime (&oNewDateTime);

      vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");

   _poContainer ->SendMCANNotification();
   }

   // onLocalTimeDate_MinuteUpdateSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onRegion_TimeZoneSet(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onRegion_TimeZoneSet: user specific code start
   ETG_TRACE_USR4(("property_set Timezone  TimezoneIndex = %d ",enTIMEZONE_Settings.enType));
   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;
   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);
   _poContainer->vSetRegionTimeZone((VDCLK_TEN_TIMEZONE_Setting)enTIMEZONE_Settings.enType);

   _poContainer ->SendMCANNotification();
   // onRegion_TimeZoneSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onAuto_TimeZoneOffsetSet(tS8 s8Offset_Hour, tS8 s8Offset_Minute, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onAuto_TimeZoneOffsetSet: user specific code start
   ETG_TRACE_USR4(("property_set Auto_TimeZoneOffsetSet  s8Offset_Hour = %d s8Offset_Minute = %d ",s8Offset_Hour,s8Offset_Minute ));
   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;
   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);
   offset_Hour = (tS64)s8Offset_Hour;
   offset_Minute = (tS64)s8Offset_Minute;
   _poContainer ->vSetAutoTimeZoneOffset(offset_Hour,offset_Minute);

   _poContainer ->SendMCANNotification();

   // onAuto_TimeZoneOffsetSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onNewDateFormatSet(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onNewDateFormatSet: user specific code start
	(tVoid)bPropertyChanged;
	(tVoid)u16ErrorCode;
      ETG_TRACE_USR4(("property_set New Dateformat  = %d ",enDateFormat.enType ));

      VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);
      if(_poContainer)
      {
      _poContainer->vSetNewDateFormat((VDCLK_TEN_NewDateFormat)enDateFormat.enType);
      }


   // onNewDateFormatSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onDebugMode_TimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onDebugMode_TimeDateSet: user specific code start
   ETG_TRACE_USR4(("property_set Localtime  s16Year = %d  u8Month = %d u8Day = %d u8Hours = %d u8Minutes = %d u8Seconds = %d u8Weekday = %d  bdebugMode = %d u8ChangeMask = %d",s16Year,u8Month,u8Day,u8Hours,u8Minutes,u8Seconds,u8Weekday,bdebugMode,u8ChangeMask ));

   (tVoid)bPropertyChanged;
   (tVoid)u16ErrorCode;

   VD_CLOCK_NULL_POINTER_CHECK_VAL(_poContainer);

   tBool bIsValid = vdclk_tclDateTime:: bIsDateTimeValid( s16Year,     u8Month,     u8Day,
                                                             u8Hours,     u8Minutes,   u8Seconds,
                                                             u8Weekday,   u8ChangeMask );

   ETG_TRACE_COMP(("SetLocalTime:bIsValid=%d", bIsValid));
   if (bIsValid)
   {
	   if(bdebugMode)
	   {
		   DebugModeFlag = TRUE;
		   tU32  _u32PrevSystemTimeOffset = 0;
		   vdclk_tclDateTime  oNewDateTime;
		   oNewDateTime.u8Update( s16Year,     u8Month,     u8Day,
	                                u8Hours,     u8Minutes,   u8Seconds,
	                                u8ChangeMask );

		   tS16  s16Year;       tU8   u8Month;       tU8   u8Day;
		   tU8   u8Hour;        tU8   u8Minute;      tU8   u8Second;
		   tU8   u8Weekday;

		   oNewDateTime.u8GetComponents
	           (
	              &s16Year,      &u8Month,      &u8Day,
	              &u8Hour,       &u8Minute,     &u8Second,
	              &u8Weekday
	           );

		   OSAL_trTimeDate tTempTimeDate;

	    	tTempTimeDate.s32Year = (tS32)s16Year - 1900;
	    	tTempTimeDate.s32Month = (tS32)u8Month;
	    	tTempTimeDate.s32Day = (tS32)u8Day;
	    	tTempTimeDate.s32Hour = (tS32)u8Hour;
	    	tTempTimeDate.s32Minute = (tS32)u8Minute;
	    	tTempTimeDate.s32Second = (tS32)u8Second;
	    	tTempTimeDate.s32Weekday = (tS32)u8Weekday;
	    	tTempTimeDate.s32Daylightsaving = OSAL_NULL;
	    	tTempTimeDate.s32Yearday = OSAL_NULL;


	    	if(OSAL_s32ClockSetTime(&tTempTimeDate) != OSAL_OK)
	    	{
	    		ETG_TRACE_USR3(("ERROR occurred while Linux set time "));
	    		TRACE_DateTime("vStoreLocalTime", oNewDateTime, _CLASS, __LINE__);
	    	}

	    	TRACE_OSALDateTime("vStoreLocalTime", tTempTimeDate, _CLASS, __LINE__ );
	   }
	   else
	   {
		   ETG_TRACE_USR3(("ERROR Debug Mode disabled"));
		   DebugModeFlag = FALSE;
	   }

   }

   vd_clock_tclAppMain::theServer() ->vPostMsgDebugMode_TimeDateUpdate("Ivd_clock_tclServiceClockIf");


   // onDebugMode_TimeDateSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onHUD_ActivationSet(clock_fi_tclDCLK_TEN_HUD_ActivationSettings enHUD_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onHUD_ActivationSet: user specific code start
	_poContainer ->SetHUDActivateToCAN((VDCLK_TEN_HUDACTIVATE)enHUD_Setting.enType);
	_u8HUDActivateState = enHUD_Setting.enType;
	vd_clock_tclAppMain::theServer() ->vPostMsgHUDActivateStateUpdate("Ivd_clock_tclServiceClockIf");


   // onHUD_ActivationSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClockIf::onHUD_PostitionSet(tU8 u8Up_Position, tU8 u8Down_Position, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // onHUD_PostitionSet: user specific code start
   // onHUD_PostitionSet: user specific code end
   return _bResult;
}

tVoid vd_clock_tclServiceClockIf::onGetAvailableTimeZonesMStart() {

   // onGetAvailableTimeZonesMStart: user specific code start
	 tU16 u16Index;

	    bpstl::vector<clock_fi_tclString, bpstl::allocator<clock_fi_tclString> > aszDescriptions;
	    bpstl::vector<tU16, bpstl::allocator<tU16> > u16Indexes;
	    if(_poContainer != NULL)
	    {
	    aszDescriptions=_poContainer->_supportedTimeZoneList;
	    u16Indexes =_poContainer->_u16IndexeList;
	    }

	    ETG_TRACE_USR3(("Elements=%u", u16Indexes.size()));

	    for (u16Index = 0; u16Index < u16Indexes.size(); u16Index++)
	    {
	        ETG_TRACE_USR3(("%20s=%u", (tString) aszDescriptions[u16Index], u16Indexes[u16Index]));
	    }


		sendGetAvailableTimeZonesMResult(aszDescriptions, u16Indexes);

   // onGetAvailableTimeZonesMStart: user specific code end
}
tVoid vd_clock_tclServiceClockIf::onGetTimeDateFromValueMStart(tU32 u32TimeDateValue, tU8 u8SourceDomain, tU8 u8TargetDomain) {

   // onGetTimeDateFromValueMStart: user specific code start
   // initialize variables
	tU32 u32Value = u32TimeDateValue;

	tS16  s16Year;          tU8  u8Month;         tU8  u8Day;
	tU8   u8Hour;           tU8  u8Minute;        tU8  u8Second;
	tU8   u8Weekday;        tU8   u8Valid;
	vdclk_tclDateTime       oResultDateTime;

	oResultDateTime.u8SetValue (u32Value);
	TRACE_DateTime("method:GETTIMEDATEFROMVALUE(IN)", oResultDateTime, _CLASS, __LINE__);

	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

	// get and fill in requested data
	_poContainer-> vGetLocalDateTime (&oResultDateTime);
	ETG_TRACE_USR3(("u8SourceDomain=%u u8TargetDomain=%u",u8SourceDomain, u8TargetDomain));
	if (u8SourceDomain > 1 || u8TargetDomain > 1)
	{
		ETG_TRACE_ERR(("Invalid parameter for DateTime domain:u8SourceDomain=%u u8TargetDomain=%u",
	                		u8SourceDomain, u8TargetDomain));
	   // vSendError (CCA_C_U16_ERROR_PARAMETER_OUT_OF_RANGE, poInMessage);
		ETG_TRACE_USR3(("Error. Parameter out of range"));
	    //break;
	}
	else if (u8SourceDomain != u8TargetDomain)
	{
		vdclk_tclDateTime oSystemDateTime;
	    _poContainer-> vGetSystemDateTime (oSystemDateTime);
	    tS64 s64Diff = (tS64) oResultDateTime.u32GetValue() - (tS64) oSystemDateTime.u32GetValue();
	    ETG_TRACE_USR3(("(tS32) s64Diff=%d", (tS32) s64Diff));
	    if (u8SourceDomain == 0 && u8TargetDomain == 1)
	    {
	    	u32Value = (tU32) ((tS64) u32Value + s64Diff);
	    }
	    else //if (u8SourceDomain == 1 && u8TargetDomain == 0)
	    {
	    	u32Value = (tU32) ((tS64) u32Value - s64Diff);
	    }
   	}

	u8Valid = oResultDateTime.u8SetValue(u32Value);

	TRACE_DateTime("method:GETTIMEDATEFROMVALUE", oResultDateTime, _CLASS, __LINE__);
	if ((u8Valid & (tU8) VDCLK_EN_AllValid) == (tU8) VDCLK_EN_AllValid)
	{  // both date and time are valid, as should be
	oResultDateTime.u8GetComponents( &s16Year,      &u8Month,      &u8Day,
	                                 &u8Hour,       &u8Minute,     &u8Second,
	                                 &u8Weekday );
	sendGetTimeDateFromValueMResult(s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, u8Weekday);
	}
	else
	{
		ETG_TRACE_ERR(("Parameter out of range for GETTIMEDATEFROMVALUE(IN) "));
	}
   // onGetTimeDateFromValueMStart: user specific code end
}
tVoid vd_clock_tclServiceClockIf::onGetDaysPerMonthMStart(tS16 s16Year, tU8 u8Month) {

   // onGetDaysPerMonthMStart: user specific code start
    tU8 u8NumberOfDays = vdclk_tclDateTime::u8DaysPerMonth(u8Month, s16Year);

    ETG_TRACE_USR3(("Number of days=%u in month=%u of year=%d",
    		u8NumberOfDays, u8Month, s16Year));

    sendGetDaysPerMonthMResult(u8NumberOfDays);
   // onGetDaysPerMonthMStart: user specific code end
}
tVoid vd_clock_tclServiceClockIf::onFID_S_DIAG_CONFIGURATIONMStart(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode) {

   // onFID_S_DIAG_CONFIGURATIONMStart: user specific code start
   tBool Status = TRUE;
   ETG_TRACE_USR4(("MIDW_EXT_CLOCKFI_C_U16_FID_S_DIAG_CONFIGURATION"));

   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

	if (DefSetStateGroup.enType == clock_fi_tcl_e8_DefSetGroups::FI_EN_DEFSET_GROUP__OFFICE__CLOCK)
	{
		tBool bResetAllUsers = TRUE;
	    switch(DefSetStateMode.enType)
	    {
	    case  clock_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_SET_USER:
	    	bResetAllUsers = FALSE;  //lint -fallthrough
	    case  clock_fi_tcl_e8_DefSetMode::FI_EN_DEFSET_SRC_SET_TEF:
	        _poContainer-> vSetDefaultSettings(bResetAllUsers);
	        break;
	        default:
	         break;
	    }
	               // indicate success anyway
	    Status = TRUE;
	}
	else
	{
		// if we have received a different group
		Status = FALSE;
	}

	// send back the result

   sendFID_S_DIAG_CONFIGURATIONMResult(DefSetStateGroup, DefSetStateMode, Status);
   // onFID_S_DIAG_CONFIGURATIONMStart: user specific code end
}
tVoid vd_clock_tclServiceClockIf::onResetHistoryMStart() {

   // onResetHistoryMStart: user specific code start


	ETG_TRACE_USR4(("Sending reset connection history to INC"));
	tU8 u8INC_msg_buff[MAX_MSG_SIZE_COMPONENTSTATUS]= {0};
	u8INC_msg_buff[0] = 0x40; // msg id
	u8INC_msg_buff[1] = 0x01; // MCAN status
	tU8 u8DataLength = sizeof(u8INC_msg_buff);
	if(_poINCAdapter != NULL)
	{
		_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8DataLength);
	}else
	{
		ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
	}


   // onResetHistoryMStart: user specific code end
}
tVoid vd_clock_tclServiceClockIf::onVersionInfoMStart() {

   // onVersionInfoMStart: user specific code start
	ETG_TRACE_USR4(("Requesting for version info to INC"));

	vGetHardwareVersion();
	vGetSoftwareVersion();

	ETG_TRACE_USR4(("Sending the method result"));
	sendVersionInfoMResult();



   // onVersionInfoMStart: user specific code end
}

tVoid vd_clock_tclServiceClockIf::sendTimeZoneStatus(tU16 u16Index, clock_fi_tclString szDescription) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTimeZoneStatus(u16Index, szDescription);
}

tVoid vd_clock_tclServiceClockIf::sendDaylightSavingTimeStatus(tBool bDST_Status, tBool bDST_AutoAdjust, clock_fi_tclDCLK_TEN_DST_Setting enDST_Status) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDaylightSavingTimeStatus(bDST_Status, bDST_AutoAdjust, enDST_Status);
}

tVoid vd_clock_tclServiceClockIf::sendGPS_AutoSyncStatus(tBool bEnabled, tBool bPositionBased) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGPS_AutoSyncStatus(bEnabled, bPositionBased);
}

tVoid vd_clock_tclServiceClockIf::sendSyncModeStatus(clock_fi_tclDCLK_TEN_SyncMode enMode) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSyncModeStatus(enMode);
}

tVoid vd_clock_tclServiceClockIf::sendGPS_WeekEpochStatus(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGPS_WeekEpochStatus(GPSepoch);
}

tVoid vd_clock_tclServiceClockIf::sendLocalTimeOffsetStatus(tS64 s64Offset_ScalarValue, tBool bIsOffsetPostive, tS16 s16Offset_Year, tU8 u8Offset_Month, tU8 u8Offset_Day, tU8 u8Offset_Hour, tU8 u8Offset_Minute, tU8 u8Offset_Second, tU32 u32UTCTimeDate_ScalarValue, tS16 s16UTCTimeDate_Year, tU8 u8UTCTimeDate_Month, tU8 u8UTCTimeDate_Day, tU8 u8UTCTimeDate_Hour, tU8 u8UTCTimeDate_Minute, tU8 u8UTCTimeDate_Second, tU8 u8UTCTimeDate_Weekday, clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendLocalTimeOffsetStatus(s64Offset_ScalarValue, bIsOffsetPostive, s16Offset_Year, u8Offset_Month, u8Offset_Day, u8Offset_Hour, u8Offset_Minute, u8Offset_Second, u32UTCTimeDate_ScalarValue, s16UTCTimeDate_Year, u8UTCTimeDate_Month, u8UTCTimeDate_Day, u8UTCTimeDate_Hour, u8UTCTimeDate_Minute, u8UTCTimeDate_Second, u8UTCTimeDate_Weekday, enGpsRtcTimeState);
}

tVoid vd_clock_tclServiceClockIf::sendLocalTimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendLocalTimeDateStatus(s16Year, u8Month, u8Day, u8Hours, u8Minutes, u8Seconds, u8Weekday, u8TimeDateStatus, u32TimeDateValue);
}

tVoid vd_clock_tclServiceClockIf::sendTimeFormatStatus(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTimeFormatStatus(enTimeFormat);
}

tVoid vd_clock_tclServiceClockIf::sendDateFormatStatus(clock_fi_tclDCLK_TEN_DateFormat enDateFormat) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDateFormatStatus(enDateFormat);
}

tVoid vd_clock_tclServiceClockIf::sendClockSourceStatusStatus(clock_fi_tclDCLK_TEN_ClockSourceStatus enSourcesValid) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendClockSourceStatusStatus(enSourcesValid);
}

tVoid vd_clock_tclServiceClockIf::sendFormatSourceStatusStatus(clock_fi_tclDCLK_TEN_FormatSourceStatus enFormatSourceStatus) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFormatSourceStatusStatus(enFormatSourceStatus);
}

tVoid vd_clock_tclServiceClockIf::sendLocalTimeDate_MinuteUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendLocalTimeDate_MinuteUpdateStatus(s16Year, u8Month, u8Day, u8Hours, u8Minutes, u8Seconds, u8Weekday, u8TimeDateStatus, u32TimeDateValue);
}

tVoid vd_clock_tclServiceClockIf::sendRegion_TimeZoneStatus(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status, clock_fi_tclString szDescription) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendRegion_TimeZoneStatus(enTIMEZONE_Status, szDescription);
}

tVoid vd_clock_tclServiceClockIf::sendAuto_TimeZoneOffsetStatus(tS8 s8Offset_Hour, tS8 s8Offset_Minute) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendAuto_TimeZoneOffsetStatus(s8Offset_Hour, s8Offset_Minute);
}

tVoid vd_clock_tclServiceClockIf::sendNewDateFormatStatus(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendNewDateFormatStatus(enDateFormat);
}

tVoid vd_clock_tclServiceClockIf::sendConnectionStatus(clock_fi_tcl_SWC_UnitConnectionStatus SWCUnitConnectionStatus) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendConnectionStatus(SWCUnitConnectionStatus);
}

tVoid vd_clock_tclServiceClockIf::sendTimeZone_DSTAvailabilityStatus(tBool bTimeZone_DSTAvailabilityForRegion) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendTimeZone_DSTAvailabilityStatus(bTimeZone_DSTAvailabilityForRegion);
}

tVoid vd_clock_tclServiceClockIf::sendHardwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arHardwareVersionList) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendHardwareVersionStatus(arHardwareVersionList);
}

tVoid vd_clock_tclServiceClockIf::sendSoftwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arSoftwareVersionList) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendSoftwareVersionStatus(arSoftwareVersionList);
}

tVoid vd_clock_tclServiceClockIf::sendDebugMode_TimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendDebugMode_TimeDateStatus(s16Year, u8Month, u8Day, u8Hours, u8Minutes, u8Seconds, u8Weekday, bdebugMode);
}

tVoid vd_clock_tclServiceClockIf::sendUTC_TimeDateUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bTimeValidity) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendUTC_TimeDateUpdateStatus(s16Year, u8Month, u8Day, u8Hours, u8Minutes, u8Seconds, u8Weekday, bTimeValidity);
}

tVoid vd_clock_tclServiceClockIf::sendHUD_ActivationStatus(tBool bHUD_Status) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendHUD_ActivationStatus(bHUD_Status);
}

tVoid vd_clock_tclServiceClockIf::sendHUD_PostitionStatus(tU8 u8Up_Position, tU8 u8Down_Position) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendHUD_PostitionStatus(u8Up_Position, u8Down_Position);
}



tVoid vd_clock_tclServiceClockIf::sendGetAvailableTimeZonesMResult(std::vector<clock_fi_tclString, std::allocator<clock_fi_tclString> > aszDescriptions, std::vector<tU16, std::allocator<tU16> > u16Indexes) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGetAvailableTimeZonesMResult(aszDescriptions, u16Indexes);
}

tVoid vd_clock_tclServiceClockIf::sendGetTimeDateFromValueMResult(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGetTimeDateFromValueMResult(s16Year, u8Month, u8Day, u8Hours, u8Minutes, u8Seconds, u8Weekday);
}

tVoid vd_clock_tclServiceClockIf::sendGetDaysPerMonthMResult(tU8 u8NumberOfDays) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendGetDaysPerMonthMResult(u8NumberOfDays);
}

tVoid vd_clock_tclServiceClockIf::sendFID_S_DIAG_CONFIGURATIONMResult(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode, tBool Status) {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendFID_S_DIAG_CONFIGURATIONMResult(DefSetStateGroup, DefSetStateMode, Status);
}

tVoid vd_clock_tclServiceClockIf::sendResetHistoryMResult() {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendResetHistoryMResult();
}

tVoid vd_clock_tclServiceClockIf::sendVersionInfoMResult() {
    //just forward send request
    VD_CLOCK_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendVersionInfoMResult();
}





// vd_clock_tclServiceClockIfvd_clock_ServiceClockIf: user specific code start

tVoid vd_clock_tclServiceClockIf::vHandleMessage_TimezoneUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_TimezoneUpdate(msg: 0x%08x) entered.", pMsg));

	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

	vdclk_trTimezoneDetails rDetails = vdclk_rTZDetails[_poContainer->u16GetTimeZoneIndex()];
	tU16 u16Index = rDetails.u16Index;
	clock_fi_tclString szDescription=  (clock_fi_tclString)rDetails.szDescription;

	ETG_TRACE_USR4(("Property_Status Timezone   Timezoneindex %d", u16Index));

	sendTimeZoneStatus(u16Index, szDescription);
		VDCLK_TEN_TIMEZONE_Setting enTZ_Status = (VDCLK_TEN_TIMEZONE_Setting)rDetails.u16Index;
		clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTZ_clockStatus;
		enTZ_clockStatus.enType = (clock_fi_tclDCLK_TEN_TIMEZONE_Setting::tenType) enTZ_Status;
		ETG_TRACE_USR4(("Property_Status Timezone   Timezoneindex %d", enTZ_clockStatus.enType));

		sendRegion_TimeZoneStatus(enTZ_clockStatus, szDescription);


}


tVoid vd_clock_tclServiceClockIf::vHandleMessage_TimeformatUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
ETG_TRACE_USR4(("vHandleMessage_TimeformatUpdate(msg: 0x%08x) entered.", pMsg));


VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

VDCLK_TEN_TimeFormat enTimeFormat = _poContainer-> enGetTimeFormat();

clock_fi_tclDCLK_TEN_TimeFormat enclockTimeFormat;

enclockTimeFormat.enType =  (clock_fi_tclDCLK_TEN_TimeFormat::tenType)enTimeFormat;

ETG_TRACE_USR4(("Property_Status Timeformat   Timeformat: %d", enclockTimeFormat.enType));


ETG_TRACE_USR4(("Sending Component Time Format to INC"));
	tU8 u8INC_msg_buff[MAX_MSG_SIZE_COMPONENTTIMEFORMAT]= {0};
	////////////////////////////////////////////SMART CAN ///////////////////////////////
	tBool bTimeFormatSmart=0; 
	///////////////////////////////////////////////////////////////////////////////////
	u8INC_msg_buff[0] = 0x36; // msg id
	if(enclockTimeFormat.enType == 1)
	{
	u8INC_msg_buff[1] = 0x02;// Time Format 24
	/////////////////////////////////////////////////SMART /////////////////////
	bTimeFormatSmart=FALSE; // 24 hour format
	///////////////////////////////////////////////////////////////////////////
	}
	else
	{
		u8INC_msg_buff[1] = 0x01;// Time Format
		/////////////////////////////////////////////////SMART /////////////////////
		bTimeFormatSmart=TRUE; // 12 hour format // 
		///////////////////////////////////////////////////////////////////////////
	}
	tU8 u8DataLength = sizeof(u8INC_msg_buff);
	if(_poINCAdapter != NULL)
	{
		_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8DataLength);
	}
	else
	{
		ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
	}
sendTimeFormatStatus(enclockTimeFormat);
//_poContainer->SetTimeFormatSMART(bTimeFormatSmart);


}


tVoid vd_clock_tclServiceClockIf::vHandleMessage_DateformatUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_DateformatUpdate(msg: 0x%08x) entered.", pMsg));



	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

	VDCLK_TEN_DateFormat enDateFormat = _poContainer-> enGetDateFormat();

	clock_fi_tclDCLK_TEN_DateFormat enclockDateFormat;
	tU8 u8DateFormat =enDateFormat; // to resolve coverity issue 
    enclockDateFormat.enType = (clock_fi_tclDCLK_TEN_DateFormat::tenType) u8DateFormat;
//	enclockDateFormat.enType = (clock_fi_tclDCLK_TEN_DateFormat::tenType) enDateFormat;
	ETG_TRACE_USR4(("Property_Status Dateformat   Dateformat: %d", enclockDateFormat.enType));

	sendDateFormatStatus(enclockDateFormat);

}
tVoid vd_clock_tclServiceClockIf::vHandleMessage_NewDateformatUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_NewDateformatUpdate(msg: 0x%08x) entered.", pMsg));


	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
	if(_poContainer)
	{

	VDCLK_TEN_NewDateFormat enDateFormat = _poContainer-> enGetNewDateFormat();

	clock_fi_tclDCLK_TEN_NewDateFormat enclockDateFormat;

	tU8 u8ClockDateFormat = enDateFormat; // to resolve coverity
    enclockDateFormat.enType = (clock_fi_tclDCLK_TEN_NewDateFormat::tenType) u8ClockDateFormat;
//	enclockDateFormat.enType = (clock_fi_tclDCLK_TEN_NewDateFormat::tenType) enDateFormat;

	ETG_TRACE_USR4(("Property_Status new Dateformat   Dateformat: %d", enclockDateFormat.enType));

	sendNewDateFormatStatus(enclockDateFormat);
	}

}


tVoid vd_clock_tclServiceClockIf::vHandleMessage_EpochUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_EpochUpdate(msg: 0x%08x) entered.", pMsg));

	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
	VDCLK_TEN_GPS_EPOCH enEpoch = _poContainer ->enGetGPSEpoch();

	clock_fi_tclDCLK_TEN_GPS_EPOCH enGPSEpoch;

	enGPSEpoch.enType = (clock_fi_tclDCLK_TEN_GPS_EPOCH::tenType) enEpoch;

	ETG_TRACE_USR4(("Property_Status GPS Epoch: %d", enGPSEpoch.enType));

	sendGPS_WeekEpochStatus(enGPSEpoch);
}

tVoid vd_clock_tclServiceClockIf::vHandleMessage_GPSAutoSyncUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_GPSAutoSyncUpdate(msg: 0x%08x) entered.", pMsg));


	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

	tBool bEnabled = _poContainer->bGetGPS_AutoSync();
	tBool bPositionBased = _poContainer->bGetPositionBased();

	ETG_TRACE_USR4(("Property_Status GPSAutoSync   bEnabled: %d bPositionBased %d ", bEnabled, bPositionBased ));

    sendGPS_AutoSyncStatus(bEnabled, bPositionBased);

    tU8 u8INC_msg_buff[MAX_MSG_SIZE_TIMEMODE] = {0};

    u8INC_msg_buff[0] = 0x34;
    if(bEnabled)
    {
    	u8INC_msg_buff[1] = 0x01;
    }else
    {
    	u8INC_msg_buff[1] = 0x03;
    }

    tU8 u8DataLength = sizeof(u8INC_msg_buff);

    ETG_TRACE_USR4(("INCMessage buffer TimeSetting Mode, message  %d",u8INC_msg_buff[0] ));
    ETG_TRACE_USR4(("INCMessage buffer TimeSetting Mode, Mode is %d",u8INC_msg_buff[1] ));

    ETG_TRACE_USR4(("INCMessage buffer DataLength is %d",u8DataLength ));

    if(_poINCAdapter != NULL)
    {
    	_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8DataLength);
    }else
    {
    	ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
    }


}

/*
tVoid vd_clock_tclServiceClockIf::vHandleMessage_GPSAutoSyncUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_GPSAutoSyncUpdate(msg: 0x%08x) entered.", pMsg));

	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

	tBool bEnabled = _poContainer->bGetGPS_AutoSync();
	tBool bPositionBased = _poContainer->bGetPositionBased();

    sendGPS_AutoSyncStatus(bEnabled, bPositionBased);
}
*/
tVoid vd_clock_tclServiceClockIf::vHandleMessage_DSTUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_DSTUpdate(msg: 0x%08x) entered.", pMsg));


	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);


	tBool bDST_Status = _poContainer->bGetDaylightSavingTimeOn();
	tBool bDST_AutoAdjust = _poContainer->bGetDaylightSavingTimeAuto();

	VDCLK_TEN_DST_Setting enDST_Status = _poContainer->enGetDaylightSavingTimeStatus();

	clock_fi_tclDCLK_TEN_DST_Setting enDST_clockStatus;
	tU8 u8Clock_Status =enDST_Status; // to resolve coverity issue 
	    enDST_clockStatus.enType =(clock_fi_tclDCLK_TEN_DST_Setting::tenType) u8Clock_Status;
	//enDST_clockStatus.enType = (clock_fi_tclDCLK_TEN_DST_Setting::tenType) enDST_Status;

   sendDaylightSavingTimeStatus(bDST_Status, bDST_AutoAdjust,enDST_clockStatus);
}

tVoid vd_clock_tclServiceClockIf::vHandleMessage_LocaltimeOffsetUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{

	ETG_TRACE_USR4(("vHandleMessage_LocaltimeOffsetUpdate(msg: 0x%08x) entered.", pMsg));

	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);


    // UTC time
    vdclk_tclDateTime          oSystemDateTime;
    _poContainer-> vGetSystemDateTime (oSystemDateTime);
    TRACE_DateTime("System (UTC)TIMEDATE", (oSystemDateTime), _CLASS, __LINE__);

    // initialize the variables
    tS16 s16Year;           tU8 u8Month;         tU8  u8Day;
    tU8   u8Hour;           tU8 u8Minute;        tU8  u8Second;
    tU8   u8Weekday;
    oSystemDateTime.u8GetComponents( &s16Year,      &u8Month,      &u8Day,
                                                      &u8Hour,       &u8Minute,     &u8Second,
                                                      &u8Weekday );

    ETG_TRACE_USR3(("UTC System Time: Years=%d, Months=%d, Days=%d, Hours=%d, Minutes=%d, Seconds=%d, Weekday=%d",s16Year,u8Month,u8Day,u8Hour,u8Minute,u8Second,u8Weekday));


    // Local time offset in seconds
    tS64 tS64LocalTimeOffset = _poContainer->s64GetLocalTimeOffset();

    // extract the sign  and convert S64 into U32
    tU32 u32Value;
    tBool bIsPositive = TRUE;
    if(tS64LocalTimeOffset < 0L)
    {
      bIsPositive = FALSE;
      u32Value = (tU32) (-(tS64LocalTimeOffset));
    }
    else
    {
       u32Value = (tU32)tS64LocalTimeOffset;
    }
    vdclk_tclDateTime oOffsetDateTime;
    tS16 s16OffsYear = 0;           tU8 u8OffsMonth = 0;         tU8  u8OffsDay = 0;
    tU8   u8OffsHour = 0;           tU8 u8OffsMinute = 0;        tU8  u8OffsSecond = 0;

    oOffsetDateTime.vGetDateFormat(bIsPositive, u32Value, s16Year, u8Month, &s16OffsYear, &u8OffsMonth, &u8OffsDay, &u8OffsHour, &u8OffsMinute, &u8OffsSecond);

    ETG_TRACE_USR3(("Local time Offset: IsPostive = %d,Years=%d, Months=%d, Days=%d, Hours=%d, Minutes=%d, Seconds=%d",bIsPositive,s16OffsYear,u8OffsMonth,u8OffsDay,u8OffsHour,u8OffsMinute,u8OffsSecond));


    // UTC Time in u32value
    tU32 u32UTCTimeDate_ScalarValue = oSystemDateTime.u32GetValue();

    ETG_TRACE_USR3(("System time scalar value %u",oSystemDateTime.u32GetValue()));


    // UTC time validity flag
    VDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState = _poContainer->enGetRtcTimeState();

    clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE enclockGpsRtcTimeState;

    enclockGpsRtcTimeState.enType = (clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE::tenType)enGpsRtcTimeState;

	sendLocalTimeOffsetStatus(tS64LocalTimeOffset, bIsPositive, s16OffsYear, u8OffsMonth, u8OffsDay, u8OffsHour, u8OffsMinute, u8OffsSecond, u32UTCTimeDate_ScalarValue, s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, u8Weekday, enclockGpsRtcTimeState);

}

tVoid vd_clock_tclServiceClockIf::vHandleMessage_clocksourcestatusUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_clocksourcestatusUpdate(msg: 0x%08x) entered.", pMsg));

	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);


// TODO
}

tVoid vd_clock_tclServiceClockIf::vHandleMessage_FormatsourcestatusUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_FormatsourcestatusUpdate(msg: 0x%08x) entered.", pMsg));

	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);


// TODO
}
tVoid vd_clock_tclServiceClockIf::vHandleMessage_AutoTimeZoneOffsetUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_AutoTimeZoneOffsetUpdate(msg: 0x%08x) entered.", pMsg));
	
	tS8 _sOffsetHr, _sOffsetMin;
	_sOffsetHr = _poContainer->offset_hour;
	_sOffsetMin = _poContainer->offset_minute;

	ETG_TRACE_USR4(("offset_Hour %d ",_sOffsetHr));
	ETG_TRACE_USR4(("offset_Minute %d ",_sOffsetMin));
	sendAuto_TimeZoneOffsetStatus(_sOffsetHr,_sOffsetMin);

}


// Requesting Hardware Version from V850
tVoid vd_clock_tclServiceClockIf::vGetHardwareVersion()
{
	// Send message for HW version info

	ETG_TRACE_USR4(("vGetHardwareVersion entered."));

	tU8 u8INC_msg_buff[MAX_MSG_SIZE_COMPONENTSTATUS]= {0};
	u8INC_msg_buff[0] = 0x44; // msg id
	u8INC_msg_buff[1] = 0x01; // MCAN status
	tU8 u8DataLength = sizeof(u8INC_msg_buff);
	if(_poINCAdapter != NULL)
		{
			ETG_TRACE_USR4(("Sending INC Message to v850 for HW version."));
			_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8DataLength);
		}
	else
		{
			ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
		}
}

// Requesting Software Version from V850

tVoid vd_clock_tclServiceClockIf::vGetSoftwareVersion()
{
	ETG_TRACE_USR4(("vGetSoftwareVersion entered."));

	// Send message for SW version info
	tU8 u8INC_msg_buff_1[MAX_MSG_SIZE_COMPONENTSTATUS]= {0};
	u8INC_msg_buff_1[0] = 0x46; // msg id
	u8INC_msg_buff_1[1] = 0x01; // MCAN status
	tU8 u8DataLength_1 = sizeof(u8INC_msg_buff_1);
		if(_poINCAdapter != NULL)
			{
				ETG_TRACE_USR4(("Sending INC Message to v850 for SW version."));
				_poINCAdapter->sendMessage((void*)u8INC_msg_buff_1, (unsigned int)u8DataLength_1);
			}
		else
			{
				ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
			}

}



tVoid vd_clock_tclServiceClockIf::vHandleMessage_LocalTimeDateUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_LocalTimeDateUpdate(msg: 0x%08x) entered.", pMsg));


	if(_poUpdater->_RTCOpenReadStatus)
	{
		VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

	    // prepare local DateTime object
	    vdclk_tclDateTime          oLocalDateTime;
	    static vdclk_tclDateTime   oPrevDateTime;

		// read current local date / time from container
		_poContainer-> vGetLocalDateTime (&oLocalDateTime);
		tU8 u8Change = (tU8) VDCLK_EN_AllChange;
		// if (poInMessage == NULL)
		//  {
		u8Change = oLocalDateTime.u8GetChanges(&oPrevDateTime);
		if ((u8Change & (tU8) VDCLK_EN_MinuteChange) != 0)  // static check
		{
			vdclk_tclDateTime          oSystemDateTime;
			_poContainer-> vGetSystemDateTime (oSystemDateTime);
			TRACE_Minute ("SendStatus:LocalTime:", (oLocalDateTime), oSystemDateTime, _CLASS, __LINE__);
		}
		// if ((u8Change & _u8NotificationChangeMask) != 0)  // dynamic check
		//  {
		TRACE_DateTime("vSendStatus:LOCALTIMEDATE", (oLocalDateTime), _CLASS, __LINE__);
		//  }
		oPrevDateTime = vdclk_tclDateTime(oLocalDateTime);
		//    }

	          // initialize some variables
	             tS16 s16Year;           tU8 u8Month;         tU8  u8Day;
	             tU8   u8Hour;           tU8 u8Minute;        tU8  u8Second;
	             tU8   u8Weekday;
	             tU8 u8ValidMask = oLocalDateTime.u8GetComponents( &s16Year,      &u8Month,      &u8Day,
	                                                               &u8Hour,       &u8Minute,     &u8Second,
	                                                               &u8Weekday );

		tU8 u8TimeDateStatus = (u8Change | u8ValidMask);
		tU32 u32TimeDateValue = oLocalDateTime.u32GetValue();

		sendLocalTimeDateStatus(s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, u8Weekday, u8TimeDateStatus, u32TimeDateValue);

		if( _poContainer->_bfirstLocalMinute) // First update to status for disclaimer pop up
		{
			sendLocalTimeDate_MinuteUpdateStatus(s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, u8Weekday, u8TimeDateStatus, u32TimeDateValue);
			_poContainer-> _bfirstLocalMinute = FALSE;
		}


		// Scope 2.1
		unsigned char VCANDiversityType = 0xFF;
		dp_tclKdsVehicleInformation _oKdsVehicleInfo;
		_oKdsVehicleInfo.u8GetVCANDiversity(VCANDiversityType);

		ETG_TRACE_USR4(("VCANDiversityType is .. %d",VCANDiversityType));

		if(VCANDiversityType==0x01 || VCANDiversityType==0x03)
		{
			ETG_TRACE_USR4(("VCANDiversityType is .. %d",VCANDiversityType));
			_poContainer->SendDateTimeStatusCAN((tU16)s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, u8Weekday);
		}
	}

	else
	{
		ETG_TRACE_USR4(("SendStatus:LocalTime update"));
	}


}


tVoid vd_clock_tclServiceClockIf ::vHandleMessage_LocalTimeDate_MinuteUpdateUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_LocalTimeDate_MinuteUpdateUpdate(msg: 0x%08x) entered.", pMsg));

	if(_poUpdater->_RTCOpenReadStatus)
	{
		VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

		// prepare local DateTime object
		vdclk_tclDateTime          oLocalDateTime;
		static vdclk_tclDateTime   oPrevDateTime;

		// read current local date / time from container
		_poContainer-> vGetLocalDateTime (&oLocalDateTime);
		tU8 u8Change = (tU8) VDCLK_EN_AllChange;
		// if (poInMessage == NULL)
		//  {
		u8Change = oLocalDateTime.u8GetChanges(&oPrevDateTime);

		if ((u8Change & 0x76) != 0)  // static check // change of hour, minute, date and HMI change and not second change
		{
			vdclk_tclDateTime          oSystemDateTime;
			_poContainer-> vGetSystemDateTime (oSystemDateTime);
			TRACE_Minute ("SendStatus:LocalTime_minute update:", (oLocalDateTime), oSystemDateTime, _CLASS, __LINE__);

			oPrevDateTime = vdclk_tclDateTime(oLocalDateTime);

			// initialize some variables
			tS16 s16Year;           tU8 u8Month;         tU8  u8Day;
			tU8   u8Hour;           tU8 u8Minute;        tU8  u8Second;
			tU8   u8Weekday;
			tU8 u8ValidMask = oLocalDateTime.u8GetComponents( &s16Year,      &u8Month,      &u8Day,
					&u8Hour,       &u8Minute,     &u8Second,
					&u8Weekday );

			tU8 u8TimeDateStatus = (u8Change | u8ValidMask);
			tU32 u32TimeDateValue = oLocalDateTime.u32GetValue();
			//property update for Localtimedate_minuteupdate(id= 0x8250)
			sendLocalTimeDate_MinuteUpdateStatus(s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, u8Weekday, u8TimeDateStatus, u32TimeDateValue);
///////////////////////////////////////////////////////SMART CAN ////////////////////////////////
		//	_poContainer->SetLocalDateTimeSMART(u8Hour,u8Minute);
	/////////////////////////////////////////////////////////////////////////////////////
			//Update for meter component also the time.

			//vdclk_tclDateTime          oSystemDateTime;
			//_poContainer-> vGetSystemDateTime (oSystemDateTime);
			//TRACE_Minute ("SendStatus:LocalTime:", (oLocalDateTime), oSystemDateTime, _CLASS, __LINE__);


			tU8 u8INC_msg_buff[MAX_MSG_SIZE_DATETIME] = {0};

			u8INC_msg_buff[0] = 0x30;
			u8INC_msg_buff[1] = u8Hour;
			u8INC_msg_buff[2] = u8Minute;
			u8INC_msg_buff[3] = u8Second;
			u8INC_msg_buff[4] = u8Day;
			u8INC_msg_buff[5] = u8Month;
			u8INC_msg_buff[6] = s16Year & 0x00FF;   // sending little-endian format.  last two digits of year
			u8INC_msg_buff[7] = (s16Year >> 8);     // first two digits of year

			ETG_TRACE_USR4(("INCMessage buffer , message  %d",u8INC_msg_buff[0] ));
			ETG_TRACE_USR4(("INCMessage buffer , Hour %d",u8INC_msg_buff[1] ));
			ETG_TRACE_USR4(("INCMessage buffer , minute %d",u8INC_msg_buff[2] ));
			ETG_TRACE_USR4(("INCMessage buffer , Seconds  %d",u8INC_msg_buff[3] ));
			ETG_TRACE_USR4(("INCMessage buffer , Day %d",u8INC_msg_buff[4] ));
			ETG_TRACE_USR4(("INCMessage buffer , month %d",u8INC_msg_buff[5] ));
			ETG_TRACE_USR4(("INCMessage buffer , Year lower 8 bits %d",u8INC_msg_buff[6] ));
			ETG_TRACE_USR4(("INCMessage buffer , Year upper 8 bits %d",u8INC_msg_buff[7] ));


			tU8 u8Datalength = sizeof(u8INC_msg_buff);

			ETG_TRACE_USR4(("INCMessage buffer data length %d",u8Datalength));

			if(_poINCAdapter != NULL)
			{
				_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8Datalength);
			}
			else
			{
				ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
			}

			// Scope 2.1 Nissan
			unsigned char FuelType = 0xFF;
			dp_tclKdsVehicleInformation _oKdsVehicleInfo;
			_oKdsVehicleInfo.u8GetFuelType(FuelType);

			ETG_TRACE_USR4(("FuelType is .. %d",FuelType));

			if(FuelType==0x04)
			{
				ETG_TRACE_USR4(("FuelType is .. %d",FuelType));

				// initialize some variables for the UTC time
				tS16 s16Year;           tU8 u8Month;         tU8  u8Day;
				tU8   u8Hour;           tU8 u8Minute;        tU8  u8Second;
				tU8   u8Weekday;
				tU8 u8ValidMask = oSystemDateTime.u8GetComponents( &s16Year,      &u8Month,      &u8Day,
						&u8Hour,       &u8Minute,     &u8Second,
						&u8Weekday );

				_poContainer->SendDateTimeStatusCANVariant((tU16)s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, u8Weekday);
			}
		}
	}

	else
	{
		ETG_TRACE_USR4 (("SendStatus:LocalTime_minute update"));
	}



}


tVoid vd_clock_tclServiceClockIf ::vHandleMessage_Clock_MeterSettingsUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	if(_poINCAdapter)
	{
		vdclk_MeterSettings Clock_Meter = _poINCAdapter->tGetMeterSettingsData();

		if(_poContainer)
		{
			_poContainer->SetMCANTimeFormat(Clock_Meter._u8SetTimeFormat);
			_poContainer->SetMCANClockMode(Clock_Meter._u8SetClockMode);
			tU8 _InvalidParam = _poContainer->SetMCANClock(Clock_Meter._u8SetClock,Clock_Meter._u8SetClockHour,Clock_Meter._u8SetClockMinute);
			_poContainer->SetMCANOffsetHourMinute(Clock_Meter._u8SetClockOffsetHour,Clock_Meter._u8SetClockOffsetMinute);
			_poContainer->SetMCANDST(Clock_Meter._u8SetDST);
			_poContainer->SetMCANTimezone(Clock_Meter._u8SetTimezone);

			vd_clock_tclAppMain::theServer()->vPostMsgTimeformatUpdate("Ivd_clock_tclServiceClockIf");
			vd_clock_tclAppMain::theServer()->vPostMsgGPSAutoSyncUpdate("Ivd_clock_tclServiceClockIf");
			vd_clock_tclAppMain::theServer()->vPostMsgAutoTimeZoneOffsetUpdate("Ivd_clock_tclServiceClockIf");
			vd_clock_tclAppMain::theServer()->vPostMsgDSTUpdate("Ivd_clock_tclServiceClockIf");
			vd_clock_tclAppMain::theServer()->vPostMsgTimezoneUpdate("Ivd_clock_tclServiceClockIf");
			vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
			vd_clock_tclAppMain::theServer()->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");


			_poContainer->SendMCANSettings_Status(_InvalidParam);
		}
	}


}

tVoid vd_clock_tclServiceClockIf::vHandleMessage_DebugMode_TimeDateUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_DebugMode_TimeDateUpdate(msg: 0x%08x) entered.", pMsg));

	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
	OSAL_trTimeDate  TmpTimeDate;
	 if(OSAL_s32ClockGetTime(&TmpTimeDate) >= 0 )
	 {
	   tS32 s32OffsetYear = 1900;
	   tS16  s16Year = TmpTimeDate.s32Year + s32OffsetYear;
	tU8   u8Month = TmpTimeDate.s32Month;
	tU8   u8Day = TmpTimeDate.s32Day;
	tU8   u8Hours = TmpTimeDate.s32Hour;
	tU8   u8Minutes = TmpTimeDate.s32Minute;
	tU8   u8Seconds = TmpTimeDate.s32Second;
	tU8   u8Weekday = TmpTimeDate.s32Weekday;
	tBool bdebugMode = DebugModeFlag;

	ETG_TRACE_USR3(("Debug_Mode:Time: (YY:MM:DD:HH:MM:SS:WeekDay) %d:%d:%d:%d:%d:%d:%d",
		s16Year, u8Month, u8Day, u8Hours, u8Minutes, u8Seconds, u8Weekday));

	sendDebugMode_TimeDateStatus( s16Year, u8Month,u8Day,u8Hours, u8Minutes, u8Seconds,u8Weekday,bdebugMode);
	 }
	 else
		 ETG_TRACE_USR4(("OSAL_s32ClockGetTime returned Negative value"));


}

tVoid vd_clock_tclServiceClockIf::vHandleMessage_UTCTimeDateUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_UTCTimeDateUpdate(msg: 0x%08x) entered.", pMsg));

	tBool _isGPSValid = FALSE;
	tBool bTimeValidity = FALSE;


	// initialize some variables
	tS16 s16Year;           tU8 u8Month;         tU8  u8Day;
	tU8   u8Hour;           tU8 u8Minute;        tU8  u8Second;
	tU8   u8Weekday;

	vdclk_tclDateTime          oUTCDateTime;
	_poContainer-> vGetSystemDateTime (oUTCDateTime);

	tU8 u8ValidMask = oUTCDateTime
			.u8GetComponents( &s16Year,      &u8Month,      &u8Day,
						&u8Hour,       &u8Minute,     &u8Second,
						&u8Weekday );

	if(_poClientSensor)
	{
		_isGPSValid = _poClientSensor->isGPSDataValid();
	}

	 //Sending the UTC time and the time as valid to TCU

	if((_isGPSValid) || (_poUpdater->_RTCValidOnce))
	{
		bTimeValidity = TRUE;
		sendUTC_TimeDateUpdateStatus(s16Year, u8Month, u8Day, u8Hour, u8Minute, u8Second, u8Weekday, bTimeValidity);
	}

}

tVoid vd_clock_tclServiceClockIf::vHandleMessage_HUDActivateStateUpdate(vd_clock_tclBaseIf::TMsg* pMsg)
{
	ETG_TRACE_USR4(("vHandleMessage_HUDActivation(msg: 0x%08x) entered.", pMsg));

	sendHUD_ActivationStatus(_u8HUDActivateState);

}


// vd_clock_tclServiceClockIfvd_clock_ServiceClockIf: user specific code end

//EOF
