/*****************************************************************************
* FILE:         vd_clock_AppMain_trace.cpp        
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     applMain_trace.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH, Hildesheim
*****************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "vd_clock_AppMain.h"


// vd_clock_AppMain_traceInclude: user specific code start

#include "vd_clock_types.h"
#include "vd_clock_datetime.h"
#include "vd_clock_timezone.h"
#include "vd_clock_datacontainer.h"
#include "vd_clock_INCAdapter.h"
#include "I_vd_clock_ServiceClockIf.h"
#include "ProfileManager.h"
// vd_clock_AppMain_traceInclude: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_APPLICATION
#include "trcGenProj/Header/vd_clock_AppMain_trace.cpp.trc.h"
#endif

tVoid vd_clock_tclAppMain::vHandleTraceMessage(const tUChar* puchData) {
    tU32 u32MsgCode = (puchData[1]<<8) | puchData[2];
    
    ETG_TRACE_USR1(("vd_clock_tclAppMain::vHandleTraceMessage(): process command: %d.", u32MsgCode));
    
    switch (u32MsgCode) {

    case VD_CLOCK_VD_CLOCK_CMDHELP:
        {

            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_VD_CLOCK_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3000 );
            etg_vTraceBinary(((0xFFFFu & (etg_tU16)(TR_CLASS_VD_CLOCK_APPLICATION)) << 16) | (etg_tU16)(TR_LEVEL_FATAL) , 0, 0, 2/* one ETG_EN_T16 only */, 0x3001 );

        }
        break;
#ifndef _CCA_APPLICATION_WO_SERVICE
    case VD_CLOCK_VD_CLOCK_POSTBROADCASTCMD:
        {
            // Post an internal message to all application object handler.
            tU16 param1 = ((tU16)puchData[3]<<8) | (tU16)puchData[4];

            vd_clock_tclBaseIf::TMsg oMsg;
            oMsg.eCmd = (vd_clock_tclBaseIf::ECmdTypes)param1;
            oMsg.strClassName[0]=0;
            oMsg.u.u32Data = 0;

            // VD_CLOCK_PostBroadcastCmd: user specific code start


            // VD_CLOCK_PostBroadcastCmd: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;

    case VD_CLOCK_VD_CLOCK_POSTBROADCASTCMDPARAM:
        {
            // Post an internal message with parameter to all application object handler.
            tU16 param1 = ((tU16)puchData[3]<<8) | (tU16)puchData[4];
            tU32 param2 = ((tU32)puchData[5]<<24) | ((tU32)puchData[6]<<16) | ((tU32)puchData[7] << 8) | (tU32)puchData[8];

            vd_clock_tclBaseIf::TMsg oMsg;
            oMsg.eCmd = (vd_clock_tclBaseIf::ECmdTypes)param1;
            oMsg.strClassName[0]=0;
            oMsg.u.u32Data = param2;

            // VD_CLOCK_PostBroadcastCmdParam: user specific code start
            // VD_CLOCK_PostBroadcastCmdParam: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;

    case VD_CLOCK_VD_CLOCK_POSTCMDTOCLASS:
        {
            // Post an internal message with parameter to a specific application object handler.
            tU16 param1 = ((tU16)puchData[3]<<8) | (tU16)puchData[4];
            tU32 param2 = ((tU32)puchData[5]<<24) | ((tU32)puchData[6]<<16) | ((tU32)puchData[7] << 8) | (tU32)puchData[8];
            const tChar* pString3 = (const tChar*)&puchData[9];

            vd_clock_tclBaseIf::TMsg oMsg;
            oMsg.eCmd = (vd_clock_tclBaseIf::ECmdTypes)param1;
            OSAL_szStringNCopy(oMsg.strClassName, pString3, 50);
            oMsg.u.u32Data = param2;
            // VD_CLOCK_PostCmdToClass: user specific code start
            // VD_CLOCK_PostCmdToClass: user specific code end
            _poMainAppInstance->vPostInternalMessage(&oMsg);            
        }
        break;
#endif
    case VD_CLOCK_VD_CLOCK_TRACEINFO:
        {
            // Printout information of an object of the given interface name. Set interface name tp '\\0' every information is shown.
            const tChar* pString1 = (const tChar*)&puchData[3];
    
            // VDDIMMING_VDDIM_TRACEINFO: user specific code start
            // VDDIMMING_VDDIM_TRACEINFO: user specific code end
            bpstl::set<vd_clock_tclBaseIf*>::iterator iter;
            for (iter = _poMainAppInstance->_oObjList.begin(); iter != _poMainAppInstance->_oObjList.end(); iter++) {
               // then check for specific implementation
               if (pString1[0] != 0) 
               {
                  if (0 == OSAL_s32StringCompare((*iter)->getIfName(), pString1)) {
                     (*iter)->vTraceInfo();
                  }
               } else {
                  (*iter)->vTraceInfo();
               }
            }
            
        }
        break;


    case VD_CLOCK_VD_CLOCK_VDCLK_GETTIME:
        {
            // Displays the Localtime
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETTIME: user specific code start
        	Ivd_clock_tclServiceClockIf* _poService = dynamic_cast<Ivd_clock_tclServiceClockIf*>(_poMainAppInstance->getHandler("Ivd_clock_tclServiceClockIf"));
            VD_CLOCK_NULL_POINTER_CHECK(_poService);

            _poService->onGetAvailableTimeZonesMStart();




            // VD_CLOCK_VD_CLOCK_VDCLK_GETTIME: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETIMEFORMAT:
        {
            // Displays the Timeformat
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETIMEFORMAT: user specific code start

    	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

        	VDCLK_TEN_TimeFormat enTimeFormat = _poContainer-> enGetTimeFormat();

        	ETG_TRACE_USR4(("Get Timeformat : %d", enTimeFormat));

            // VD_CLOCK_VD_CLOCK_VDCLK_GETIMEFORMAT: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETDATEFORMAT:
        {
            // Displays the Dateformat
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETDATEFORMAT: user specific code start

    	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

        	VDCLK_TEN_DateFormat enDateFormat = _poContainer-> enGetDateFormat();

        	ETG_TRACE_USR4(("Get Dateformat : %d", enDateFormat));

            // VD_CLOCK_VD_CLOCK_VDCLK_GETDATEFORMAT: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETGPSAUTOSYNC:
        {
            // Displays the whether GPS Auto Sync Enabled  or not
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETGPSAUTOSYNC: user specific code start

    	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
        	tBool bEnabled = _poContainer->bGetGPS_AutoSync();
        	tBool bPositionBased = _poContainer->bGetPositionBased();

        	ETG_TRACE_USR4(("Get GPSAutoSync bEnabled: %d bPositionBased %d ", bEnabled, bPositionBased ));

            // VD_CLOCK_VD_CLOCK_VDCLK_GETGPSAUTOSYNC: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETSYNCMODE:
        {
            // Displays the Syncmode
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETSYNCMODE: user specific code start

    	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

            VDCLK_TEN_SyncMode enSyncMode = _poContainer->enGetSyncMode();
            ETG_TRACE_USR4(("Get enSyncMode : %d", enSyncMode));

            // VD_CLOCK_VD_CLOCK_VDCLK_GETSYNCMODE: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETDST:
        {
            // Displays the DST
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETDST: user specific code start

    	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

            VDCLK_TEN_DST_Setting enDST = _poContainer->enGetDaylightSavingTimeStatus();
            ETG_TRACE_USR4(("Get DST : %d", enDST));

            // VD_CLOCK_VD_CLOCK_VDCLK_GETDST: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETTIMEZONE:
        {
            // Displays the Timezone index
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETTIMEZONE: user specific code start
    	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

        	tU16 u16Index = _poContainer->u16GetTimeZoneIndex();
        	ETG_TRACE_USR4(("Get Timezone   Timezoneindex %d", u16Index));

            // VD_CLOCK_VD_CLOCK_VDCLK_GETTIMEZONE: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETTIMEFORMAT:
        {
            // Sets the timeformat
            tU8 param1 = puchData[3];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETTIMEFORMAT: user specific code start

    	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
            _poContainer->vSetTimeFormat((VDCLK_TEN_TimeFormat)param1);

            // VD_CLOCK_VD_CLOCK_VDCLK_SETTIMEFORMAT: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETDATEFORMAT:
        {
            // Sets the Dateformat
            tU8 param1 = puchData[3];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETDATEFORMAT: user specific code start

    	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
           _poContainer->vSetDateFormat((VDCLK_TEN_DateFormat)param1);
            // VD_CLOCK_VD_CLOCK_VDCLK_SETDATEFORMAT: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETNEWDATEFORMAT:
        {
            // Sets the New Dateformat
            tU8 param1 = puchData[3];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETNEWDATEFORMAT: user specific code start
    	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
           _poContainer->vSetNewDateFormat((VDCLK_TEN_NewDateFormat)param1);
            // VD_CLOCK_VD_CLOCK_VDCLK_SETNEWDATEFORMAT: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETTIME:
        {
            // Sets the Localtime
            tU16 param1 = ((tU16)puchData[3] <<  8) | (tU16)puchData[4];
            tU8 param2 = puchData[5];
            tU8 param3 = puchData[6];
            tU8 param4 = puchData[7];
            tU8 param5 = puchData[8];
            tU8 param6 = puchData[9];
            tU8 param7 = puchData[10];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETTIME: user specific code start
	    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
        VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

		tU16 s16Year = param1;
        tU8  u8Month = param2;
        tU8  u8Day = param3;
        tU8  u8Hours = param4;
        tU8  u8Minutes = param5;
        tU8  u8Seconds = param6;
        tU8  u8ChangeMask = 0xFF;
        (tVoid)param7; //To satisfy lint

        ETG_TRACE_FATAL(("sendSelf:Set LOCALTIMEDATE:([Y:M:D][h:m:s])[%u:%u:%u][%u%u%u]",
        		s16Year, u8Month, u8Day,
        		u8Hours, u8Minutes, u8Seconds));

    	tBool bIsValid = vdclk_tclDateTime:: bIsDateTimeValid( s16Year, u8Month, u8Day, u8Hours, u8Minutes, u8Seconds, 1, u8ChangeMask );

    	ETG_TRACE_COMP(("SetLocalTime:bIsValid=%d", bIsValid));
    	if (bIsValid)
    	{
    		vdclk_tclDateTime  oNewDateTime;
    	    oNewDateTime.u8Update( s16Year,     u8Month,     u8Day,
    	    		               u8Hours,     u8Minutes,   u8Seconds,
    	    		               u8ChangeMask );

    	    _poContainer-> vSetLocalDateTime (&oNewDateTime);
    	 //   u32NotifyEvents = cu32EventMaskPropertyNotify8200;

    	    _poMainAppInstance->vPostMsgLocalTimeDateUpdate("Ivd_clock_tclServiceClockIf");
    	    _poMainAppInstance->vPostMsgLocalTimeDate_MinuteUpdateUpdate("Ivd_clock_tclServiceClockIf");
    	}
    	else
    	{
    		ETG_TRACE_COMP(("Error. Parameter not valid"));
    	}
            // VD_CLOCK_VD_CLOCK_VDCLK_SETTIME: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETGPSAUTOSYNC:
        {
            // Sets the GPS Auto Sync
            tU8 param1 = puchData[3];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETGPSAUTOSYNC: user specific code start

		    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

			tBool bEnabled = param1 ? TRUE : FALSE;
            ETG_TRACE_FATAL(("Set GPS_AUTOSYNC=%d", bEnabled));
            _poContainer-> vSetGPS_AutoSync(bEnabled, bEnabled);

            // VD_CLOCK_VD_CLOCK_VDCLK_SETGPSAUTOSYNC: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETTIMEZONE:
        {
            // Sets the TimezoneIndex
            tU8 param1 = puchData[3];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETTIMEZONE: user specific code start

		    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

            ETG_TRACE_FATAL(("Set Timezone: TimezoneIndex=%d", param1));
            _poContainer->vSetTimeZone((tU16) param1);

            // VD_CLOCK_VD_CLOCK_VDCLK_SETTIMEZONE: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETDST:
        {
            // Sets the DST
            tU8 param1 = puchData[3];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETDST: user specific code start
		    vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

            ETG_TRACE_USR4(("property_set DaylightSaving  enDST_Setting = %d ",param1 ));
            _poContainer-> vSetDaylightSavingTime( (VDCLK_TEN_DST_Setting)param1, TRUE );

            // VD_CLOCK_VD_CLOCK_VDCLK_SETDST: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETINCTIME:
        {
            // Sets the INC time. Used for testing the INC time receive
            tU16 param1 = ((tU16)puchData[3] <<  8) | (tU16)puchData[4];
            tU8 param2 = puchData[5];
            tU8 param3 = puchData[6];
            tU8 param4 = puchData[7];
            tU8 param5 = puchData[8];
            tU8 param6 = puchData[9];
            tU8 param7 = puchData[10];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETINCTIME: user specific code start

            vd_clock_INCAdapter* _poINCAdapter = dynamic_cast<vd_clock_INCAdapter*>(_poMainAppInstance->getHandler("vd_clock_INCAdapter"));
            VD_CLOCK_NULL_POINTER_CHECK(_poINCAdapter);

            OSAL_trTimeDate t_INCTime;

            t_INCTime.s32Hour = 0;
            t_INCTime.s32Minute = 0;
            t_INCTime.s32Second = 0;
            t_INCTime.s32Day  = 0;
            t_INCTime.s32Month = 0;
            t_INCTime.s32Year = 0;
			t_INCTime.s32Weekday=0;
			t_INCTime.s32Yearday=0;
			t_INCTime.s32Daylightsaving=0;



            t_INCTime.s32Hour   = param4;
            t_INCTime.s32Minute = param5;
            t_INCTime.s32Second = param6;
            t_INCTime.s32Day    = param3;
            t_INCTime.s32Month  = param2;
            t_INCTime.s32Year   = param1;
            (tVoid)param7;//To satisfy lint

            _poINCAdapter->vTestINCReceive(t_INCTime);
            // VD_CLOCK_VD_CLOCK_VDCLK_SETINCTIME: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETAUTOTIMEZONE_OFFSET:
        {
            // Displays the Auto and timezone offset values
			tU16 u16AutoTimeZoneOffset=0;

            // VD_CLOCK_VD_CLOCK_VDCLK_GETAUTOTIMEZONE_OFFSET: user specific code start
        	 vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
        	 VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
        	 u16AutoTimeZoneOffset=_poContainer ->u16GetAutoTimezoneOffset();
			 ETG_TRACE_USR4(("property_get auto Timezone offset  = %d",u16AutoTimeZoneOffset ));
            // VD_CLOCK_VD_CLOCK_VDCLK_GETAUTOTIMEZONE_OFFSET: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETAUTOTIMEZONE_OFFSET:
        {
            // Sets the AUTOTIMEZONE_OFFSET
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETAUTOTIMEZONE_OFFSET: user specific code start
            vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
            ETG_TRACE_USR4(("property_set auto Timezone offset  = %d  %d ",param1,param2 ));
            _poContainer ->vSetAutoTimeZoneOffset((tS64)param1,(tS64)param2);
            // VD_CLOCK_VD_CLOCK_VDCLK_SETAUTOTIMEZONE_OFFSET: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETLOCALTIMEDATE:
        {
            // Displays the local time and date values
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETLOCALTIMEDATE: user specific code start
        	vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
        	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
        	 vdclk_tclDateTime          oLocalDateTime;
        	_poContainer-> vGetLocalDateTime (&oLocalDateTime);
            // VD_CLOCK_VD_CLOCK_VDCLK_GETLOCALTIMEDATE: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETLOCALTIMEDATE:
        {
            // Sets the LOCALTIMEDATE
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
            tU8 param3 = puchData[5];
            tU8 param4 = puchData[6];
            tU8 param5 = puchData[7];
            tU8 param6 = puchData[8];
            tU8 param7 = puchData[9];
            tU8 param8 = puchData[10];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETLOCALTIMEDATE: user specific code start
            vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
            ETG_TRACE_USR4(("property_set local DateTime " ));
            vdclk_tclDateTime  oNewDateTime;
            (tVoid)param8;//To satisfy lint
            oNewDateTime.u8Update( param1,	param2,	param3,	param4,	param5,	param6,	param7 );
            _poContainer-> vSetLocalDateTime (&oNewDateTime);
            // VD_CLOCK_VD_CLOCK_VDCLK_SETLOCALTIMEDATE: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETLOCALTIMEDATE_MINUTEUPDATE:
        {
            // Displays the local time,date and minute update
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETLOCALTIMEDATE_MINUTEUPDATE: user specific code start
        	vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
        	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
        	 vdclk_tclDateTime          oLocalDateTime;
        	_poContainer-> vGetLocalDateTime (&oLocalDateTime);
            // VD_CLOCK_VD_CLOCK_VDCLK_GETLOCALTIMEDATE_MINUTEUPDATE: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETLOCALTIMEDATE_MINUTEUPDATE:
        {
            // Sets the local time date minute 
            tU8 param1 = puchData[3];
            tU8 param2 = puchData[4];
            tU8 param3 = puchData[5];
            tU8 param4 = puchData[6];
            tU8 param5 = puchData[7];
            tU8 param6 = puchData[8];
            tU8 param7 = puchData[9];
            tU8 param8 = puchData[10];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETLOCALTIMEDATE_MINUTEUPDATE: user specific code start
            vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
            ETG_TRACE_USR4(("property_set local TimeDate_Minute Update " ));
            vdclk_tclDateTime  oNewDateTime;
            oNewDateTime.u8Update( param1,	param2,	param3,	param4,	param5,	param6,	param7 );
            _poContainer-> vSetLocalDateTime (&oNewDateTime);
            (tVoid)param8;//To satisfy lint
            // VD_CLOCK_VD_CLOCK_VDCLK_SETLOCALTIMEDATE_MINUTEUPDATE: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_GETREGIONTIMEZONE:
        {
            // Displays the region time zone
    

            // VD_CLOCK_VD_CLOCK_VDCLK_GETREGIONTIMEZONE: user specific code start
            // VD_CLOCK_VD_CLOCK_VDCLK_GETREGIONTIMEZONE: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SETREGIONTIMEZONE:
        {
            // Sets the Region time zone
            tU8 param1 = puchData[3];
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SETREGIONTIMEZONE: user specific code start
            vdclk_tclDataContainer* _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_poMainAppInstance->getHandler("vdclk_tclDataContainer"));
            VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
            ETG_TRACE_USR4(("property_set region timezone = %d ",param1 ));
            _poContainer->vSetRegionTimeZone((VDCLK_TEN_TIMEZONE_Setting)param1);
            // VD_CLOCK_VD_CLOCK_VDCLK_SETREGIONTIMEZONE: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_HW_VERSIONINFO:
        {
            // Displays the MCAN SW/HW INFO
    

            // VD_CLOCK_VD_CLOCK_VDCLK_HW_VERSIONINFO: user specific code start
			vd_clock_INCAdapter* _poINCAdapter = dynamic_cast<vd_clock_INCAdapter*>(_poMainAppInstance->getHandler("vd_clock_INCAdapter"));

			//VD_CLOCK_NULL_POINTER_CHECK(_poINCAdapter);

			// Send message for HW version info
			tU8 u8INC_msg_buff[MAX_MSG_SIZE_COMPONENTSTATUS]= {0};
			u8INC_msg_buff[0] = 0x44; // msg id
			u8INC_msg_buff[1] = 0x01; // MCAN status
			tU8 u8DataLength = sizeof(u8INC_msg_buff);
			if(_poINCAdapter != NULL)
			{
				_poINCAdapter->sendMessage((void*)u8INC_msg_buff, (unsigned int)u8DataLength);
			}else
			{
				ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
			}
            // VD_CLOCK_VD_CLOCK_VDCLK_HW_VERSIONINFO: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_VDCLK_SW_VERSIONINFO:
        {
            // Displays the MCAN SW/HW INFO
    

            // VD_CLOCK_VD_CLOCK_VDCLK_SW_VERSIONINFO: user specific code start
			vd_clock_INCAdapter* _poINCAdapter = dynamic_cast<vd_clock_INCAdapter*>(_poMainAppInstance->getHandler("vd_clock_INCAdapter"));

			//VD_CLOCK_NULL_POINTER_CHECK(_poINCAdapter);

			// Send message for SW version info
			tU8 u8INC_msg_buff_1[MAX_MSG_SIZE_COMPONENTSTATUS]= {0};
			u8INC_msg_buff_1[0] = 0x46; // msg id
			u8INC_msg_buff_1[1] = 0x01; // MCAN status
			tU8 u8DataLength_1 = sizeof(u8INC_msg_buff_1);
			if(_poINCAdapter != NULL)
			{
				_poINCAdapter->sendMessage((void*)u8INC_msg_buff_1, (unsigned int)u8DataLength_1);
			}else
			{
				ETG_TRACE_USR4(("Error. _poINCAdapter is NULL"));
			}
            // VD_CLOCK_VD_CLOCK_VDCLK_SW_VERSIONINFO: user specific code end
            
        }
        break;
    case VD_CLOCK_VD_CLOCK_PROFILE_SIMULATION:
        {
            // 1->Simulate Prepared State.2->Simulate Profile Changed
            tU8 param1 = puchData[3];
    

            // VD_CLOCK_VD_CLOCK_PROFILE_SIMULATION: user specific code start
            ETG_TRACE_USR4(("vd_clock_AppMain_trace.cpp:: Profile Simulation with Value=%d",param1));
            profileManager* _poProfile = dynamic_cast<profileManager*>(_poMainAppInstance->getHandler("profileManager"));
            VD_CLOCK_NULL_POINTER_CHECK(_poProfile);
            if(param1 == 0x01)
            {
            	//Send Prepare trigger
            	_poProfile->HandlePrepareTrigger();
            }
            else if(param1 == 0x02)
            {
            	//Send Profile Change Trigger
            	_poProfile->HandleProfileChangeTrigger();
            }

            // VD_CLOCK_VD_CLOCK_PROFILE_SIMULATION: user specific code end
            
        }
        break;
    default:
        ETG_TRACE_USR4(("vd_clock_tclAppMain::vHandleTraceMessage(): unknown command %d.", u32MsgCode));
        break;
    }
    // vd_clock_tclAppMainFunction_vHandleTraceMessage: user specific code start
    // vd_clock_tclAppMainFunction_vHandleTraceMessage: user specific code end
    
    return;
}
// vd_clock_AppMain_trace: user specific code start
// vd_clock_AppMain_trace: user specific code end
