/*****************************************************************************
* FILE:         vd_clock_AppMain.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     applMain.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2018 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


#ifndef _VD_CLOCKMAIN_H_
#define _VD_CLOCKMAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include <string>
#include <map>
#include <set>

#include "vd_clock_AppMain_Trace.h"

// vd_clock_tclAppMainIncludes: user specific code start

#include "vd_clock_types.h"
#include "vd_clock_timezone.h"
//#include "../sources/appl/vdclock_DiagHandler.h"
#define DIAGLIB_INCLUDE_SYSTEM_SET
#include "diaglib_if.h"


// vd_clock_tclAppMainIncludes: user specific code end

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


#define VD_CLOCK_NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }

#define VD_CLOCK_NULL_POINTER_CHECK_VAL(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return 0;\
   }

// vd_clock_tclAppMainDefine: user specific code start
#define MAX_MSG_SIZE_COMPONENTSTATUS  3
#define MAX_MSG_SIZE_COMPONENTTIMEFORMAT 2
#define MAX_MSG_SIZE_MCAN_CONNECTION 50
#define MAX_MSG_SIZE_MCAN_STATUS 48
#define MAX_MSG_SIZE_MCAN_INDICATION 48

// vd_clock_tclAppMainDefine: user specific code end


#define TRACE_BUFFER_MAXSIZE  250
#define VD_CLOCKINTERNAL_MSG_LEN    4       

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class vd_clock_tclAppMain;

// vd_clock_tclAppMainForwardDecl: user specific code start
class tclSystemSetListener;
// vd_clock_tclAppMainForwardDecl: user specific code end

////////////////////////////////////////////////////////////////////////////////
// Base class for all Classes
class vd_clock_tclBaseIf
{
protected:
   const vd_clock_tclAppMain*   _cpoMain;

public:
   typedef enum {
      //internal messages
      LocalTimeDateUpdate = 0,
      AutoTimeZoneOffsetUpdate = 1,
      AvailableTimezonesUpdate = 2,
      Clock_MeterSettingsUpdate = 3,
      clocksourcestatusUpdate = 4,
      DateformatUpdate = 5,
      DaysPerMonthUpdate = 6,
      DebugMode_TimeDateUpdate = 7,
      DiagconfigUpdate = 8,
      DSTUpdate = 9,
      eDefaultSetting = 10,
      EpochUpdate = 11,
      FormatsourcestatusUpdate = 12,
      GPSAutoSyncUpdate = 13,
      LocalTimeDate_MinuteUpdateUpdate = 14,
      LocaltimeOffsetUpdate = 15,
      NewDateformatUpdate = 16,
      SyncmodeUpdate = 17,
      TimeDatefromValueUpdate = 18,
      TimeformatUpdate = 19,
      TimezoneUpdate = 20,
      UTCTimeDateUpdate = 21,
      HUDActivateStateUpdate = 22,

      // vd_clock_tclAppMainIMsgDef: user specific code start
      // vd_clock_tclAppMainIMsgDef: user specific code end

      eHeartbeat = 200,
      eCmdTraceCmdReceived,
      eCmdCsmSignalReceived,
      eCmdMCanChannelReady,
      eCmdMCanDataInd,      
      eMaxTypes
   }ECmdTypes;

   typedef struct TMsg{
      ECmdTypes  eCmd;
      tChar      strClassName[51];
      
      typedef struct {
          tU32 u32Len;
          tU8* pu8Data;
      }TDataTrailer;
      TDataTrailer tDataTrailer;
            
      union {
         tBool bData;
         tU8   u8Data;
         tS8   s8Data;
         tU16  u16Data;
         tS16  s16Data;
         tU32  u32Data;
         tS32  s32Data;
         tU8   au8Data[VD_CLOCKINTERNAL_MSG_LEN];
         typedef struct {
            tU16   u16MsgId;
            tU8    u8Opcode;
         } TMCanMsg;
         TMCanMsg tMCanMsg;

         // vd_clock_tclAppMainIMsgUnion: user specific code start
         // vd_clock_tclAppMainIMsgUnion: user specific code end
      }u;
   } TMsg;

   vd_clock_tclBaseIf(const vd_clock_tclAppMain* cpoMain):_cpoMain(cpoMain) {;} 
   virtual ~vd_clock_tclBaseIf() {_cpoMain = OSAL_NULL;} 
   virtual const tChar* getName() const = 0;
   virtual const tChar* getIfName() const = 0;

   virtual tVoid vHandleMessage(TMsg* pMsg) = 0;
   virtual tVoid vHandleTraceMessage(const tUChar* puchData) = 0;
   virtual tVoid vGetReferences() = 0;
   virtual tVoid vStartCommunication() = 0;
   virtual tVoid vTraceInfo() = 0;

   // vd_clock_tclAppMainBaseIfDecl: user specific code start
   // vd_clock_tclAppMainBaseIfDecl: user specific code end

};


class vd_clock_tclAppMain : public ahl_tclBaseOneThreadApp
{

private:
   static vd_clock_tclAppMain*   _poMainAppInstance;

public:
   static vd_clock_tclAppMain* theServer();    


   vd_clock_tclAppMain(tVoid);
   virtual ~vd_clock_tclAppMain(tVoid);

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'vd_clock_tclAppMain' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   vd_clock_tclAppMain& operator= (const vd_clock_tclAppMain &oApp);

   /**************************************************************************
   * Copy Constructor, will not be implemented.
   * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
   * 'vd_clock_tclAppMain' which has no copy constructor.
   * NOTE: This is a technique to disable the copy constructor for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   vd_clock_tclAppMain(const vd_clock_tclAppMain &oApp); 

   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadApp methods.
   **************************************************************************/
   virtual tBool bOnInit();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);   
   virtual tVoid vOnTimer(tU16 nTimerId);

   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   virtual tVoid vDispatchInternalMsg(vd_clock_tclBaseIf::TMsg* pInternalMsg);

#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostInternalMessage(vd_clock_tclBaseIf::TMsg* pInternalMsg);
#endif

   tVoid vAddObj(vd_clock_tclBaseIf* client) {
      _oObjList.insert(client);
   }

   tVoid vRemoveObj(vd_clock_tclBaseIf* client){
      if(_oObjList.find(client) != _oObjList.end()) {
         _oObjList.erase(_oObjList.find(client));
      }
   }

   tVoid vStart();
   tBool _bStartPerformed;   

   //reference handling for __ created objects
private:
   std::set<vd_clock_tclBaseIf*>  _oObjList;

public:
   tVoid vStartCommunication() const {
      std::set<vd_clock_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vStartCommunication();
      }
   }

   tVoid vGetReferences() const {
      std::set<vd_clock_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetReferences();
      }
   }

public:
   vd_clock_tclBaseIf*  getHandler(const tChar* cName) const{
      std::set<vd_clock_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (0 == OSAL_s32StringCompare((*iter)->getIfName(), cName)) {
            return (*iter);
         }
         if (0 == OSAL_s32StringCompare((*iter)->getName(), cName)) {
            return (*iter);
         }         
      }
      return NULL;
   }

   tVoid vLoadRegistry();

private:
   tVoid vTracePlugIn(tVoid);
   tVoid vTraceUnplug(tVoid);

   static tVoid vTraceCallbackFunction(const tUChar* puchData);
   static tVoid vHandleTraceMessage(const tUChar* puchData);
   static tVoid vHandleTraceMessageGen(const tUChar* puchData);

   static tUChar _auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE];

public:
#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostMsgLocalTimeDateUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgAutoTimeZoneOffsetUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgAvailableTimezonesUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgClock_MeterSettingsUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgclocksourcestatusUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgDateformatUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgDaysPerMonthUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgDebugMode_TimeDateUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgDiagconfigUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgDSTUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgDefaultSetting(const tChar* strIfName, tU32 u32DefaultSetting);
   virtual tVoid vPostMsgEpochUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgFormatsourcestatusUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgGPSAutoSyncUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgLocalTimeDate_MinuteUpdateUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgLocaltimeOffsetUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgNewDateformatUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgSyncmodeUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgTimeDatefromValueUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgTimeformatUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgTimezoneUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgUTCTimeDateUpdate(const tChar* strIfName);
   virtual tVoid vPostMsgHUDActivateStateUpdate(const tChar* strIfName);
#endif

   // vd_clock_tclAppMainDecl: user specific code start
   
   //virtual tVoid vOnNewAppState ( tU32 u32OldAppState, tU32 u32AppState );
   virtual tVoid vOnServiceState
      (
         tU16 u16ServiceId,
         tU16 u16ServerId,
         tU16 u16RegisterId,
          tU8  u8ServiceState,
         tU16 u16SubId
      );

   //static tU8 m_u8INC_msg_buff[MAX_MSG_SIZE];

   tVoid SendComponentStatusInActive_INC();
   tVoid SendComponentStatusActive_INC();
	inline tBool  bErrorIsMasked() const { return ( !_bSContActive ); }

	tBool _bSContActive;
public:
	diaglib::tclServiceDiaglib* m_poServiceDiaglib;
	  tclSystemSetListener* m_poSystemSetListener;

private:
	  tBool _bfirstupdate;
  // virtual tBool bOnAcceptNewRegister (tU16 u16ServiceId, tU16 u16ClientAppId, tU16 u16ClientSubId, tU16* pu16RegisterId);
   // vd_clock_tclAppMainDecl: user specific code end
}; 

class tclMCanClientMsgInfo
{
private:
    tBool                   _bSendingInProgress;
    tU32                    _u32TimeStampSend;
    tU32                    _u32TimeStampReceived;
    tU32                    _u32DebounceIntervall;
    tU32                    _u32TimeStampTimeout;
    tU32                    _u32TimeStampSendEnabled;
    tU32                    _u32Timeout;
    tBool                   _bContentChanged;
    tBool                   _bEnabled;
    tBool                   _bConfiured;
    tBool                   _bForce;

public:
    typedef tBool (*T_SendFunction) (tVoid*);
    typedef tVoid (*T_TimeoutFunction) (tVoid*);
    T_SendFunction      pFuncSendMsg;
    T_TimeoutFunction   pFuncTimeoutMsg;

    std::vector < tU32 > _vecStateBlockedIn;
        
    tclMCanClientMsgInfo() :
        _bSendingInProgress(FALSE),
        _u32TimeStampSend(0),
        _u32TimeStampReceived(0),
        _u32DebounceIntervall(0),
        _u32TimeStampTimeout(0),
        _u32TimeStampSendEnabled(0),
        _u32Timeout(1500),
        _bContentChanged(TRUE),
        _bEnabled(TRUE),
        _bConfiured(TRUE),
        _bForce(FALSE),
         pFuncSendMsg(NULL),
         pFuncTimeoutMsg(NULL) {};
    virtual ~tclMCanClientMsgInfo() {};

    tVoid vSetTimeout(tU32 u32Timeout) {_u32Timeout = u32Timeout;}
    tVoid vStartTimeoutDetection() {
        _bSendingInProgress   = TRUE;
        _u32TimeStampTimeout  = OSAL_ClockGetElapsedTime() + _u32Timeout;
    }
    tVoid vMsgSend() {
        _u32TimeStampSend     = OSAL_ClockGetElapsedTime();
        _bContentChanged      = FALSE;
        _u32TimeStampTimeout = _u32TimeStampSend + _u32DebounceIntervall;
        if ( (_u32DebounceIntervall != 0) && (_bForce)){
            _bContentChanged = TRUE;
        }
    }
    tVoid vMsgReceived(tBool bResetInSendingOnly = FALSE) {
        _bSendingInProgress = FALSE;
        if (!bResetInSendingOnly) _u32TimeStampReceived = OSAL_ClockGetElapsedTime();
    }
    tVoid vStartStatusSendPeriod() {
        _bEnabled = TRUE;
        _u32TimeStampSendEnabled = OSAL_ClockGetElapsedTime() + _u32Timeout;
    }

    tU32 u32GetLastSendTimestamp() {return _u32TimeStampSend;}
    tU32 u32GetLastRcvTimestamp() {return _u32TimeStampReceived;}

    tU32 u32MsgTimeout() {return _u32TimeStampTimeout;}
    tU32 u32GetMsgSendPeriodTimeout() {return _u32TimeStampSendEnabled;}

    tBool bSendingInProgress() {return _bSendingInProgress;}
    tVoid vDataChanged() {_bContentChanged = TRUE;}
    tBool bIsDataChanged() {return _bContentChanged;}
    tVoid vClearDataChanged() {_bContentChanged = FALSE;}

    tBool bIsMsgEnabled() {return _bEnabled;}
    tVoid vSetMsgEnabled(tBool bEnabled) {_bEnabled = bEnabled;}

    tBool bIsMsgConfigured() {return _bConfiured;}
    tVoid vSetMsgConfigured(tBool bConfiured) {_bConfiured = bConfiured;}

    tVoid vSetDebounceIntervall(tU32 u32Intervall) {_u32DebounceIntervall = u32Intervall;}
    tVoid vSetForceSend(tBool bForce) {_bForce = bForce;}
};
#endif // _VD_CLOCKMAIN_H_

