/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          vd_clock_ServiceClockCallbackIF.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: vd_clock
  * @Template:     serviceCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                service callback interface
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#ifndef __clock_main_fi_CALLBACKIF_H_
#define __clock_main_fi_CALLBACKIF_H_

class vd_clock_tclServiceClockCallbackIF
{
   public:
       virtual ~vd_clock_tclServiceClockCallbackIF() {};

       virtual tVoid onServiceAvailable() = 0;
       virtual tVoid onServiceUnavailable() = 0;

       virtual tBool onTimeZoneSet(tU16 u16Index, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onDaylightSavingTimeSet(clock_fi_tclDCLK_TEN_DST_Setting enDST_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onGPS_AutoSyncSet(tBool bEnabled, tBool bPositionBased, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onSyncModeSet(clock_fi_tclDCLK_TEN_SyncMode enMode, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onGPS_WeekEpochSet(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onLocalTimeOffsetSet(tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onLocalTimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onTimeFormatSet(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onDateFormatSet(clock_fi_tclDCLK_TEN_DateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onLocalTimeDate_MinuteUpdateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onRegion_TimeZoneSet(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onAuto_TimeZoneOffsetSet(tS8 s8Offset_Hour, tS8 s8Offset_Minute, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onNewDateFormatSet(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onDebugMode_TimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onHUD_ActivationSet(clock_fi_tclDCLK_TEN_HUD_ActivationSettings enHUD_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
       virtual tBool onHUD_PostitionSet(tU8 u8Up_Position, tU8 u8Down_Position, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;

       virtual tVoid onGetAvailableTimeZonesMStart() = 0;
       virtual tVoid onGetTimeDateFromValueMStart(tU32 u32TimeDateValue, tU8 u8SourceDomain, tU8 u8TargetDomain) = 0;
       virtual tVoid onGetDaysPerMonthMStart(tS16 s16Year, tU8 u8Month) = 0;
       virtual tVoid onFID_S_DIAG_CONFIGURATIONMStart(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode) = 0;
       virtual tVoid onResetHistoryMStart() = 0;
       virtual tVoid onVersionInfoMStart() = 0;
};

#endif //__clock_main_fi_CALLBACKIF_H_


