/*****************************************************************************
* FILE:         vd_clock_ServiceClock.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ServiceClock_H_
#define __vd_clock_ServiceClock_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_vd_clock_ServiceClock.h"
#include "vd_clock_AppMain.h"

// vd_clock_tclServiceClock_Include: user specific code start
#include "vd_clock_datacontainer.h"
#include "vd_clock_types.h"
// vd_clock_tclServiceClock_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class vd_clock_tclServiceClockCallbackIF;

class vd_clock_tclServiceClock : public Ivd_clock_tclServiceClock
{
protected:
   class tclMethodResultManager {
   public:

      // Constructors and destructors
      tclMethodResultManager(){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };
      ~tclMethodResultManager(){};

      tVoid vInit(tVoid){
         _bPending = 0;
         _u16SourceAppID = 0;
         _u16RegisterID = 0;
         _u16CmdCounter = 0;
         _u16FctID = 0;      
      };

      tVoid vMemorize(tBool bPending, tU16 u16SourceAppID, tU16 u16RegisterID, tU16 u16CmdCounter,  tU16 u16FctID) {
         _bPending = bPending;
         _u16SourceAppID = u16SourceAppID;
         _u16RegisterID = u16RegisterID;
         _u16CmdCounter = u16CmdCounter;
         _u16FctID = u16FctID;

      }

      tBool bIsPending(tVoid) const {return _bPending;};    
      tVoid vSetPending(tVoid) {_bPending = TRUE;};
      tVoid vSetPendingValue(tBool _bPendingValue){_bPending = _bPendingValue;};
      tVoid vClearPending(tVoid){_bPending = FALSE;};
      tBool bGetPending(tVoid) const {return _bPending;};    

      tU16 u16GetSourceAppID(tVoid) const {return _u16SourceAppID;};    
      tU16 u16GetRegisterID(tVoid) const {return _u16RegisterID;};    
      tU16 u16GetCMDCounter(tVoid) const {return _u16CmdCounter;};    
      tU16 u16GetFctID(tVoid) const {return _u16FctID;};    

   private:                    
      tBool _bPending;
      tU16 _u16SourceAppID;
      tU16 _u16RegisterID;
      tU16 _u16CmdCounter;    
      tU16 _u16FctID; 
   };

public:

   vd_clock_tclServiceClock(tVoid); 
   vd_clock_tclServiceClock(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclServiceClock();

   virtual tVoid vSetCallbackIf(vd_clock_tclServiceClockCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // vd_clock_tclServiceClockDeclarations: user specific code start
   // vd_clock_tclServiceClockDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'vd_clock_tclServiceClock' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   vd_clock_tclServiceClock& operator = (const vd_clock_tclServiceClock &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
   virtual tBool bStatusMessageFactory(tU16 u16FunctionId,
                                        amt_tclServiceData& roOutMsg,
                                        amt_tclServiceData* poInMsg);
   virtual tBool bProcessSet(amt_tclServiceData* poMessage,
                              tBool& bPropertyChanged,
                              tU16& u16Error);
public:
   virtual const tChar* getName() const { return "vd_clock_tclServiceClock"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();
   
private:
   vd_clock_tclServiceClockCallbackIF* _poCallbackIf;

public:



    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
   virtual tVoid sendTimeZoneStatus(tU16 u16Index, clock_fi_tclString szDescription);
   virtual tVoid sendDaylightSavingTimeStatus(tBool bDST_Status, tBool bDST_AutoAdjust, clock_fi_tclDCLK_TEN_DST_Setting enDST_Status);
   virtual tVoid sendGPS_AutoSyncStatus(tBool bEnabled, tBool bPositionBased);
   virtual tVoid sendSyncModeStatus(clock_fi_tclDCLK_TEN_SyncMode enMode);
   virtual tVoid sendGPS_WeekEpochStatus(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch);
   virtual tVoid sendLocalTimeOffsetStatus(tS64 s64Offset_ScalarValue, tBool bIsOffsetPostive, tS16 s16Offset_Year, tU8 u8Offset_Month, tU8 u8Offset_Day, tU8 u8Offset_Hour, tU8 u8Offset_Minute, tU8 u8Offset_Second, tU32 u32UTCTimeDate_ScalarValue, tS16 s16UTCTimeDate_Year, tU8 u8UTCTimeDate_Month, tU8 u8UTCTimeDate_Day, tU8 u8UTCTimeDate_Hour, tU8 u8UTCTimeDate_Minute, tU8 u8UTCTimeDate_Second, tU8 u8UTCTimeDate_Weekday, clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState);
   virtual tVoid sendLocalTimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue);
   virtual tVoid sendTimeFormatStatus(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat);
   virtual tVoid sendDateFormatStatus(clock_fi_tclDCLK_TEN_DateFormat enDateFormat);
   virtual tVoid sendClockSourceStatusStatus(clock_fi_tclDCLK_TEN_ClockSourceStatus enSourcesValid);
   virtual tVoid sendFormatSourceStatusStatus(clock_fi_tclDCLK_TEN_FormatSourceStatus enFormatSourceStatus);
   virtual tVoid sendLocalTimeDate_MinuteUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue);
   virtual tVoid sendRegion_TimeZoneStatus(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status, clock_fi_tclString szDescription);
   virtual tVoid sendAuto_TimeZoneOffsetStatus(tS8 s8Offset_Hour, tS8 s8Offset_Minute);
   virtual tVoid sendNewDateFormatStatus(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat);
   virtual tVoid sendConnectionStatus(clock_fi_tcl_SWC_UnitConnectionStatus SWCUnitConnectionStatus);
   virtual tVoid sendTimeZone_DSTAvailabilityStatus(tBool bTimeZone_DSTAvailabilityForRegion);
   virtual tVoid sendHardwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arHardwareVersionList);
   virtual tVoid sendSoftwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arSoftwareVersionList);
   virtual tVoid sendDebugMode_TimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode);
   virtual tVoid sendUTC_TimeDateUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bTimeValidity);
   virtual tVoid sendHUD_ActivationStatus(tBool bHUD_Status);
   virtual tVoid sendHUD_PostitionStatus(tU8 u8Up_Position, tU8 u8Down_Position);

   virtual tBool onTimeZoneSet(tU16 u16Index, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDaylightSavingTimeSet(clock_fi_tclDCLK_TEN_DST_Setting enDST_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onGPS_AutoSyncSet(tBool bEnabled, tBool bPositionBased, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onSyncModeSet(clock_fi_tclDCLK_TEN_SyncMode enMode, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onGPS_WeekEpochSet(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onLocalTimeOffsetSet(tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onLocalTimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onTimeFormatSet(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDateFormatSet(clock_fi_tclDCLK_TEN_DateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onLocalTimeDate_MinuteUpdateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onRegion_TimeZoneSet(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onAuto_TimeZoneOffsetSet(tS8 s8Offset_Hour, tS8 s8Offset_Minute, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onNewDateFormatSet(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onDebugMode_TimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onHUD_ActivationSet(clock_fi_tclDCLK_TEN_HUD_ActivationSettings enHUD_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode);
   virtual tBool onHUD_PostitionSet(tU8 u8Up_Position, tU8 u8Down_Position, tBool& bPropertyChanged, tU16& u16ErrorCode);

   virtual tVoid onGetAvailableTimeZonesMStart();
   virtual tVoid vHandleGetAvailableTimeZonesOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onGetTimeDateFromValueMStart(tU32 u32TimeDateValue, tU8 u8SourceDomain, tU8 u8TargetDomain);
   virtual tVoid vHandleGetTimeDateFromValueOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onGetDaysPerMonthMStart(tS16 s16Year, tU8 u8Month);
   virtual tVoid vHandleGetDaysPerMonthOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onFID_S_DIAG_CONFIGURATIONMStart(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode);
   virtual tVoid vHandleFID_S_DIAG_CONFIGURATIONOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onResetHistoryMStart();
   virtual tVoid vHandleResetHistoryOpMStart(amt_tclServiceData* poMessage);
   virtual tVoid onVersionInfoMStart();
   virtual tVoid vHandleVersionInfoOpMStart(amt_tclServiceData* poMessage);

   virtual tVoid sendGetAvailableTimeZonesMResult(std::vector<clock_fi_tclString, std::allocator<clock_fi_tclString> > aszDescriptions, std::vector<tU16, std::allocator<tU16> > u16Indexes);
   virtual tVoid sendGetTimeDateFromValueMResult(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday);
   virtual tVoid sendGetDaysPerMonthMResult(tU8 u8NumberOfDays);
   virtual tVoid sendFID_S_DIAG_CONFIGURATIONMResult(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode, tBool Status);
   virtual tVoid sendResetHistoryMResult();
   virtual tVoid sendVersionInfoMResult();

   virtual void vGetTimeZoneMsg(clock_mainfi_tclMsgTimeZoneStatus& oStatus) {
      oStatus.u16Index = _tTimeZone_u16Index;
      oStatus.szDescription = _tTimeZone_szDescription;
   }
   virtual void vGetDaylightSavingTimeMsg(clock_mainfi_tclMsgDaylightSavingTimeStatus& oStatus) {
      oStatus.bDST_Status = _tDaylightSavingTime_bDST_Status;
      oStatus.bDST_AutoAdjust = _tDaylightSavingTime_bDST_AutoAdjust;
      oStatus.enDST_Status = _tDaylightSavingTime_enDST_Status;
   }
   virtual void vGetGPS_AutoSyncMsg(clock_mainfi_tclMsgGPS_AutoSyncStatus& oStatus) {
      oStatus.bEnabled = _tGPS_AutoSync_bEnabled;
      oStatus.bPositionBased = _tGPS_AutoSync_bPositionBased;
   }
   virtual void vGetSyncModeMsg(clock_mainfi_tclMsgSyncModeStatus& oStatus) {
      oStatus.enMode = _tSyncMode_enMode;
   }
   virtual void vGetGPS_WeekEpochMsg(clock_mainfi_tclMsgGPS_WeekEpochStatus& oStatus) {
      oStatus.GPSepoch = _tGPS_WeekEpoch_GPSepoch;
   }
   virtual void vGetLocalTimeOffsetMsg(clock_mainfi_tclMsgLocalTimeOffsetStatus& oStatus) {
      oStatus.s64Offset_ScalarValue = _tLocalTimeOffset_s64Offset_ScalarValue;
      oStatus.bIsOffsetPostive = _tLocalTimeOffset_bIsOffsetPostive;
      oStatus.s16Offset_Year = _tLocalTimeOffset_s16Offset_Year;
      oStatus.u8Offset_Month = _tLocalTimeOffset_u8Offset_Month;
      oStatus.u8Offset_Day = _tLocalTimeOffset_u8Offset_Day;
      oStatus.u8Offset_Hour = _tLocalTimeOffset_u8Offset_Hour;
      oStatus.u8Offset_Minute = _tLocalTimeOffset_u8Offset_Minute;
      oStatus.u8Offset_Second = _tLocalTimeOffset_u8Offset_Second;
      oStatus.u32UTCTimeDate_ScalarValue = _tLocalTimeOffset_u32UTCTimeDate_ScalarValue;
      oStatus.s16UTCTimeDate_Year = _tLocalTimeOffset_s16UTCTimeDate_Year;
      oStatus.u8UTCTimeDate_Month = _tLocalTimeOffset_u8UTCTimeDate_Month;
      oStatus.u8UTCTimeDate_Day = _tLocalTimeOffset_u8UTCTimeDate_Day;
      oStatus.u8UTCTimeDate_Hour = _tLocalTimeOffset_u8UTCTimeDate_Hour;
      oStatus.u8UTCTimeDate_Minute = _tLocalTimeOffset_u8UTCTimeDate_Minute;
      oStatus.u8UTCTimeDate_Second = _tLocalTimeOffset_u8UTCTimeDate_Second;
      oStatus.u8UTCTimeDate_Weekday = _tLocalTimeOffset_u8UTCTimeDate_Weekday;
      oStatus.enGpsRtcTimeState = _tLocalTimeOffset_enGpsRtcTimeState;
   }
   virtual void vGetLocalTimeDateMsg(clock_mainfi_tclMsgLocalTimeDateStatus& oStatus) {
      oStatus.s16Year = _tLocalTimeDate_s16Year;
      oStatus.u8Month = _tLocalTimeDate_u8Month;
      oStatus.u8Day = _tLocalTimeDate_u8Day;
      oStatus.u8Hours = _tLocalTimeDate_u8Hours;
      oStatus.u8Minutes = _tLocalTimeDate_u8Minutes;
      oStatus.u8Seconds = _tLocalTimeDate_u8Seconds;
      oStatus.u8Weekday = _tLocalTimeDate_u8Weekday;
      oStatus.u8TimeDateStatus = _tLocalTimeDate_u8TimeDateStatus;
      oStatus.u32TimeDateValue = _tLocalTimeDate_u32TimeDateValue;
   }
   virtual void vGetTimeFormatMsg(clock_mainfi_tclMsgTimeFormatStatus& oStatus) {
      oStatus.enTimeFormat = _tTimeFormat_enTimeFormat;
   }
   virtual void vGetDateFormatMsg(clock_mainfi_tclMsgDateFormatStatus& oStatus) {
      oStatus.enDateFormat = _tDateFormat_enDateFormat;
   }
   virtual void vGetClockSourceStatusMsg(clock_mainfi_tclMsgClockSourceStatusStatus& oStatus) {
      oStatus.enSourcesValid = _tClockSourceStatus_enSourcesValid;
   }
   virtual void vGetFormatSourceStatusMsg(clock_mainfi_tclMsgFormatSourceStatusStatus& oStatus) {
      oStatus.enFormatSourceStatus = _tFormatSourceStatus_enFormatSourceStatus;
   }
   virtual void vGetLocalTimeDate_MinuteUpdateMsg(clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& oStatus) {
      oStatus.s16Year = _tLocalTimeDate_MinuteUpdate_s16Year;
      oStatus.u8Month = _tLocalTimeDate_MinuteUpdate_u8Month;
      oStatus.u8Day = _tLocalTimeDate_MinuteUpdate_u8Day;
      oStatus.u8Hours = _tLocalTimeDate_MinuteUpdate_u8Hours;
      oStatus.u8Minutes = _tLocalTimeDate_MinuteUpdate_u8Minutes;
      oStatus.u8Seconds = _tLocalTimeDate_MinuteUpdate_u8Seconds;
      oStatus.u8Weekday = _tLocalTimeDate_MinuteUpdate_u8Weekday;
      oStatus.u8TimeDateStatus = _tLocalTimeDate_MinuteUpdate_u8TimeDateStatus;
      oStatus.u32TimeDateValue = _tLocalTimeDate_MinuteUpdate_u32TimeDateValue;
   }
   virtual void vGetRegion_TimeZoneMsg(clock_mainfi_tclMsgRegion_TimeZoneStatus& oStatus) {
      oStatus.enTIMEZONE_Status = _tRegion_TimeZone_enTIMEZONE_Status;
      oStatus.szDescription = _tRegion_TimeZone_szDescription;
   }
   virtual void vGetAuto_TimeZoneOffsetMsg(clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& oStatus) {
      oStatus.s8Offset_Hour = _tAuto_TimeZoneOffset_s8Offset_Hour;
      oStatus.s8Offset_Minute = _tAuto_TimeZoneOffset_s8Offset_Minute;
   }
   virtual void vGetNewDateFormatMsg(clock_mainfi_tclMsgNewDateFormatStatus& oStatus) {
      oStatus.enDateFormat = _tNewDateFormat_enDateFormat;
   }
   virtual void vGetConnectionMsg(clock_mainfi_tclMsgConnectionStatus& oStatus) {
      oStatus.SWCUnitConnectionStatus = _tConnection_SWCUnitConnectionStatus;
   }
   virtual void vGetTimeZone_DSTAvailabilityMsg(clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& oStatus) {
      oStatus.bTimeZone_DSTAvailabilityForRegion = _tTimeZone_DSTAvailability_bTimeZone_DSTAvailabilityForRegion;
   }
   virtual void vGetHardwareVersionMsg(clock_mainfi_tclMsgHardwareVersionStatus& oStatus) {
      oStatus.arHardwareVersionList = _tHardwareVersion_arHardwareVersionList;
   }
   virtual void vGetSoftwareVersionMsg(clock_mainfi_tclMsgSoftwareVersionStatus& oStatus) {
      oStatus.arSoftwareVersionList = _tSoftwareVersion_arSoftwareVersionList;
   }
   virtual void vGetDebugMode_TimeDateMsg(clock_mainfi_tclMsgDebugMode_TimeDateStatus& oStatus) {
      oStatus.s16Year = _tDebugMode_TimeDate_s16Year;
      oStatus.u8Month = _tDebugMode_TimeDate_u8Month;
      oStatus.u8Day = _tDebugMode_TimeDate_u8Day;
      oStatus.u8Hours = _tDebugMode_TimeDate_u8Hours;
      oStatus.u8Minutes = _tDebugMode_TimeDate_u8Minutes;
      oStatus.u8Seconds = _tDebugMode_TimeDate_u8Seconds;
      oStatus.u8Weekday = _tDebugMode_TimeDate_u8Weekday;
      oStatus.bdebugMode = _tDebugMode_TimeDate_bdebugMode;
   }
   virtual void vGetUTC_TimeDateUpdateMsg(clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& oStatus) {
      oStatus.s16Year = _tUTC_TimeDateUpdate_s16Year;
      oStatus.u8Month = _tUTC_TimeDateUpdate_u8Month;
      oStatus.u8Day = _tUTC_TimeDateUpdate_u8Day;
      oStatus.u8Hours = _tUTC_TimeDateUpdate_u8Hours;
      oStatus.u8Minutes = _tUTC_TimeDateUpdate_u8Minutes;
      oStatus.u8Seconds = _tUTC_TimeDateUpdate_u8Seconds;
      oStatus.u8Weekday = _tUTC_TimeDateUpdate_u8Weekday;
      oStatus.bTimeValidity = _tUTC_TimeDateUpdate_bTimeValidity;
   }
   virtual void vGetHUD_ActivationMsg(clock_mainfi_tclMsgHUD_ActivationStatus& oStatus) {
      oStatus.bHUD_Status = _tHUD_Activation_bHUD_Status;
   }
   virtual void vGetHUD_PostitionMsg(clock_mainfi_tclMsgHUD_PostitionStatus& oStatus) {
      oStatus.u8Up_Position = _tHUD_Postition_u8Up_Position;
      oStatus.u8Down_Position = _tHUD_Postition_u8Down_Position;
   }
   virtual void vGetGetAvailableTimeZonesMsg(clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }
   virtual void vGetGetTimeDateFromValueMsg(clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& oMethodStart) {
      oMethodStart.u32TimeDateValue = _tGetTimeDateFromValue_u32TimeDateValue;
      oMethodStart.u8SourceDomain = _tGetTimeDateFromValue_u8SourceDomain;
      oMethodStart.u8TargetDomain = _tGetTimeDateFromValue_u8TargetDomain;
   }
   virtual void vGetGetDaysPerMonthMsg(clock_mainfi_tclMsgGetDaysPerMonthMethodStart& oMethodStart) {
      oMethodStart.s16Year = _tGetDaysPerMonth_s16Year;
      oMethodStart.u8Month = _tGetDaysPerMonth_u8Month;
   }
   virtual void vGetFID_S_DIAG_CONFIGURATIONMsg(clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& oMethodStart) {
      oMethodStart.DefSetStateGroup = _tFID_S_DIAG_CONFIGURATION_DefSetStateGroup;
      oMethodStart.DefSetStateMode = _tFID_S_DIAG_CONFIGURATION_DefSetStateMode;
   }
   virtual void vGetResetHistoryMsg(clock_mainfi_tclMsgResetHistoryMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }
   virtual void vGetVersionInfoMsg(clock_mainfi_tclMsgVersionInfoMethodStart& oMethodStart) {
	   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(oMethodStart);
   }

private:
   // Add status information properties.
   tU16 _tTimeZone_u16Index;

   clock_fi_tclString _tTimeZone_szDescription;

   tBool _tDaylightSavingTime_bDST_Status;

   tBool _tDaylightSavingTime_bDST_AutoAdjust;

   clock_fi_tclDCLK_TEN_DST_Setting _tDaylightSavingTime_enDST_Status;

   tBool _tGPS_AutoSync_bEnabled;

   tBool _tGPS_AutoSync_bPositionBased;

   clock_fi_tclDCLK_TEN_SyncMode _tSyncMode_enMode;

   clock_fi_tclDCLK_TEN_GPS_EPOCH _tGPS_WeekEpoch_GPSepoch;

   tS64 _tLocalTimeOffset_s64Offset_ScalarValue;

   tBool _tLocalTimeOffset_bIsOffsetPostive;

   tS16 _tLocalTimeOffset_s16Offset_Year;

   tU8 _tLocalTimeOffset_u8Offset_Month;

   tU8 _tLocalTimeOffset_u8Offset_Day;

   tU8 _tLocalTimeOffset_u8Offset_Hour;

   tU8 _tLocalTimeOffset_u8Offset_Minute;

   tU8 _tLocalTimeOffset_u8Offset_Second;

   tU32 _tLocalTimeOffset_u32UTCTimeDate_ScalarValue;

   tS16 _tLocalTimeOffset_s16UTCTimeDate_Year;

   tU8 _tLocalTimeOffset_u8UTCTimeDate_Month;

   tU8 _tLocalTimeOffset_u8UTCTimeDate_Day;

   tU8 _tLocalTimeOffset_u8UTCTimeDate_Hour;

   tU8 _tLocalTimeOffset_u8UTCTimeDate_Minute;

   tU8 _tLocalTimeOffset_u8UTCTimeDate_Second;

   tU8 _tLocalTimeOffset_u8UTCTimeDate_Weekday;

   clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE _tLocalTimeOffset_enGpsRtcTimeState;

   tS16 _tLocalTimeDate_s16Year;

   tU8 _tLocalTimeDate_u8Month;

   tU8 _tLocalTimeDate_u8Day;

   tU8 _tLocalTimeDate_u8Hours;

   tU8 _tLocalTimeDate_u8Minutes;

   tU8 _tLocalTimeDate_u8Seconds;

   tU8 _tLocalTimeDate_u8Weekday;

   tU8 _tLocalTimeDate_u8TimeDateStatus;

   tU32 _tLocalTimeDate_u32TimeDateValue;

   clock_fi_tclDCLK_TEN_TimeFormat _tTimeFormat_enTimeFormat;

   clock_fi_tclDCLK_TEN_DateFormat _tDateFormat_enDateFormat;

   clock_fi_tclDCLK_TEN_ClockSourceStatus _tClockSourceStatus_enSourcesValid;

   clock_fi_tclDCLK_TEN_FormatSourceStatus _tFormatSourceStatus_enFormatSourceStatus;

   tS16 _tLocalTimeDate_MinuteUpdate_s16Year;

   tU8 _tLocalTimeDate_MinuteUpdate_u8Month;

   tU8 _tLocalTimeDate_MinuteUpdate_u8Day;

   tU8 _tLocalTimeDate_MinuteUpdate_u8Hours;

   tU8 _tLocalTimeDate_MinuteUpdate_u8Minutes;

   tU8 _tLocalTimeDate_MinuteUpdate_u8Seconds;

   tU8 _tLocalTimeDate_MinuteUpdate_u8Weekday;

   tU8 _tLocalTimeDate_MinuteUpdate_u8TimeDateStatus;

   tU32 _tLocalTimeDate_MinuteUpdate_u32TimeDateValue;

   clock_fi_tclDCLK_TEN_TIMEZONE_Setting _tRegion_TimeZone_enTIMEZONE_Status;

   clock_fi_tclString _tRegion_TimeZone_szDescription;

   tS8 _tAuto_TimeZoneOffset_s8Offset_Hour;

   tS8 _tAuto_TimeZoneOffset_s8Offset_Minute;

   clock_fi_tclDCLK_TEN_NewDateFormat _tNewDateFormat_enDateFormat;

   clock_fi_tcl_SWC_UnitConnectionStatus _tConnection_SWCUnitConnectionStatus;

   tBool _tTimeZone_DSTAvailability_bTimeZone_DSTAvailabilityForRegion;

   std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > _tHardwareVersion_arHardwareVersionList;

   std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > _tSoftwareVersion_arSoftwareVersionList;

   tS16 _tDebugMode_TimeDate_s16Year;

   tU8 _tDebugMode_TimeDate_u8Month;

   tU8 _tDebugMode_TimeDate_u8Day;

   tU8 _tDebugMode_TimeDate_u8Hours;

   tU8 _tDebugMode_TimeDate_u8Minutes;

   tU8 _tDebugMode_TimeDate_u8Seconds;

   tU8 _tDebugMode_TimeDate_u8Weekday;

   tBool _tDebugMode_TimeDate_bdebugMode;

   tS16 _tUTC_TimeDateUpdate_s16Year;

   tU8 _tUTC_TimeDateUpdate_u8Month;

   tU8 _tUTC_TimeDateUpdate_u8Day;

   tU8 _tUTC_TimeDateUpdate_u8Hours;

   tU8 _tUTC_TimeDateUpdate_u8Minutes;

   tU8 _tUTC_TimeDateUpdate_u8Seconds;

   tU8 _tUTC_TimeDateUpdate_u8Weekday;

   tBool _tUTC_TimeDateUpdate_bTimeValidity;

   tBool _tHUD_Activation_bHUD_Status;

   tU8 _tHUD_Postition_u8Up_Position;

   tU8 _tHUD_Postition_u8Down_Position;

   tU32 _tGetTimeDateFromValue_u32TimeDateValue;
   tU8 _tGetTimeDateFromValue_u8SourceDomain;
   tU8 _tGetTimeDateFromValue_u8TargetDomain;
   tS16 _tGetDaysPerMonth_s16Year;
   tU8 _tGetDaysPerMonth_u8Month;
   clock_fi_tcl_e8_DefSetGroups _tFID_S_DIAG_CONFIGURATION_DefSetStateGroup;
   clock_fi_tcl_e8_DefSetMode _tFID_S_DIAG_CONFIGURATION_DefSetStateMode;
   tclMethodResultManager _oMemGetAvailableTimeZones;
   tclMethodResultManager _oMemGetTimeDateFromValue;
   tclMethodResultManager _oMemGetDaysPerMonth;
   tclMethodResultManager _oMemFID_S_DIAG_CONFIGURATION;
   tclMethodResultManager _oMemResetHistory;
   tclMethodResultManager _oMemVersionInfo;
   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(vd_clock_tclServiceClock) 

// vd_clock_tclServiceClockDeclarationsPart2: user specific code start

   vdclk_tclDataContainer* _poContainer;

// vd_clock_tclServiceClockDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ServiceClock_H_


