/*****************************************************************************
* FILE:         vd_clock_ServiceClock.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ServiceHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// vd_clock_tclServiceClockIncludes: user specific code start
// vd_clock_tclServiceClockIncludes: user specific code end

#include "vd_clock_ServiceClock.h"
#include "vd_clock_ServiceClockCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_SERVER_CLOCK
#include "trcGenProj/Header/vd_clock_ServiceClock.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define CLOCK_SERVICE_ID              54
#define CLOCK_FI_MAJOR_VERSION        1
#define CLOCK_FI_MINOR_VERSION        5

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(vd_clock_tclServiceClock, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(CLOCK_MAINFI_C_U16_GETAVAILABLETIMEZONES, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleGetAvailableTimeZonesOpMStart)
   ON_MESSAGE_SVCDATA(CLOCK_MAINFI_C_U16_GETTIMEDATEFROMVALUE, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleGetTimeDateFromValueOpMStart)
   ON_MESSAGE_SVCDATA(CLOCK_MAINFI_C_U16_GETDAYSPERMONTH, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleGetDaysPerMonthOpMStart)
   ON_MESSAGE_SVCDATA(CLOCK_MAINFI_C_U16_FID_S_DIAG_CONFIGURATION, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleFID_S_DIAG_CONFIGURATIONOpMStart)
   ON_MESSAGE_SVCDATA(CLOCK_MAINFI_C_U16_RESETHISTORY, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleResetHistoryOpMStart)
   ON_MESSAGE_SVCDATA(CLOCK_MAINFI_C_U16_VERSIONINFO, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vHandleVersionInfoOpMStart)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclServiceClock::
*             vd_clock_tclServiceClock(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclServiceClock::vd_clock_tclServiceClock(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclServiceClock(poMainAppl, CLOCK_SERVICE_ID, CLOCK_FI_MAJOR_VERSION, CLOCK_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClock() entered."));
   _poCallbackIf = OSAL_NULL;

   _tTimeZone_u16Index = 0;
   _tDaylightSavingTime_bDST_Status = FALSE;
   _tDaylightSavingTime_bDST_AutoAdjust = FALSE;
   _tGPS_AutoSync_bEnabled = FALSE;
   _tGPS_AutoSync_bPositionBased = FALSE;
   _tLocalTimeOffset_bIsOffsetPostive = FALSE;
   _tLocalTimeOffset_s16Offset_Year = 0;
   _tLocalTimeOffset_u8Offset_Month = 0;
   _tLocalTimeOffset_u8Offset_Day = 0;
   _tLocalTimeOffset_u8Offset_Hour = 0;
   _tLocalTimeOffset_u8Offset_Minute = 0;
   _tLocalTimeOffset_u8Offset_Second = 0;
   _tLocalTimeOffset_u32UTCTimeDate_ScalarValue = 0;
   _tLocalTimeOffset_s16UTCTimeDate_Year = 0;
   _tLocalTimeOffset_u8UTCTimeDate_Month = 0;
   _tLocalTimeOffset_u8UTCTimeDate_Day = 0;
   _tLocalTimeOffset_u8UTCTimeDate_Hour = 0;
   _tLocalTimeOffset_u8UTCTimeDate_Minute = 0;
   _tLocalTimeOffset_u8UTCTimeDate_Second = 0;
   _tLocalTimeOffset_u8UTCTimeDate_Weekday = 0;
   _tLocalTimeDate_s16Year = 0;
   _tLocalTimeDate_u8Month = 0;
   _tLocalTimeDate_u8Day = 0;
   _tLocalTimeDate_u8Hours = 0;
   _tLocalTimeDate_u8Minutes = 0;
   _tLocalTimeDate_u8Seconds = 0;
   _tLocalTimeDate_u8Weekday = 0;
   _tLocalTimeDate_u8TimeDateStatus = 0;
   _tLocalTimeDate_u32TimeDateValue = 0;
   _tLocalTimeDate_MinuteUpdate_s16Year = 0;
   _tLocalTimeDate_MinuteUpdate_u8Month = 0;
   _tLocalTimeDate_MinuteUpdate_u8Day = 0;
   _tLocalTimeDate_MinuteUpdate_u8Hours = 0;
   _tLocalTimeDate_MinuteUpdate_u8Minutes = 0;
   _tLocalTimeDate_MinuteUpdate_u8Seconds = 0;
   _tLocalTimeDate_MinuteUpdate_u8Weekday = 0;
   _tLocalTimeDate_MinuteUpdate_u8TimeDateStatus = 0;
   _tLocalTimeDate_MinuteUpdate_u32TimeDateValue = 0;
   _tAuto_TimeZoneOffset_s8Offset_Hour = 0;
   _tAuto_TimeZoneOffset_s8Offset_Minute = 0;
   _tTimeZone_DSTAvailability_bTimeZone_DSTAvailabilityForRegion = FALSE;
   _tDebugMode_TimeDate_s16Year = 0;
   _tDebugMode_TimeDate_u8Month = 0;
   _tDebugMode_TimeDate_u8Day = 0;
   _tDebugMode_TimeDate_u8Hours = 0;
   _tDebugMode_TimeDate_u8Minutes = 0;
   _tDebugMode_TimeDate_u8Seconds = 0;
   _tDebugMode_TimeDate_u8Weekday = 0;
   _tDebugMode_TimeDate_bdebugMode = FALSE;
   _tUTC_TimeDateUpdate_s16Year = 0;
   _tUTC_TimeDateUpdate_u8Month = 0;
   _tUTC_TimeDateUpdate_u8Day = 0;
   _tUTC_TimeDateUpdate_u8Hours = 0;
   _tUTC_TimeDateUpdate_u8Minutes = 0;
   _tUTC_TimeDateUpdate_u8Seconds = 0;
   _tUTC_TimeDateUpdate_u8Weekday = 0;
   _tUTC_TimeDateUpdate_bTimeValidity = FALSE;
   _tHUD_Activation_bHUD_Status = FALSE;
   _tHUD_Postition_u8Up_Position = 0;
   _tHUD_Postition_u8Down_Position = 0;
   _tGetTimeDateFromValue_u32TimeDateValue = 0;
   _tGetTimeDateFromValue_u8SourceDomain = 0;
   _tGetTimeDateFromValue_u8TargetDomain = 0;
   _tGetDaysPerMonth_s16Year = 0;
   _tGetDaysPerMonth_u8Month = 0;

   // vd_clock_tclServiceClockConstructor: user specific code start
    _poContainer = OSAL_NULL;
    _tLocalTimeOffset_s64Offset_ScalarValue = 0;
   // vd_clock_tclServiceClockConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclServiceClock::
*             ~vd_clock_tclServiceClock(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclServiceClock::~vd_clock_tclServiceClock(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclServiceClock() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // vd_clock_tclServiceClockDestructor: user specific code start
   _poContainer = OSAL_NULL;
   // vd_clock_tclServiceClockDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClock::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ServiceClock.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     CLOCK_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClock::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClock::vGetReferences() entered."));
   // vd_clock_tclServiceClockvGetReferences: user specific code start

   _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));

   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

   // vd_clock_tclServiceClockvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClock::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClock::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClock::vStartCommunication() entered."));
   // vd_clock_tclServiceClockvStartCommunication: user specific code start
   // vd_clock_tclServiceClockvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClock::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClock::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclServiceClock::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // vd_clock_tclServiceClockvHandleMessage: user specific code start
   // vd_clock_tclServiceClockvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClock::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClock::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclServiceClock::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclServiceClockvHandleTraceMessage: user specific code start
   // vd_clock_tclServiceClockvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClock::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclServiceClock::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      TimeZone (CLOCK_MAINFI_C_U16_TIMEZONE) -> Opcode: Get, Set, UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DaylightSavingTime (CLOCK_MAINFI_C_U16_DAYLIGHTSAVINGTIME) -> Opcode: Get, Set, UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      GPS_AutoSync (CLOCK_MAINFI_C_U16_GPS_AUTOSYNC) -> Opcode: Get, Set, UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      SyncMode (CLOCK_MAINFI_C_U16_SYNCMODE) -> Opcode: Get, Set, UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      GPS_WeekEpoch (CLOCK_MAINFI_C_U16_GPS_WEEKEPOCH) -> Opcode: Get, Set, UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      LocalTimeOffset (CLOCK_MAINFI_C_U16_LOCALTIMEOFFSET) -> Opcode: UpReg, RelUpReg, Get, Status, Set, Error, "));
   ETG_TRACE_FATAL(("Property support:      LocalTimeDate (CLOCK_MAINFI_C_U16_LOCALTIMEDATE) -> Opcode: UpReg, RelUpReg, Get, Status, Set, Error, "));
   ETG_TRACE_FATAL(("Property support:      TimeFormat (CLOCK_MAINFI_C_U16_TIMEFORMAT) -> Opcode: UpReg, RelUpReg, Get, Status, Set, Error, "));
   ETG_TRACE_FATAL(("Property support:      DateFormat (CLOCK_MAINFI_C_U16_DATEFORMAT) -> Opcode: UpReg, RelUpReg, Get, Status, Set, Error, "));
   ETG_TRACE_FATAL(("Property support:      ClockSourceStatus (CLOCK_MAINFI_C_U16_CLOCKSOURCESTATUS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      FormatSourceStatus (CLOCK_MAINFI_C_U16_FORMATSOURCESTATUS) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      LocalTimeDate_MinuteUpdate (CLOCK_MAINFI_C_U16_LOCALTIMEDATE_MINUTEUPDATE) -> Opcode: UpReg, RelUpReg, Get, Status, Set, Error, "));
   ETG_TRACE_FATAL(("Property support:      Region_TimeZone (CLOCK_MAINFI_C_U16_REGION_TIMEZONE) -> Opcode: Get, Set, UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      Auto_TimeZoneOffset (CLOCK_MAINFI_C_U16_AUTO_TIMEZONEOFFSET) -> Opcode: UpReg, RelUpReg, Get, Status, Set, Error, "));
   ETG_TRACE_FATAL(("Property support:      NewDateFormat (CLOCK_MAINFI_C_U16_NEWDATEFORMAT) -> Opcode: UpReg, RelUpReg, Get, Status, Set, Error, "));
   ETG_TRACE_FATAL(("Property support:      Connection (CLOCK_MAINFI_C_U16_CONNECTION) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      TimeZone_DSTAvailability (CLOCK_MAINFI_C_U16_TIMEZONE_DSTAVAILABILITY) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      HardwareVersion (CLOCK_MAINFI_C_U16_HARDWAREVERSION) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      SoftwareVersion (CLOCK_MAINFI_C_U16_SOFTWAREVERSION) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      DebugMode_TimeDate (CLOCK_MAINFI_C_U16_DEBUGMODE_TIMEDATE) -> Opcode: UpReg, RelUpReg, Get, Status, Set, Error, "));
   ETG_TRACE_FATAL(("Property support:      UTC_TimeDateUpdate (CLOCK_MAINFI_C_U16_UTC_TIMEDATEUPDATE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      HUD_Activation (CLOCK_MAINFI_C_U16_HUD_ACTIVATION) -> Opcode: Get, Set, UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      HUD_Postition (CLOCK_MAINFI_C_U16_HUD_POSTITION) -> Opcode: UpReg, RelUpReg, Get, Status, Set, Error, "));
   ETG_TRACE_FATAL(("Method   support:      GetAvailableTimeZones (CLOCK_MAINFI_C_U16_GETAVAILABLETIMEZONES) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      GetTimeDateFromValue (CLOCK_MAINFI_C_U16_GETTIMEDATEFROMVALUE) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      GetDaysPerMonth (CLOCK_MAINFI_C_U16_GETDAYSPERMONTH) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      FID_S_DIAG_CONFIGURATION (CLOCK_MAINFI_C_U16_FID_S_DIAG_CONFIGURATION) -> Opcode: MethodStart, MethodResult, "));
   ETG_TRACE_FATAL(("Method   support:      ResetHistory (CLOCK_MAINFI_C_U16_RESETHISTORY) -> Opcode: MethodStart, MethodResult, Error, "));
   ETG_TRACE_FATAL(("Method   support:      VersionInfo (CLOCK_MAINFI_C_U16_VERSIONINFO) -> Opcode: MethodStart, MethodResult, Error, "));

   // vd_clock_tclServiceClockvTraceInfo: user specific code start
   // vd_clock_tclServiceClockvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClock::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclServiceClock::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // vd_clock_tclServiceClockvOnServiceAvailable: user specific code start
   // vd_clock_tclServiceClockvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclServiceClock::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclServiceClock::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // vd_clock_tclServiceClockvOnServiceUnavailable: user specific code start
   // vd_clock_tclServiceClockvOnServiceUnavailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tBool vd_clock_tclServiceClock
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object which is then copied to the
*              referenced parameter 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = Status message for property successfully generated.
*              FALSE = Failed to generate status message for property.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool vd_clock_tclServiceClock
::bStatusMessageFactory(tU16 u16FunctionId,
                        amt_tclServiceData& roOutMsg,
                        amt_tclServiceData* poInMsg)
{
   (tVoid)poInMsg;   // These lines are added to avoid LINT warnings. Please
   (tVoid)roOutMsg;  // remove as soon as variables are used.

   tBool bSuccess = FALSE;

   ETG_TRACE_USR4(("vd_clock_tclServiceClock:bStatusMessageFactory() entered. FID = 0x%04x.", u16FunctionId));

   switch (u16FunctionId)
   {
   case CLOCK_MAINFI_C_U16_TIMEZONE:
      {
         clock_mainfi_tclMsgTimeZoneStatus oStatus;

         oStatus.u16Index = _tTimeZone_u16Index;
         oStatus.szDescription = _tTimeZone_szDescription;

         // CaseTimeZoneStatus_Pre: user specific code start
         // CaseTimeZoneStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseTimeZoneStatus: user specific code start
         // CaseTimeZoneStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_DAYLIGHTSAVINGTIME:
      {
         clock_mainfi_tclMsgDaylightSavingTimeStatus oStatus;

         oStatus.bDST_Status = _tDaylightSavingTime_bDST_Status;
         oStatus.bDST_AutoAdjust = _tDaylightSavingTime_bDST_AutoAdjust;
         oStatus.enDST_Status = _tDaylightSavingTime_enDST_Status;

         // CaseDaylightSavingTimeStatus_Pre: user specific code start
         // CaseDaylightSavingTimeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseDaylightSavingTimeStatus: user specific code start
         // CaseDaylightSavingTimeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_GPS_AUTOSYNC:
      {
         clock_mainfi_tclMsgGPS_AutoSyncStatus oStatus;

         oStatus.bEnabled = _tGPS_AutoSync_bEnabled;
         oStatus.bPositionBased = _tGPS_AutoSync_bPositionBased;

         // CaseGPS_AutoSyncStatus_Pre: user specific code start
         // CaseGPS_AutoSyncStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseGPS_AutoSyncStatus: user specific code start
         // CaseGPS_AutoSyncStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_SYNCMODE:
      {
         clock_mainfi_tclMsgSyncModeStatus oStatus;

         oStatus.enMode = _tSyncMode_enMode;

         // CaseSyncModeStatus_Pre: user specific code start
         // CaseSyncModeStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseSyncModeStatus: user specific code start
         // CaseSyncModeStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_GPS_WEEKEPOCH:
      {
         clock_mainfi_tclMsgGPS_WeekEpochStatus oStatus;

         oStatus.GPSepoch = _tGPS_WeekEpoch_GPSepoch;

         // CaseGPS_WeekEpochStatus_Pre: user specific code start
         // CaseGPS_WeekEpochStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseGPS_WeekEpochStatus: user specific code start
         // CaseGPS_WeekEpochStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_LOCALTIMEOFFSET:
      {
         clock_mainfi_tclMsgLocalTimeOffsetStatus oStatus;

         oStatus.s64Offset_ScalarValue = _tLocalTimeOffset_s64Offset_ScalarValue;
         oStatus.bIsOffsetPostive = _tLocalTimeOffset_bIsOffsetPostive;
         oStatus.s16Offset_Year = _tLocalTimeOffset_s16Offset_Year;
         oStatus.u8Offset_Month = _tLocalTimeOffset_u8Offset_Month;
         oStatus.u8Offset_Day = _tLocalTimeOffset_u8Offset_Day;
         oStatus.u8Offset_Hour = _tLocalTimeOffset_u8Offset_Hour;
         oStatus.u8Offset_Minute = _tLocalTimeOffset_u8Offset_Minute;
         oStatus.u8Offset_Second = _tLocalTimeOffset_u8Offset_Second;
         oStatus.u32UTCTimeDate_ScalarValue = _tLocalTimeOffset_u32UTCTimeDate_ScalarValue;
         oStatus.s16UTCTimeDate_Year = _tLocalTimeOffset_s16UTCTimeDate_Year;
         oStatus.u8UTCTimeDate_Month = _tLocalTimeOffset_u8UTCTimeDate_Month;
         oStatus.u8UTCTimeDate_Day = _tLocalTimeOffset_u8UTCTimeDate_Day;
         oStatus.u8UTCTimeDate_Hour = _tLocalTimeOffset_u8UTCTimeDate_Hour;
         oStatus.u8UTCTimeDate_Minute = _tLocalTimeOffset_u8UTCTimeDate_Minute;
         oStatus.u8UTCTimeDate_Second = _tLocalTimeOffset_u8UTCTimeDate_Second;
         oStatus.u8UTCTimeDate_Weekday = _tLocalTimeOffset_u8UTCTimeDate_Weekday;
         oStatus.enGpsRtcTimeState = _tLocalTimeOffset_enGpsRtcTimeState;

         // CaseLocalTimeOffsetStatus_Pre: user specific code start
         // CaseLocalTimeOffsetStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseLocalTimeOffsetStatus: user specific code start
         // CaseLocalTimeOffsetStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_LOCALTIMEDATE:
      {
         clock_mainfi_tclMsgLocalTimeDateStatus oStatus;

         oStatus.s16Year = _tLocalTimeDate_s16Year;
         oStatus.u8Month = _tLocalTimeDate_u8Month;
         oStatus.u8Day = _tLocalTimeDate_u8Day;
         oStatus.u8Hours = _tLocalTimeDate_u8Hours;
         oStatus.u8Minutes = _tLocalTimeDate_u8Minutes;
         oStatus.u8Seconds = _tLocalTimeDate_u8Seconds;
         oStatus.u8Weekday = _tLocalTimeDate_u8Weekday;
         oStatus.u8TimeDateStatus = _tLocalTimeDate_u8TimeDateStatus;
         oStatus.u32TimeDateValue = _tLocalTimeDate_u32TimeDateValue;

         // CaseLocalTimeDateStatus_Pre: user specific code start
         // CaseLocalTimeDateStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseLocalTimeDateStatus: user specific code start
         // CaseLocalTimeDateStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_TIMEFORMAT:
      {
         clock_mainfi_tclMsgTimeFormatStatus oStatus;

         oStatus.enTimeFormat = _tTimeFormat_enTimeFormat;

         // CaseTimeFormatStatus_Pre: user specific code start
         // CaseTimeFormatStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseTimeFormatStatus: user specific code start
         // CaseTimeFormatStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_DATEFORMAT:
      {
         clock_mainfi_tclMsgDateFormatStatus oStatus;

         oStatus.enDateFormat = _tDateFormat_enDateFormat;

         // CaseDateFormatStatus_Pre: user specific code start
         // CaseDateFormatStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseDateFormatStatus: user specific code start
         // CaseDateFormatStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_CLOCKSOURCESTATUS:
      {
         clock_mainfi_tclMsgClockSourceStatusStatus oStatus;

         oStatus.enSourcesValid = _tClockSourceStatus_enSourcesValid;

         // CaseClockSourceStatusStatus_Pre: user specific code start
         // CaseClockSourceStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseClockSourceStatusStatus: user specific code start
         // CaseClockSourceStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_FORMATSOURCESTATUS:
      {
         clock_mainfi_tclMsgFormatSourceStatusStatus oStatus;

         oStatus.enFormatSourceStatus = _tFormatSourceStatus_enFormatSourceStatus;

         // CaseFormatSourceStatusStatus_Pre: user specific code start
         // CaseFormatSourceStatusStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseFormatSourceStatusStatus: user specific code start
         // CaseFormatSourceStatusStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_LOCALTIMEDATE_MINUTEUPDATE:
      {
         clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus oStatus;

         oStatus.s16Year = _tLocalTimeDate_MinuteUpdate_s16Year;
         oStatus.u8Month = _tLocalTimeDate_MinuteUpdate_u8Month;
         oStatus.u8Day = _tLocalTimeDate_MinuteUpdate_u8Day;
         oStatus.u8Hours = _tLocalTimeDate_MinuteUpdate_u8Hours;
         oStatus.u8Minutes = _tLocalTimeDate_MinuteUpdate_u8Minutes;
         oStatus.u8Seconds = _tLocalTimeDate_MinuteUpdate_u8Seconds;
         oStatus.u8Weekday = _tLocalTimeDate_MinuteUpdate_u8Weekday;
         oStatus.u8TimeDateStatus = _tLocalTimeDate_MinuteUpdate_u8TimeDateStatus;
         oStatus.u32TimeDateValue = _tLocalTimeDate_MinuteUpdate_u32TimeDateValue;

         // CaseLocalTimeDate_MinuteUpdateStatus_Pre: user specific code start
         // CaseLocalTimeDate_MinuteUpdateStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseLocalTimeDate_MinuteUpdateStatus: user specific code start
         // CaseLocalTimeDate_MinuteUpdateStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_REGION_TIMEZONE:
      {
         clock_mainfi_tclMsgRegion_TimeZoneStatus oStatus;

         oStatus.enTIMEZONE_Status = _tRegion_TimeZone_enTIMEZONE_Status;
         oStatus.szDescription = _tRegion_TimeZone_szDescription;

         // CaseRegion_TimeZoneStatus_Pre: user specific code start
         // CaseRegion_TimeZoneStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseRegion_TimeZoneStatus: user specific code start
         // CaseRegion_TimeZoneStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_AUTO_TIMEZONEOFFSET:
      {
         clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus oStatus;

         oStatus.s8Offset_Hour = _tAuto_TimeZoneOffset_s8Offset_Hour;
         oStatus.s8Offset_Minute = _tAuto_TimeZoneOffset_s8Offset_Minute;

         // CaseAuto_TimeZoneOffsetStatus_Pre: user specific code start
         // CaseAuto_TimeZoneOffsetStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseAuto_TimeZoneOffsetStatus: user specific code start
         // CaseAuto_TimeZoneOffsetStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_NEWDATEFORMAT:
      {
         clock_mainfi_tclMsgNewDateFormatStatus oStatus;

         oStatus.enDateFormat = _tNewDateFormat_enDateFormat;

         // CaseNewDateFormatStatus_Pre: user specific code start
         // CaseNewDateFormatStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseNewDateFormatStatus: user specific code start
         // CaseNewDateFormatStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_CONNECTION:
      {
         clock_mainfi_tclMsgConnectionStatus oStatus;

         oStatus.SWCUnitConnectionStatus = _tConnection_SWCUnitConnectionStatus;

         // CaseConnectionStatus_Pre: user specific code start
         // CaseConnectionStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseConnectionStatus: user specific code start
         // CaseConnectionStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_TIMEZONE_DSTAVAILABILITY:
      {
         clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus oStatus;

         oStatus.bTimeZone_DSTAvailabilityForRegion = _tTimeZone_DSTAvailability_bTimeZone_DSTAvailabilityForRegion;

         // CaseTimeZone_DSTAvailabilityStatus_Pre: user specific code start
         // CaseTimeZone_DSTAvailabilityStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseTimeZone_DSTAvailabilityStatus: user specific code start
         // CaseTimeZone_DSTAvailabilityStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_HARDWAREVERSION:
      {
         clock_mainfi_tclMsgHardwareVersionStatus oStatus;

         oStatus.arHardwareVersionList = _tHardwareVersion_arHardwareVersionList;

         // CaseHardwareVersionStatus_Pre: user specific code start
         // CaseHardwareVersionStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseHardwareVersionStatus: user specific code start
         // CaseHardwareVersionStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_SOFTWAREVERSION:
      {
         clock_mainfi_tclMsgSoftwareVersionStatus oStatus;

         oStatus.arSoftwareVersionList = _tSoftwareVersion_arSoftwareVersionList;

         // CaseSoftwareVersionStatus_Pre: user specific code start
         // CaseSoftwareVersionStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseSoftwareVersionStatus: user specific code start
         // CaseSoftwareVersionStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_DEBUGMODE_TIMEDATE:
      {
         clock_mainfi_tclMsgDebugMode_TimeDateStatus oStatus;

         oStatus.s16Year = _tDebugMode_TimeDate_s16Year;
         oStatus.u8Month = _tDebugMode_TimeDate_u8Month;
         oStatus.u8Day = _tDebugMode_TimeDate_u8Day;
         oStatus.u8Hours = _tDebugMode_TimeDate_u8Hours;
         oStatus.u8Minutes = _tDebugMode_TimeDate_u8Minutes;
         oStatus.u8Seconds = _tDebugMode_TimeDate_u8Seconds;
         oStatus.u8Weekday = _tDebugMode_TimeDate_u8Weekday;
         oStatus.bdebugMode = _tDebugMode_TimeDate_bdebugMode;

         // CaseDebugMode_TimeDateStatus_Pre: user specific code start
         // CaseDebugMode_TimeDateStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseDebugMode_TimeDateStatus: user specific code start
         // CaseDebugMode_TimeDateStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_UTC_TIMEDATEUPDATE:
      {
         clock_mainfi_tclMsgUTC_TimeDateUpdateStatus oStatus;

         oStatus.s16Year = _tUTC_TimeDateUpdate_s16Year;
         oStatus.u8Month = _tUTC_TimeDateUpdate_u8Month;
         oStatus.u8Day = _tUTC_TimeDateUpdate_u8Day;
         oStatus.u8Hours = _tUTC_TimeDateUpdate_u8Hours;
         oStatus.u8Minutes = _tUTC_TimeDateUpdate_u8Minutes;
         oStatus.u8Seconds = _tUTC_TimeDateUpdate_u8Seconds;
         oStatus.u8Weekday = _tUTC_TimeDateUpdate_u8Weekday;
         oStatus.bTimeValidity = _tUTC_TimeDateUpdate_bTimeValidity;

         // CaseUTC_TimeDateUpdateStatus_Pre: user specific code start
         // CaseUTC_TimeDateUpdateStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseUTC_TimeDateUpdateStatus: user specific code start
         // CaseUTC_TimeDateUpdateStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_HUD_ACTIVATION:
      {
         clock_mainfi_tclMsgHUD_ActivationStatus oStatus;

         oStatus.bHUD_Status = _tHUD_Activation_bHUD_Status;

         // CaseHUD_ActivationStatus_Pre: user specific code start
         // CaseHUD_ActivationStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseHUD_ActivationStatus: user specific code start
         // CaseHUD_ActivationStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_HUD_POSTITION:
      {
         clock_mainfi_tclMsgHUD_PostitionStatus oStatus;

         oStatus.u8Up_Position = _tHUD_Postition_u8Up_Position;
         oStatus.u8Down_Position = _tHUD_Postition_u8Down_Position;

         // CaseHUD_PostitionStatus_Pre: user specific code start
         // CaseHUD_PostitionStatus_Pre: user specific code end

         fi_tclVisitorMessage oVisitor(oStatus, CLOCK_FI_MAJOR_VERSION);

         // CaseHUD_PostitionStatus: user specific code start
         // CaseHUD_PostitionStatus: user specific code end

         bSuccess = oVisitor.bHandOver(&roOutMsg);

         oStatus.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Status: user specific code start
         // Case_Default_Status: user specific code end
     }
     break;
   } // switch



   if (!bSuccess)
   {
      ETG_TRACE_ERR(("bStatusMessageFactory(). Creation of message with 'FID = %u' failed.", u16FunctionId));

      NORMAL_M_ASSERT_ALWAYS();
   }

   return bSuccess;
} // bStatusMessageFactory


/*******************************************************************************
*
* FUNCTION: tBool vd_clock_tclServiceClock
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Send 'STATUS' message to the requesting client if opcode
*                     was 'SET'. Send 'STATUS' message to other registered
*                     clients as well if [OUT] parameter 'bPropertyChanged'
*                     is set to TRUE.
*              FALSE = Send an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool vd_clock_tclServiceClock
::bProcessSet(amt_tclServiceData* poMessage,
              tBool& bPropertyChanged,
              tU16& u16ErrorCode)
{
   (tVoid)bPropertyChanged;  // These lines are added to avoid LINT warnings.
   (tVoid)u16ErrorCode;      // Please remove as soon as variables are used.

   tBool bSuccess = FALSE;

   tU16 u16FunctionId = poMessage->u16GetFunctionID();

   ETG_TRACE_USR4(("vd_clock_tclServiceClock:bProcessSet() entered. FID = 0x%04x.", u16FunctionId));

   fi_tclVisitorMessage oVisitorMsg(poMessage);

   switch (u16FunctionId)
   {
   case CLOCK_MAINFI_C_U16_TIMEZONE:
      {
         clock_mainfi_tclMsgTimeZoneSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onTimeZoneSet(oSet.u16Index, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onTimeZoneSet(oSet.u16Index, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseTimeZoneSet: user specific code start
         // CaseTimeZoneSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_DAYLIGHTSAVINGTIME:
      {
         clock_mainfi_tclMsgDaylightSavingTimeSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDaylightSavingTimeSet(oSet.enDST_Setting, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onDaylightSavingTimeSet(oSet.enDST_Setting, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseDaylightSavingTimeSet: user specific code start
         // CaseDaylightSavingTimeSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_GPS_AUTOSYNC:
      {
         clock_mainfi_tclMsgGPS_AutoSyncSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onGPS_AutoSyncSet(oSet.bEnabled, oSet.bPositionBased, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onGPS_AutoSyncSet(oSet.bEnabled, oSet.bPositionBased, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseGPS_AutoSyncSet: user specific code start
         // CaseGPS_AutoSyncSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_SYNCMODE:
      {
         clock_mainfi_tclMsgSyncModeSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onSyncModeSet(oSet.enMode, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onSyncModeSet(oSet.enMode, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseSyncModeSet: user specific code start
         // CaseSyncModeSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_GPS_WEEKEPOCH:
      {
         clock_mainfi_tclMsgGPS_WeekEpochSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onGPS_WeekEpochSet(oSet.GPSepoch, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onGPS_WeekEpochSet(oSet.GPSepoch, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseGPS_WeekEpochSet: user specific code start
         // CaseGPS_WeekEpochSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_LOCALTIMEOFFSET:
      {
         clock_mainfi_tclMsgLocalTimeOffsetSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onLocalTimeOffsetSet(bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onLocalTimeOffsetSet(bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseLocalTimeOffsetSet: user specific code start
         // CaseLocalTimeOffsetSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_LOCALTIMEDATE:
      {
         clock_mainfi_tclMsgLocalTimeDateSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onLocalTimeDateSet(oSet.s16Year, oSet.u8Month, oSet.u8Day, oSet.u8Hours, oSet.u8Minutes, oSet.u8Seconds, oSet.u8Weekday, oSet.u8ChangeMask, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onLocalTimeDateSet(oSet.s16Year, oSet.u8Month, oSet.u8Day, oSet.u8Hours, oSet.u8Minutes, oSet.u8Seconds, oSet.u8Weekday, oSet.u8ChangeMask, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseLocalTimeDateSet: user specific code start
         // CaseLocalTimeDateSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_TIMEFORMAT:
      {
         clock_mainfi_tclMsgTimeFormatSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onTimeFormatSet(oSet.enTimeFormat, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onTimeFormatSet(oSet.enTimeFormat, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseTimeFormatSet: user specific code start
         // CaseTimeFormatSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_DATEFORMAT:
      {
         clock_mainfi_tclMsgDateFormatSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDateFormatSet(oSet.enDateFormat, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onDateFormatSet(oSet.enDateFormat, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseDateFormatSet: user specific code start
         // CaseDateFormatSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_LOCALTIMEDATE_MINUTEUPDATE:
      {
         clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onLocalTimeDate_MinuteUpdateSet(oSet.s16Year, oSet.u8Month, oSet.u8Day, oSet.u8Hours, oSet.u8Minutes, oSet.u8Seconds, oSet.u8Weekday, oSet.u8ChangeMask, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onLocalTimeDate_MinuteUpdateSet(oSet.s16Year, oSet.u8Month, oSet.u8Day, oSet.u8Hours, oSet.u8Minutes, oSet.u8Seconds, oSet.u8Weekday, oSet.u8ChangeMask, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseLocalTimeDate_MinuteUpdateSet: user specific code start
         // CaseLocalTimeDate_MinuteUpdateSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_REGION_TIMEZONE:
      {
         clock_mainfi_tclMsgRegion_TimeZoneSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onRegion_TimeZoneSet(oSet.enTIMEZONE_Settings, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onRegion_TimeZoneSet(oSet.enTIMEZONE_Settings, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseRegion_TimeZoneSet: user specific code start
         // CaseRegion_TimeZoneSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_AUTO_TIMEZONEOFFSET:
      {
         clock_mainfi_tclMsgAuto_TimeZoneOffsetSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onAuto_TimeZoneOffsetSet(oSet.s8Offset_Hour, oSet.s8Offset_Minute, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onAuto_TimeZoneOffsetSet(oSet.s8Offset_Hour, oSet.s8Offset_Minute, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseAuto_TimeZoneOffsetSet: user specific code start
         // CaseAuto_TimeZoneOffsetSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_NEWDATEFORMAT:
      {
         clock_mainfi_tclMsgNewDateFormatSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onNewDateFormatSet(oSet.enDateFormat, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onNewDateFormatSet(oSet.enDateFormat, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseNewDateFormatSet: user specific code start
         // CaseNewDateFormatSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_DEBUGMODE_TIMEDATE:
      {
         clock_mainfi_tclMsgDebugMode_TimeDateSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onDebugMode_TimeDateSet(oSet.s16Year, oSet.u8Month, oSet.u8Day, oSet.u8Hours, oSet.u8Minutes, oSet.u8Seconds, oSet.u8Weekday, oSet.bdebugMode, oSet.u8ChangeMask, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onDebugMode_TimeDateSet(oSet.s16Year, oSet.u8Month, oSet.u8Day, oSet.u8Hours, oSet.u8Minutes, oSet.u8Seconds, oSet.u8Weekday, oSet.bdebugMode, oSet.u8ChangeMask, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseDebugMode_TimeDateSet: user specific code start
         // CaseDebugMode_TimeDateSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_HUD_ACTIVATION:
      {
         clock_mainfi_tclMsgHUD_ActivationSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onHUD_ActivationSet(oSet.enHUD_Setting, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onHUD_ActivationSet(oSet.enHUD_Setting, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseHUD_ActivationSet: user specific code start
         // CaseHUD_ActivationSet: user specific code end

         oSet.vDestroy();
      }
      break;
   case CLOCK_MAINFI_C_U16_HUD_POSTITION:
      {
         clock_mainfi_tclMsgHUD_PostitionSet oSet;

         if (oVisitorMsg.s32GetData(oSet, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
             bSuccess = onHUD_PostitionSet(oSet.u8Up_Position, oSet.u8Down_Position, bPropertyChanged, u16ErrorCode);
             if (_poCallbackIf && _poCallbackIf->onHUD_PostitionSet(oSet.u8Up_Position, oSet.u8Down_Position, bPropertyChanged, u16ErrorCode)) {
                bSuccess = TRUE;
             }
         }
         // CaseHUD_PostitionSet: user specific code start
         // CaseHUD_PostitionSet: user specific code end

         oSet.vDestroy();
      }
      break;

   default:
      {
         // Case_Default_Set: user specific code start
         // Case_Default_Set: user specific code end
      }
      break;
   } //lint !e764: switch statement possibly does not have a case --> generated process function
   return bSuccess;
} // bProcessSet

tVoid vd_clock_tclServiceClock::sendTimeZoneStatus(tU16 u16Index, clock_fi_tclString szDescription)
{

   _tTimeZone_u16Index = u16Index;
   _tTimeZone_szDescription = szDescription;


   ETG_TRACE_USR4(("sendTimeZoneStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_TIMEZONE);
}
tVoid vd_clock_tclServiceClock::sendDaylightSavingTimeStatus(tBool bDST_Status, tBool bDST_AutoAdjust, clock_fi_tclDCLK_TEN_DST_Setting enDST_Status)
{

   _tDaylightSavingTime_bDST_Status = bDST_Status;
   _tDaylightSavingTime_bDST_AutoAdjust = bDST_AutoAdjust;
   _tDaylightSavingTime_enDST_Status = enDST_Status;


   ETG_TRACE_USR4(("sendDaylightSavingTimeStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_DAYLIGHTSAVINGTIME);
}
tVoid vd_clock_tclServiceClock::sendGPS_AutoSyncStatus(tBool bEnabled, tBool bPositionBased)
{

   _tGPS_AutoSync_bEnabled = bEnabled;
   _tGPS_AutoSync_bPositionBased = bPositionBased;


   ETG_TRACE_USR4(("sendGPS_AutoSyncStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_GPS_AUTOSYNC);
}
tVoid vd_clock_tclServiceClock::sendSyncModeStatus(clock_fi_tclDCLK_TEN_SyncMode enMode)
{

   _tSyncMode_enMode = enMode;


   ETG_TRACE_USR4(("sendSyncModeStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_SYNCMODE);
}
tVoid vd_clock_tclServiceClock::sendGPS_WeekEpochStatus(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch)
{

   _tGPS_WeekEpoch_GPSepoch = GPSepoch;


   ETG_TRACE_USR4(("sendGPS_WeekEpochStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_GPS_WEEKEPOCH);
}
tVoid vd_clock_tclServiceClock::sendLocalTimeOffsetStatus(tS64 s64Offset_ScalarValue, tBool bIsOffsetPostive, tS16 s16Offset_Year, tU8 u8Offset_Month, tU8 u8Offset_Day, tU8 u8Offset_Hour, tU8 u8Offset_Minute, tU8 u8Offset_Second, tU32 u32UTCTimeDate_ScalarValue, tS16 s16UTCTimeDate_Year, tU8 u8UTCTimeDate_Month, tU8 u8UTCTimeDate_Day, tU8 u8UTCTimeDate_Hour, tU8 u8UTCTimeDate_Minute, tU8 u8UTCTimeDate_Second, tU8 u8UTCTimeDate_Weekday, clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState)
{

   _tLocalTimeOffset_s64Offset_ScalarValue = s64Offset_ScalarValue;
   _tLocalTimeOffset_bIsOffsetPostive = bIsOffsetPostive;
   _tLocalTimeOffset_s16Offset_Year = s16Offset_Year;
   _tLocalTimeOffset_u8Offset_Month = u8Offset_Month;
   _tLocalTimeOffset_u8Offset_Day = u8Offset_Day;
   _tLocalTimeOffset_u8Offset_Hour = u8Offset_Hour;
   _tLocalTimeOffset_u8Offset_Minute = u8Offset_Minute;
   _tLocalTimeOffset_u8Offset_Second = u8Offset_Second;
   _tLocalTimeOffset_u32UTCTimeDate_ScalarValue = u32UTCTimeDate_ScalarValue;
   _tLocalTimeOffset_s16UTCTimeDate_Year = s16UTCTimeDate_Year;
   _tLocalTimeOffset_u8UTCTimeDate_Month = u8UTCTimeDate_Month;
   _tLocalTimeOffset_u8UTCTimeDate_Day = u8UTCTimeDate_Day;
   _tLocalTimeOffset_u8UTCTimeDate_Hour = u8UTCTimeDate_Hour;
   _tLocalTimeOffset_u8UTCTimeDate_Minute = u8UTCTimeDate_Minute;
   _tLocalTimeOffset_u8UTCTimeDate_Second = u8UTCTimeDate_Second;
   _tLocalTimeOffset_u8UTCTimeDate_Weekday = u8UTCTimeDate_Weekday;
   _tLocalTimeOffset_enGpsRtcTimeState = enGpsRtcTimeState;


   ETG_TRACE_USR4(("sendLocalTimeOffsetStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_LOCALTIMEOFFSET);
}
tVoid vd_clock_tclServiceClock::sendLocalTimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue)
{

   _tLocalTimeDate_s16Year = s16Year;
   _tLocalTimeDate_u8Month = u8Month;
   _tLocalTimeDate_u8Day = u8Day;
   _tLocalTimeDate_u8Hours = u8Hours;
   _tLocalTimeDate_u8Minutes = u8Minutes;
   _tLocalTimeDate_u8Seconds = u8Seconds;
   _tLocalTimeDate_u8Weekday = u8Weekday;
   _tLocalTimeDate_u8TimeDateStatus = u8TimeDateStatus;
   _tLocalTimeDate_u32TimeDateValue = u32TimeDateValue;


   ETG_TRACE_USR4(("sendLocalTimeDateStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_LOCALTIMEDATE);
}
tVoid vd_clock_tclServiceClock::sendTimeFormatStatus(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat)
{

   _tTimeFormat_enTimeFormat = enTimeFormat;


   ETG_TRACE_USR4(("sendTimeFormatStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_TIMEFORMAT);
}
tVoid vd_clock_tclServiceClock::sendDateFormatStatus(clock_fi_tclDCLK_TEN_DateFormat enDateFormat)
{

   _tDateFormat_enDateFormat = enDateFormat;


   ETG_TRACE_USR4(("sendDateFormatStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_DATEFORMAT);
}
tVoid vd_clock_tclServiceClock::sendClockSourceStatusStatus(clock_fi_tclDCLK_TEN_ClockSourceStatus enSourcesValid)
{

   _tClockSourceStatus_enSourcesValid = enSourcesValid;


   ETG_TRACE_USR4(("sendClockSourceStatusStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_CLOCKSOURCESTATUS);
}
tVoid vd_clock_tclServiceClock::sendFormatSourceStatusStatus(clock_fi_tclDCLK_TEN_FormatSourceStatus enFormatSourceStatus)
{

   _tFormatSourceStatus_enFormatSourceStatus = enFormatSourceStatus;


   ETG_TRACE_USR4(("sendFormatSourceStatusStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_FORMATSOURCESTATUS);
}
tVoid vd_clock_tclServiceClock::sendLocalTimeDate_MinuteUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue)
{

   _tLocalTimeDate_MinuteUpdate_s16Year = s16Year;
   _tLocalTimeDate_MinuteUpdate_u8Month = u8Month;
   _tLocalTimeDate_MinuteUpdate_u8Day = u8Day;
   _tLocalTimeDate_MinuteUpdate_u8Hours = u8Hours;
   _tLocalTimeDate_MinuteUpdate_u8Minutes = u8Minutes;
   _tLocalTimeDate_MinuteUpdate_u8Seconds = u8Seconds;
   _tLocalTimeDate_MinuteUpdate_u8Weekday = u8Weekday;
   _tLocalTimeDate_MinuteUpdate_u8TimeDateStatus = u8TimeDateStatus;
   _tLocalTimeDate_MinuteUpdate_u32TimeDateValue = u32TimeDateValue;


   ETG_TRACE_USR4(("sendLocalTimeDate_MinuteUpdateStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_LOCALTIMEDATE_MINUTEUPDATE);
}
tVoid vd_clock_tclServiceClock::sendRegion_TimeZoneStatus(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status, clock_fi_tclString szDescription)
{

   _tRegion_TimeZone_enTIMEZONE_Status = enTIMEZONE_Status;
   _tRegion_TimeZone_szDescription = szDescription;


   ETG_TRACE_USR4(("sendRegion_TimeZoneStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_REGION_TIMEZONE);
}
tVoid vd_clock_tclServiceClock::sendAuto_TimeZoneOffsetStatus(tS8 s8Offset_Hour, tS8 s8Offset_Minute)
{

   _tAuto_TimeZoneOffset_s8Offset_Hour = s8Offset_Hour;
   _tAuto_TimeZoneOffset_s8Offset_Minute = s8Offset_Minute;


   ETG_TRACE_USR4(("sendAuto_TimeZoneOffsetStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_AUTO_TIMEZONEOFFSET);
}
tVoid vd_clock_tclServiceClock::sendNewDateFormatStatus(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat)
{

   _tNewDateFormat_enDateFormat = enDateFormat;


   ETG_TRACE_USR4(("sendNewDateFormatStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_NEWDATEFORMAT);
}
tVoid vd_clock_tclServiceClock::sendConnectionStatus(clock_fi_tcl_SWC_UnitConnectionStatus SWCUnitConnectionStatus)
{

   _tConnection_SWCUnitConnectionStatus = SWCUnitConnectionStatus;


   ETG_TRACE_USR4(("sendConnectionStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_CONNECTION);
}
tVoid vd_clock_tclServiceClock::sendTimeZone_DSTAvailabilityStatus(tBool bTimeZone_DSTAvailabilityForRegion)
{

   _tTimeZone_DSTAvailability_bTimeZone_DSTAvailabilityForRegion = bTimeZone_DSTAvailabilityForRegion;


   ETG_TRACE_USR4(("sendTimeZone_DSTAvailabilityStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_TIMEZONE_DSTAVAILABILITY);
}
tVoid vd_clock_tclServiceClock::sendHardwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arHardwareVersionList)
{

   _tHardwareVersion_arHardwareVersionList = arHardwareVersionList;


   ETG_TRACE_USR4(("sendHardwareVersionStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_HARDWAREVERSION);
}
tVoid vd_clock_tclServiceClock::sendSoftwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arSoftwareVersionList)
{

   _tSoftwareVersion_arSoftwareVersionList = arSoftwareVersionList;


   ETG_TRACE_USR4(("sendSoftwareVersionStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_SOFTWAREVERSION);
}
tVoid vd_clock_tclServiceClock::sendDebugMode_TimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode)
{

   _tDebugMode_TimeDate_s16Year = s16Year;
   _tDebugMode_TimeDate_u8Month = u8Month;
   _tDebugMode_TimeDate_u8Day = u8Day;
   _tDebugMode_TimeDate_u8Hours = u8Hours;
   _tDebugMode_TimeDate_u8Minutes = u8Minutes;
   _tDebugMode_TimeDate_u8Seconds = u8Seconds;
   _tDebugMode_TimeDate_u8Weekday = u8Weekday;
   _tDebugMode_TimeDate_bdebugMode = bdebugMode;


   ETG_TRACE_USR4(("sendDebugMode_TimeDateStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_DEBUGMODE_TIMEDATE);
}
tVoid vd_clock_tclServiceClock::sendUTC_TimeDateUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bTimeValidity)
{

   _tUTC_TimeDateUpdate_s16Year = s16Year;
   _tUTC_TimeDateUpdate_u8Month = u8Month;
   _tUTC_TimeDateUpdate_u8Day = u8Day;
   _tUTC_TimeDateUpdate_u8Hours = u8Hours;
   _tUTC_TimeDateUpdate_u8Minutes = u8Minutes;
   _tUTC_TimeDateUpdate_u8Seconds = u8Seconds;
   _tUTC_TimeDateUpdate_u8Weekday = u8Weekday;
   _tUTC_TimeDateUpdate_bTimeValidity = bTimeValidity;


   ETG_TRACE_USR4(("sendUTC_TimeDateUpdateStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_UTC_TIMEDATEUPDATE);
}
tVoid vd_clock_tclServiceClock::sendHUD_ActivationStatus(tBool bHUD_Status)
{

   _tHUD_Activation_bHUD_Status = bHUD_Status;


   ETG_TRACE_USR4(("sendHUD_ActivationStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_HUD_ACTIVATION);
}
tVoid vd_clock_tclServiceClock::sendHUD_PostitionStatus(tU8 u8Up_Position, tU8 u8Down_Position)
{

   _tHUD_Postition_u8Up_Position = u8Up_Position;
   _tHUD_Postition_u8Down_Position = u8Down_Position;


   ETG_TRACE_USR4(("sendHUD_PostitionStatus() called."));
   eUpdateClients(CLOCK_MAINFI_C_U16_HUD_POSTITION);
}

tBool vd_clock_tclServiceClock::onTimeZoneSet(tU16 u16Index, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)u16Index;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onTimeZoneSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onTimeZoneSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onDaylightSavingTimeSet(clock_fi_tclDCLK_TEN_DST_Setting enDST_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)enDST_Setting;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDaylightSavingTimeSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onDaylightSavingTimeSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onGPS_AutoSyncSet(tBool bEnabled, tBool bPositionBased, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)bEnabled; (tVoid)bPositionBased;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onGPS_AutoSyncSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onGPS_AutoSyncSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onSyncModeSet(clock_fi_tclDCLK_TEN_SyncMode enMode, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)enMode;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onSyncModeSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onSyncModeSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onGPS_WeekEpochSet(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)GPSepoch;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onGPS_WeekEpochSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onGPS_WeekEpochSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onLocalTimeOffsetSet(tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onLocalTimeOffsetSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onLocalTimeOffsetSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onLocalTimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)s16Year; (tVoid)u8Month; (tVoid)u8Day; (tVoid)u8Hours; (tVoid)u8Minutes; (tVoid)u8Seconds; (tVoid)u8Weekday; (tVoid)u8ChangeMask;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onLocalTimeDateSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onLocalTimeDateSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onTimeFormatSet(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)enTimeFormat;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onTimeFormatSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onTimeFormatSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onDateFormatSet(clock_fi_tclDCLK_TEN_DateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)enDateFormat;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDateFormatSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onDateFormatSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onLocalTimeDate_MinuteUpdateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)s16Year; (tVoid)u8Month; (tVoid)u8Day; (tVoid)u8Hours; (tVoid)u8Minutes; (tVoid)u8Seconds; (tVoid)u8Weekday; (tVoid)u8ChangeMask;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onLocalTimeDate_MinuteUpdateSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onLocalTimeDate_MinuteUpdateSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onRegion_TimeZoneSet(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)enTIMEZONE_Settings;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onRegion_TimeZoneSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onRegion_TimeZoneSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onAuto_TimeZoneOffsetSet(tS8 s8Offset_Hour, tS8 s8Offset_Minute, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)s8Offset_Hour; (tVoid)s8Offset_Minute;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onAuto_TimeZoneOffsetSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onAuto_TimeZoneOffsetSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onNewDateFormatSet(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)enDateFormat;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onNewDateFormatSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onNewDateFormatSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onDebugMode_TimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)s16Year; (tVoid)u8Month; (tVoid)u8Day; (tVoid)u8Hours; (tVoid)u8Minutes; (tVoid)u8Seconds; (tVoid)u8Weekday; (tVoid)bdebugMode; (tVoid)u8ChangeMask;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onDebugMode_TimeDateSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onDebugMode_TimeDateSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onHUD_ActivationSet(clock_fi_tclDCLK_TEN_HUD_ActivationSettings enHUD_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)enHUD_Setting;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onHUD_ActivationSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onHUD_ActivationSet: user specific code end
   return _bResult;
}
tBool vd_clock_tclServiceClock::onHUD_PostitionSet(tU8 u8Up_Position, tU8 u8Down_Position, tBool& bPropertyChanged, tU16& u16ErrorCode) {
   tBool _bResult = FALSE;
   // lint
   (tVoid)u8Up_Position; (tVoid)u8Down_Position;
   (tVoid)bPropertyChanged; (tVoid)u16ErrorCode;
   // onHUD_PostitionSet: user specific code start
   u16ErrorCode = CCA_C_U16_ERROR_OPCODE_NOT_SUPPORTED;
   // onHUD_PostitionSet: user specific code end
   return _bResult;
}


tVoid vd_clock_tclServiceClock::vHandleGetAvailableTimeZonesOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemGetAvailableTimeZones.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onGetAvailableTimeZonesMStart();
            if (_poCallbackIf) _poCallbackIf->onGetAvailableTimeZonesMStart();
            // vHandleGetAvailableTimeZonesOpMStart: user specific code start
            // vHandleGetAvailableTimeZonesOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleGetAvailableTimeZonesOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid vd_clock_tclServiceClock::onGetAvailableTimeZonesMStart() {

   // onGetAvailableTimeZonesMStart: user specific code start
   // onGetAvailableTimeZonesMStart: user specific code end
}
tVoid vd_clock_tclServiceClock::sendGetAvailableTimeZonesMResult(std::vector<clock_fi_tclString, std::allocator<clock_fi_tclString> > aszDescriptions, std::vector<tU16, std::allocator<tU16> > u16Indexes) {
   if (_oMemGetAvailableTimeZones.bIsPending() == TRUE) {
      clock_mainfi_tclMsgGetAvailableTimeZonesMethodResult  oMResult;
      //the data content

      oMResult.aszDescriptions = aszDescriptions;
      oMResult.u16Indexes = u16Indexes;


      _oMemGetAvailableTimeZones.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemGetAvailableTimeZones.u16GetSourceAppID(), 
         _oMemGetAvailableTimeZones.u16GetRegisterID(), 
         _oMemGetAvailableTimeZones.u16GetCMDCounter(), 
         (tU16) CLOCK_MAINFI_C_U16_GETAVAILABLETIMEZONES, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendGetAvailableTimeZonesMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", CLOCK_MAINFI_C_U16_GETAVAILABLETIMEZONES, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid vd_clock_tclServiceClock::vHandleGetTimeDateFromValueOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         clock_mainfi_tclMsgGetTimeDateFromValueMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tGetTimeDateFromValue_u32TimeDateValue = oMStart.u32TimeDateValue;
            _tGetTimeDateFromValue_u8SourceDomain = oMStart.u8SourceDomain;
            _tGetTimeDateFromValue_u8TargetDomain = oMStart.u8TargetDomain;



            // Remember that we have to send an answer to this request
            _oMemGetTimeDateFromValue.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onGetTimeDateFromValueMStart(oMStart.u32TimeDateValue, oMStart.u8SourceDomain, oMStart.u8TargetDomain);
            if (_poCallbackIf) _poCallbackIf->onGetTimeDateFromValueMStart(oMStart.u32TimeDateValue, oMStart.u8SourceDomain, oMStart.u8TargetDomain);
            // vHandleGetTimeDateFromValueOpMStart: user specific code start
            // vHandleGetTimeDateFromValueOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleGetTimeDateFromValueOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid vd_clock_tclServiceClock::onGetTimeDateFromValueMStart(tU32 u32TimeDateValue, tU8 u8SourceDomain, tU8 u8TargetDomain) {

   // onGetTimeDateFromValueMStart: user specific code start
	(tVoid)u32TimeDateValue;
	(tVoid)u8SourceDomain;
	(tVoid)u8TargetDomain;
   // onGetTimeDateFromValueMStart: user specific code end
}
tVoid vd_clock_tclServiceClock::sendGetTimeDateFromValueMResult(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday) {
   if (_oMemGetTimeDateFromValue.bIsPending() == TRUE) {
      clock_mainfi_tclMsgGetTimeDateFromValueMethodResult  oMResult;
      //the data content

      oMResult.s16Year = s16Year;
      oMResult.u8Month = u8Month;
      oMResult.u8Day = u8Day;
      oMResult.u8Hours = u8Hours;
      oMResult.u8Minutes = u8Minutes;
      oMResult.u8Seconds = u8Seconds;
      oMResult.u8Weekday = u8Weekday;


      _oMemGetTimeDateFromValue.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemGetTimeDateFromValue.u16GetSourceAppID(), 
         _oMemGetTimeDateFromValue.u16GetRegisterID(), 
         _oMemGetTimeDateFromValue.u16GetCMDCounter(), 
         (tU16) CLOCK_MAINFI_C_U16_GETTIMEDATEFROMVALUE, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendGetTimeDateFromValueMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", CLOCK_MAINFI_C_U16_GETTIMEDATEFROMVALUE, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid vd_clock_tclServiceClock::vHandleGetDaysPerMonthOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         clock_mainfi_tclMsgGetDaysPerMonthMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tGetDaysPerMonth_s16Year = oMStart.s16Year;
            _tGetDaysPerMonth_u8Month = oMStart.u8Month;



            // Remember that we have to send an answer to this request
            _oMemGetDaysPerMonth.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onGetDaysPerMonthMStart(oMStart.s16Year, oMStart.u8Month);
            if (_poCallbackIf) _poCallbackIf->onGetDaysPerMonthMStart(oMStart.s16Year, oMStart.u8Month);
            // vHandleGetDaysPerMonthOpMStart: user specific code start
            // vHandleGetDaysPerMonthOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleGetDaysPerMonthOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid vd_clock_tclServiceClock::onGetDaysPerMonthMStart(tS16 s16Year, tU8 u8Month) {

   // onGetDaysPerMonthMStart: user specific code start
	(tVoid)s16Year;
	(tVoid)u8Month;
   // onGetDaysPerMonthMStart: user specific code end
}
tVoid vd_clock_tclServiceClock::sendGetDaysPerMonthMResult(tU8 u8NumberOfDays) {
   if (_oMemGetDaysPerMonth.bIsPending() == TRUE) {
      clock_mainfi_tclMsgGetDaysPerMonthMethodResult  oMResult;
      //the data content

      oMResult.u8NumberOfDays = u8NumberOfDays;


      _oMemGetDaysPerMonth.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemGetDaysPerMonth.u16GetSourceAppID(), 
         _oMemGetDaysPerMonth.u16GetRegisterID(), 
         _oMemGetDaysPerMonth.u16GetCMDCounter(), 
         (tU16) CLOCK_MAINFI_C_U16_GETDAYSPERMONTH, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendGetDaysPerMonthMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", CLOCK_MAINFI_C_U16_GETDAYSPERMONTH, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid vd_clock_tclServiceClock::vHandleFID_S_DIAG_CONFIGURATIONOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _tFID_S_DIAG_CONFIGURATION_DefSetStateGroup = oMStart.DefSetStateGroup;
            _tFID_S_DIAG_CONFIGURATION_DefSetStateMode = oMStart.DefSetStateMode;



            // Remember that we have to send an answer to this request
            _oMemFID_S_DIAG_CONFIGURATION.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onFID_S_DIAG_CONFIGURATIONMStart(oMStart.DefSetStateGroup, oMStart.DefSetStateMode);
            if (_poCallbackIf) _poCallbackIf->onFID_S_DIAG_CONFIGURATIONMStart(oMStart.DefSetStateGroup, oMStart.DefSetStateMode);
            // vHandleFID_S_DIAG_CONFIGURATIONOpMStart: user specific code start
            // vHandleFID_S_DIAG_CONFIGURATIONOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleFID_S_DIAG_CONFIGURATIONOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid vd_clock_tclServiceClock::onFID_S_DIAG_CONFIGURATIONMStart(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode) {

   // onFID_S_DIAG_CONFIGURATIONMStart: user specific code start
	(tVoid)DefSetStateGroup;
	(tVoid)DefSetStateMode;
   // onFID_S_DIAG_CONFIGURATIONMStart: user specific code end
}
tVoid vd_clock_tclServiceClock::sendFID_S_DIAG_CONFIGURATIONMResult(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode, tBool Status) {
   if (_oMemFID_S_DIAG_CONFIGURATION.bIsPending() == TRUE) {
      clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodResult  oMResult;
      //the data content

      oMResult.DefSetStateGroup = DefSetStateGroup;
      oMResult.DefSetStateMode = DefSetStateMode;
      oMResult.Status = Status;


      _oMemFID_S_DIAG_CONFIGURATION.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemFID_S_DIAG_CONFIGURATION.u16GetSourceAppID(), 
         _oMemFID_S_DIAG_CONFIGURATION.u16GetRegisterID(), 
         _oMemFID_S_DIAG_CONFIGURATION.u16GetCMDCounter(), 
         (tU16) CLOCK_MAINFI_C_U16_FID_S_DIAG_CONFIGURATION, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendFID_S_DIAG_CONFIGURATIONMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", CLOCK_MAINFI_C_U16_FID_S_DIAG_CONFIGURATION, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid vd_clock_tclServiceClock::vHandleResetHistoryOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         clock_mainfi_tclMsgResetHistoryMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemResetHistory.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onResetHistoryMStart();
            if (_poCallbackIf) _poCallbackIf->onResetHistoryMStart();
            // vHandleResetHistoryOpMStart: user specific code start
            // vHandleResetHistoryOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleResetHistoryOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid vd_clock_tclServiceClock::onResetHistoryMStart() {

   // onResetHistoryMStart: user specific code start
   // onResetHistoryMStart: user specific code end
}
tVoid vd_clock_tclServiceClock::sendResetHistoryMResult() {
   if (_oMemResetHistory.bIsPending() == TRUE) {
      clock_mainfi_tclMsgResetHistoryMethodResult  oMResult;
      //the data content



      _oMemResetHistory.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemResetHistory.u16GetSourceAppID(), 
         _oMemResetHistory.u16GetRegisterID(), 
         _oMemResetHistory.u16GetCMDCounter(), 
         (tU16) CLOCK_MAINFI_C_U16_RESETHISTORY, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendResetHistoryMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", CLOCK_MAINFI_C_U16_RESETHISTORY, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}
tVoid vd_clock_tclServiceClock::vHandleVersionInfoOpMStart(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         clock_mainfi_tclMsgVersionInfoMethodStart  oMStart;

         if (oInMsg.s32GetData(oMStart, CLOCK_FI_MAJOR_VERSION) != OSAL_ERROR) {



            // Remember that we have to send an answer to this request
            _oMemVersionInfo.vMemorize( 
               TRUE, 
               poMessage->u16GetSourceAppID(),
               poMessage->u16GetRegisterID(),
               poMessage->u16GetCmdCounter(),
               poMessage->u16GetFunctionID());

            onVersionInfoMStart();
            if (_poCallbackIf) _poCallbackIf->onVersionInfoMStart();
            // vHandleVersionInfoOpMStart: user specific code start
            // vHandleVersionInfoOpMStart: user specific code end
         } else {
            ETG_TRACE_ERR(("SPM  :: vHandleVersionInfoOpMStart: Received message is invalid!"));
         }

         oMStart.vDestroy();
      }
   }  
}

tVoid vd_clock_tclServiceClock::onVersionInfoMStart() {

   // onVersionInfoMStart: user specific code start
   // onVersionInfoMStart: user specific code end
}
tVoid vd_clock_tclServiceClock::sendVersionInfoMResult() {
   if (_oMemVersionInfo.bIsPending() == TRUE) {
      clock_mainfi_tclMsgVersionInfoMethodResult  oMResult;
      //the data content



      _oMemVersionInfo.vClearPending();

      fi_tclVisitorMessage oOutMessage(oMResult);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, 
         _oMemVersionInfo.u16GetSourceAppID(), 
         _oMemVersionInfo.u16GetRegisterID(), 
         _oMemVersionInfo.u16GetCMDCounter(), 
         (tU16) CLOCK_MAINFI_C_U16_VERSIONINFO, 
         (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);

      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "bSendVersionInfoMResult(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", CLOCK_MAINFI_C_U16_VERSIONINFO, (tU32)enResult));
      }

      // Always destroy the FI data object before leaving its creation scope
      oMResult.vDestroy();
   }
   return;
}




// vd_clock_tclServiceClockvd_clock_ServiceClock: user specific code start
// vd_clock_tclServiceClockvd_clock_ServiceClock: user specific code end

//EOF
