/*****************************************************************************
* FILE:         I_vd_clock_ServiceClock.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     I_ServiceHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef _I_vd_clock_ServiceClock_H_
#define _I_vd_clock_ServiceClock_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
//Include FI interface of used service
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_STDVISITORS
#define CLOCK_FI_S_IMPORT_INTERFACE_CLOCK_MAINFI_FUNCTIONIDS
#include "clock_fi_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

//include base class
#include "vd_clock_AppMain.h"

// Ivd_clock_tclServiceClock_Include: user specific code start
// Ivd_clock_tclServiceClock_Include: user specific code end

class vd_clock_tclServiceClockCallbackIF;

class Ivd_clock_tclServiceClock : public ahl_tclBaseOneThreadService, public vd_clock_tclBaseIf
{
public:
   Ivd_clock_tclServiceClock(vd_clock_tclAppMain* poMainAppl, tU16 u16ServiceID, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion):
      ahl_tclBaseOneThreadService(poMainAppl, u16ServiceID, u16ServiceMajorVersion, u16ServiceMinorVersion),
      vd_clock_tclBaseIf(poMainAppl) {;}
   virtual ~Ivd_clock_tclServiceClock() {;}
   virtual const tChar* getIfName() const { return "Ivd_clock_tclServiceClock"; };

   virtual tVoid vSetCallbackIf(vd_clock_tclServiceClockCallbackIF* poCallback) = 0;


   virtual tBool onTimeZoneSet(tU16 u16Index, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onDaylightSavingTimeSet(clock_fi_tclDCLK_TEN_DST_Setting enDST_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onGPS_AutoSyncSet(tBool bEnabled, tBool bPositionBased, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onSyncModeSet(clock_fi_tclDCLK_TEN_SyncMode enMode, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onGPS_WeekEpochSet(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onLocalTimeOffsetSet(tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onLocalTimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onTimeFormatSet(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onDateFormatSet(clock_fi_tclDCLK_TEN_DateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onLocalTimeDate_MinuteUpdateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onRegion_TimeZoneSet(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Settings, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onAuto_TimeZoneOffsetSet(tS8 s8Offset_Hour, tS8 s8Offset_Minute, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onNewDateFormatSet(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onDebugMode_TimeDateSet(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode, tU8 u8ChangeMask, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onHUD_ActivationSet(clock_fi_tclDCLK_TEN_HUD_ActivationSettings enHUD_Setting, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;
   virtual tBool onHUD_PostitionSet(tU8 u8Up_Position, tU8 u8Down_Position, tBool& bPropertyChanged, tU16& u16ErrorCode) = 0;

   virtual tVoid sendTimeZoneStatus(tU16 u16Index, clock_fi_tclString szDescription) = 0;
   virtual tVoid sendDaylightSavingTimeStatus(tBool bDST_Status, tBool bDST_AutoAdjust, clock_fi_tclDCLK_TEN_DST_Setting enDST_Status) = 0;
   virtual tVoid sendGPS_AutoSyncStatus(tBool bEnabled, tBool bPositionBased) = 0;
   virtual tVoid sendSyncModeStatus(clock_fi_tclDCLK_TEN_SyncMode enMode) = 0;
   virtual tVoid sendGPS_WeekEpochStatus(clock_fi_tclDCLK_TEN_GPS_EPOCH GPSepoch) = 0;
   virtual tVoid sendLocalTimeOffsetStatus(tS64 s64Offset_ScalarValue, tBool bIsOffsetPostive, tS16 s16Offset_Year, tU8 u8Offset_Month, tU8 u8Offset_Day, tU8 u8Offset_Hour, tU8 u8Offset_Minute, tU8 u8Offset_Second, tU32 u32UTCTimeDate_ScalarValue, tS16 s16UTCTimeDate_Year, tU8 u8UTCTimeDate_Month, tU8 u8UTCTimeDate_Day, tU8 u8UTCTimeDate_Hour, tU8 u8UTCTimeDate_Minute, tU8 u8UTCTimeDate_Second, tU8 u8UTCTimeDate_Weekday, clock_fi_tclDCLK_TEN_GPSRTCTIMESTATE enGpsRtcTimeState) = 0;
   virtual tVoid sendLocalTimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue) = 0;
   virtual tVoid sendTimeFormatStatus(clock_fi_tclDCLK_TEN_TimeFormat enTimeFormat) = 0;
   virtual tVoid sendDateFormatStatus(clock_fi_tclDCLK_TEN_DateFormat enDateFormat) = 0;
   virtual tVoid sendClockSourceStatusStatus(clock_fi_tclDCLK_TEN_ClockSourceStatus enSourcesValid) = 0;
   virtual tVoid sendFormatSourceStatusStatus(clock_fi_tclDCLK_TEN_FormatSourceStatus enFormatSourceStatus) = 0;
   virtual tVoid sendLocalTimeDate_MinuteUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tU8 u8TimeDateStatus, tU32 u32TimeDateValue) = 0;
   virtual tVoid sendRegion_TimeZoneStatus(clock_fi_tclDCLK_TEN_TIMEZONE_Setting enTIMEZONE_Status, clock_fi_tclString szDescription) = 0;
   virtual tVoid sendAuto_TimeZoneOffsetStatus(tS8 s8Offset_Hour, tS8 s8Offset_Minute) = 0;
   virtual tVoid sendNewDateFormatStatus(clock_fi_tclDCLK_TEN_NewDateFormat enDateFormat) = 0;
   virtual tVoid sendConnectionStatus(clock_fi_tcl_SWC_UnitConnectionStatus SWCUnitConnectionStatus) = 0;
   virtual tVoid sendTimeZone_DSTAvailabilityStatus(tBool bTimeZone_DSTAvailabilityForRegion) = 0;
   virtual tVoid sendHardwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arHardwareVersionList) = 0;
   virtual tVoid sendSoftwareVersionStatus(std::vector<clock_fi_tcl_VdClock_UnitVersion, std::allocator<clock_fi_tcl_VdClock_UnitVersion> > arSoftwareVersionList) = 0;
   virtual tVoid sendDebugMode_TimeDateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bdebugMode) = 0;
   virtual tVoid sendUTC_TimeDateUpdateStatus(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday, tBool bTimeValidity) = 0;
   virtual tVoid sendHUD_ActivationStatus(tBool bHUD_Status) = 0;
   virtual tVoid sendHUD_PostitionStatus(tU8 u8Up_Position, tU8 u8Down_Position) = 0;

   virtual tVoid sendGetAvailableTimeZonesMResult(std::vector<clock_fi_tclString, std::allocator<clock_fi_tclString> > aszDescriptions, std::vector<tU16, std::allocator<tU16> > u16Indexes) = 0;
   virtual tVoid sendGetTimeDateFromValueMResult(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hours, tU8 u8Minutes, tU8 u8Seconds, tU8 u8Weekday) = 0;
   virtual tVoid sendGetDaysPerMonthMResult(tU8 u8NumberOfDays) = 0;
   virtual tVoid sendFID_S_DIAG_CONFIGURATIONMResult(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode, tBool Status) = 0;
   virtual tVoid sendResetHistoryMResult() = 0;
   virtual tVoid sendVersionInfoMResult() = 0;

   virtual tVoid onGetAvailableTimeZonesMStart() = 0;
   virtual tVoid onGetTimeDateFromValueMStart(tU32 u32TimeDateValue, tU8 u8SourceDomain, tU8 u8TargetDomain) = 0;
   virtual tVoid onGetDaysPerMonthMStart(tS16 s16Year, tU8 u8Month) = 0;
   virtual tVoid onFID_S_DIAG_CONFIGURATIONMStart(clock_fi_tcl_e8_DefSetGroups DefSetStateGroup, clock_fi_tcl_e8_DefSetMode DefSetStateMode) = 0;
   virtual tVoid onResetHistoryMStart() = 0;
   virtual tVoid onVersionInfoMStart() = 0;

   virtual void vGetTimeZoneMsg(clock_mainfi_tclMsgTimeZoneStatus& oStatus) = 0;
   virtual void vGetDaylightSavingTimeMsg(clock_mainfi_tclMsgDaylightSavingTimeStatus& oStatus) = 0;
   virtual void vGetGPS_AutoSyncMsg(clock_mainfi_tclMsgGPS_AutoSyncStatus& oStatus) = 0;
   virtual void vGetSyncModeMsg(clock_mainfi_tclMsgSyncModeStatus& oStatus) = 0;
   virtual void vGetGPS_WeekEpochMsg(clock_mainfi_tclMsgGPS_WeekEpochStatus& oStatus) = 0;
   virtual void vGetLocalTimeOffsetMsg(clock_mainfi_tclMsgLocalTimeOffsetStatus& oStatus) = 0;
   virtual void vGetLocalTimeDateMsg(clock_mainfi_tclMsgLocalTimeDateStatus& oStatus) = 0;
   virtual void vGetTimeFormatMsg(clock_mainfi_tclMsgTimeFormatStatus& oStatus) = 0;
   virtual void vGetDateFormatMsg(clock_mainfi_tclMsgDateFormatStatus& oStatus) = 0;
   virtual void vGetClockSourceStatusMsg(clock_mainfi_tclMsgClockSourceStatusStatus& oStatus) = 0;
   virtual void vGetFormatSourceStatusMsg(clock_mainfi_tclMsgFormatSourceStatusStatus& oStatus) = 0;
   virtual void vGetLocalTimeDate_MinuteUpdateMsg(clock_mainfi_tclMsgLocalTimeDate_MinuteUpdateStatus& oStatus) = 0;
   virtual void vGetRegion_TimeZoneMsg(clock_mainfi_tclMsgRegion_TimeZoneStatus& oStatus) = 0;
   virtual void vGetAuto_TimeZoneOffsetMsg(clock_mainfi_tclMsgAuto_TimeZoneOffsetStatus& oStatus) = 0;
   virtual void vGetNewDateFormatMsg(clock_mainfi_tclMsgNewDateFormatStatus& oStatus) = 0;
   virtual void vGetConnectionMsg(clock_mainfi_tclMsgConnectionStatus& oStatus) = 0;
   virtual void vGetTimeZone_DSTAvailabilityMsg(clock_mainfi_tclMsgTimeZone_DSTAvailabilityStatus& oStatus) = 0;
   virtual void vGetHardwareVersionMsg(clock_mainfi_tclMsgHardwareVersionStatus& oStatus) = 0;
   virtual void vGetSoftwareVersionMsg(clock_mainfi_tclMsgSoftwareVersionStatus& oStatus) = 0;
   virtual void vGetDebugMode_TimeDateMsg(clock_mainfi_tclMsgDebugMode_TimeDateStatus& oStatus) = 0;
   virtual void vGetUTC_TimeDateUpdateMsg(clock_mainfi_tclMsgUTC_TimeDateUpdateStatus& oStatus) = 0;
   virtual void vGetHUD_ActivationMsg(clock_mainfi_tclMsgHUD_ActivationStatus& oStatus) = 0;
   virtual void vGetHUD_PostitionMsg(clock_mainfi_tclMsgHUD_PostitionStatus& oStatus) = 0;
   virtual void vGetGetAvailableTimeZonesMsg(clock_mainfi_tclMsgGetAvailableTimeZonesMethodStart& oMethodStart) = 0;
   virtual void vGetGetTimeDateFromValueMsg(clock_mainfi_tclMsgGetTimeDateFromValueMethodStart& oMethodStart) = 0;
   virtual void vGetGetDaysPerMonthMsg(clock_mainfi_tclMsgGetDaysPerMonthMethodStart& oMethodStart) = 0;
   virtual void vGetFID_S_DIAG_CONFIGURATIONMsg(clock_mainfi_tclMsgFID_S_DIAG_CONFIGURATIONMethodStart& oMethodStart) = 0;
   virtual void vGetResetHistoryMsg(clock_mainfi_tclMsgResetHistoryMethodStart& oMethodStart) = 0;
   virtual void vGetVersionInfoMsg(clock_mainfi_tclMsgVersionInfoMethodStart& oMethodStart) = 0;


// Ivd_clock_tclServiceClockDeclarations: user specific code start
// Ivd_clock_tclServiceClockDeclarations: user specific code end
};

#endif // _I_vd_clock_ServiceClock_H_


