

/*****************************************************************************
* FILE:         vd_clock_ClientVehicledata.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2019 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

// vd_clock_tclClientVehicledataIncludes: user specific code start
// vd_clock_tclClientVehicledataIncludes: user specific code end

#include "vd_clock_ClientVehicledata.h"
#include "vd_clock_ClientVehicledataCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_SPM
#include "trcGenProj/Header/vd_clock_ClientVehicledata.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define VEHICLEDATA_SERVICE_ID              63
#define VEHICLEDATA_FI_MAJOR_VERSION        1
#define VEHICLEDATA_FI_MINOR_VERSION        0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(vd_clock_tclClientVehicledata, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_DATEMODE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleDateModeOpStatus)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_TMMODE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleTmModeOpStatus)
   ON_MESSAGE_SVCDATA(VEHICLE_MAINFI_C_U16_TIMEDATE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleTimeDateOpStatus)
   // vd_clock_tclClientVehicledata_MsgMap: user specific code start
   // vd_clock_tclClientVehicledata_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientVehicledata::
*             vd_clock_tclClientVehicledata(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientVehicledata::vd_clock_tclClientVehicledata(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientVehicledata(poMainAppl, VEHICLEDATA_SERVICE_ID, VEHICLEDATA_FI_MAJOR_VERSION, VEHICLEDATA_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("vd_clock_tclClientVehicledata() entered."));
   _poCallbackIf = OSAL_NULL;
   _DateModeValue_DateModeStatus = 0;
   _TmModeValue_TmModeStatus = 0;
   _TimeDateValue_TimeDateStatus=0;
   // vd_clock_tclClientVehicledataConstructor: user specific code start
   ETG_TRACE_USR4(("vd_clock_tclClientVehicledata() entered."));
   // vd_clock_tclClientVehicledataConstructor: user specific code end
   vAddAutoRegisterForProperty(VEHICLE_MAINFI_C_U16_DATEMODE);
   vAddAutoRegisterForProperty(VEHICLE_MAINFI_C_U16_TMMODE);
   vAddAutoRegisterForProperty(VEHICLE_MAINFI_C_U16_TIMEDATE);
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientVehicledata::
*             ~vd_clock_tclClientVehicledata(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientVehicledata::~vd_clock_tclClientVehicledata(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientVehicledata() entered."));
   _poCallbackIf = OSAL_NULL;

   // vd_clock_tclClientVehicledataDestructor: user specific code start
   // vd_clock_tclClientVehicledataDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledata::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientVehicledata.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     VEHICLEDATA_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledata::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientVehicledata::vGetReferences() entered."));
   
   // vd_clock_tclClientVehicledatavGetReferences: user specific code start
   // vd_clock_tclClientVehicledatavGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledata::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledata::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientVehicledata::vStartCommunication() entered."));
   // vd_clock_tclClientVehicledatavStartCommunication: user specific code start
   // vd_clock_tclClientVehicledatavStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledata::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledata::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientVehicledata::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // vd_clock_tclClientVehicledatavHandleMessage: user specific code start
   // vd_clock_tclClientVehicledatavHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledata::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledata::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientVehicledata::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientVehicledatavHandleTraceMessage: user specific code start
   // vd_clock_tclClientVehicledatavHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledata::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientVehicledata::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      DateMode (VEHICLE_MAINFI_C_U16_DATEMODE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      TmMode (VEHICLE_MAINFI_C_U16_TMMODE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      TimeDate (VEHICLE_MAINFI_C_U16_TIMEDATE) -> Opcode: UpReg, RelUpReg, Get, Status, Error, "));

   // vd_clock_tclClientVehicledatavTraceInfo: user specific code start
   // vd_clock_tclClientVehicledatavTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledata::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientVehicledata::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // vd_clock_tclClientVehicledatavOnServiceAvailable: user specific code start
   // vd_clock_tclClientVehicledatavOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientVehicledata::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientVehicledata::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // vd_clock_tclClientVehicledatavOnServiceUnavailable: user specific code start
   // vd_clock_tclClientVehicledatavOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property VEHICLE_MAINFI_C_U16_DATEMODE
*******************************************************************************/

tVoid vd_clock_tclClientVehicledata::vHandleDateModeOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgDateModeStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, VEHICLEDATA_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _DateModeValue_DateModeStatus = oStatus.DateModeValue;

            ETG_TRACE_USR1(("vd_clock_tclClientVehicledata::vHandleDateModeOpStatus(): Status update message received for 'VEHICLE_MAINFI_C_U16_DATEMODE' (FID: 0x100B)!"));

            onDateModeStatus(oStatus.DateModeValue);

            // vHandleDateModeOpStatus: user specific code start
            // vHandleDateModeOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientVehicledata::vHandleDateModeOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientVehicledata::onDateModeStatus(tU8 DateModeValue) {

   if (_poCallbackIf) _poCallbackIf->onDateModeStatus(DateModeValue); 

   // onDateModeStatus: user specific code start
   // onDateModeStatus: user specific code end

}

/*******************************************************************************
* Handling of property VEHICLE_MAINFI_C_U16_TMMODE
*******************************************************************************/

tVoid vd_clock_tclClientVehicledata::vHandleTmModeOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgTmModeStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, VEHICLEDATA_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _TmModeValue_TmModeStatus = oStatus.TmModeValue;

            ETG_TRACE_USR1(("vd_clock_tclClientVehicledata::vHandleTmModeOpStatus(): Status update message received for 'VEHICLE_MAINFI_C_U16_TMMODE' (FID: 0x100C)!"));

            onTmModeStatus(oStatus.TmModeValue);

            // vHandleTmModeOpStatus: user specific code start
            // vHandleTmModeOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientVehicledata::vHandleTmModeOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientVehicledata::onTmModeStatus(tU8 TmModeValue) {

   if (_poCallbackIf) _poCallbackIf->onTmModeStatus(TmModeValue); 

   // onTmModeStatus: user specific code start
   // onTmModeStatus: user specific code end

}

/*******************************************************************************
* Handling of property VEHICLE_MAINFI_C_U16_TIMEDATE
*******************************************************************************/

tVoid vd_clock_tclClientVehicledata::vHandleTimeDateOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         vehicle_mainfi_tclMsgTimeDateStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, VEHICLEDATA_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _TimeDateValue_TimeDateStatus = oStatus.TimeDateValue;

            ETG_TRACE_USR1(("vd_clock_tclClientVehicledata::vHandleTimeDateOpStatus(): Status update message received for 'VEHICLE_MAINFI_C_U16_TIMEDATE' (FID: 0x1023)!"));

            onTimeDateStatus(oStatus.TimeDateValue);

            // vHandleTimeDateOpStatus: user specific code start
            // vHandleTimeDateOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientVehicledata::vHandleTimeDateOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientVehicledata::onTimeDateStatus(tU64 TimeDateValue) {

   if (_poCallbackIf) _poCallbackIf->onTimeDateStatus(TimeDateValue); 

   // onTimeDateStatus: user specific code start
   // onTimeDateStatus: user specific code end

}






tBool vd_clock_tclClientVehicledata::sendDateModeGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      vehicle_mainfi_tclMsgDateModeGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VEHICLE_MAINFI_C_U16_DATEMODE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientVehicledata::sendDateModeGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_DATEMODE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool vd_clock_tclClientVehicledata::sendTmModeGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      vehicle_mainfi_tclMsgTmModeGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VEHICLE_MAINFI_C_U16_TMMODE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientVehicledata::sendTmModeGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_TMMODE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool vd_clock_tclClientVehicledata::sendTimeDateGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      vehicle_mainfi_tclMsgTimeDateGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) VEHICLE_MAINFI_C_U16_TIMEDATE, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientVehicledata::sendTimeDateGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", VEHICLE_MAINFI_C_U16_TIMEDATE, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// vd_clock_tclClientVehicledatavd_clock_ClientVehicledata: user specific code start
// vd_clock_tclClientVehicledatavd_clock_ClientVehicledata: user specific code end

//EOF
