

/*****************************************************************************
* FILE:         vd_clock_ClientSensor_pv.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientSensor_pvIncludes: user specific code start
// vd_clock_tclClientSensor_pvIncludes: user specific code end

#include "vd_clock_ClientSensor_pv.h"
#include "vd_clock_ClientSensor_pvCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_SENSOR_PV
#include "trcGenProj/Header/vd_clock_ClientSensor_pv.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define SENSOR_PV_SERVICE_ID              195
#define SENSOR_PV_FI_MAJOR_VERSION        1
#define SENSOR_PV_FI_MINOR_VERSION        1

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(vd_clock_tclClientSensor_pv, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(SENSOR_PVFI_C_U16_POSITION, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandlepositionOpStatus)
   // vd_clock_tclClientSensor_pv_MsgMap: user specific code start
   // vd_clock_tclClientSensor_pv_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSensor_pv::
*             vd_clock_tclClientSensor_pv(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSensor_pv::vd_clock_tclClientSensor_pv(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientSensor_pv(poMainAppl, SENSOR_PV_SERVICE_ID, SENSOR_PV_FI_MAJOR_VERSION, SENSOR_PV_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pv() entered."));
   _poCallbackIf = OSAL_NULL;
   
   // vd_clock_tclClientSensor_pvConstructor: user specific code start
   _posLatitude_positionStatus = 0;		//Coverity Fix
   _posLongitude_positionStatus = 0;	//Coverity Fix
   // vd_clock_tclClientSensor_pvConstructor: user specific code end
   vAddAutoRegisterForProperty(SENSOR_PVFI_C_U16_POSITION);
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSensor_pv::
*             ~vd_clock_tclClientSensor_pv(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSensor_pv::~vd_clock_tclClientSensor_pv(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientSensor_pv() entered."));
   _poCallbackIf = OSAL_NULL;

   // vd_clock_tclClientSensor_pvDestructor: user specific code start
   // vd_clock_tclClientSensor_pvDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pv::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientSensor_pv.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     SENSOR_PV_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pv::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pv::vGetReferences() entered."));
   
   // vd_clock_tclClientSensor_pvvGetReferences: user specific code start
   // vd_clock_tclClientSensor_pvvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pv::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pv::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pv::vStartCommunication() entered."));
   // vd_clock_tclClientSensor_pvvStartCommunication: user specific code start
   // vd_clock_tclClientSensor_pvvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pv::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pv::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pv::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // vd_clock_tclClientSensor_pvvHandleMessage: user specific code start
   // vd_clock_tclClientSensor_pvvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pv::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pv::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pv::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientSensor_pvvHandleTraceMessage: user specific code start
   // vd_clock_tclClientSensor_pvvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pv::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pv::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      position (SENSOR_PVFI_C_U16_POSITION) -> Opcode: Get, UpReg, RelUpReg, Status, "));

   // vd_clock_tclClientSensor_pvvTraceInfo: user specific code start
   // vd_clock_tclClientSensor_pvvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pv::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pv::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // vd_clock_tclClientSensor_pvvOnServiceAvailable: user specific code start
   // vd_clock_tclClientSensor_pvvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pv::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pv::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // vd_clock_tclClientSensor_pvvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientSensor_pvvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property SENSOR_PVFI_C_U16_POSITION
*******************************************************************************/

tVoid vd_clock_tclClientSensor_pv::vHandlepositionOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         sensor_pvfi_tclMsgpositionStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, SENSOR_PV_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _posLatitude_positionStatus = oStatus.posLatitude;
            _posLongitude_positionStatus = oStatus.posLongitude;
            _posSource_positionStatus = oStatus.posSource;
            _countryCode_positionStatus = oStatus.countryCode;
            _countryCodeSource_positionStatus = oStatus.countryCodeSource;
            _timeZone_positionStatus = oStatus.timeZone;
            _timeZoneSource_positionStatus = oStatus.timeZoneSource;

            ETG_TRACE_USR1(("vd_clock_tclClientSensor_pv::vHandlepositionOpStatus(): Status update message received for 'SENSOR_PVFI_C_U16_POSITION' (FID: 0x01)!"));

            onpositionStatus(oStatus.posLatitude, oStatus.posLongitude, oStatus.posSource, oStatus.countryCode, oStatus.countryCodeSource, oStatus.timeZone, oStatus.timeZoneSource);

            // vHandlepositionOpStatus: user specific code start
            // vHandlepositionOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientSensor_pv::vHandlepositionOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientSensor_pv::onpositionStatus(tF64 posLatitude, tF64 posLongitude, sensor_fi_tcl_e8_position_source posSource, sensor_fi_tcl_e16_pv_ISOCountryCode countryCode, sensor_fi_tcl_e8_countrycode_source countryCodeSource, sensor_fi_tcl_pv_TimeZone timeZone, sensor_fi_tcl_e8_timezone_source timeZoneSource) {

   if (_poCallbackIf) _poCallbackIf->onpositionStatus(posLatitude, posLongitude, posSource, countryCode, countryCodeSource, timeZone, timeZoneSource); 

   // onpositionStatus: user specific code start
   // onpositionStatus: user specific code end

}






tBool vd_clock_tclClientSensor_pv::sendpositionGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      sensor_pvfi_tclMsgpositionGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) SENSOR_PVFI_C_U16_POSITION, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientSensor_pv::sendpositionGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", SENSOR_PVFI_C_U16_POSITION, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// vd_clock_tclClientSensor_pvvd_clock_ClientSensor_pv: user specific code start
// vd_clock_tclClientSensor_pvvd_clock_ClientSensor_pv: user specific code end

//EOF
