/*****************************************************************************
* FILE:         vd_clock_ClientPos.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ClientPos_H_
#define __vd_clock_ClientPos_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ivd_clock_ClientPos.h"
#include "vd_clock_AppMain.h"

// vd_clock_tclClientPos_Include: user specific code start
// vd_clock_tclClientPos_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class vd_clock_tclClientPosCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class vd_clock_tclClientPos : public Ivd_clock_tclClientPos
{

public:
   virtual const tChar* getName() const { return "vd_clock_tclClientPos"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   vd_clock_tclClientPos(tVoid); 
   vd_clock_tclClientPos(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientPos();

   virtual tVoid vSetCallbackIf(vd_clock_tclClientPosCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // vd_clock_tclClientPosDeclarations: user specific code start
   // vd_clock_tclClientPosDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'vd_clock_tclClientPos' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   vd_clock_tclClientPos& operator = (const vd_clock_tclClientPos &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   vd_clock_tclClientPosCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tBool sendPositionGet();
   virtual tVoid getPositionStatus(fi_tcl_PositionHeadingSpeed& rPositionElementBlock, fi_tcl_e8_PositionCalculationState& rPositionStatus, fi_tcl_PosixExactTime& rSensorPosixTime, fi_tcl_s32_Meter& rHeight, fi_tcl_s16_Degree& rInclination, fi_tcl_s16_CentimeterSecond& rAcceleration) {
      rPositionElementBlock = _PositionElementBlock_PositionStatus;
      rPositionStatus       = _PositionStatus_PositionStatus;
      rSensorPosixTime      = _SensorPosixTime_PositionStatus;
      rHeight               = _Height_PositionStatus;
      rInclination          = _Inclination_PositionStatus;
      rAcceleration         = _Acceleration_PositionStatus;
   }

   virtual tBool sendPositionInfoGet();
   virtual tVoid getPositionInfoStatus(fi_tcl_RoadAttributes& rRoadAttributes, fi_tcl_PositionWGS84& rPositionCoord, fi_tcl_u8_DirectionAbsolute& rCourse, tBool& rIsEntryPoint, fi_tcl_PosixExactTime& rSensorPosixTime, std::vector<fi_tcl_SingleRoadInfo, std::allocator<fi_tcl_SingleRoadInfo> >& rPositionInfo) {
      rRoadAttributes       = _RoadAttributes_PositionInfoStatus;
      rPositionCoord        = _PositionCoord_PositionInfoStatus;
      rCourse               = _Course_PositionInfoStatus;
      rIsEntryPoint         = _IsEntryPoint_PositionInfoStatus;
      rSensorPosixTime      = _SensorPosixTime_PositionInfoStatus;
      rPositionInfo         = _PositionInfo_PositionInfoStatus;
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandlePositionOpStatus(amt_tclServiceData* poMessage);
   virtual tVoid vHandlePositionInfoOpStatus(amt_tclServiceData* poMessage);


   virtual tVoid onPositionStatus(fi_tcl_PositionHeadingSpeed PositionElementBlock, fi_tcl_e8_PositionCalculationState PositionStatus, fi_tcl_PosixExactTime SensorPosixTime, fi_tcl_s32_Meter Height, fi_tcl_s16_Degree Inclination, fi_tcl_s16_CentimeterSecond Acceleration);
   virtual tVoid onPositionInfoStatus(fi_tcl_RoadAttributes RoadAttributes, fi_tcl_PositionWGS84 PositionCoord, fi_tcl_u8_DirectionAbsolute Course, tBool IsEntryPoint, fi_tcl_PosixExactTime SensorPosixTime, std::vector<fi_tcl_SingleRoadInfo, std::allocator<fi_tcl_SingleRoadInfo> > PositionInfo);


private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   fi_tcl_PositionHeadingSpeed              _PositionElementBlock_PositionStatus;
   fi_tcl_e8_PositionCalculationState       _PositionStatus_PositionStatus;
   fi_tcl_PosixExactTime                    _SensorPosixTime_PositionStatus;
   fi_tcl_s32_Meter                         _Height_PositionStatus;
   fi_tcl_s16_Degree                        _Inclination_PositionStatus;
   fi_tcl_s16_CentimeterSecond              _Acceleration_PositionStatus;
   fi_tcl_RoadAttributes                    _RoadAttributes_PositionInfoStatus;
   fi_tcl_PositionWGS84                     _PositionCoord_PositionInfoStatus;
   fi_tcl_u8_DirectionAbsolute              _Course_PositionInfoStatus;
   tBool                                    _IsEntryPoint_PositionInfoStatus;
   fi_tcl_PosixExactTime                    _SensorPosixTime_PositionInfoStatus;
   std::vector<fi_tcl_SingleRoadInfo, std::allocator<fi_tcl_SingleRoadInfo> > _PositionInfo_PositionInfoStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(vd_clock_tclClientPos) 

// vd_clock_tclClientPosDeclarationsPart2: user specific code start
// vd_clock_tclClientPosDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientPos_H_


