

/*****************************************************************************
* FILE:         vd_clock_ClientPos.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientPosIncludes: user specific code start
// vd_clock_tclClientPosIncludes: user specific code end

#include "vd_clock_ClientPos.h"
#include "vd_clock_ClientPosCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_POS
#include "trcGenProj/Header/vd_clock_ClientPos.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define POS_SERVICE_ID              30
#define POS_FI_MAJOR_VERSION        37
#define POS_FI_MINOR_VERSION        1

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(vd_clock_tclClientPos, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(POSFI_C_U16_POSITION, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandlePositionOpStatus)
   ON_MESSAGE_SVCDATA(POSFI_C_U16_POSITIONINFO, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandlePositionInfoOpStatus)
   // vd_clock_tclClientPos_MsgMap: user specific code start
   // vd_clock_tclClientPos_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientPos::
*             vd_clock_tclClientPos(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientPos::vd_clock_tclClientPos(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientPos(poMainAppl, POS_SERVICE_ID, POS_FI_MAJOR_VERSION, POS_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("vd_clock_tclClientPos() entered."));
   _poCallbackIf = OSAL_NULL;
   _IsEntryPoint_PositionInfoStatus = FALSE;
   
   // vd_clock_tclClientPosConstructor: user specific code start
   // vd_clock_tclClientPosConstructor: user specific code end
   vAddAutoRegisterForProperty(POSFI_C_U16_POSITION);
   vAddAutoRegisterForProperty(POSFI_C_U16_POSITIONINFO);
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientPos::
*             ~vd_clock_tclClientPos(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientPos::~vd_clock_tclClientPos(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientPos() entered."));
   _poCallbackIf = OSAL_NULL;

   // vd_clock_tclClientPosDestructor: user specific code start
   // vd_clock_tclClientPosDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPos::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientPos.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     POS_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPos::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientPos::vGetReferences() entered."));
   
   // vd_clock_tclClientPosvGetReferences: user specific code start
   // vd_clock_tclClientPosvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPos::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPos::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientPos::vStartCommunication() entered."));
   // vd_clock_tclClientPosvStartCommunication: user specific code start
   // vd_clock_tclClientPosvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPos::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPos::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientPos::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // vd_clock_tclClientPosvHandleMessage: user specific code start
   // vd_clock_tclClientPosvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPos::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPos::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientPos::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientPosvHandleTraceMessage: user specific code start
   // vd_clock_tclClientPosvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPos::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientPos::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      Position (POSFI_C_U16_POSITION) -> Opcode: Get, UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Property support:      PositionInfo (POSFI_C_U16_POSITIONINFO) -> Opcode: Get, UpReg, RelUpReg, Status, Error, "));

   // vd_clock_tclClientPosvTraceInfo: user specific code start
   // vd_clock_tclClientPosvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPos::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientPos::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // vd_clock_tclClientPosvOnServiceAvailable: user specific code start
   // vd_clock_tclClientPosvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientPos::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientPos::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // vd_clock_tclClientPosvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientPosvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property POSFI_C_U16_POSITION
*******************************************************************************/

tVoid vd_clock_tclClientPos::vHandlePositionOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         posfi_tclMsgPositionStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, POS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _PositionElementBlock_PositionStatus = oStatus.PositionElementBlock;
            _PositionStatus_PositionStatus = oStatus.PositionStatus;
            _SensorPosixTime_PositionStatus = oStatus.SensorPosixTime;
            _Height_PositionStatus = oStatus.Height;
            _Inclination_PositionStatus = oStatus.Inclination;
            _Acceleration_PositionStatus = oStatus.Acceleration;

            ETG_TRACE_USR1(("vd_clock_tclClientPos::vHandlePositionOpStatus(): Status update message received for 'POSFI_C_U16_POSITION' (FID: 0x0020)!"));

            onPositionStatus(oStatus.PositionElementBlock, oStatus.PositionStatus, oStatus.SensorPosixTime, oStatus.Height, oStatus.Inclination, oStatus.Acceleration);

            // vHandlePositionOpStatus: user specific code start
            // vHandlePositionOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientPos::vHandlePositionOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientPos::onPositionStatus(fi_tcl_PositionHeadingSpeed PositionElementBlock, fi_tcl_e8_PositionCalculationState PositionStatus, fi_tcl_PosixExactTime SensorPosixTime, fi_tcl_s32_Meter Height, fi_tcl_s16_Degree Inclination, fi_tcl_s16_CentimeterSecond Acceleration) {

   if (_poCallbackIf) _poCallbackIf->onPositionStatus(PositionElementBlock, PositionStatus, SensorPosixTime, Height, Inclination, Acceleration); 

   // onPositionStatus: user specific code start
   // onPositionStatus: user specific code end

}

/*******************************************************************************
* Handling of property POSFI_C_U16_POSITIONINFO
*******************************************************************************/

tVoid vd_clock_tclClientPos::vHandlePositionInfoOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         posfi_tclMsgPositionInfoStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, POS_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _RoadAttributes_PositionInfoStatus = oStatus.RoadAttributes;
            _PositionCoord_PositionInfoStatus = oStatus.PositionCoord;
            _Course_PositionInfoStatus = oStatus.Course;
            _IsEntryPoint_PositionInfoStatus = oStatus.IsEntryPoint;
            _SensorPosixTime_PositionInfoStatus = oStatus.SensorPosixTime;
            _PositionInfo_PositionInfoStatus = oStatus.PositionInfo;

            ETG_TRACE_USR1(("vd_clock_tclClientPos::vHandlePositionInfoOpStatus(): Status update message received for 'POSFI_C_U16_POSITIONINFO' (FID: 0x0021)!"));

            onPositionInfoStatus(oStatus.RoadAttributes, oStatus.PositionCoord, oStatus.Course, oStatus.IsEntryPoint, oStatus.SensorPosixTime, oStatus.PositionInfo);

            // vHandlePositionInfoOpStatus: user specific code start
            // vHandlePositionInfoOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientPos::vHandlePositionInfoOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientPos::onPositionInfoStatus(fi_tcl_RoadAttributes RoadAttributes, fi_tcl_PositionWGS84 PositionCoord, fi_tcl_u8_DirectionAbsolute Course, tBool IsEntryPoint, fi_tcl_PosixExactTime SensorPosixTime, std::vector<fi_tcl_SingleRoadInfo, std::allocator<fi_tcl_SingleRoadInfo> > PositionInfo) {

   if (_poCallbackIf) _poCallbackIf->onPositionInfoStatus(RoadAttributes, PositionCoord, Course, IsEntryPoint, SensorPosixTime, PositionInfo); 

   // onPositionInfoStatus: user specific code start
   // onPositionInfoStatus: user specific code end

}






tBool vd_clock_tclClientPos::sendPositionGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      posfi_tclMsgPositionGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) POSFI_C_U16_POSITION, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientPos::sendPositionGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", POSFI_C_U16_POSITION, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}
tBool vd_clock_tclClientPos::sendPositionInfoGet() {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      posfi_tclMsgPositionInfoGet  oGet;
      //the data content


      fi_tclVisitorMessage oOutMessage(oGet);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) POSFI_C_U16_POSITIONINFO, (tU8) AMT_C_U8_CCAMSG_OPCODE_GET);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientPos::sendPositionInfoGet(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", POSFI_C_U16_POSITIONINFO, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oGet.vDestroy();
   }
   return bRetVal;
}


// vd_clock_tclClientPosvd_clock_ClientPos: user specific code start
// vd_clock_tclClientPosvd_clock_ClientPos: user specific code end

//EOF
