/*****************************************************************************
* FILE:         vd_clock_ClientDiaglog.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ClientDiaglog_H_
#define __vd_clock_ClientDiaglog_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "Ivd_clock_ClientDiaglog.h"
#include "vd_clock_AppMain.h"

// vd_clock_tclClientDiaglog_Include: user specific code start
// vd_clock_tclClientDiaglog_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class vd_clock_tclClientDiaglogCallbackIF;

class ahl_tclBaseOneThreadClientHandler;

class vd_clock_tclClientDiaglog : public Ivd_clock_tclClientDiaglog
{

public:
   virtual const tChar* getName() const { return "vd_clock_tclClientDiaglog"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   vd_clock_tclClientDiaglog(tVoid); 
   vd_clock_tclClientDiaglog(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientDiaglog();

   virtual tVoid vSetCallbackIf(vd_clock_tclClientDiaglogCallbackIF* poCallback) {
      _poCallbackIf = poCallback;
   }

   // vd_clock_tclClientDiaglogDeclarations: user specific code start
   // vd_clock_tclClientDiaglogDeclarations: user specific code end

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'vd_clock_tclClientDiaglog' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   vd_clock_tclClientDiaglog& operator = (const vd_clock_tclClientDiaglog &oClientHandler);

   /***************************************************************************
   * Overriding ahl_tclBaseOneThreadClientHandler methods.
   ***************************************************************************/
   virtual tVoid vOnServiceAvailable();
   virtual tVoid vOnServiceUnavailable();
   
private:
   vd_clock_tclClientDiaglogCallbackIF* _poCallbackIf;

public:

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/

   virtual tVoid getSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure& rNextTestResultStruct, tBool& rStatus) {
      rNextTestResultStruct = _NextTestResultStruct_SendNextTestResultStatus;
      rStatus               = _Status_SendNextTestResultStatus;
   }

   virtual tBool sendSaveTestResultMStart(midw_fi_tcl_TestResultList TestResultList);

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid vHandleSendNextTestResultOpStatus(amt_tclServiceData* poMessage);

   virtual tVoid vHandleSaveTestResultOpMResult(amt_tclServiceData* poMessage);

   virtual tVoid onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status);

   virtual tVoid onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status);

private:
   /***************************************************************************
   * value of each received status
   ***************************************************************************/

   midw_fi_tcl_SendNextTestResultStructure  _NextTestResultStruct_SendNextTestResultStatus;
   tBool                                    _Status_SendNextTestResultStatus;

   /***************************************************************************
   * Message map definition macro
   ***************************************************************************/

   DECLARE_MSG_MAP(vd_clock_tclClientDiaglog) 

// vd_clock_tclClientDiaglogDeclarationsPart2: user specific code start
   tBool _bIsStartMResultPending;
   std::vector<midw_fi_tcl_TestResult, std::allocator<midw_fi_tcl_TestResult> > _TestResultList;
   virtual tVoid vSaveLocalTestResultList(const midw_fi_tcl_TestResult oTestResult);
// vd_clock_tclClientDiaglogDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientDiaglog_H_


