

/*****************************************************************************
* FILE:         vd_clock_ClientDiaglog.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientHandler.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientDiaglogIncludes: user specific code start
// vd_clock_tclClientDiaglogIncludes: user specific code end

#include "vd_clock_ClientDiaglog.h"
#include "vd_clock_ClientDiaglogCallbackIf.h"



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_DIAGLOG
#include "trcGenProj/Header/vd_clock_ClientDiaglog.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
#define DIAGLOG_SERVICE_ID              112
#define DIAGLOG_FI_MAJOR_VERSION        1
#define DIAGLOG_FI_MINOR_VERSION        6

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(vd_clock_tclClientDiaglog, ahl_tclBaseWork)
   ON_MESSAGE_SVCDATA(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleSendNextTestResultOpStatus)
   ON_MESSAGE_SVCDATA(MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleSaveTestResultOpMResult)
   // vd_clock_tclClientDiaglog_MsgMap: user specific code start
   // vd_clock_tclClientDiaglog_MsgMap: user specific code end
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientDiaglog::
*             vd_clock_tclClientDiaglog(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientDiaglog::vd_clock_tclClientDiaglog(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientDiaglog(poMainAppl, DIAGLOG_SERVICE_ID, DIAGLOG_FI_MAJOR_VERSION, DIAGLOG_FI_MINOR_VERSION )
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglog() entered."));
   _poCallbackIf = OSAL_NULL;
   _Status_SendNextTestResultStatus = FALSE;
   
   // vd_clock_tclClientDiaglogConstructor: user specific code start
   _TestResultList.clear();
   _bIsStartMResultPending = FALSE;
   // vd_clock_tclClientDiaglogConstructor: user specific code end
   vAddAutoRegisterForProperty(MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT);
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientDiaglog::
*             ~vd_clock_tclClientDiaglog(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientDiaglog::~vd_clock_tclClientDiaglog(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientDiaglog() entered."));
   _poCallbackIf = OSAL_NULL;

   // vd_clock_tclClientDiaglogDestructor: user specific code start
   _TestResultList.clear();
   _bIsStartMResultPending = FALSE;
   // vd_clock_tclClientDiaglogDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglog::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientDiaglog.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     DIAGLOG_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglog::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglog::vGetReferences() entered."));
   
   // vd_clock_tclClientDiaglogvGetReferences: user specific code start
   // vd_clock_tclClientDiaglogvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglog::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglog::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglog::vStartCommunication() entered."));
   // vd_clock_tclClientDiaglogvStartCommunication: user specific code start
   // vd_clock_tclClientDiaglogvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglog::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglog::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglog::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // vd_clock_tclClientDiaglogvHandleMessage: user specific code start
   // vd_clock_tclClientDiaglogvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglog::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglog::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglog::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientDiaglogvHandleTraceMessage: user specific code start
   // vd_clock_tclClientDiaglogvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglog::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglog::vTraceInfo()
{
   ETG_TRACE_FATAL(("Property support:      SendNextTestResult (MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT) -> Opcode: UpReg, RelUpReg, Status, Error, "));
   ETG_TRACE_FATAL(("Method   support:      SaveTestResult (MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT) -> Opcode: MethodStart, MethodResult, Error, "));

   // vd_clock_tclClientDiaglogvTraceInfo: user specific code start
   // vd_clock_tclClientDiaglogvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglog::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientDiaglog::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceAvailable();

   // vd_clock_tclClientDiaglogvOnServiceAvailable: user specific code start
   if ( _bIsStartMResultPending )
   {
   	midw_fi_tcl_TestResultList oResult;
   	oResult.TestResultList = _TestResultList;
   	sendSaveTestResultMStart(oResult);
   	_bIsStartMResultPending = FALSE;
   }
   else
   {
   	ETG_TRACE_USR4(("vOnServiceAvailable() _bIsStartMResultPending Not Pending = %u.", _bIsStartMResultPending));
   }
   // vd_clock_tclClientDiaglogvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglog::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientDiaglog::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));

   if (_poCallbackIf) _poCallbackIf->onServiceUnavailable();

   // vd_clock_tclClientDiaglogvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientDiaglogvOnServiceUnavailable: user specific code end
}


/*******************************************************************************
* Handling of property MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT
*******************************************************************************/

tVoid vd_clock_tclClientDiaglog::vHandleSendNextTestResultOpStatus(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_STATUS ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         midw_diaglogfi_tclMsgSendNextTestResultStatus  oStatus;

         if (oInMsg.s32GetData(oStatus, DIAGLOG_FI_MAJOR_VERSION) != OSAL_ERROR) {
            _NextTestResultStruct_SendNextTestResultStatus = oStatus.NextTestResultStruct;
            _Status_SendNextTestResultStatus = oStatus.Status;

            ETG_TRACE_USR1(("vd_clock_tclClientDiaglog::vHandleSendNextTestResultOpStatus(): Status update message received for 'MIDW_DIAGLOGFI_C_U16_SENDNEXTTESTRESULT' (FID: 0x000A)!"));

            onSendNextTestResultStatus(oStatus.NextTestResultStruct, oStatus.Status);

            // vHandleSendNextTestResultOpStatus: user specific code start
            // vHandleSendNextTestResultOpStatus: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientDiaglog::vHandleSendNextTestResultOpStatus: Received message is invalid!"));
         }

         oStatus.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientDiaglog::onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status) {

   if (_poCallbackIf) _poCallbackIf->onSendNextTestResultStatus(NextTestResultStruct, Status); 

   // onSendNextTestResultStatus: user specific code start
   // onSendNextTestResultStatus: user specific code end

}



/*******************************************************************************
* Handling of property MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT
*******************************************************************************/

tVoid vd_clock_tclClientDiaglog::vHandleSaveTestResultOpMResult(amt_tclServiceData* poMessage) {
   if (poMessage != NULL) {
      if ( poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT ) {
         fi_tclVisitorMessage            oInMsg( poMessage );
         midw_diaglogfi_tclMsgSaveTestResultMethodResult  oMResult;

         if (oInMsg.s32GetData(oMResult, DIAGLOG_FI_MAJOR_VERSION) != OSAL_ERROR) {
            ETG_TRACE_USR1(("vd_clock_tclClientDiaglog::vHandleSaveTestResultOpMResult(): Method result update message received for 'MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT' (FID: 0x0001)!"));

            onSaveTestResultMResult(oMResult.Status);

            // vHandleSaveTestResultOpMResult: user specific code start
            // vHandleSaveTestResultOpMResult: user specific code end
         } else {
            ETG_TRACE_ERR(("vd_clock_tclClientDiaglog::vHandleSaveTestResultOpMResult: Received message is invalid!"));
         }

         oMResult.vDestroy();
      }
   }  
}

tVoid vd_clock_tclClientDiaglog::onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status) {

   if (_poCallbackIf) _poCallbackIf->onSaveTestResultMResult(Status); 

   // onSaveTestResultMResult: user specific code start
   // onSaveTestResultMResult: user specific code end

}





tBool vd_clock_tclClientDiaglog::sendSaveTestResultMStart(midw_fi_tcl_TestResultList TestResultList) {
   tBool bRetVal = FALSE;
   if (u16GetRegID() != AMT_C_U16_REGID_INVALID) {
      midw_diaglogfi_tclMsgSaveTestResultMethodStart  oMStart;
      //the data content
      oMStart.TestResultList = TestResultList;


      fi_tclVisitorMessage oOutMessage(oMStart);
      //Initialize the message with register id and so on
      vInitServiceData(oOutMessage, (tU16) 0, (tU16) MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, (tU8) AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
      // Post message - since the second parameter is true we need not explicitly delete the message
      ail_tenCommunicationError enResult = _poMainAppl->enPostMessage(&oOutMessage, TRUE);

      if (enResult != AIL_EN_N_NO_ERROR) {
         // Error situation:
         ETG_TRACE_ERR(( "vd_clock_tclClientDiaglog::sendSaveTestResultMStart(): enPostMessage failed for FuncId - %u, 'ail_tenCommunicationError' = %u", MIDW_DIAGLOGFI_C_U16_SAVETESTRESULT, (tU32)enResult));
      } else {
         bRetVal = TRUE;
      }

      // Always destroy the FI data object before leaving its creation scope
      oMStart.vDestroy();
   }
   return bRetVal;
}

// vd_clock_tclClientDiaglogvd_clock_ClientDiaglog: user specific code start
tVoid vd_clock_tclClientDiaglog::vSaveLocalTestResultList(const midw_fi_tcl_TestResult oTestResult)
{
    ETG_TRACE_USR4(("sendSaveTestResultMStart() entered."));
	ETG_TRACE_USR1(("veda_tclClientDiaglog::vSaveLocalTestResultList() for ITC %u Result as %u", \
	      ETG_ENUM(VEDA_INT_ITC, oTestResult.TroubleCode), ETG_CENUM(enITCResult, oTestResult.Result.enType)));

	tBool bUpdated = FALSE;
	std::vector<midw_fi_tcl_TestResult, std::allocator<midw_fi_tcl_TestResult> >::iterator it = _TestResultList.begin();

	for (; it != _TestResultList.end(); it++ )
	{
		if ( oTestResult.TroubleCode == it->TroubleCode )
		{
			it->Result.enType =  oTestResult.Result.enType;
			bUpdated = TRUE;
			_bIsStartMResultPending = TRUE;
			break;
		}
	}

	if ( !bUpdated )
	{
		_TestResultList.push_back(oTestResult);
		_bIsStartMResultPending = TRUE;
	}
}
// vd_clock_tclClientDiaglogvd_clock_ClientDiaglog: user specific code end

//EOF
